/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.state;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mimvista.brachytherapy.BrachyReportPlanState;
import com.mimvista.brachytherapy.mui.sidepanel.BrachySidePanel;
import com.mimvista.d;
import com.mimvista.dicom.rtdose.DVHCollection;
import com.mimvista.dicom.rtdose.DoseValue;
import com.mimvista.dicom.rtdose.DoseVolumeHistogram;
import com.mimvista.dicom.rtdose.gui.DVHAnnotation;
import com.mimvista.dicom.rtdose.gui.DVHDisplayParams;
import com.mimvista.dicom.rtdose.gui.DVHFrame;
import com.mimvista.dicom.rtdose.gui.DVHNotification;
import com.mimvista.dicom.rtdose.gui.DoseNormType;
import com.mimvista.dicom.rtdose.gui.DvhAnnotationType;
import com.mimvista.dicom.rtdose.gui.DvhChartPointGenerator;
import com.mimvista.dicom.rtdose.gui.DvhDisplayInfo;
import com.mimvista.dicom.rtdose.gui.DvhLineStyle;
import com.mimvista.internals.DynamicVolumeRef3D;
import com.mimvista.internals.ImageFrame;
import com.mimvista.internals.ViewController3D;
import com.mimvista.internals.volumes.ImageVolumeShort;
import com.mimvista.mui.Session;
import com.mimvista.mui.bm;
import com.mimvista.mui.overlays.IsodoseOverlay;
import com.mimvista.mui.overlays.Overlay;
import com.mimvista.state.ReadHelper;
import com.mimvista.state.VolumeState;
import com.mimvista.util.Pair;
import com.mimvista.util.ay;
import com.mimvista.viewer.SeriesInfo;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SerialDVHState
implements Serializable {
    private static final long serialVersionUID = 1L;
    public DoseValue doseCap;
    public DoseNormType doseNormType;
    public boolean isNormalizedVolume;
    public boolean showLegend;
    public boolean useDoseCap;
    public DoseValue maxDose;
    public DoseValue rxDose;
    public Map<SerialDVHCollection, List<SerialDVH>> filteredDVHs;
    public List<SerialDVHAnnotation> annotations = Lists.newArrayList();

    public SerialDVHState(DVHFrame dVHFrame, Map<ImageFrame, VolumeState> map) {
        DVHDisplayParams dVHDisplayParams = dVHFrame.getDisplay().getDVHParams();
        this.doseCap = dVHDisplayParams.getDoseCap();
        this.doseNormType = dVHDisplayParams.getDoseNormType();
        this.isNormalizedVolume = dVHDisplayParams.isNormalizedVolume();
        this.showLegend = dVHDisplayParams.isShowLegend();
        this.useDoseCap = dVHDisplayParams.isUseDoseCap();
        this.maxDose = dVHDisplayParams.getMaxDose();
        this.rxDose = dVHDisplayParams.getRxDose();
        this.filteredDVHs = new HashMap<SerialDVHCollection, List<SerialDVH>>();
        HashMap hashMap = Maps.newHashMap();
        for (Map.Entry<DVHCollection, List<DvhDisplayInfo>> object : dVHDisplayParams.getFilteredDVHs().entrySet()) {
            SerialDVHCollection serialDVHCollection = new SerialDVHCollection(object.getKey(), map);
            ArrayList arrayList = Lists.newArrayList();
            for (DvhDisplayInfo dvhDisplayInfo : object.getValue()) {
                SerialDVH serialDVH = new SerialDVH(dvhDisplayInfo);
                arrayList.add(serialDVH);
                hashMap.put(dvhDisplayInfo, serialDVH);
            }
            this.filteredDVHs.put(serialDVHCollection, arrayList);
        }
        for (DVHAnnotation dVHAnnotation : dVHFrame.getDisplay().getAnnotations()) {
            this.annotations.add(new SerialDVHAnnotation(dVHAnnotation, hashMap));
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        System.out.println("try dvh");
        objectOutputStream.defaultWriteObject();
        System.out.println("yay dvh!");
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        ReadHelper readHelper = new ReadHelper();
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        readHelper.a(getField, (Object)this);
        if (ReadHelper.b(getField, "oldDoseCap")) {
            this.doseCap = new DoseValue();
            this.doseCap.setValueInGy(getField.get("oldDoseCap", 0.0f));
        }
        if (ReadHelper.b(getField, "oldDoseCapObj")) {
            this.doseCap = new DoseValue();
            this.doseCap.setValueInGy(((Float)getField.get("oldDoseCapObj", Float.valueOf(0.0f))).floatValue());
        }
        if (ReadHelper.b(getField, "oldRxDose")) {
            this.rxDose = new DoseValue();
            this.rxDose.setValueInGy(getField.get("oldRxDose", 0.0f));
        }
        if (ReadHelper.b(getField, "oldMaxDose")) {
            this.maxDose = new DoseValue();
            this.maxDose.setValueInGy(getField.get("oldMaxDose", 0.0f));
        }
        if (ReadHelper.b(getField, "oldFilteredDVHs")) {
            this.filteredDVHs = Maps.newHashMap();
            List list = (List)getField.get("oldFilteredDVHs", null);
            for (Pair pair : list) {
                this.filteredDVHs.put((SerialDVHCollection)pair.x, (List<SerialDVH>)pair.y);
            }
        }
    }

    public static void a(Session session, SerialDVHState serialDVHState, Map<VolumeState, ImageFrame> map) {
        HashMap hashMap = Maps.newHashMap();
        HashMap hashMap2 = Maps.newHashMap();
        for (Map.Entry<SerialDVHCollection, List<SerialDVH>> object2 : serialDVHState.filteredDVHs.entrySet()) {
            ArrayList arrayList = Lists.newArrayList();
            for (SerialDVH serialDVH : object2.getValue()) {
                DvhDisplayInfo dvhDisplayInfo = serialDVH.a();
                arrayList.add(dvhDisplayInfo);
                hashMap.put(serialDVH, dvhDisplayInfo);
            }
            hashMap2.put(object2.getKey().a(map), arrayList);
        }
        DVHDisplayParams dVHDisplayParams = new DVHDisplayParams(hashMap2, serialDVHState.maxDose, serialDVHState.rxDose);
        dVHDisplayParams.setDoseCap(serialDVHState.doseCap);
        dVHDisplayParams.setDoseNormType(serialDVHState.doseNormType);
        dVHDisplayParams.setNormalizedVolume(serialDVHState.isNormalizedVolume);
        dVHDisplayParams.setShowLegend(serialDVHState.showLegend);
        dVHDisplayParams.setUseDoseCap(serialDVHState.useDoseCap);
        DVHFrame dVHFrame = new DVHFrame(session, dVHDisplayParams);
        DVHNotification.addToDVHViewer(dVHFrame);
        if (serialDVHState.annotations != null) {
            for (SerialDVHAnnotation serialDVHAnnotation : serialDVHState.annotations) {
                serialDVHAnnotation.a(dVHFrame, hashMap);
            }
        }
    }

    public class SerialDVHAnnotation
    implements Serializable {
        private static final long serialVersionUID = 2508643181274198459L;
        public SerialDVH serialDVH;
        public double value;
        public boolean isUsingDose;

        public SerialDVHAnnotation(DVHAnnotation dVHAnnotation, Map<DvhDisplayInfo, SerialDVH> map) {
            this.serialDVH = map.get(dVHAnnotation.ddi);
            this.value = dVHAnnotation.getGenerator().value;
            this.isUsingDose = dVHAnnotation.getGenerator() instanceof DvhChartPointGenerator.PointGeneratorUsingDose;
        }

        public void a(DVHFrame dVHFrame, Map<SerialDVH, DvhDisplayInfo> map) {
            DvhDisplayInfo dvhDisplayInfo = map.get(this.serialDVH);
            DvhAnnotationType dvhAnnotationType = this.isUsingDose ? DvhAnnotationType.DOSE : DvhAnnotationType.VOLUME;
            dVHFrame.getDisplay().getChartPanel().addAnnotation(dvhDisplayInfo, this.value, dvhAnnotationType);
        }
    }

    public static class SerialDVHCollection
    implements Serializable {
        private static final long serialVersionUID = 5193389983449804360L;
        public DvhLineStyle style;
        public List<SerialDVH> list = Lists.newArrayList();
        public VolumeState volume;
        public SeriesInfo doseInfo;
        private boolean isBrachyDose;
        @d
        public ImageVolumeShort doseVolume = null;

        public SerialDVHCollection(DVHCollection dVHCollection, Map<ImageFrame, VolumeState> map) {
            this.style = dVHCollection.getLineStyle();
            for (DvhDisplayInfo bm2 : dVHCollection.getDvhDisplayInfo()) {
                this.list.add(new SerialDVH(bm2));
            }
            BrachyReportPlanState brachyReportPlanState = BrachySidePanel.v(bm.b());
            if (brachyReportPlanState != null) {
                IsodoseOverlay isodoseOverlay = brachyReportPlanState.c;
                ImageFrame imageFrame = isodoseOverlay == null ? null : isodoseOverlay.ao();
                this.isBrachyDose = dVHCollection.getVolume() == imageFrame;
            } else {
                this.isBrachyDose = false;
            }
            this.volume = map.get(dVHCollection.getVolume());
            this.doseInfo = dVHCollection.getDoseInfo();
            this.doseVolume = dVHCollection.getDoseVolume();
        }

        public DVHCollection a(Map<VolumeState, ImageFrame> map) {
            DynamicVolumeRef3D dynamicVolumeRef3D;
            Serializable serializable;
            if (this.isBrachyDose) {
                serializable = BrachySidePanel.v((Session)bm.b()).c;
                dynamicVolumeRef3D = new DynamicVolumeRef3D((ViewController3D)((Overlay)serializable).ao().j());
                this.doseInfo = ((IsodoseOverlay)serializable).getUncopiedMutableInfo();
            } else {
                dynamicVolumeRef3D = new DynamicVolumeRef3D((ViewController3D)map.get(this.volume).j());
            }
            serializable = Lists.newArrayList();
            for (SerialDVH serialDVH : this.list) {
                serializable.add(serialDVH.a());
            }
            DVHCollection dVHCollection = new DVHCollection(dynamicVolumeRef3D, this.doseVolume, (Collection<DvhDisplayInfo>)((Object)serializable), this.doseInfo);
            dVHCollection.setLineStyle(this.style);
            return dVHCollection;
        }
    }

    public static class SerialDVH
    implements Serializable {
        private static final long serialVersionUID = -7639846617984585492L;
        DoseVolumeHistogram state;
        DvhDisplayInfo ddi;

        public SerialDVH(DvhDisplayInfo dvhDisplayInfo) {
            this.ddi = dvhDisplayInfo.clone();
            this.state = dvhDisplayInfo.getDVH();
        }

        public DvhDisplayInfo a() {
            DvhDisplayInfo dvhDisplayInfo = this.ddi.clone();
            dvhDisplayInfo.setDVH(this.state);
            return dvhDisplayInfo;
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            objectOutputStream.defaultWriteObject();
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            ReadHelper readHelper = new ReadHelper();
            ObjectInputStream.GetField getField = objectInputStream.readFields();
            readHelper.a(getField, (Object)this);
            if (ReadHelper.b(getField, "oldState")) {
                Object object = getField.get("oldState", null);
                DoseVolumeHistogram.SimpleDVHState simpleDVHState = (DoseVolumeHistogram.SimpleDVHState)object;
                ArrayList arrayList = Lists.newArrayList();
                for (int i2 = 0; i2 < simpleDVHState.values.length; ++i2) {
                    arrayList.add(new DoseVolumeHistogram.HistogramBin(simpleDVHState.widths[i2], simpleDVHState.values[i2]));
                }
                if (simpleDVHState.oldDisplayInfo != null) {
                    this.ddi = simpleDVHState.oldDisplayInfo;
                    simpleDVHState.oldDisplayInfo = null;
                    ay.b((Object)"Had to move DvhDisplayInfo due to pre 5.5 save.", this);
                }
                this.state = new DoseVolumeHistogram(simpleDVHState.stats, simpleDVHState.dvhInfo, (List<DoseVolumeHistogram.HistogramBin>)arrayList, simpleDVHState.doseOfFirstBin, simpleDVHState.rois, simpleDVHState.generatedFrom);
            }
        }
    }
}

