/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.state;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mimvista.LocalLicense.LicenseOption;
import com.mimvista.brachytherapy.mui.sidepanel.BrachySidePanel;
import com.mimvista.dicom.rtdose.gui.DVHFrame;
import com.mimvista.internals.ImageFrame;
import com.mimvista.internals.ViewController;
import com.mimvista.internals.linking.PositionTransform;
import com.mimvista.license.LicenseTransformer;
import com.mimvista.mui.Session;
import com.mimvista.mui.SessionKey;
import com.mimvista.mui.ak;
import com.mimvista.mui.findings.SessionFindingsState;
import com.mimvista.mui.overlays.IsodoseOverlay;
import com.mimvista.mui.overlays.OverlayType;
import com.mimvista.mui.overlays.Overlayish;
import com.mimvista.mui.toolbar.SidePanel;
import com.mimvista.mui.toolbar.SidePanelManager;
import com.mimvista.neuro.NeuroMinion;
import com.mimvista.neuro.NeuroMistress;
import com.mimvista.preferencesNew.ContourPrefs;
import com.mimvista.response.StatsManager;
import com.mimvista.response.gui.TherapyResponseWindow;
import com.mimvista.state.NeuroMistressState;
import com.mimvista.state.PageGroupState;
import com.mimvista.state.ReadHelper;
import com.mimvista.state.SerialBrachyState;
import com.mimvista.state.SerialDVHState;
import com.mimvista.state.SerialVC;
import com.mimvista.state.SerialViewState;
import com.mimvista.state.SessionStateObjectManager;
import com.mimvista.state.TransformWrapper;
import com.mimvista.state.VolumeLinkState;
import com.mimvista.state.VolumeState;
import com.mimvista.state.e;
import com.mimvista.state.g;
import com.mimvista.util.Messages;
import com.mimvista.util.Pair;
import com.mimvista.util.ay;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SessionState
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static Messages a = Messages.a("SessionSave");
    public List<VolumeState> volList = Lists.newArrayList();
    public VolumeLinkState linkState;
    public SessionKey sessKey;
    public long nextId;
    public long nextVolId = -1L;
    public int activePage;
    @Deprecated
    public List<SerialViewState> vcs = null;
    public List<SerialVC> vcStates = Lists.newArrayList();
    public List<PageGroupState> pages = Lists.newArrayList();
    public Map<String, String> trwPrefs = null;
    public boolean trwVisible = false;
    public Map<String, String> trwContextToRefContour = null;
    public List<SidePanel.SidePanelType> visibleSidePanels;
    public Map<Long, NeuroMinion> neuroManagers;
    public NeuroMistressState nmState;
    public SerialBrachyState brachyState;
    public SerialDVHState dvhState;
    public SessionFindingsState findingState;
    public SessionStateObjectManager.SerializedSessionStateObjectManager stateObjectMap;
    public StatsManager statManager;
    public List<LicenseOption> licenses;
    public long activeContouringVcId = -1L;
    public boolean selectedVcIsLocked;
    public boolean enableHoverEffectOfContours;
    public String workflowName;

    public SessionState(Session session, g g2) {
        List<LicenseOption> list;
        Serializable serializable;
        if (session.e(-75L)) {
            ay.d((Object)"Temporary warp vol is present. This session may not restore properly.", this);
            g2.b(a.b("SAVE_GENERAL_WARNING"));
        }
        this.nextId = session.k();
        this.nextVolId = session.x().b();
        this.sessKey = session.H();
        this.activePage = session.s().indexOf(session.ac());
        this.neuroManagers = session.j();
        this.stateObjectMap = session.o().serialize();
        try {
            this.brachyState = BrachySidePanel.a(session);
        }
        catch (Exception exception) {
            ay.d((Object)"Error during brachy state construction.", (Throwable)exception, SessionState.class);
            g2.b(a.b("SAVE_GENERAL_WARNING"));
        }
        this.activeContouringVcId = session.aG() != null ? session.aG().aV() : -1L;
        this.selectedVcIsLocked = session.aF();
        HashMap hashMap = Maps.newHashMap();
        HashMap hashMap2 = Maps.newHashMap();
        a a2 = new a(session, hashMap, hashMap2);
        ak ak2 = ak.c();
        if (ak2 != null && (serializable = ak2.i()) != null) {
            this.visibleSidePanels = ((SidePanelManager)serializable).f();
        }
        this.b(a2);
        this.c(a2);
        this.linkState = new VolumeLinkState(session.q(), a2);
        serializable = Maps.newHashMap();
        for (com.mimvista.mui.presenters.protocol.a object2 : session.s()) {
            PageGroupState exception = new PageGroupState(object2, (Map<com.mimvista.mui.presenters.protocol.a, PageGroupState>)((Object)serializable));
            serializable.put(object2, exception);
            this.pages.add(exception);
        }
        try {
            this.nmState = new NeuroMistressState(NeuroMistress.a(session), hashMap2);
        }
        catch (Exception exception) {
            ay.d((Object)"Error during neuro state construction.", (Throwable)exception, SessionState.class);
            g2.b(a.b("SAVE_GENERAL_WARNING"));
        }
        try {
            list = DVHFrame.getCurrentFrameForSession(session);
            if (list != null) {
                this.dvhState = new SerialDVHState((DVHFrame)((Object)list), hashMap2);
            }
        }
        catch (Exception exception) {
            ay.d((Object)"Error during DVH state construction.", (Throwable)exception, SessionState.class);
            g2.b(a.b("SAVE_GENERAL_WARNING"));
        }
        list = LicenseTransformer.getLicenseOptionsForDisplayingToUserOnlyNotForCheckingIfYouHaveAValidLicense();
        this.licenses = Lists.newArrayList();
        Set<LicenseOption> set = LicenseOption.g();
        for (LicenseOption licenseOption : list) {
            if (!set.contains(licenseOption)) continue;
            this.licenses.add(licenseOption);
        }
        this.findingState = session.u();
        try {
            this.a(a2);
        }
        catch (Exception exception) {
            ay.d((Object)"Error during brachy state cleanup.", (Throwable)exception, SessionState.class);
            g2.b(a.b("SAVE_GENERAL_WARNING"));
        }
        if (session.K() != null) {
            session.K().t();
            this.trwPrefs = TherapyResponseWindow.m().getAllProps();
            if (session.K().i()) {
                this.trwVisible = true;
            }
            this.trwContextToRefContour = session.K().r();
        }
        this.statManager = session.Z();
        this.enableHoverEffectOfContours = session.b();
        this.workflowName = session.B();
    }

    public List<? extends e> a() {
        if (this.vcs != null) {
            return this.vcs;
        }
        return this.vcStates;
    }

    private void a(a a2) {
        IsodoseOverlay isodoseOverlay;
        if (this.brachyState != null && (isodoseOverlay = this.brachyState.brpState.c) != null) {
            block0: for (VolumeState volumeState : a2.c.values()) {
                for (Overlayish overlayish : Lists.newArrayList(volumeState.ocState.realOverlays)) {
                    if (overlayish != isodoseOverlay) continue;
                    volumeState.ocState.realOverlays.remove(overlayish);
                    break block0;
                }
            }
        }
    }

    private void b(a a2) {
        for (ImageFrame imageFrame : a2.a.ap()) {
            VolumeState volumeState = new VolumeState(imageFrame, a2);
            this.volList.add(volumeState);
            a2.c.put(imageFrame, volumeState);
            List<IsodoseOverlay> list = imageFrame.n().K();
            for (IsodoseOverlay isodoseOverlay : list) {
                if (g.a(isodoseOverlay)) continue;
                VolumeState volumeState2 = isodoseOverlay.s();
                if (volumeState2 == null) {
                    throw new RuntimeException("Dose doesn't have a VolumeState.");
                }
                volumeState.doseVols.add(volumeState2);
            }
        }
    }

    private void c(a a2) {
        List<ViewController> list = a2.a.af();
        for (ViewController viewController : list) {
            this.vcStates.add(SerialVC.a(viewController, a2));
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        ReadHelper readHelper = new ReadHelper();
        readHelper.a(Pair.get(String.class, OverlayType.class), new ReadHelper.b<String, OverlayType>(){

            @Override
            public OverlayType a(String string) {
                OverlayType overlayType = OverlayType.a;
                OverlayType overlayType2 = OverlayType.a(string);
                if (overlayType2 != null) {
                    overlayType = overlayType2;
                } else {
                    try {
                        overlayType = OverlayType.valueOf(string);
                    }
                    catch (Exception exception) {
                        ay.c((Object)("Bad overlay type: " + string), this);
                    }
                }
                return overlayType;
            }
        });
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        if (!ReadHelper.b(getField, "volId")) {
            this.nextVolId = -2L;
        }
        if (!ReadHelper.b(getField, "enableHoverEffectOfContours")) {
            this.enableHoverEffectOfContours = ContourPrefs.enableHoverInformationForContours.getValue();
        }
        readHelper.a(getField, (Object)this);
    }

    public static class a {
        public Session a;
        public Map<PositionTransform, TransformWrapper> b;
        public Map<ImageFrame, VolumeState> c;

        public a(Session session, Map<PositionTransform, TransformWrapper> map, Map<ImageFrame, VolumeState> map2) {
            this.a = session;
            this.b = map;
            this.c = map2;
        }
    }
}

