/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.state;

import com.google.common.collect.ClassToInstanceMap;
import com.google.common.collect.Maps;
import com.google.common.collect.MutableClassToInstanceMap;
import com.mimvista.mui.Session;
import com.mimvista.state.ReadHelper;
import com.mimvista.state.SerializedSessionStateObject;
import com.mimvista.state.SessionStateObject;
import com.mimvista.util.ay;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Map;

public class SessionStateObjectManager
implements SessionStateObject<SessionStateObjectManager> {
    private final ClassToInstanceMap<SessionStateObject> map;
    private final Session session;

    public SessionStateObjectManager(Session session) {
        this.session = session;
        this.map = MutableClassToInstanceMap.create();
    }

    private SessionStateObjectManager(SessionStateObjectManager sessionStateObjectManager) {
        this.session = sessionStateObjectManager.session;
        this.map = MutableClassToInstanceMap.create();
        this.map.putAll(sessionStateObjectManager.map);
    }

    public synchronized <StateType extends SessionStateObject> StateType getStateObjectIfItExists(Class<StateType> clazz) {
        return (StateType)((SessionStateObject)this.map.getInstance(clazz));
    }

    public synchronized <StateType extends SessionStateObject> StateType getOrCreateStateObject(Class<StateType> clazz) {
        SessionStateObject sessionStateObject = (SessionStateObject)this.map.getInstance(clazz);
        if (sessionStateObject == null) {
            try {
                sessionStateObject = (SessionStateObject)clazz.getConstructor(Session.class).newInstance(this.session);
                this.map.putInstance(clazz, (Object)sessionStateObject);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                ay.b((Object)("" + clazz + " needs to have a constructor that takes a Session"), (Throwable)noSuchMethodException, this);
            }
            catch (Throwable throwable) {
                ay.b((Object)("Something bad happened when trying to create a per-session " + clazz), throwable, this);
            }
        }
        return (StateType)sessionStateObject;
    }

    public synchronized <StateType extends SessionStateObject> StateType removeStateObject(Class<StateType> clazz) {
        return (StateType)((SessionStateObject)clazz.cast(this.map.remove(clazz)));
    }

    public SessionStateObjectManager getShallowCopy() {
        return new SessionStateObjectManager(this);
    }

    public SerializedSessionStateObjectManager serialize() {
        return new SerializedSessionStateObjectManager(this);
    }

    public static class SerializedSessionStateObjectManager
    implements SerializedSessionStateObject<SessionStateObjectManager> {
        private static final long serialVersionUID = 1L;
        Map<Class<? extends SessionStateObject>, SerializedSessionStateObject> serializableMap = Maps.newHashMap();

        public SerializedSessionStateObjectManager(SessionStateObjectManager sessionStateObjectManager) {
            for (Class clazz : sessionStateObjectManager.map.keySet()) {
                SerializedSessionStateObject serializedSessionStateObject = ((SessionStateObject)sessionStateObjectManager.map.getInstance(clazz)).serialize();
                if (serializedSessionStateObject == null) continue;
                this.serializableMap.put(clazz, serializedSessionStateObject);
            }
        }

        @Override
        public void preventLambdas() {
        }

        public SessionStateObjectManager a(Session session) {
            SessionStateObjectManager sessionStateObjectManager = new SessionStateObjectManager(session);
            for (Class<? extends SessionStateObject> clazz : this.serializableMap.keySet()) {
                sessionStateObjectManager.map.put(clazz, (Object)clazz.cast(this.serializableMap.get(clazz).deserialize(session)));
            }
            return sessionStateObjectManager;
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            ReadHelper readHelper = new ReadHelper();
            readHelper.a(objectInputStream, (Object)this);
        }

        @Override
        public /* synthetic */ Object deserialize(Session session) {
            return this.a(session);
        }
    }
}

