/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.state;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mimvista.archive.search.SearchSource;
import com.mimvista.dicom.UIDContainer;
import com.mimvista.file.MIMFile;
import com.mimvista.internals.BufferedPlanarImage;
import com.mimvista.internals.FrameNumber;
import com.mimvista.internals.ImageFrame;
import com.mimvista.internals.MimPlanarImage;
import com.mimvista.internals.SliceInfo;
import com.mimvista.internals.ViewController;
import com.mimvista.internals.ViewController3D;
import com.mimvista.internals.VolumetricRendering;
import com.mimvista.internals.ae;
import com.mimvista.internals.linking.InverseWarpTransform;
import com.mimvista.internals.linking.WarpTransform;
import com.mimvista.internals.o;
import com.mimvista.internals.volumes.ImageVolumeShort;
import com.mimvista.internals.volumes.SimpleImageVolume;
import com.mimvista.mui.presenters.display.p;
import com.mimvista.numerics.ImageSlice;
import com.mimvista.state.ReadHelper;
import com.mimvista.state.SerialOverlayCollection;
import com.mimvista.state.SessionState;
import com.mimvista.state.TransformWrapper;
import com.mimvista.state.VolumeSourceInfo;
import com.mimvista.util.Pair;
import com.mimvista.util.ay;
import com.mimvista.util.cn;
import com.mimvista.viewer.SeriesInfo;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.List;
import java.util.Set;
import javax.vecmath.Vector3f;

public class VolumeState
implements Serializable {
    private static final long serialVersionUID = 1L;
    String seriesUID;
    String studyDate;
    String patientId;
    List<UIDContainer.SOPInstanceUID> allSops;
    List<FrameNumber> frameNumbersFor2D;
    @Deprecated
    UIDContainer.SOPInstanceUID sopInstanceUID;
    @Deprecated
    List<UIDContainer.SOPInstanceUID> sopsToLoadForDynamic2D;
    String pName;
    boolean derived = false;
    public boolean nuller = false;
    String searchSourceName;
    int searchSourceType;
    public TransformWrapper warp;
    public TransformWrapper invWarp;
    public String frameOfRefUID;
    public SeriesInfo info;
    public float[] dcmCenter;
    public ImageFrame entireVol;
    public boolean embedded = false;
    public int embedIdx;
    public transient MIMFile a;
    public List<ImageSlice.ImageSliceShort> goonSSPBonusSSPImages;
    public SerialOverlayCollection ocState;
    public List<VolumeState> doseVols = Lists.newArrayList();
    public boolean reoriented;
    public transient boolean b;
    public Pair<Vector3f, Vector3f> selectedExtent;
    public boolean isVideo = false;
    public float[] videoVoxel = null;
    public long volumeId = -1L;

    public VolumeState() {
    }

    public VolumeState(ImageFrame imageFrame, SessionState.a a2) {
        List<SliceInfo> list;
        Object object;
        Serializable serializable;
        Iterable<UIDContainer.SOPInstanceUID> iterable;
        if (imageFrame == null) {
            this.nuller = true;
            return;
        }
        SeriesInfo seriesInfo = imageFrame.getUncopiedMutableInfo();
        this.pName = seriesInfo.patientName;
        this.studyDate = seriesInfo.N();
        this.patientId = seriesInfo.patientId;
        this.reoriented = seriesInfo.reoriented;
        this.selectedExtent = seriesInfo.selectedExtent;
        this.volumeId = imageFrame.x();
        if (this.volumeId == -1L) {
            ay.d((Object)("Should never be creating a vol state for an unregistered vol: " + imageFrame), this);
        }
        if (this.selectedExtent != null) {
            System.out.println("Woo, got selected extent!");
        }
        this.ocState = new SerialOverlayCollection(imageFrame.n(), a2);
        ViewController viewController = imageFrame.j();
        if (viewController != null && viewController.bi() && viewController.bl()) {
            iterable = ((ViewController3D)viewController).cE();
        }
        this.info = seriesInfo;
        iterable = Sets.newLinkedHashSet();
        boolean bl2 = false;
        if (imageFrame instanceof ImageVolumeShort) {
            serializable = (ImageVolumeShort)imageFrame;
            bl2 = this.a(a2, bl2, (ImageVolumeShort)serializable);
        } else if (imageFrame instanceof BufferedPlanarImage) {
            this.isVideo = true;
            this.videoVoxel = imageFrame.b();
            System.out.println("the volume being saved is a video.");
        }
        serializable = imageFrame.q();
        if (serializable == null) {
            ay.c((Object)"Volume has no source info at session save time; shouldn't happen.", this);
            serializable = new VolumeSourceInfo();
        }
        if (!bl2 && ((VolumeSourceInfo)serializable).e()) {
            System.out.println("full save type");
            if (imageFrame instanceof ImageVolumeShort) {
                object = (ImageVolumeShort)imageFrame;
                this.entireVol = object;
                if (cn.h(seriesInfo.ag()) || seriesInfo.volumeHasBeenSaved && !((VolumeSourceInfo)serializable).c()) {
                    seriesInfo.Q();
                }
            } else {
                System.out.println("Problem on volume save... weird type");
            }
        }
        this.seriesUID = seriesInfo.ag();
        System.out.println("sDesc serial: " + seriesInfo.seriesDesc);
        this.derived = ((VolumeSourceInfo)serializable).f();
        if (serializable != null && (object = ((VolumeSourceInfo)serializable).a()) != null) {
            this.searchSourceName = ((SearchSource)object).j();
            this.searchSourceType = ((SearchSource)object).I();
        }
        if (viewController == null || viewController.g().T()) {
            ay.c((Object)"Volume has null or headless parent, careful.", this);
        } else {
            object = p.e(viewController);
            if (object != null && ((ViewController)object).bi() && ((ViewController3D)((Object)(list = (ViewController3D)object))).b(VolumetricRendering.RenderingType.c)) {
                ae object2 = ((ViewController3D)((Object)list)).c(VolumetricRendering.RenderingType.c);
                this.goonSSPBonusSSPImages = object2.p().a();
            }
        }
        if (imageFrame instanceof SimpleImageVolume) {
            object = (SimpleImageVolume)((Object)imageFrame);
            list = ((SimpleImageVolume)object).as();
            if (list != null) {
                for (SliceInfo sliceInfo : list) {
                    String string = sliceInfo.sopInstanceUID;
                    if (string == null || string.length() <= 0) continue;
                    iterable.add((UIDContainer.SOPInstanceUID)new UIDContainer.SOPInstanceUID(string));
                }
            } else {
                iterable.add((UIDContainer.SOPInstanceUID)new UIDContainer.SOPInstanceUID(((SimpleImageVolume)object).getUncopiedMutableInfo().sopInstanceUID));
            }
        } else if (viewController != null) {
            iterable.add((UIDContainer.SOPInstanceUID)new UIDContainer.SOPInstanceUID(imageFrame.getUncopiedMutableInfo().sopInstanceUID));
        }
        if (viewController != null) {
            object = Lists.newArrayList();
            if (viewController.is2D()) {
                for (MimPlanarImage mimPlanarImage : viewController.be().k()) {
                    if (!mimPlanarImage.s()) continue;
                    object.add(new FrameNumber(mimPlanarImage.c()));
                }
            } else if (viewController.bi() && (list = viewController.bh().cE()) != null) {
                for (ImageVolumeShort imageVolumeShort : ((o)((Object)list)).l()) {
                    if (!imageVolumeShort.s()) continue;
                    object.add(new FrameNumber(imageVolumeShort.c()));
                }
            }
            if (object.size() > 0) {
                this.frameNumbersFor2D = object;
            }
        }
        if (!iterable.isEmpty()) {
            this.allSops = Lists.newArrayList(iterable);
        }
    }

    public Set<UIDContainer.SOPInstanceUID> a() {
        if (this.sopsToLoadForDynamic2D != null && !this.sopsToLoadForDynamic2D.isEmpty()) {
            return Sets.newHashSet(this.sopsToLoadForDynamic2D);
        }
        if (this.allSops != null && !this.allSops.isEmpty()) {
            return Sets.newHashSet(this.allSops);
        }
        if (this.sopInstanceUID != null) {
            ay.a((Object)"Falling back to using single SOP field, unusual legacy case?", this);
            return Sets.newHashSet((Object[])new UIDContainer.SOPInstanceUID[]{this.sopInstanceUID});
        }
        return null;
    }

    private boolean a(SessionState.a a2, boolean bl2, ImageVolumeShort imageVolumeShort) {
        if (imageVolumeShort.R() != null) {
            System.out.println("warpy save type");
            WarpTransform warpTransform = imageVolumeShort.R();
            InverseWarpTransform inverseWarpTransform = imageVolumeShort.S();
            if (warpTransform instanceof WarpTransform) {
                this.warp = new TransformWrapper(a2, warpTransform);
                a2.b.put(warpTransform, this.warp);
                this.invWarp = new TransformWrapper(a2, inverseWarpTransform);
                a2.b.put(inverseWarpTransform, this.invWarp);
            } else {
                System.out.println("State save failure involving warps...");
            }
            this.dcmCenter = imageVolumeShort.G();
            this.frameOfRefUID = this.info.frameOfRefUID;
            bl2 = true;
        }
        return bl2;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        boolean bl2 = this.b = !ReadHelper.b(getField, "reoriented");
        if (!ReadHelper.b(getField, "embedIdx")) {
            this.embedIdx = -1;
        }
        if (!ReadHelper.b(getField, "volId")) {
            this.volumeId = -2L;
        }
        if (this.doseVols == null) {
            this.doseVols = Lists.newArrayList();
        }
        ReadHelper readHelper = new ReadHelper();
        readHelper.a(getField, (Object)this);
    }
}

