/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.sureplan;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Floats;
import com.mimvista.LocalLicense.LicenseOption;
import com.mimvista.commands.MIMFeatureCategory;
import com.mimvista.commands.MIMFeatureType;
import com.mimvista.commands.SessionPredicate;
import com.mimvista.commands.i;
import com.mimvista.commands.keyboard.DeriveResampledVolumeCommand;
import com.mimvista.commands.workflow.WorkflowCommand;
import com.mimvista.d;
import com.mimvista.dicom.DataUnitUtils;
import com.mimvista.dicom.rtdose.DoseValue;
import com.mimvista.dicom.util.RescaleConverter;
import com.mimvista.gui.util.MockDialogPanel;
import com.mimvista.internals.Contour;
import com.mimvista.internals.ViewController;
import com.mimvista.internals.ViewController3D;
import com.mimvista.internals.statistics.ContourStatistician;
import com.mimvista.internals.statistics.Statistician;
import com.mimvista.internals.volumes.ImageVolumeShort;
import com.mimvista.mui.overlays.IsodoseOverlay;
import com.mimvista.mui.overlays.Overlayish;
import com.mimvista.mui.overlays.VolumetricContourOverlayish;
import com.mimvista.numerics.ImageCube;
import com.mimvista.numerics.ImageSlice;
import com.mimvista.numerics.MultipliedIndexPoint3i;
import com.mimvista.numerics.VoxelIndexPoint3i;
import com.mimvista.sureplan.DicomDecayCorrection;
import com.mimvista.sureplan.SurePlanDoseCalcMethod;
import com.mimvista.sureplan.a;
import com.mimvista.sureplan.c;
import com.mimvista.sureplan.e;
import com.mimvista.sureplan.f;
import com.mimvista.sureplan.ui.CreateDoseFromImageDialog;
import com.mimvista.swing.widgets.BasicNotification;
import com.mimvista.swing.widgets.Notification;
import com.mimvista.swing.widgets.m;
import com.mimvista.swing.widgets.u;
import com.mimvista.util.Messages;
import com.mimvista.util.ay;
import com.mimvista.util.progress.Progress;
import com.mimvista.viewer.PTSeriesInfo;
import com.mimvista.viewer.RTDoseSeriesInfo;
import com.mimvista.viewer.SeriesInfo;
import com.mimvista.viewer.UnitHelper;
import com.mimvista.viewer.algo.BestContrastor;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.function.Consumer;
import javax.swing.SwingUtilities;

@com.mimvista.commands.e(e="create_dose_from_image", f="create_dose_from_image", b="CREATE_DOSE_FROM_IMAGE_NAME", a="Commands", h="image_to_dose", k=MIMFeatureCategory.DOSE, l={MIMFeatureType.Workflow}, i={i.class}, n={SessionPredicate.NonNull}, j={LicenseOption.SURE_PLAN})
public class CreateDoseFromImageCommand
extends WorkflowCommand {
    public static final double a = 0.0010400000000000001;
    private ViewController3D b;
    private a.a c;

    public CreateDoseFromImageCommand(ViewController3D viewController3D, SurePlanDoseCalcMethod surePlanDoseCalcMethod, @d List<VolumetricContourOverlayish> list, @d List<VolumetricContourOverlayish> list2, float f2) {
        this.b = viewController3D;
        this.c = com.mimvista.sureplan.a.n();
        if (viewController3D != null) {
            this.c.a(viewController3D);
            this.c.a(this.getDicomIsotope(viewController3D));
        }
        this.c.c(e.b());
        if (surePlanDoseCalcMethod != null) {
            this.c.a(surePlanDoseCalcMethod);
        }
        if (list != null && !list.isEmpty()) {
            Preconditions.checkArgument((list.size() == 1 ? 1 : 0) != 0, (Object)("Expected 1 contour for wholeBodyContour but got " + list.size()));
            this.c.a(list.get(0));
        }
        if (list2 != null && !list2.isEmpty()) {
            Preconditions.checkArgument((list2.size() == 1 ? 1 : 0) != 0, (Object)("Expected 1 contour for wholeBodyContour but got " + list2.size()));
            this.c.b(list2.get(0));
        }
        if (f2 > 0.0f) {
            this.c.a(Float.valueOf(f2));
        }
    }

    @Override
    public IsodoseOverlay execute() {
        return this.popExtensionDialogAndConvert();
    }

    private com.mimvista.sureplan.d getDicomIsotope(ViewController3D viewController3D) {
        SeriesInfo seriesInfo = viewController3D.getUncopiedMutableInfo();
        if (seriesInfo.modInfo instanceof PTSeriesInfo) {
            String string = MessageFormat.format(Messages.a("SurePlan", "DICOM_ISOTOPE_NAME_FORMAT"), seriesInfo.radpharm, seriesInfo.b(0));
            float f2 = seriesInfo.halflife;
            float f3 = ((PTSeriesInfo)seriesInfo.modInfo).radNucPositronFraction;
            return new com.mimvista.sureplan.d(string, string, f2, f3, null);
        }
        return null;
    }

    private IsodoseOverlay popExtensionDialogAndConvert() {
        com.mimvista.sureplan.a a2 = this.c.a();
        if (a2.i() == SurePlanDoseCalcMethod.c && (a2.d() == null || a2.e() == null)) {
            ay.d((Object)("Error in " + this.getName() + " command:  one or more required contours were null, dose will not be created"), this);
            MockDialogPanel mockDialogPanel = new MockDialogPanel(Messages.a("SurePlan", "LDM_CANT_FIND_CONTOURS"), BasicNotification.NotificationType.a);
            mockDialogPanel.a(MessageFormat.format(Messages.a("SurePlan", "WF_ERROR_NOT_TITLE"), this.getName()));
            CountDownLatch countDownLatch = new CountDownLatch(1);
            mockDialogPanel.b(mockDialogEvent -> countDownLatch.countDown());
            m m2 = new m(mockDialogPanel);
            m2.a(new Notification.a(a2.a().g()));
            u.b().c(m2);
            try {
                countDownLatch.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return null;
        }
        CreateDoseFromImageDialog createDoseFromImageDialog = new CreateDoseFromImageDialog(a2, this::doConversion);
        createDoseFromImageDialog.setVisible(true);
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        createDoseFromImageDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                countDownLatch.countDown();
            }
        });
        while (countDownLatch.getCount() > 0L) {
            try {
                countDownLatch.await();
            }
            catch (InterruptedException interruptedException) {}
        }
        return createDoseFromImageDialog.a();
    }

    @Override
    public com.mimvista.workflow.gui.args.a<WorkflowCommand>[] createArgumentViews(com.mimvista.workflow.gui.c<WorkflowCommand> c2) {
        com.mimvista.workflow.gui.args.a[] aArray = super.createArgumentViews(c2);
        aArray[1].a(() -> {
            SurePlanDoseCalcMethod surePlanDoseCalcMethod = (SurePlanDoseCalcMethod)aArray[1].k_().a();
            aArray[2].n().setVisible(surePlanDoseCalcMethod == SurePlanDoseCalcMethod.c);
            aArray[3].n().setVisible(surePlanDoseCalcMethod == SurePlanDoseCalcMethod.c);
        });
        return aArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IsodoseOverlay doConversion(com.mimvista.sureplan.a a2) {
        ViewController3D viewController3D = a2.a();
        UnitHelper unitHelper = viewController3D.getUncopiedMutableInfo().u();
        UnitHelper.AppliedImageUnit appliedImageUnit = null;
        if (unitHelper.w() && DataUnitUtils.BQML_CANON_.matchesUnit(unitHelper.a().unit.canonBaseUnit)) {
            ay.b((Object)("Temporarily converting units from " + unitHelper.C() + " to BQML for dose calc"), this);
            appliedImageUnit = unitHelper.m();
            unitHelper.b(unitHelper.a());
            viewController3D.cw().an_();
        }
        try {
            switch (a2.i()) {
                case b: {
                    IsodoseOverlay isodoseOverlay = this.convertUsingDPK(a2);
                    return isodoseOverlay;
                }
                case a: {
                    IsodoseOverlay isodoseOverlay = this.convertUsingLDM(a2);
                    return isodoseOverlay;
                }
                case c: {
                    IsodoseOverlay isodoseOverlay = this.convertUsingLdmWithActivity(a2);
                    return isodoseOverlay;
                }
            }
            return null;
        }
        finally {
            if (appliedImageUnit != null) {
                unitHelper.b(appliedImageUnit);
                viewController3D.cw().an_();
            }
        }
    }

    private IsodoseOverlay convertUsingDPK(com.mimvista.sureplan.a a2) {
        ViewController3D viewController3D = a2.a();
        ImageVolumeShort imageVolumeShort = viewController3D.cw();
        ImageVolumeShort imageVolumeShort2 = imageVolumeShort.W();
        com.mimvista.sureplan.b b2 = new com.mimvista.sureplan.b();
        b2.a(a2.l());
        b2.b(a2.m());
        if (!a2.g().equals(a2.h())) {
            b2.a(imageVolumeShort2, a2.g());
            b2.a(imageVolumeShort2, DicomDecayCorrection.c, a2.h());
        } else {
            b2.a(imageVolumeShort2, DicomDecayCorrection.c, a2.h());
        }
        float[] fArray = new float[]{3.0f, 3.0f, 3.0f};
        if (!CreateDoseFromImageCommand.isVoxelSize(imageVolumeShort2, fArray)) {
            imageVolumeShort2 = DeriveResampledVolumeCommand.LoadFromResampleState.a(imageVolumeShort2, fArray, true, null);
        }
        float[][][] fArray2 = CreateDoseFromImageCommand.copyImageIntoFloatArray(imageVolumeShort2);
        double d2 = CreateDoseFromImageCommand.correctPositronBranchFactor(a2.g(), a2.h()) * CreateDoseFromImageCommand.calculateCumulativeCounts(imageVolumeShort2, a2.h());
        ay.b((Object)("Correction factor: " + d2), this);
        c c2 = new c(f.a(d2));
        c2.a(a2.j());
        float[][][] fArray3 = c2.a(fArray2);
        fArray2 = null;
        ImageVolumeShort imageVolumeShort3 = this.createBlankDose(a2, CreateDoseFromImageCommand.getDims(fArray3), fArray, viewController3D);
        CreateDoseFromImageCommand.calcRescaleSlope(imageVolumeShort3, fArray3);
        float f2 = 0.0f;
        f2 = a2.k() != null ? a2.k().floatValue() : CreateDoseFromImageCommand.getMax(fArray3);
        CreateDoseFromImageCommand.copyFloatArrayIntoImage(fArray3, imageVolumeShort3);
        fArray3 = null;
        RTDoseSeriesInfo rTDoseSeriesInfo = (RTDoseSeriesInfo)imageVolumeShort3.getUncopiedMutableInfo().modInfo;
        rTDoseSeriesInfo.getRxDose().setValueInGy(f2);
        IsodoseOverlay isodoseOverlay = new IsodoseOverlay((ViewController)viewController3D, imageVolumeShort3);
        viewController3D.ba().a((Overlayish)isodoseOverlay, false);
        return isodoseOverlay;
    }

    private IsodoseOverlay convertUsingLDM(com.mimvista.sureplan.a a2) {
        Object object;
        ViewController3D viewController3D = a2.a();
        ImageVolumeShort imageVolumeShort = viewController3D.cw();
        ImageVolumeShort imageVolumeShort2 = imageVolumeShort.W();
        if (!a2.g().equals(a2.h())) {
            object = new com.mimvista.sureplan.b();
            ((com.mimvista.sureplan.b)object).a(a2.l());
            ((com.mimvista.sureplan.b)object).b(a2.m());
            ((com.mimvista.sureplan.b)object).a(imageVolumeShort2, a2.g());
            ((com.mimvista.sureplan.b)object).a(imageVolumeShort2, DicomDecayCorrection.c, a2.h());
        }
        object = CreateDoseFromImageCommand.copyImageIntoFloatArray(imageVolumeShort2);
        double d2 = CreateDoseFromImageCommand.correctPositronBranchFactor(a2.g(), a2.h()) * ((double)a2.h().getLdmConstant().floatValue() / 0.0010400000000000001);
        ay.b((Object)("Correction factor: " + d2), this);
        if (a2.j() != null) {
            SwingUtilities.invokeLater(() -> CreateDoseFromImageCommand.lambda$convertUsingLDM$2(a2, (float[][][])object));
        }
        for (int i2 = 0; i2 < ((Object)object).length; ++i2) {
            int n2;
            for (n2 = 0; n2 < ((Object)object[i2]).length; ++n2) {
                int n3 = 0;
                while (n3 < ((Object)object[i2][n2]).length) {
                    Object object2 = object[i2][n2];
                    int n4 = n3++;
                    object2[n4] = (float)((double)object2[n4] * d2);
                }
            }
            if (a2.j() == null) continue;
            n2 = i2 + 1;
            SwingUtilities.invokeLater(() -> a2.j().b(n2));
        }
        ImageVolumeShort imageVolumeShort3 = this.createBlankDose(a2, CreateDoseFromImageCommand.getDims((float[][][])object), imageVolumeShort.b(), viewController3D);
        CreateDoseFromImageCommand.calcRescaleSlope(imageVolumeShort3, (float[][][])object);
        float f2 = 0.0f;
        f2 = a2.k() != null ? a2.k().floatValue() : CreateDoseFromImageCommand.getMax((float[][][])object);
        RTDoseSeriesInfo rTDoseSeriesInfo = (RTDoseSeriesInfo)imageVolumeShort3.getUncopiedMutableInfo().modInfo;
        rTDoseSeriesInfo.getRxDose().setValueInGy(f2);
        CreateDoseFromImageCommand.copyFloatArrayIntoImage((float[][][])object, imageVolumeShort3);
        IsodoseOverlay isodoseOverlay = new IsodoseOverlay((ViewController)viewController3D, imageVolumeShort3);
        viewController3D.ba().a((Overlayish)isodoseOverlay, false);
        return isodoseOverlay;
    }

    private IsodoseOverlay convertUsingLdmWithActivity(com.mimvista.sureplan.a a2) {
        ViewController3D viewController3D = a2.a();
        ImageVolumeShort imageVolumeShort = viewController3D.cw();
        int[] nArray = viewController3D.ay();
        VolumetricContourOverlayish volumetricContourOverlayish = a2.d();
        VolumetricContourOverlayish volumetricContourOverlayish2 = a2.e();
        float[][][] fArray = CreateDoseFromImageCommand.copyImageIntoFloatArray(imageVolumeShort);
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            for (int i3 = 0; i3 < fArray[i2].length; ++i3) {
                Arrays.fill(fArray[i2][i3], 0.0f);
            }
        }
        SwingUtilities.invokeLater(() -> {
            Progress progress = a2.j();
            progress.a(nArray[2] + nArray[2] + fArray.length);
            progress.b(0);
            progress.a(false);
        });
        Statistician.e e2 = volumetricContourOverlayish.bF_().b(Collections.singleton(ContourStatistician.p));
        float f2 = e2.a(ContourStatistician.p).d.floatValue();
        ay.b((Object)("Total body activity: " + f2), this);
        a a3 = new a(a2, imageVolumeShort, fArray, f2);
        this.forEachImageVoxelCoveredByContour(volumetricContourOverlayish2, imageVolumeShort, 0.5f, a3);
        ImageVolumeShort imageVolumeShort2 = this.createBlankDose(a2, CreateDoseFromImageCommand.getDims(fArray), viewController3D.ao_(), viewController3D);
        CreateDoseFromImageCommand.calcRescaleSlope(imageVolumeShort2, fArray);
        float f3 = 0.0f;
        f3 = a2.k() != null ? a2.k().floatValue() : CreateDoseFromImageCommand.getMax(fArray);
        SeriesInfo seriesInfo = imageVolumeShort2.getUncopiedMutableInfo();
        RTDoseSeriesInfo rTDoseSeriesInfo = (RTDoseSeriesInfo)seriesInfo.modInfo;
        rTDoseSeriesInfo.doseGridScaling = seriesInfo.rescale.slope;
        rTDoseSeriesInfo.getRxDose().setValueInGy(f3);
        CreateDoseFromImageCommand.copyFloatArrayIntoImage(fArray, imageVolumeShort2);
        IsodoseOverlay isodoseOverlay = new IsodoseOverlay((ViewController)viewController3D, imageVolumeShort2);
        viewController3D.ba().a((Overlayish)isodoseOverlay, false);
        return isodoseOverlay;
    }

    private void forEachImageVoxelCoveredByContour(VolumetricContourOverlayish volumetricContourOverlayish, ImageVolumeShort imageVolumeShort, float f2, Consumer<VoxelIndexPoint3i> consumer) {
        Contour contour = volumetricContourOverlayish.aq();
        int n2 = contour.b(0);
        int n3 = contour.b(1);
        int n4 = contour.b(2);
        int n5 = n2 * n3 * n4;
        int n6 = (int)((float)n5 * f2);
        VoxelIndexPoint3i voxelIndexPoint3i = contour.C().k();
        VoxelIndexPoint3i voxelIndexPoint3i2 = voxelIndexPoint3i.b();
        VoxelIndexPoint3i voxelIndexPoint3i3 = contour.D().k();
        MultipliedIndexPoint3i multipliedIndexPoint3i = MultipliedIndexPoint3i.a(0, 0, 0, contour);
        voxelIndexPoint3i2.z = voxelIndexPoint3i.z;
        while (voxelIndexPoint3i2.z <= voxelIndexPoint3i3.z) {
            voxelIndexPoint3i2.y = voxelIndexPoint3i.y;
            while (voxelIndexPoint3i2.y <= voxelIndexPoint3i3.y) {
                voxelIndexPoint3i2.x = voxelIndexPoint3i.x;
                while (voxelIndexPoint3i2.x <= voxelIndexPoint3i3.x) {
                    int n7 = 0;
                    block3: for (int i2 = 0; i2 < n4; ++i2) {
                        multipliedIndexPoint3i.z = voxelIndexPoint3i2.z * n4 + i2;
                        for (int i3 = 0; i3 < n3; ++i3) {
                            multipliedIndexPoint3i.y = voxelIndexPoint3i2.y * n3 + i3;
                            for (int i4 = 0; i4 < n2; ++i4) {
                                multipliedIndexPoint3i.x = voxelIndexPoint3i2.x * n2 + i4;
                                if (!contour.b(multipliedIndexPoint3i) || ++n7 < n6) continue;
                                consumer.accept(voxelIndexPoint3i2);
                                break block3;
                            }
                        }
                    }
                    ++voxelIndexPoint3i2.x;
                }
                ++voxelIndexPoint3i2.y;
            }
            ++voxelIndexPoint3i2.z;
        }
    }

    static double correctPositronBranchFactor(com.mimvista.sureplan.d d2, com.mimvista.sureplan.d d3) {
        if (d2 == d3) {
            return 1.0;
        }
        return d2.getPositronFraction() / d3.getPositronFraction();
    }

    static double calculateCumulativeCounts(ImageVolumeShort imageVolumeShort, com.mimvista.sureplan.d d2) {
        float[] fArray = imageVolumeShort.b();
        return (double)(fArray[0] * fArray[1] * fArray[2]) / 1000.0 / -d2.getDecayConstant();
    }

    private ImageVolumeShort createBlankDose(com.mimvista.sureplan.a a2, int[] nArray, float[] fArray, ViewController viewController) {
        SeriesInfo seriesInfo = SeriesInfo.a(viewController.getUncopiedMutableInfo());
        seriesInfo.rescale = new RescaleConverter(0.2f, 0.0f);
        seriesInfo.scalingFactorFromOriginal = 1;
        seriesInfo.seriesDesc = "Converted from a Y90 image (Dose calc method: " + a2.i() + ")";
        DoseValue doseValue = new DoseValue();
        doseValue.setValueInGy(0.0f);
        seriesInfo.modInfo = new RTDoseSeriesInfo(viewController.getUncopiedMutableInfo().ag(), 1.0f, doseValue, "", "", "");
        seriesInfo.u().a("Gy");
        seriesInfo.modality = "RTDOSE";
        seriesInfo.mimDerivedVolume = false;
        ImageCube.ImageCubeShort imageCubeShort = ImageCube.ImageCubeShort.a(nArray, (short)seriesInfo.rescale.removeWithBounds(0.0f));
        ImageVolumeShort imageVolumeShort = new ImageVolumeShort(viewController);
        imageVolumeShort.a(imageCubeShort);
        imageVolumeShort.b(seriesInfo);
        imageVolumeShort.a(fArray);
        imageVolumeShort.a(BestContrastor.SubtractionStrategy.d);
        imageVolumeShort.f(true);
        imageVolumeShort.c(false);
        imageVolumeShort.q().a(true);
        imageVolumeShort.n().a(viewController.g());
        imageVolumeShort.b(viewController.cq().get(0).G());
        return imageVolumeShort;
    }

    static float[][][] copyImageIntoFloatArray(ImageVolumeShort imageVolumeShort) {
        int[] nArray = imageVolumeShort.a();
        RescaleConverter rescaleConverter = imageVolumeShort.getUncopiedMutableInfo().rescale;
        ImageCube.ImageCubeShort imageCubeShort = (ImageCube.ImageCubeShort)imageVolumeShort.ad();
        float[][][] fArray = new float[nArray[2]][nArray[1]][nArray[0]];
        for (int i2 = 0; i2 < nArray[2]; ++i2) {
            ImageSlice.ImageSliceShort imageSliceShort = (ImageSlice.ImageSliceShort)imageCubeShort.f(i2);
            for (int i3 = 0; i3 < nArray[1]; ++i3) {
                for (int i4 = 0; i4 < nArray[0]; ++i4) {
                    fArray[i2][i3][i4] = rescaleConverter.apply(imageSliceShort.d(i4, i3));
                }
            }
        }
        return fArray;
    }

    static void copyFloatArrayIntoImage(float[][][] fArray, ImageVolumeShort imageVolumeShort) {
        int n2 = fArray.length;
        int n3 = fArray[0].length;
        int n4 = fArray[0][0].length;
        int[] nArray = CreateDoseFromImageCommand.getDims(fArray);
        int[] nArray2 = imageVolumeShort.a();
        if (!Arrays.equals(nArray2, nArray)) {
            throw new IllegalArgumentException("The dimensions of the input data don't match the dimensions of the destination volume (" + Arrays.toString(nArray) + " vs " + Arrays.toString(nArray2) + ")");
        }
        ImageCube.ImageCubeShort imageCubeShort = (ImageCube.ImageCubeShort)imageVolumeShort.ad();
        RescaleConverter rescaleConverter = imageVolumeShort.getUncopiedMutableInfo().rescale;
        for (int i2 = 0; i2 < n2; ++i2) {
            ImageSlice.ImageSliceShort imageSliceShort = (ImageSlice.ImageSliceShort)imageCubeShort.f(i2);
            for (int i3 = 0; i3 < n3; ++i3) {
                for (int i4 = 0; i4 < n4; ++i4) {
                    imageSliceShort.a(i4, i3, (short)rescaleConverter.removeWithBounds(fArray[i2][i3][i4]));
                }
            }
        }
    }

    static void calcRescaleSlope(ImageVolumeShort imageVolumeShort, float[][][] fArray) {
        int n2;
        int n3;
        RescaleConverter rescaleConverter = imageVolumeShort.getUncopiedMutableInfo().rescale;
        float f2 = Float.MAX_VALUE;
        float f3 = Float.MIN_VALUE;
        for (n3 = 0; n3 < fArray.length; ++n3) {
            for (n2 = 0; n2 < fArray[n3].length; ++n2) {
                f2 = Math.min(f2, Floats.min((float[])fArray[n3][n2]));
                f3 = Math.max(f3, Floats.max((float[])fArray[n3][n2]));
            }
        }
        n3 = 0;
        n2 = Short.MAX_VALUE;
        if (f2 >= 0.0f) {
            f2 = 0.0f;
        } else {
            n3 = -32766;
        }
        rescaleConverter.slope = (f3 - f2) / (float)(n2 - n3);
        rescaleConverter.intercept = (f2 * (float)n2 - f3 * (float)n3) / (float)(n2 - n3);
    }

    private static float getMax(float[][][] fArray) {
        float f2 = Float.MIN_VALUE;
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            for (int i3 = 0; i3 < fArray[i2].length; ++i3) {
                f2 = Math.max(f2, Floats.max((float[])fArray[i2][i3]));
            }
        }
        return f2;
    }

    private static int[] getDims(float[][][] fArray) {
        int n2 = fArray.length;
        int n3 = fArray[0].length;
        int n4 = fArray[0][0].length;
        return new int[]{n4, n3, n2};
    }

    static boolean epEquals(float f2, float f3, float f4) {
        return Math.abs(f2 - f3) <= f4;
    }

    static boolean isVoxelSize(ImageVolumeShort imageVolumeShort, float[] fArray) {
        float[] fArray2 = imageVolumeShort.b();
        return CreateDoseFromImageCommand.epEquals(fArray2[0], fArray[0], 0.1f) && CreateDoseFromImageCommand.epEquals(fArray2[1], fArray[1], 0.1f) && CreateDoseFromImageCommand.epEquals(fArray2[2], fArray[2], 0.1f);
    }

    private static /* synthetic */ void lambda$convertUsingLDM$2(com.mimvista.sureplan.a a2, float[][][] fArray) {
        Progress progress = a2.j();
        progress.a(fArray.length);
        progress.b(0);
    }

    private class a
    implements Consumer<VoxelIndexPoint3i> {
        private final ImageCube.ImageCubeShort b;
        private final RescaleConverter c;
        private final float[][][] d;
        private final float e;
        private final double f;

        public a(com.mimvista.sureplan.a a2, ImageVolumeShort imageVolumeShort, float[][][] fArray, float f2) {
            this.b = (ImageCube.ImageCubeShort)imageVolumeShort.ad();
            this.c = imageVolumeShort.getUncopiedMutableInfo().rescale;
            this.d = fArray;
            this.e = f2;
            float[] fArray2 = imageVolumeShort.b();
            float f3 = fArray2[0] * fArray2[1] * fArray2[2] * 0.001f;
            float f4 = a2.b() * 1.0E9f;
            float f5 = a2.c();
            if (f5 >= 0.0f) {
                f4 *= 1.0f - f5;
            }
            this.f = (double)(f4 * a2.h().getLdmConstant().floatValue()) / 0.0010400000000000001 / (double)f3;
        }

        public void a(VoxelIndexPoint3i voxelIndexPoint3i) {
            float f2;
            float f3 = this.c.apply(this.b.b(voxelIndexPoint3i.x, voxelIndexPoint3i.y, voxelIndexPoint3i.z));
            this.d[voxelIndexPoint3i.z][voxelIndexPoint3i.y][voxelIndexPoint3i.x] = f2 = (float)((double)f3 / (double)this.e * this.f);
        }

        @Override
        public /* synthetic */ void accept(Object object) {
            this.a((VoxelIndexPoint3i)((Object)object));
        }
    }

    private class b
    implements Consumer<VoxelIndexPoint3i> {
        private final ImageVolumeShort b;
        private final ImageCube.ImageCubeShort c;
        private final RescaleConverter d;
        private float e;

        public b(ImageVolumeShort imageVolumeShort) {
            this.b = imageVolumeShort;
            this.c = (ImageCube.ImageCubeShort)imageVolumeShort.ad();
            this.d = imageVolumeShort.getUncopiedMutableInfo().rescale;
            this.e = 0.0f;
        }

        public void a(VoxelIndexPoint3i voxelIndexPoint3i) {
            this.e += this.d.apply(this.c.b(voxelIndexPoint3i.x, voxelIndexPoint3i.y, voxelIndexPoint3i.z));
        }

        public float a() {
            return this.e;
        }

        @Override
        public /* synthetic */ void accept(Object object) {
            this.a((VoxelIndexPoint3i)((Object)object));
        }
    }
}

