/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.sureplan.ui;

import com.google.common.base.Preconditions;
import com.mimvista.dicom.DataUnitUtils;
import com.mimvista.dicom.Modality;
import com.mimvista.dicom.rtdose.Units;
import com.mimvista.gui.util.MIMSwingUtils;
import com.mimvista.internals.ViewController3D;
import com.mimvista.internals.volumes.ImageVolumeShort;
import com.mimvista.mui.ak;
import com.mimvista.mui.overlays.IsodoseOverlay;
import com.mimvista.mui.overlays.VolumetricContourOverlayish;
import com.mimvista.preferencesNew.DosePrefs;
import com.mimvista.preferencesNew.SurePlanPrefs;
import com.mimvista.sureplan.SurePlanDoseCalcMethod;
import com.mimvista.sureplan.a;
import com.mimvista.sureplan.d;
import com.mimvista.sureplan.e;
import com.mimvista.sureplan.ui.IsotopeSelectionPanel;
import com.mimvista.sureplan.ui.SurePlanWarningSummaryDialog;
import com.mimvista.sureplan.ui.b;
import com.mimvista.swing.g;
import com.mimvista.util.DateUtils;
import com.mimvista.util.MIMFormat;
import com.mimvista.util.Messages;
import com.mimvista.util.WarningItem;
import com.mimvista.util.ay;
import com.mimvista.viewer.SeriesInfo;
import com.mimvista.viewer.UnitHelper;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class CreateDoseFromImageDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    public static final DateFormat a = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    public static final DateFormat b = new SimpleDateFormat("yyyyMMddHHmmss");
    private ViewController3D inputImage;
    private SurePlanDoseCalcMethod initialDoseCalcMethod;
    private VolumetricContourOverlayish wholeBodyContour;
    private VolumetricContourOverlayish liverContour;
    private float initialRxDose;
    private d dicomIsotope;
    private IsotopeSelectionPanel scannerIsotopeSelector;
    private IsotopeSelectionPanel actualIsotopeSelector;
    private JComboBox<SurePlanDoseCalcMethod> doseCalcMethodCombo;
    private JTextField txtRxDose;
    private Units rxDoseUnits;
    private JLabel lblRxDoseUnits;
    private Box knownActivityPanel;
    private Box lungShuntPanel;
    private JTextField txtKnownActivity;
    private JLabel lblKnownActivityUnits;
    private JTextField txtLungShuntPercentage;
    private Component knownActivitySeparator;
    private Component lungShuntSeparator;
    private JPanel dateAdjusterGridPanel;
    private JCheckBox checkInjectionDate;
    private JCheckBox checkAcquisitionDate;
    private JTextField txtInjectionDate;
    private JTextField txtAcquisitionDate;
    private JPanel timeBetweenInjectionAndAcquisitionPanel;
    private Component dateAdjusterSeparator;
    private JLabel timeBetweenInjectionAndAcquisitionLabel;
    private JProgressBar progressBar;
    private JButton runButton;
    private Thread conversionThread;
    private boolean isSpect;
    private Function<a, IsodoseOverlay> commandRunner;
    private IsodoseOverlay doseOutput;

    public CreateDoseFromImageDialog(a a2, Function<a, IsodoseOverlay> function) {
        super(ak.S());
        this.inputImage = a2.a();
        this.initialDoseCalcMethod = a2.i();
        this.wholeBodyContour = a2.d();
        this.liverContour = a2.e();
        this.initialRxDose = a2.k() == null ? -1.0f : a2.k().floatValue();
        this.dicomIsotope = a2.f();
        this.isSpect = Modality.NM.isSameModality(this.inputImage.getUncopiedMutableInfo().modality);
        this.commandRunner = function;
        this.setTitle(Messages.a("Commands", "CREATE_DOSE_FROM_IMAGE_NAME"));
        this.b();
        this.pack();
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(2);
    }

    public IsodoseOverlay a() {
        return this.doseOutput;
    }

    private void b() {
        Serializable serializable;
        Box box = Box.createVerticalBox();
        this.doseCalcMethodCombo = this.e();
        if (this.initialDoseCalcMethod != null) {
            this.doseCalcMethodCombo.setSelectedItem(this.initialDoseCalcMethod);
        }
        if (this.doseCalcMethodCombo.getSelectedItem() == null) {
            this.doseCalcMethodCombo.setSelectedIndex(0);
        }
        this.doseCalcMethodCombo.addActionListener(actionEvent -> {
            SurePlanDoseCalcMethod surePlanDoseCalcMethod = this.d();
            this.a(surePlanDoseCalcMethod == SurePlanDoseCalcMethod.c, true);
            this.b(surePlanDoseCalcMethod == SurePlanDoseCalcMethod.c, true);
        });
        Box box2 = Box.createVerticalBox();
        box2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(Messages.a("SurePlan", "DOSE_CALCULATION_METHOD")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        box2.add(this.doseCalcMethodCombo);
        this.scannerIsotopeSelector = new IsotopeSelectionPanel(Messages.a("SurePlan", "SCANNER_ISOTOPE"));
        if (this.dicomIsotope != null) {
            this.scannerIsotopeSelector.b(this.dicomIsotope);
            this.scannerIsotopeSelector.a(this.dicomIsotope);
        } else {
            this.scannerIsotopeSelector.a(e.c());
        }
        this.actualIsotopeSelector = new IsotopeSelectionPanel(Messages.a("SurePlan", "ACTUAL_ISOTOPE"));
        this.actualIsotopeSelector.a((d d2) -> d2.getLdmConstant() != null);
        this.actualIsotopeSelector.a(e.b());
        this.rxDoseUnits = DosePrefs.doseUnit.getValue();
        this.txtRxDose = new JTextField(10);
        this.lblRxDoseUnits = new JLabel(this.rxDoseUnits.getExternalizedString());
        if (this.initialRxDose > 0.0f) {
            serializable = new DecimalFormat("0.#");
            if (this.rxDoseUnits == Units.cGy) {
                this.txtRxDose.setText(((NumberFormat)serializable).format(this.initialRxDose * 100.0f));
            } else {
                this.txtRxDose.setText(((NumberFormat)serializable).format(this.initialRxDose));
            }
        }
        serializable = Box.createVerticalBox();
        ((JComponent)serializable).setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(Messages.a("SurePlan", "PRESCRIPTION_DOSE")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        Box box3 = Box.createHorizontalBox();
        box3.add(this.txtRxDose);
        box3.add(Box.createRigidArea(new Dimension(5, 0)));
        box3.add(this.lblRxDoseUnits);
        ((Container)serializable).add(box3);
        this.txtKnownActivity = new JTextField(10);
        this.lblKnownActivityUnits = new JLabel(Messages.a("SurePlan", "UNITS_GIGABECQUEREL_ABBREV"));
        this.knownActivityPanel = Box.createVerticalBox();
        this.knownActivityPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(Messages.a("SurePlan", "KNOWN_ACTIVITY")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        Box box4 = Box.createHorizontalBox();
        box4.add(this.txtKnownActivity);
        box4.add(Box.createRigidArea(new Dimension(5, 0)));
        box4.add(this.lblKnownActivityUnits);
        this.knownActivityPanel.add(box4);
        this.txtLungShuntPercentage = new JTextField(10);
        this.lungShuntPanel = Box.createVerticalBox();
        this.lungShuntPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(Messages.a("SurePlan", "ACTIVITY_SHUNT_PANEL_TITLE")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        JTextArea jTextArea = new JTextArea(){
            private static final long serialVersionUID = 1L;

            @Override
            public Dimension getMaximumSize() {
                Dimension dimension = super.getMaximumSize();
                dimension.height = this.getPreferredSize().height;
                return dimension;
            }
        };
        jTextArea.setSize(500, 500);
        jTextArea.setText(Messages.a("SurePlan", "ACTIVITY_SHUNT_DESCRIPTION"));
        jTextArea.setEditable(false);
        jTextArea.setBorder(null);
        jTextArea.setBackground(null);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        this.lungShuntPanel.add(jTextArea);
        this.lungShuntPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        this.lungShuntPanel.add(this.txtLungShuntPercentage);
        ImageVolumeShort imageVolumeShort = this.inputImage.cw();
        this.checkAcquisitionDate = new JCheckBox(Messages.a("SurePlan", "SET_ACQUISITION_DATE_TIME"));
        this.checkAcquisitionDate.setOpaque(true);
        this.checkAcquisitionDate.addActionListener(actionEvent -> {
            this.txtAcquisitionDate.setEnabled(this.checkAcquisitionDate.isSelected());
            this.c();
        });
        this.txtAcquisitionDate = new JTextField(15);
        this.checkInjectionDate = new JCheckBox(Messages.a("SurePlan", "SET_INJECTION_DATE_TIME"));
        this.checkInjectionDate.setOpaque(true);
        this.checkInjectionDate.addActionListener(actionEvent -> {
            this.txtInjectionDate.setEnabled(this.checkInjectionDate.isSelected());
            this.c();
        });
        this.txtInjectionDate = new JTextField(15);
        this.dateAdjusterGridPanel = new JPanel(new GridLayout(1, 2));
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createCompoundBorder(new g(this.checkInjectionDate, jPanel, BorderFactory.createTitledBorder(" ")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        jPanel.add(this.txtInjectionDate);
        com.mimvista.sureplan.b b2 = new com.mimvista.sureplan.b();
        if (b2.a(imageVolumeShort) != null) {
            this.txtInjectionDate.setText(a.format(b2.a(imageVolumeShort)));
            this.txtInjectionDate.setEnabled(false);
        } else {
            this.checkInjectionDate.setSelected(true);
            this.txtInjectionDate.setEnabled(true);
        }
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createCompoundBorder(new g(this.checkAcquisitionDate, jPanel2, BorderFactory.createTitledBorder(" ")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        jPanel2.add(this.txtAcquisitionDate);
        if (b2.b(imageVolumeShort) != null) {
            this.txtAcquisitionDate.setText(a.format(b2.b(imageVolumeShort)));
            this.txtAcquisitionDate.setEnabled(false);
        } else {
            this.checkAcquisitionDate.setSelected(true);
            this.txtAcquisitionDate.setEnabled(true);
        }
        jPanel.add(this.checkInjectionDate);
        jPanel2.add(this.checkAcquisitionDate);
        this.dateAdjusterGridPanel.add(jPanel);
        this.dateAdjusterGridPanel.add(jPanel2);
        this.timeBetweenInjectionAndAcquisitionPanel = new JPanel();
        this.timeBetweenInjectionAndAcquisitionLabel = new JLabel();
        this.timeBetweenInjectionAndAcquisitionPanel.add(this.timeBetweenInjectionAndAcquisitionLabel);
        DocumentListener documentListener = MIMSwingUtils.a((DocumentEvent documentEvent) -> this.c());
        this.txtAcquisitionDate.getDocument().addDocumentListener(documentListener);
        this.txtInjectionDate.getDocument().addDocumentListener(documentListener);
        this.c();
        this.progressBar = new JProgressBar();
        this.progressBar.setPreferredSize(new Dimension(300, 15));
        this.runButton = new JButton(Messages.a("SurePlan", "CONVERT_IMAGE_TO_DOSE"));
        this.runButton.setAlignmentX(0.5f);
        this.runButton.addActionListener(this::a);
        box.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        box.add(box2);
        box.add(Box.createVerticalStrut(10));
        if (!this.isSpect) {
            box.add(this.scannerIsotopeSelector);
            box.add(Box.createVerticalStrut(10));
            box.add(this.actualIsotopeSelector);
            box.add(Box.createVerticalStrut(10));
        }
        box.add(this.dateAdjusterGridPanel);
        box.add(this.timeBetweenInjectionAndAcquisitionPanel);
        this.dateAdjusterSeparator = Box.createVerticalStrut(10);
        box.add(this.dateAdjusterSeparator);
        box.add((Component)serializable);
        box.add(Box.createVerticalStrut(10));
        box.add(this.knownActivityPanel);
        this.knownActivitySeparator = Box.createVerticalStrut(10);
        box.add(this.knownActivitySeparator);
        box.add(this.lungShuntPanel);
        this.lungShuntSeparator = Box.createVerticalStrut(10);
        box.add(this.lungShuntSeparator);
        box.add(this.progressBar);
        box.add(Box.createVerticalStrut(10));
        box.add(this.runButton);
        SurePlanDoseCalcMethod surePlanDoseCalcMethod = this.d();
        this.a(surePlanDoseCalcMethod == SurePlanDoseCalcMethod.c, false);
        this.b(surePlanDoseCalcMethod == SurePlanDoseCalcMethod.c, false);
        this.c(surePlanDoseCalcMethod != SurePlanDoseCalcMethod.c, false);
        this.setContentPane(box);
    }

    private void a(boolean bl2, boolean bl3) {
        if (this.knownActivityPanel.isVisible() == bl2) {
            return;
        }
        this.knownActivityPanel.setVisible(bl2);
        this.knownActivitySeparator.setVisible(bl2);
        if (bl3) {
            int n2 = this.knownActivityPanel.getPreferredSize().height + this.knownActivitySeparator.getPreferredSize().height;
            Dimension dimension = this.getSize();
            dimension.height = dimension.height + (bl2 ? n2 : -n2);
            this.setSize(dimension);
        }
    }

    private void b(boolean bl2, boolean bl3) {
        if (this.lungShuntPanel.isVisible() == bl2) {
            return;
        }
        this.lungShuntPanel.setVisible(bl2);
        this.lungShuntSeparator.setVisible(bl2);
        if (bl3) {
            int n2 = this.lungShuntPanel.getPreferredSize().height + this.lungShuntSeparator.getPreferredSize().height;
            Dimension dimension = this.getSize();
            dimension.height = dimension.height + (bl2 ? n2 : -n2);
            this.setSize(dimension);
        }
    }

    private void c(boolean bl2, boolean bl3) {
        if (this.dateAdjusterGridPanel.isVisible() == bl2) {
            return;
        }
        this.dateAdjusterGridPanel.setVisible(bl2);
        this.timeBetweenInjectionAndAcquisitionPanel.setVisible(bl2);
        this.dateAdjusterSeparator.setVisible(bl2);
        if (bl3) {
            int n2 = this.dateAdjusterGridPanel.getPreferredSize().height + this.timeBetweenInjectionAndAcquisitionPanel.getPreferredSize().height + this.dateAdjusterSeparator.getPreferredSize().height;
            Dimension dimension = this.getSize();
            dimension.height = dimension.height + (bl2 ? n2 : -n2);
            this.setSize(dimension);
        }
    }

    private void c() {
        Object object;
        String string = null;
        com.mimvista.sureplan.b b2 = new com.mimvista.sureplan.b();
        try {
            if (this.checkAcquisitionDate.isSelected()) {
                b2.b(a.parse(this.txtAcquisitionDate.getText()));
            }
            if (this.checkInjectionDate.isSelected()) {
                b2.a(a.parse(this.txtInjectionDate.getText()));
            }
            object = this.inputImage.cw();
            string = CreateDoseFromImageDialog.a(b2.a((ImageVolumeShort)object), b2.b((ImageVolumeShort)object));
        }
        catch (Throwable throwable) {
            string = Messages.a("SurePlan", "TIME_BETWEEN_INJECTION_AND_ACQUISITION_ERROR");
        }
        object = MIMFormat.a(Messages.a("SurePlan", "TIME_BETWEEN_INJECTION_AND_ACQUISITION"), string);
        this.timeBetweenInjectionAndAcquisitionLabel.setText((String)object);
    }

    private static String a(Date date, Date date2) {
        Duration duration = Duration.between(date.toInstant(), date2.toInstant());
        String string = duration.isNegative() ? "-" : "";
        duration = duration.abs();
        long l2 = duration.getSeconds();
        long l3 = l2 / 3600L;
        long l4 = (l2 -= l3 * 3600L) / 60L;
        return String.format("%s%02d:%02d:%02d", string, l3, l4, l2 -= l4 * 60L);
    }

    private SurePlanDoseCalcMethod d() {
        int n2 = this.doseCalcMethodCombo.getSelectedIndex();
        if (n2 < 0) {
            return null;
        }
        return this.doseCalcMethodCombo.getItemAt(n2);
    }

    private void a(ActionEvent actionEvent) {
        a a2;
        boolean bl2;
        if (this.conversionThread != null) {
            this.conversionThread.interrupt();
            try {
                this.conversionThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.conversionThread = null;
            return;
        }
        d d2 = this.scannerIsotopeSelector.a();
        d d3 = this.actualIsotopeSelector.a();
        SurePlanDoseCalcMethod surePlanDoseCalcMethod = this.d();
        String string = this.txtRxDose.getText().trim();
        Float f2 = null;
        String string2 = Messages.a("SurePlan", "PARAM_ERROR_DIALOG_TITLE");
        if (!this.isSpect && d2 == null) {
            JOptionPane.showMessageDialog(this, Messages.a("SurePlan", "MUST_SELECT_SCANNER_ISOTOPE"), string2, 0);
            return;
        }
        if (!this.isSpect && (Float.isNaN(d2.getHalflife()) || Float.isNaN(d2.getPositronFraction()))) {
            JOptionPane.showMessageDialog(this, Messages.a("SurePlan", "DICOM_ISOTOPE_INVALID"));
            return;
        }
        if (!this.isSpect && d3 == null) {
            JOptionPane.showMessageDialog(this, Messages.a("SurePlan", "MUST_SELECT_ACTUAL_ISOTOPE"), string2, 0);
            return;
        }
        if (surePlanDoseCalcMethod == null) {
            JOptionPane.showMessageDialog(this, Messages.a("SurePlan", "MUST_SELECT_DOSE_CALC_METHOD"), string2, 0);
            return;
        }
        if (string.length() > 0) {
            try {
                f2 = Float.valueOf(string);
                if (this.rxDoseUnits == Units.cGy) {
                    f2 = Float.valueOf(f2.floatValue() / 100.0f);
                }
            }
            catch (NumberFormatException numberFormatException) {
                JOptionPane.showMessageDialog(this, Messages.a("SurePlan", "INVALID_PRESCRIPTION_DOSE"), string2, 0);
                return;
            }
        }
        String string3 = this.txtKnownActivity.getText();
        float f3 = -1.0f;
        if (string3.length() > 0) {
            try {
                f3 = Float.valueOf(string3).floatValue();
            }
            catch (NumberFormatException numberFormatException) {
                JOptionPane.showMessageDialog(this, Messages.a("SurePlan", "INVALID_KNOWN_ACTIVITY"), string2, 0);
                return;
            }
        }
        String string4 = this.txtLungShuntPercentage.getText();
        float f4 = -1.0f;
        if (string4.length() > 0) {
            try {
                f4 = Float.valueOf(string4).floatValue();
                Preconditions.checkArgument((f4 >= 0.0f && f4 <= 100.0f ? 1 : 0) != 0);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                JOptionPane.showMessageDialog(this, Messages.a("SurePlan", "INVALID_LUNG_SHUNT_PERCENTAGE"), string2, 0);
                return;
            }
        }
        a.a a3 = com.mimvista.sureplan.a.n().a(this.inputImage).a(f3).b(f4 / 100.0f).b(d2).c(d3).a(surePlanDoseCalcMethod).a(this.wholeBodyContour).b(this.liverContour).a(new b(this.progressBar)).a(f2);
        if (this.checkInjectionDate.isSelected()) {
            try {
                a3.a(a.parse(this.txtInjectionDate.getText().trim()));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (this.checkAcquisitionDate.isSelected()) {
            try {
                a3.b(a.parse(this.txtAcquisitionDate.getText().trim()));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (!(bl2 = this.a(a2 = a3.a()))) {
            return;
        }
        this.progressBar.setVisible(true);
        this.a(false);
        this.conversionThread = new Thread("convert-pt-to-dose"){

            @Override
            public void run() {
                try {
                    CreateDoseFromImageDialog.this.doseOutput = (IsodoseOverlay)CreateDoseFromImageDialog.this.commandRunner.apply(a2);
                    SwingUtilities.invokeLater(CreateDoseFromImageDialog.this::dispose);
                }
                catch (Throwable throwable) {
                    ay.d((Object)"Error running Dose to Series command", throwable, this);
                    SwingUtilities.invokeLater(() -> {
                        JOptionPane.showMessageDialog(CreateDoseFromImageDialog.this, Messages.a("SurePlan", "CREATE_DOSE_FROM_IMAGE_ERROR"));
                        CreateDoseFromImageDialog.this.a(true);
                    });
                }
                CreateDoseFromImageDialog.this.conversionThread = null;
            }
        };
        this.conversionThread.start();
    }

    private boolean a(a a2) {
        Serializable serializable;
        Date date;
        Serializable serializable2;
        Cloneable cloneable;
        ArrayList<WarningItem> arrayList = new ArrayList<WarningItem>();
        if (a2.i() == SurePlanDoseCalcMethod.c) {
            float f2 = a2.b();
            float f3 = SurePlanPrefs.minimumKnownActivity.getValue().floatValue();
            float f4 = SurePlanPrefs.maximumKnownActivity.getValue().floatValue();
            if (f2 < f3 || f2 > f4) {
                cloneable = new DecimalFormat("0.#");
                serializable2 = new WarningItem("SurePlan", "KNOWN_ACTIVITY_OUTSIDE_TYPICAL_RANGE");
                ((WarningItem)serializable2).a(((NumberFormat)cloneable).format(f2), ((NumberFormat)cloneable).format(f3), ((NumberFormat)cloneable).format(f4));
                arrayList.add((WarningItem)serializable2);
            }
        }
        Date date2 = a2.l();
        Date date3 = a2.m();
        Date date4 = this.a(a2.a());
        cloneable = this.b(a2.a());
        serializable2 = date2 != null ? date2 : date4;
        Cloneable cloneable2 = date = date3 != null ? date3 : cloneable;
        if (date.getTime() - ((Date)serializable2).getTime() > TimeUnit.DAYS.toMillis(1L)) {
            serializable = new WarningItem("SurePlan", "INJ_TIME_24H_BEFORE_ACQ_TIME");
            ((WarningItem)serializable).a(a.format((Date)serializable2), a.format(date));
            arrayList.add((WarningItem)serializable);
        }
        if (date3 != null && !date.equals(cloneable)) {
            serializable = new WarningItem("SurePlan", "ACQ_TIME_MODIFIED");
            ((WarningItem)serializable).a(a.format(date));
            arrayList.add((WarningItem)serializable);
        }
        if (a2.i() != SurePlanDoseCalcMethod.c && !((UnitHelper)(serializable = a2.a().getUncopiedMutableInfo().u())).p() && !DataUnitUtils.BQML_CANON_.matchesUnit(((UnitHelper)serializable).c())) {
            String string = ((UnitHelper)serializable).c();
            if (string == null || string.isEmpty()) {
                string = Messages.a("Internals", "IMAGEUNIT_UNIT_NONE");
            }
            WarningItem warningItem = new WarningItem("SurePlan", "UNITS_WARNING");
            warningItem.a(string);
            arrayList.add(warningItem);
        }
        if (arrayList.isEmpty()) {
            return true;
        }
        serializable = new SurePlanWarningSummaryDialog((Window)this, arrayList);
        ((Dialog)serializable).setModal(true);
        ((Dialog)serializable).setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        ((Dialog)serializable).setVisible(true);
        return ((SurePlanWarningSummaryDialog)serializable).a();
    }

    private void a(boolean bl2) {
        this.scannerIsotopeSelector.setEnabled(bl2);
        this.actualIsotopeSelector.setEnabled(bl2);
        this.doseCalcMethodCombo.setEnabled(bl2);
        this.txtRxDose.setEnabled(bl2);
        this.txtKnownActivity.setEnabled(bl2);
        this.txtLungShuntPercentage.setEnabled(bl2);
        this.runButton.setText(bl2 ? Messages.a("SurePlan", "CONVERT_IMAGE_TO_DOSE") : Messages.a("SurePlan", "CANCEL_DOSE_FROM_IMAGE"));
    }

    private JComboBox<SurePlanDoseCalcMethod> e() {
        SurePlanDoseCalcMethod[] surePlanDoseCalcMethodArray = SurePlanDoseCalcMethod.values();
        ArrayList<SurePlanDoseCalcMethod> arrayList = new ArrayList<SurePlanDoseCalcMethod>(surePlanDoseCalcMethodArray.length);
        for (SurePlanDoseCalcMethod surePlanDoseCalcMethod2 : surePlanDoseCalcMethodArray) {
            if (surePlanDoseCalcMethod2 == SurePlanDoseCalcMethod.c && (this.wholeBodyContour == null || this.liverContour == null)) continue;
            arrayList.add(surePlanDoseCalcMethod2);
        }
        JComboBox<SurePlanDoseCalcMethod> jComboBox = new JComboBox<SurePlanDoseCalcMethod>(arrayList.toArray(new SurePlanDoseCalcMethod[0]));
        JLabel jLabel = new JLabel();
        jLabel.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        jComboBox.setRenderer((jList, surePlanDoseCalcMethod, n2, bl2, bl3) -> {
            jLabel.setText(surePlanDoseCalcMethod.a());
            return jLabel;
        });
        return jComboBox;
    }

    private Date a(ViewController3D viewController3D) {
        Date date;
        SeriesInfo seriesInfo = viewController3D.getUncopiedMutableInfo();
        Date date2 = (Date)seriesInfo.startDate.clone();
        if (date2 != null && (date = this.b(viewController3D)) != null && date2.after(date)) {
            Date date3 = DateUtils.b(date, null);
            date3 = new Date(date3.toInstant().minus(1L, ChronoUnit.DAYS).toEpochMilli());
            return DateUtils.b(date3, date2);
        }
        return date2;
    }

    private Date b(ViewController3D viewController3D) {
        SeriesInfo seriesInfo = viewController3D.getUncopiedMutableInfo();
        return DateUtils.b(seriesInfo.acqDate, seriesInfo.acqTime);
    }
}

