/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.swing;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionListener;

public class BasicListModel<T>
extends AbstractListModel<T>
implements List<T>,
ListSelectionModel {
    private static final long serialVersionUID = 1L;
    private final List<T> delegateList;
    private final DefaultListSelectionModel delegateSelectionModel;

    public BasicListModel(T ... TArray) {
        this.delegateList = new ArrayList<T>(Arrays.asList(TArray));
        this.delegateSelectionModel = new DefaultListSelectionModel();
    }

    public BasicListModel(Iterable<T> iterable) {
        this.delegateList = new ArrayList<T>();
        Iterables.addAll(this.delegateList, iterable);
        this.delegateSelectionModel = new DefaultListSelectionModel();
    }

    public void c() {
        this.delegateList.clear();
    }

    public boolean a(T t2) {
        return this.delegateList.add(t2);
    }

    public boolean b(T t2) {
        return this.delegateList.remove(t2);
    }

    public List<T> d() {
        int n2 = this.getMinSelectionIndex();
        int n3 = this.getMaxSelectionIndex();
        if (n2 < 0 || n3 < 0) {
            return new ArrayList();
        }
        ArrayList<T> arrayList = new ArrayList<T>(1 + (n3 - n2));
        for (int i2 = n2; i2 <= n3; ++i2) {
            if (!this.isSelectedIndex(i2)) continue;
            arrayList.add(this.get(i2));
        }
        return arrayList;
    }

    public int[] e() {
        int n2 = this.getMinSelectionIndex();
        int n3 = this.getMaxSelectionIndex();
        if (n2 < 0 || n3 < 0) {
            return new int[0];
        }
        int[] nArray = new int[1 + (n3 - n2)];
        int n4 = 0;
        for (int i2 = n2; i2 <= n3; ++i2) {
            if (!this.isSelectedIndex(i2)) continue;
            nArray[n4++] = i2;
        }
        int[] nArray2 = new int[n4];
        System.arraycopy(nArray, 0, nArray2, 0, n4);
        return nArray2;
    }

    @Override
    public int getSize() {
        return this.delegateList.size();
    }

    @Override
    public T getElementAt(int n2) {
        return this.delegateList.get(n2);
    }

    @Override
    public int size() {
        return this.delegateList.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegateList.isEmpty();
    }

    @Override
    public boolean contains(Object object) {
        return this.delegateList.contains(object);
    }

    @Override
    public Iterator<T> iterator() {
        return this.delegateList.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.delegateList.toArray();
    }

    @Override
    public <AT> AT[] toArray(AT[] ATArray) {
        return this.delegateList.toArray(ATArray);
    }

    @Override
    public boolean add(T t2) {
        int n2 = this.size();
        boolean bl2 = this.delegateList.add(t2);
        if (bl2) {
            this.fireIntervalAdded(this, n2, n2);
        }
        return bl2;
    }

    @Override
    public boolean remove(Object object) {
        int n2 = this.indexOf(object);
        boolean bl2 = this.delegateList.remove(object);
        if (bl2) {
            this.fireIntervalRemoved(this, n2, n2);
        }
        return bl2;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.delegateList.containsAll(collection);
    }

    @Override
    public boolean addAll(Collection<? extends T> collection) {
        int n2 = this.size();
        boolean bl2 = this.delegateList.addAll(collection);
        if (bl2) {
            this.fireIntervalAdded(this, n2, n2 + collection.size() - 1);
        }
        return bl2;
    }

    @Override
    public boolean addAll(int n2, Collection<? extends T> collection) {
        boolean bl2 = this.delegateList.addAll(n2, collection);
        if (bl2) {
            this.fireIntervalRemoved(this, n2, n2 + collection.size() - 1);
        }
        return bl2;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        boolean bl2 = this.delegateList.removeAll(collection);
        if (bl2) {
            this.fireContentsChanged(this, 0, this.size() - 1);
        }
        return bl2;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        boolean bl2 = this.delegateList.retainAll(collection);
        if (bl2) {
            this.fireContentsChanged(this, 0, this.size() - 1);
        }
        return bl2;
    }

    @Override
    public void clear() {
        int n2 = this.size() - 1;
        this.delegateList.clear();
        if (n2 >= 0) {
            this.fireIntervalRemoved(this, 0, n2);
        }
    }

    @Override
    public T get(int n2) {
        return this.delegateList.get(n2);
    }

    @Override
    public T set(int n2, T t2) {
        T t3 = this.delegateList.set(n2, t2);
        this.fireContentsChanged(this, n2, n2);
        return t3;
    }

    @Override
    public void add(int n2, T t2) {
        this.delegateList.add(n2, t2);
        this.fireIntervalAdded(this, n2, n2);
    }

    @Override
    public T remove(int n2) {
        T t2 = this.delegateList.remove(n2);
        this.fireIntervalRemoved(this, n2, n2);
        return t2;
    }

    @Override
    public int indexOf(Object object) {
        return this.delegateList.indexOf(object);
    }

    @Override
    public int lastIndexOf(Object object) {
        return this.delegateList.lastIndexOf(object);
    }

    @Override
    public ListIterator<T> listIterator() {
        return this.delegateList.listIterator();
    }

    @Override
    public ListIterator<T> listIterator(int n2) {
        return this.delegateList.listIterator(n2);
    }

    @Override
    public List<T> subList(int n2, int n3) {
        return this.delegateList.subList(n2, n3);
    }

    public void f() {
        this.fireContentsChanged(this, 0, this.size() - 1);
    }

    @Override
    public void setSelectionInterval(int n2, int n3) {
        this.delegateSelectionModel.setSelectionInterval(n2, n3);
    }

    @Override
    public void addSelectionInterval(int n2, int n3) {
        this.delegateSelectionModel.addSelectionInterval(n2, n3);
    }

    @Override
    public void removeSelectionInterval(int n2, int n3) {
        this.delegateSelectionModel.removeSelectionInterval(n2, n3);
    }

    @Override
    public int getMinSelectionIndex() {
        return this.delegateSelectionModel.getMinSelectionIndex();
    }

    @Override
    public int getMaxSelectionIndex() {
        return this.delegateSelectionModel.getMaxSelectionIndex();
    }

    @Override
    public boolean isSelectedIndex(int n2) {
        return this.delegateSelectionModel.isSelectedIndex(n2);
    }

    @Override
    public int getAnchorSelectionIndex() {
        return this.delegateSelectionModel.getAnchorSelectionIndex();
    }

    @Override
    public void setAnchorSelectionIndex(int n2) {
        this.delegateSelectionModel.setAnchorSelectionIndex(n2);
    }

    @Override
    public int getLeadSelectionIndex() {
        return this.delegateSelectionModel.getLeadSelectionIndex();
    }

    @Override
    public void setLeadSelectionIndex(int n2) {
        this.delegateSelectionModel.setLeadSelectionIndex(n2);
    }

    @Override
    public void clearSelection() {
        this.delegateSelectionModel.clearSelection();
    }

    @Override
    public boolean isSelectionEmpty() {
        return this.delegateSelectionModel.isSelectionEmpty();
    }

    @Override
    public void insertIndexInterval(int n2, int n3, boolean bl2) {
        this.delegateSelectionModel.insertIndexInterval(n2, n3, bl2);
    }

    @Override
    public void removeIndexInterval(int n2, int n3) {
        this.delegateSelectionModel.removeIndexInterval(n2, n3);
    }

    @Override
    public void setValueIsAdjusting(boolean bl2) {
        this.delegateSelectionModel.setValueIsAdjusting(bl2);
    }

    @Override
    public boolean getValueIsAdjusting() {
        return this.delegateSelectionModel.getValueIsAdjusting();
    }

    @Override
    public void setSelectionMode(int n2) {
        this.delegateSelectionModel.setSelectionMode(n2);
    }

    @Override
    public int getSelectionMode() {
        return this.delegateSelectionModel.getSelectionMode();
    }

    @Override
    public void addListSelectionListener(ListSelectionListener listSelectionListener) {
        this.delegateSelectionModel.addListSelectionListener(listSelectionListener);
    }

    @Override
    public void removeListSelectionListener(ListSelectionListener listSelectionListener) {
        this.delegateSelectionModel.removeListSelectionListener(listSelectionListener);
    }
}

