/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.swing;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.mimvista.numerics.az;
import com.mimvista.swing.AbstractListSelectionModel;
import com.mimvista.swing.TypedListModel;
import gnu.trove.map.hash.TIntIntHashMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class FilteredTypedListModel<T>
extends TypedListModel<T> {
    private static final long serialVersionUID = 1L;
    private TypedListModel<T> model;
    private Predicate<T> filter;
    private List<T> cachedList;
    private FilteredSelectionModel selectionModel;
    private TIntIntHashMap srcToFilterMap = new TIntIntHashMap(10, 0.5f, -1, -1);
    private TIntIntHashMap filterToSrcMap = new TIntIntHashMap(10, 0.5f, -1, -1);

    public FilteredTypedListModel(TypedListModel<T> typedListModel, Predicate<T> predicate, ListSelectionModel listSelectionModel) {
        this.model = typedListModel;
        this.selectionModel = new FilteredSelectionModel(listSelectionModel);
        listSelectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                FilteredTypedListModel.this.b().a(listSelectionEvent.getFirstIndex(), listSelectionEvent.getLastIndex());
            }
        });
        typedListModel.addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent listDataEvent) {
                FilteredTypedListModel.this.c();
                FilteredTypedListModel.this.d();
                List list = FilteredTypedListModel.this.a(listDataEvent.getIndex0(), listDataEvent.getIndex1());
                if (!list.isEmpty()) {
                    for (az az2 : list) {
                        FilteredTypedListModel.this.fireIntervalAdded(listDataEvent.getSource(), az2.a, az2.b);
                    }
                }
            }

            @Override
            public void intervalRemoved(ListDataEvent listDataEvent) {
                List list = FilteredTypedListModel.this.a(listDataEvent.getIndex0(), listDataEvent.getIndex1());
                FilteredTypedListModel.this.c();
                if (!list.isEmpty()) {
                    for (az az2 : list) {
                        FilteredTypedListModel.this.fireIntervalRemoved(listDataEvent.getSource(), az2.a, az2.b);
                    }
                } else {
                    FilteredTypedListModel.this.fireContentsChanged(this, 0, 0);
                }
            }

            @Override
            public void contentsChanged(ListDataEvent listDataEvent) {
                FilteredTypedListModel.this.c();
                FilteredTypedListModel.this.fireContentsChanged(this, 0, FilteredTypedListModel.this.getSize());
            }
        });
        this.filter = predicate;
    }

    private List<az> a(int n2, int n3) {
        return this.a(this.srcToFilterMap, n2, n3);
    }

    private List<az> b(int n2, int n3) {
        return this.a(this.filterToSrcMap, n2, n3);
    }

    private List<az> a(TIntIntHashMap tIntIntHashMap, int n2, int n3) {
        ArrayList arrayList = Lists.newArrayList();
        int n4 = -1;
        int n5 = -1;
        for (int i2 = n2; i2 <= n3; ++i2) {
            int n6 = tIntIntHashMap.get(i2);
            if (n6 == -1) continue;
            if (n4 == -1) {
                n4 = n6;
                continue;
            }
            if (n5 == -1) {
                if (n6 == n4 + 1) {
                    n5 = n6;
                    continue;
                }
                this.a(arrayList, n4, n5);
                n4 = n6;
                continue;
            }
            if (n5 == -1) continue;
            if (n6 == n5 + 1) {
                n5 = n6;
                continue;
            }
            this.a(arrayList, n4, n5);
            n4 = n6;
            n5 = -1;
        }
        if (n4 != -1) {
            this.a(arrayList, n4, n5);
        }
        return arrayList;
    }

    private void a(List<az> list, int n2, int n3) {
        az az2 = new az();
        az2.a = n2;
        az2.b = n3 != -1 ? n3 : n2;
        list.add(az2);
    }

    private void c() {
        this.cachedList = null;
        this.srcToFilterMap.clear();
        this.filterToSrcMap.clear();
    }

    public void a(Predicate<T> predicate) {
        this.filter = predicate;
        this.c();
        this.fireContentsChanged(this, 0, this.getSize());
    }

    public int a() {
        return this.model.getSize() - this.getSize();
    }

    private List<T> d() {
        if (this.cachedList == null) {
            this.cachedList = Lists.newArrayList();
            this.srcToFilterMap.clear();
            this.filterToSrcMap.clear();
            int n2 = 0;
            for (int i2 = 0; i2 < this.model.getSize(); ++i2) {
                T t2 = this.model.getElementAt(i2);
                if (!this.filter.apply(t2)) continue;
                this.cachedList.add(t2);
                this.srcToFilterMap.put(i2, n2);
                this.filterToSrcMap.put(n2, i2);
                ++n2;
            }
        }
        return this.cachedList;
    }

    @Override
    public int getSize() {
        return this.d().size();
    }

    @Override
    public T getElementAt(int n2) {
        if (n2 < 0 || n2 >= this.getSize()) {
            return null;
        }
        return this.d().get(n2);
    }

    @Override
    public Iterator<T> iterator() {
        return this.d().iterator();
    }

    public FilteredSelectionModel b() {
        return this.selectionModel;
    }

    private class FilteredSelectionModel
    extends AbstractListSelectionModel {
        private static final long serialVersionUID = 1L;
        private ListSelectionModel model;

        public FilteredSelectionModel(ListSelectionModel listSelectionModel) {
            this.model = listSelectionModel;
        }

        @Override
        public void setSelectionInterval(int n2, int n3) {
            List list = FilteredTypedListModel.this.b(n2, n3);
            boolean bl2 = this.getValueIsAdjusting();
            if (!bl2) {
                this.setValueIsAdjusting(true);
            }
            this.model.clearSelection();
            if (!list.isEmpty()) {
                for (az az2 : list) {
                    this.model.addSelectionInterval(az2.a, az2.b);
                }
            }
            if (!bl2) {
                this.setValueIsAdjusting(false);
            }
        }

        @Override
        public void addSelectionInterval(int n2, int n3) {
            List list = FilteredTypedListModel.this.b(n2, n3);
            if (!list.isEmpty()) {
                for (az az2 : list) {
                    this.model.addSelectionInterval(az2.a, az2.b);
                }
            }
        }

        @Override
        public void removeSelectionInterval(int n2, int n3) {
            List list = FilteredTypedListModel.this.b(n2, n3);
            if (!list.isEmpty()) {
                for (az az2 : list) {
                    this.model.removeSelectionInterval(az2.a, az2.b);
                }
            }
        }

        @Override
        public int getMinSelectionIndex() {
            for (int i2 = 0; i2 < this.a(); ++i2) {
                if (!this.isSelectedIndex(i2)) continue;
                return i2;
            }
            return -1;
        }

        @Override
        public int getMaxSelectionIndex() {
            for (int i2 = this.a() - 1; i2 >= 0; --i2) {
                if (!this.isSelectedIndex(i2)) continue;
                return i2;
            }
            return -1;
        }

        @Override
        public boolean isSelectedIndex(int n2) {
            int n3 = FilteredTypedListModel.this.filterToSrcMap.get(n2);
            if (n3 != -1) {
                return this.model.isSelectedIndex(n3);
            }
            return false;
        }

        private int a(int n2) {
            if (n2 != -1 && FilteredTypedListModel.this.srcToFilterMap.containsKey(n2)) {
                return FilteredTypedListModel.this.srcToFilterMap.get(n2);
            }
            return -1;
        }

        @Override
        public int getAnchorSelectionIndex() {
            return this.a(this.model.getAnchorSelectionIndex());
        }

        @Override
        public void setAnchorSelectionIndex(int n2) {
            this.model.setAnchorSelectionIndex(FilteredTypedListModel.this.filterToSrcMap.get(n2));
        }

        @Override
        public int getLeadSelectionIndex() {
            return this.a(this.model.getLeadSelectionIndex());
        }

        @Override
        public void setLeadSelectionIndex(int n2) {
            this.model.setLeadSelectionIndex(FilteredTypedListModel.this.filterToSrcMap.get(n2));
        }

        @Override
        public void clearSelection() {
            this.model.clearSelection();
        }

        @Override
        public boolean isSelectionEmpty() {
            for (int i2 = 0; i2 < this.a(); ++i2) {
                if (!this.isSelectedIndex(i2)) continue;
                return false;
            }
            return true;
        }

        @Override
        public void insertIndexInterval(int n2, int n3, boolean bl2) {
            this.model.insertIndexInterval(FilteredTypedListModel.this.filterToSrcMap.get(n2), n3, bl2);
        }

        @Override
        public void removeIndexInterval(int n2, int n3) {
            List list = FilteredTypedListModel.this.b(n2, n3);
            if (!list.isEmpty()) {
                for (az az2 : list) {
                    this.model.removeIndexInterval(az2.a, az2.b);
                }
            }
        }

        @Override
        public void setSelectionMode(int n2) {
            this.model.setSelectionMode(n2);
        }

        @Override
        public int getSelectionMode() {
            return this.model.getSelectionMode();
        }

        @Override
        public int a() {
            return FilteredTypedListModel.this.getSize();
        }
    }
}

