/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.swing.widgets;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Stroke;
import javax.swing.border.AbstractBorder;

public class DashedBorder
extends AbstractBorder {
    private static final long serialVersionUID = 1L;
    private Insets ins;
    private int thickness;
    private Color color;

    public DashedBorder(Color color) {
        this(color, 1);
    }

    public DashedBorder(Color color, int n2) {
        this.color = color;
        this.thickness = n2;
        this.ins = new Insets(n2, n2, n2, n2);
    }

    @Override
    public Insets getBorderInsets(Component component) {
        return this.ins;
    }

    @Override
    public Insets getBorderInsets(Component component, Insets insets) {
        insets.top = this.ins.top;
        insets.left = this.ins.left;
        insets.bottom = this.ins.bottom;
        insets.right = this.ins.right;
        return insets;
    }

    @Override
    public void paintBorder(Component component, Graphics graphics, int n2, int n3, int n4, int n5) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setColor(this.color);
        graphics2D.setStroke(new BasicStroke(this.thickness, 0, 2, 0.0f, new float[]{5.0f}, 0.0f));
        graphics2D.drawRect(n2, n3, n4 - 1, n5 - 1);
        graphics2D.setStroke(stroke);
    }
}

