/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.swing.widgets;

import com.mimvista.dicom.util.Operator;
import com.mimvista.dicom.util.OperatorListCellRenderer;
import com.mimvista.dicom.util.TagPath;
import com.mimvista.swing.widgets.TagPathCombobox;
import com.mimvista.util.Messages;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class DicomTagPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static Messages d = Messages.a("WorkflowProps");
    public static final TagPath[] a = new TagPath[]{new TagPath(0x37733003), new TagPath(930295812), new TagPath(0x100010), new TagPath(0x100020), new TagPath(524432), new TagPath(524384), new TagPath(0x200052), new TagPath(524368), new TagPath(524320), new TagPath(524321), new TagPath(528432), new TagPath(528446), new TagPath(0x20000D), new TagPath(0x20000E), new TagPath(528496)};
    public static final TagPath[] b = new TagPath[]{new TagPath(528446), new TagPath(0x20000D), new TagPath(0x20000E), new TagPath(528496), new TagPath(4235553), new TagPath(4235554), new TagPath(1253536), new TagPath(0x100020), new TagPath(0x100030), new TagPath(524432), new TagPath(0x37733003), new TagPath(930295812), new TagPath(524384), new TagPath(0x200052), new TagPath(524368), new TagPath(524320), new TagPath(524321), new TagPath(528432), new TagPath(930295816), new TagPath(0x100010), new TagPath(524306), new TagPath(524307)};
    public static final TagPath[] c = new TagPath[]{new TagPath(930312193), new TagPath(930312194)};
    private TagPathCombobox tagBox;
    private JComboBox<Operator> operator;
    private DefaultComboBoxModel<Operator> operatorModel;
    private JTextField value;
    private List<TagPath> suggestedTagPaths;

    public DicomTagPanel(TagPath[] tagPathArray) {
        this.suggestedTagPaths = Arrays.asList(tagPathArray);
        this.f();
    }

    public DicomTagPanel(List<TagPath> list) {
        this.suggestedTagPaths = new ArrayList<TagPath>(list);
        this.f();
    }

    private void f() {
        this.setLayout(new BoxLayout(this, 0));
        this.tagBox = new TagPathCombobox(this.suggestedTagPaths);
        this.tagBox.putClientProperty("com.mimvista.JTextField.InsideLabel", Messages.a("Automator", "FILTER_HEADING_DICOM_TAG"));
        this.operatorModel = new DefaultComboBoxModel<Operator>(Operator.values());
        this.operator = new JComboBox<Operator>(this.operatorModel){
            private static final long serialVersionUID = 1L;

            @Override
            public void setSelectedIndex(int n2) {
                DicomTagPanel.this.value.setVisible(((Operator)((Object)DicomTagPanel.this.operatorModel.getElementAt(n2))).usesTwoOperands());
                super.setSelectedIndex(n2);
                Container container = DicomTagPanel.this.value.getParent();
                if (container != null) {
                    container.revalidate();
                }
            }

            @Override
            public void setSelectedItem(Object object) {
                if (object instanceof Operator) {
                    DicomTagPanel.this.value.setVisible(((Operator)((Object)object)).usesTwoOperands());
                    Container container = DicomTagPanel.this.value.getParent();
                    if (container != null) {
                        container.revalidate();
                    }
                }
                super.setSelectedItem(object);
            }
        };
        this.value = new JTextField();
        this.value.putClientProperty("com.mimvista.JTextField.InsideLabel", d.getProperty("DESCRIPTION_VALUE"));
        this.value.setMaximumSize(new Dimension(150, Integer.MAX_VALUE));
        this.value.setMinimumSize(new Dimension(150, 0));
        this.value.setPreferredSize(new Dimension(150, this.value.getPreferredSize().height));
        this.operator.setRenderer(new OperatorListCellRenderer());
        this.operator.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() != 1) {
                    return;
                }
                Object object = itemEvent.getItem();
                if (!(object instanceof Operator)) {
                    return;
                }
                final Operator operator = (Operator)((Object)object);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DicomTagPanel.this.operator.setToolTipText(operator.getDisplayExplanation());
                    }
                });
            }
        });
        this.add(this.tagBox);
        this.add(Box.createHorizontalStrut(5));
        this.add(this.operator);
        this.add(Box.createHorizontalStrut(5));
        this.add(this.value);
    }

    public TagPath a() {
        return (TagPath)this.tagBox.a();
    }

    public void a(TagPath tagPath) {
        this.tagBox.setSelectedItem(tagPath);
    }

    public void a(Operator operator) {
        this.operator.setSelectedItem((Object)operator);
    }

    public String b() {
        return this.value.getText();
    }

    public void a(String string) {
        this.value.setText(string);
    }

    public TagPathCombobox c() {
        return this.tagBox;
    }

    public JComboBox d() {
        return this.operator;
    }

    public JTextField e() {
        return this.value;
    }

    public static TagPath[] a(int[] nArray) {
        TagPath[] tagPathArray = new TagPath[nArray.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            tagPathArray[i2] = new TagPath(nArray[i2]);
        }
        return tagPathArray;
    }

    public static TagPathCombobox a(TagPath[] tagPathArray, TagPath tagPath) {
        ArrayList<TagPath> arrayList = new ArrayList<TagPath>();
        for (TagPath tagPath2 : tagPathArray) {
            arrayList.add(tagPath2);
        }
        TagPathCombobox tagPathCombobox = new TagPathCombobox(arrayList);
        tagPathCombobox.setSelectedItem(tagPath);
        return tagPathCombobox;
    }

    public static TagPathCombobox a(TagPath[] tagPathArray) {
        return DicomTagPanel.a(tagPathArray, null);
    }

    public static TagPathCombobox b(int[] nArray) {
        return DicomTagPanel.a(DicomTagPanel.a(nArray));
    }

    public static TagPathCombobox a(int[] nArray, int n2) {
        return DicomTagPanel.a(DicomTagPanel.a(nArray), new TagPath(n2));
    }
}

