/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.swing.widgets;

import com.mimvista.commands.keyboard.al;
import com.mimvista.gui.util.MIMSwingUtils;
import com.mimvista.util.Messages;
import com.mimvista.util.NumberFormatFactory;
import com.mimvista.util.ay;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.EventObject;
import java.util.Iterator;
import javax.swing.DefaultCellEditor;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;

public class ExcelTable
extends JTable {
    private static final long serialVersionUID = 1L;
    private static final String a = "ExcelTable.PasteAction";
    private float fontSize = 15.0f;

    public ExcelTable(TableModel tableModel) {
        super(tableModel);
        this.setDefaultEditor(Object.class, new ExcelEditor(false));
        this.setDefaultEditor(Number.class, new ExcelEditor(true));
        this.setRowSelectionAllowed(false);
        this.a(this);
        this.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (MIMSwingUtils.a(mouseEvent)) {
                    JPopupMenu jPopupMenu = new JPopupMenu();
                    JMenuItem jMenuItem = new JMenuItem(Messages.a("Swing", "EXCELTABLE_COPY_TABLE_HEADER"));
                    jMenuItem.addActionListener(actionEvent -> ExcelTable.this.a());
                    jPopupMenu.add(jMenuItem);
                    jPopupMenu.show(ExcelTable.this, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
    }

    private void a(JComponent jComponent) {
        KeyStroke keyStroke = al.h();
        jComponent.getInputMap(0).put(keyStroke, a);
        jComponent.registerKeyboardAction(this::a, a, keyStroke, 1);
    }

    public void a(float f2) {
        this.fontSize = f2;
        this.setFont(this.getFont().deriveFont(f2));
    }

    private void a(ActionEvent actionEvent) {
        if (actionEvent != null && a.equals(actionEvent.getActionCommand())) {
            this.b();
        }
    }

    @Override
    public boolean editCellAt(int n2, int n3, EventObject eventObject) {
        boolean bl2 = super.editCellAt(n2, n3, eventObject);
        Component component = this.getEditorComponent();
        if (component instanceof JTextComponent) {
            JTextComponent jTextComponent = (JTextComponent)component;
            SwingUtilities.invokeLater(jTextComponent::selectAll);
        }
        return bl2;
    }

    @Override
    public void changeSelection(int n2, int n3, boolean bl2, boolean bl3) {
        super.changeSelection(n2, n3, bl2, bl3);
        if (!this.isEditing()) {
            this.editCellAt(n2, n3);
        }
    }

    private void a() {
        try {
            TableModel tableModel = this.getModel();
            StringBuilder stringBuilder = new StringBuilder();
            for (int i2 = 0; i2 < tableModel.getColumnCount(); ++i2) {
                stringBuilder.append(tableModel.getColumnName(i2));
                if (i2 >= tableModel.getColumnCount() - 1) continue;
                stringBuilder.append("\t");
            }
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(new StringSelection(stringBuilder.toString()), null);
        }
        catch (Throwable throwable) {
            ay.d((Object)"Error copying table header to clipboard", throwable, this);
        }
    }

    private void b() {
        try {
            int n2;
            String string;
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            int n3 = this.getSelectedRow();
            int n4 = this.getSelectedColumn();
            if (this.isEditing()) {
                n3 = this.getEditingRow();
                n4 = this.getEditingColumn();
                this.getCellEditor().stopCellEditing();
            }
            if ((string = (String)clipboard.getContents(null).getTransferData(DataFlavor.stringFlavor)) == null) {
                ay.a((Object)"No text to paste", this);
                return;
            }
            TableModel tableModel = this.getModel();
            Iterator<String> iterator = Arrays.asList(string.split("\n")).iterator();
            for (n2 = n3; n2 < tableModel.getRowCount() && iterator.hasNext(); ++n2) {
                String string2 = iterator.next();
                Iterator<String> iterator2 = Arrays.asList(string2.split("\t")).iterator();
                for (int i2 = n4; i2 < tableModel.getColumnCount() && iterator2.hasNext(); ++i2) {
                    String string3 = iterator2.next();
                    Object object = string3;
                    try {
                        object = Double.parseDouble(string3);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    if (!tableModel.isCellEditable(n2, i2)) continue;
                    tableModel.setValueAt(object, n2, i2);
                }
            }
            this.tableChanged(new TableModelEvent(tableModel, n3, n2 - 1));
        }
        catch (Throwable throwable) {
            ay.d((Object)"Error pasting data from clipboard", throwable, this);
        }
    }

    private class ExcelEditor
    extends DefaultCellEditor {
        private static final long serialVersionUID = 1L;

        public ExcelEditor(boolean bl2) {
            super(bl2 ? new JFormattedTextField(NumberFormatFactory.f()) : new JTextField());
            this.setClickCountToStart(2);
            ExcelTable.this.a(this.editorComponent);
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl2, int n2, int n3) {
            JTextField jTextField = (JTextField)super.getTableCellEditorComponent(jTable, object, bl2, n2, n3);
            jTextField.setText(String.valueOf(object));
            jTextField.setHorizontalAlignment(4);
            jTextField.setFont(jTextField.getFont().deriveFont(ExcelTable.this.fontSize));
            jTextField.selectAll();
            return jTextField;
        }
    }
}

