/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.swing.widgets;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.mimvista.gui.util.MIMSwingUtils;
import com.mimvista.proui.ProComboBoxUI;
import com.mimvista.util.Messages;
import com.mimvista.util.cn;
import com.mimvista.util.work.m;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.PlainDocument;

public class FontChooserComboBox
extends JComboBox {
    private static final long serialVersionUID = 5244710701508429877L;
    private static final int a = 15;
    private int previewFontSize;
    private String previewString = Messages.a("Report", "FONT_SAMPLE_TEXT");
    private int recentFontsCount = 5;
    private final FontChooserComboBoxModel fontComboModel;
    private final a separator = new a(null);
    private List<a> fontItems = Lists.newArrayList();
    private List<a> recentItems = Lists.newArrayList();

    public FontChooserComboBox() {
        this((Function<Font, Boolean>)null);
    }

    public FontChooserComboBox(Function<Font, Boolean> function) {
        JLabel jLabel = new JLabel();
        this.previewFontSize = jLabel.getFont().getSize();
        this.fontComboModel = new FontChooserComboBoxModel();
        this.setModel(this.fontComboModel);
        this.setEditable(true);
        this.setEditor(new FontChooserComboBoxEditor());
        this.setRenderer(new FontChooserComboBoxRenderer());
        this.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                Object object = FontChooserComboBox.this.getSelectedItem();
                if (object instanceof a) {
                    a a2 = (a)object;
                    FontChooserComboBox.this.a(a2);
                }
            }
        });
        this.a(function);
    }

    public int a() {
        return this.previewFontSize;
    }

    public String b() {
        return this.previewString;
    }

    public String c() {
        if (this.getSelectedItem() != null) {
            return ((a)this.getSelectedItem()).b.getFamily();
        }
        return null;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(super.getPreferredSize().width, new JComboBox<E>().getPreferredSize().height);
    }

    public void a(final String string) {
        MIMSwingUtils.a(new Runnable(){

            @Override
            public void run() {
                a a2 = FontChooserComboBox.this.b(string);
                if (a2 != null && FontChooserComboBox.this.fontComboModel.getSelectedItem() == a2) {
                    return;
                }
                if (a2 == null) {
                    a2 = new a(string);
                    FontChooserComboBox.this.a((Collection)Lists.newArrayList((Object[])new a[]{a2}));
                }
                FontChooserComboBox.this.a(a2);
                FontChooserComboBox.this.setSelectedItem(a2);
            }
        });
    }

    private void a(final a a2) {
        MIMSwingUtils.a(new Runnable(){

            @Override
            public void run() {
                int n2 = FontChooserComboBox.this.recentItems.indexOf(a2);
                if (n2 == 0) {
                    return;
                }
                if (n2 != -1) {
                    FontChooserComboBox.this.recentItems.remove(n2);
                }
                FontChooserComboBox.this.fontItems.remove(a2);
                FontChooserComboBox.this.recentItems.add(0, a2);
                if (FontChooserComboBox.this.recentItems.size() > FontChooserComboBox.this.recentFontsCount) {
                    FontChooserComboBox.this.b((a)FontChooserComboBox.this.recentItems.get(FontChooserComboBox.this.recentItems.size() - 1));
                }
                FontChooserComboBox.this.fontComboModel.a();
            }
        });
    }

    private void b(final a a2) {
        MIMSwingUtils.a(new Runnable(){

            @Override
            public void run() {
                FontChooserComboBox.this.recentItems.remove(a2);
                if (!FontChooserComboBox.this.fontItems.contains(a2)) {
                    FontChooserComboBox.this.fontItems.add(a2);
                    Collections.sort(FontChooserComboBox.this.fontItems);
                }
                FontChooserComboBox.this.fontComboModel.a();
            }
        });
    }

    private void a(final Collection<a> collection) {
        MIMSwingUtils.a(new Runnable(){

            @Override
            public void run() {
                HashSet hashSet = new HashSet(FontChooserComboBox.this.fontItems);
                hashSet.addAll(collection);
                hashSet.removeAll(FontChooserComboBox.this.recentItems);
                FontChooserComboBox.this.fontItems = Lists.newArrayList(hashSet);
                Collections.sort(FontChooserComboBox.this.fontItems);
                FontChooserComboBox.this.fontComboModel.a();
            }
        });
    }

    private a b(String string) {
        for (a a2 : this.recentItems) {
            if (!a2.a.equals(string)) continue;
            return a2;
        }
        for (a a2 : this.fontItems) {
            if (!a2.a.equals(string)) continue;
            return a2;
        }
        return null;
    }

    private void a(final Function<Font, Boolean> function) {
        m.b.submit(new Runnable(){

            @Override
            public void run() {
                GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
                Object[] objectArray = graphicsEnvironment.getAvailableFontFamilyNames();
                Arrays.sort(objectArray);
                int n2 = 0;
                while (n2 < objectArray.length) {
                    ArrayList<a> arrayList = new ArrayList<a>(15);
                    for (int i2 = 0; i2 < 15 && n2 < objectArray.length; ++i2, ++n2) {
                        a a2 = new a((String)objectArray[n2]);
                        if (function != null && !((Boolean)function.apply((Object)a2.a())).booleanValue()) continue;
                        arrayList.add(a2);
                    }
                    FontChooserComboBox.this.a(arrayList);
                }
            }
        });
    }

    private class a
    implements Comparable<a> {
        final String a;
        final Font b;
        final boolean c;
        final String d;

        private a(String string) {
            this.a = cn.i(string);
            if (string != null) {
                this.b = new Font(string, 0, FontChooserComboBox.this.previewFontSize);
                this.c = false;
            } else {
                this.b = null;
                this.c = true;
            }
            this.d = this.b();
        }

        private String b() {
            if (FontChooserComboBox.this.previewString != null && !this.c) {
                StringBuilder stringBuilder = new StringBuilder();
                for (int i2 = 0; i2 < FontChooserComboBox.this.previewString.length(); ++i2) {
                    char c2 = FontChooserComboBox.this.previewString.charAt(i2);
                    if (!this.b.canDisplay(c2)) continue;
                    stringBuilder.append(c2);
                }
                return stringBuilder.toString();
            }
            return "";
        }

        public int a(a a2) {
            return this.a.compareTo(a2.a);
        }

        public int hashCode() {
            int n2 = 31;
            int n3 = 1;
            n3 = 31 * n3 + this.c().hashCode();
            n3 = 31 * n3 + (this.a == null ? 0 : this.a.hashCode());
            n3 = 31 * n3 + (this.c ? 1231 : 1237);
            return n3;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            a a2 = (a)object;
            if (!this.c().equals(a2.c())) {
                return false;
            }
            if (this.a == null ? a2.a != null : !this.a.equals(a2.a)) {
                return false;
            }
            return this.c == a2.c;
        }

        public String toString() {
            return this.a;
        }

        private FontChooserComboBox c() {
            return FontChooserComboBox.this;
        }

        public Font a() {
            return this.b;
        }

        @Override
        public /* synthetic */ int compareTo(Object object) {
            return this.a((a)object);
        }
    }

    class FontChooserComboBoxModel
    extends DefaultComboBoxModel {
        private static final long serialVersionUID = 2901402548929994566L;

        FontChooserComboBoxModel() {
        }

        public a a(int n2) {
            if (n2 < FontChooserComboBox.this.recentItems.size()) {
                return (a)FontChooserComboBox.this.recentItems.get(n2);
            }
            if (n2 == FontChooserComboBox.this.recentItems.size()) {
                return FontChooserComboBox.this.separator;
            }
            return (a)FontChooserComboBox.this.fontItems.get(n2 - FontChooserComboBox.this.recentItems.size() - 1);
        }

        @Override
        public int getSize() {
            return FontChooserComboBox.this.recentItems.size() + 1 + FontChooserComboBox.this.fontItems.size();
        }

        void a() {
            this.fireContentsChanged(this, 0, this.getSize() - 1);
        }

        @Override
        public /* synthetic */ Object getElementAt(int n2) {
            return this.a(n2);
        }
    }

    class FontChooserComboBoxRenderer
    extends JPanel
    implements ListCellRenderer {
        private static final long serialVersionUID = 1L;
        private DefaultListCellRenderer textLabel = new DefaultListCellRenderer();
        private DefaultListCellRenderer previewLabel = new DefaultListCellRenderer();
        private JSeparator separator = new JSeparator(0);

        public FontChooserComboBoxRenderer() {
            this.setLayout(new BorderLayout());
            this.previewLabel.setBorder(BorderFactory.createEmptyBorder(0, 15, 0, 0));
            this.previewLabel.setForeground(this.textLabel.getForeground().darker());
            this.add((Component)this.textLabel, "North");
            this.add(Box.createHorizontalGlue());
            this.add((Component)this.previewLabel, "South");
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n2, boolean bl2, boolean bl3) {
            this.setBackground(this.textLabel.getBackground());
            a a2 = (a)object;
            if (a2.c) {
                return this.separator;
            }
            this.textLabel.setText(a2.a);
            this.previewLabel.setText(a2.d);
            this.previewLabel.setFont(a2.b);
            return this;
        }
    }

    class FontChooserComboBoxEditor
    extends ProComboBoxUI.b {
        private FontChooserComboBoxEditor() {
            super(FontChooserComboBox.this);
            this.editor.setDocument(new AutoCompletionDocument());
            String string = FontChooserComboBox.this.c();
            if (string == null && FontChooserComboBox.this.fontComboModel.getSize() > 0) {
                string = ((FontChooserComboBox)FontChooserComboBox.this).fontComboModel.a((int)0).a;
            }
            this.editor.setText(cn.i(string));
        }

        private String b(String string) {
            ArrayList arrayList = Lists.newArrayList();
            arrayList.addAll(FontChooserComboBox.this.recentItems);
            arrayList.addAll(FontChooserComboBox.this.fontItems);
            for (a a2 : arrayList) {
                if (!a2.a.toLowerCase().startsWith(string.toLowerCase())) continue;
                return a2.a;
            }
            return null;
        }

        public void a(String string) {
            AutoCompletionDocument autoCompletionDocument = (AutoCompletionDocument)this.editor.getDocument();
            try {
                Caret caret = this.editor.getCaret();
                int n2 = Math.min(caret.getDot(), caret.getMark());
                int n3 = Math.max(caret.getDot(), caret.getMark());
                autoCompletionDocument.replace(n2, n3 - n2, string, null);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        class AutoCompletionDocument
        extends PlainDocument {
            private static final long serialVersionUID = -5937714911202815782L;
            private JTextField textField;

            AutoCompletionDocument() {
                this.textField = FontChooserComboBoxEditor.this.editor;
            }

            @Override
            public void replace(int n2, int n3, String string, AttributeSet attributeSet) throws BadLocationException {
                super.remove(n2, n3);
                this.insertString(n2, string, attributeSet);
            }

            @Override
            public void insertString(int n2, String string, AttributeSet attributeSet) throws BadLocationException {
                if (string != null && !"".equals(string)) {
                    String string2 = this.getText(0, n2);
                    String string3 = FontChooserComboBoxEditor.this.b(string2 + string);
                    int n3 = n2 + string.length() - 1;
                    if (string3 == null) {
                        string3 = FontChooserComboBoxEditor.this.b(string2);
                        --n3;
                    }
                    if (string3 != null) {
                        FontChooserComboBox.this.a(string3);
                    }
                    super.remove(0, this.getLength());
                    super.insertString(0, string3, attributeSet);
                    this.textField.setSelectionStart(n3 + 1);
                    this.textField.setSelectionEnd(this.getLength());
                }
            }

            @Override
            public void remove(int n2, int n3) throws BadLocationException {
                int n4 = this.textField.getSelectionStart();
                if (n4 > 0) {
                    --n4;
                }
                String string = FontChooserComboBoxEditor.this.b(this.getText(0, n4));
                super.remove(0, this.getLength());
                super.insertString(0, string, null);
                if (string != null) {
                    FontChooserComboBox.this.a(string);
                }
                try {
                    this.textField.setSelectionStart(n4);
                    this.textField.setSelectionEnd(this.getLength());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

