/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.swing.widgets;

import com.mimvista.util.ay;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.Stroke;
import javax.swing.border.AbstractBorder;

public class RoundedBorder
extends AbstractBorder {
    private static final long serialVersionUID = 1L;
    private final Color color;
    private final int thickness;
    private final int cornerRadius;
    private final int inset;

    public RoundedBorder(Color color, int n2, int n3) {
        this.color = color;
        this.thickness = n2;
        this.cornerRadius = n3;
        this.inset = this.b();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintBorder(Component component, Graphics graphics, int n2, int n3, int n4, int n5) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        try {
            graphics2D.setBackground(component.getBackground());
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setStroke(this.a());
            graphics2D.setColor(this.color);
            int n6 = this.thickness / 2;
            graphics2D.drawRoundRect(n6, n6, n4 - this.thickness - 1, n5 - this.thickness - 1, this.cornerRadius, this.cornerRadius);
        }
        catch (Throwable throwable) {
            ay.d((Object)"Error painting border", throwable, this);
        }
        finally {
            graphics2D.dispose();
        }
    }

    @Override
    public Insets getBorderInsets(Component component) {
        return new Insets(this.inset, this.inset, this.inset, this.inset);
    }

    @Override
    public Insets getBorderInsets(Component component, Insets insets) {
        insets.top = this.inset;
        insets.bottom = this.inset;
        insets.left = this.inset;
        insets.right = this.inset;
        return insets;
    }

    public Stroke a() {
        return new BasicStroke(this.thickness);
    }

    private int b() {
        double d2 = (double)this.cornerRadius - (double)this.cornerRadius / Math.sqrt(2.0);
        return (int)Math.round((double)this.thickness + d2);
    }
}

