/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.swing.widgets;

import com.google.common.collect.Lists;
import com.mimvista.archive.NameFormatter;
import com.mimvista.archive.gui.MIMSeriesPanel;
import com.mimvista.archive.gui.ak;
import com.mimvista.d;
import com.mimvista.dicom.DcmSeries;
import com.mimvista.dicom.devices.dump.gui.TableColumnAdjuster;
import com.mimvista.gui.util.ImageManipulator;
import com.mimvista.proui.MIMLookAndFeel;
import com.mimvista.util.DateUtils;
import com.mimvista.util.Messages;
import com.mimvista.workflow.backend.g;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.HorizontalLayout;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.Highlighter;

public class SeriesSelectionTable
extends JXTable {
    private static final long serialVersionUID = 1L;
    private boolean showMatch = true;
    private boolean showModality = true;
    private ak descBuilder;
    private a seriesFilter = null;
    private TableColumnAdjuster tca;

    public SeriesSelectionTable(List<DcmSeries> list) {
        this(list, true, false, new ak(), null);
    }

    public SeriesSelectionTable(boolean bl2, ak ak2, @d a a2) {
        this(new ArrayList<DcmSeries>(), true, bl2, ak2, a2);
    }

    public SeriesSelectionTable(boolean bl2, boolean bl3, ak ak2, @d a a2) {
        this(new ArrayList<DcmSeries>(), bl2, bl3, ak2, a2);
    }

    private SeriesSelectionTable(List<DcmSeries> list, boolean bl2, boolean bl3, ak ak2, a a2) {
        this.showMatch = bl2;
        this.showModality = bl3;
        this.descBuilder = ak2;
        this.seriesFilter = a2;
        MIMSeriesPanel.a(this);
        this.setHighlighters(new Highlighter[]{MIMLookAndFeel.c(this.getBackground())});
        this.tca = new TableColumnAdjuster((JTable)((Object)this), 10);
        this.tca.setColumnHeaderIncluded(true);
        this.getTableHeader().setVisible(true);
        this.getTableHeader().setReorderingAllowed(false);
        this.getTableHeader().setResizingAllowed(true);
        this.setSelectionMode(0);
        this.setAutoResizeMode(3);
        this.setRowHeight(25);
        this.setFont(this.getFont().deriveFont(12.0f));
        this.setDefaultRenderer(String.class, new DefaultTableCellRenderer(){
            private static final long serialVersionUID = 1L;

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl2, boolean bl3, int n2, int n3) {
                if (object == null) {
                    object = "";
                }
                final Component component = super.getTableCellRendererComponent(jTable, object, bl2, bl3, n2, n3);
                final AtomicBoolean atomicBoolean = new AtomicBoolean(false);
                JPanel jPanel = new JPanel((LayoutManager)new HorizontalLayout()){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public void setBackground(Color color) {
                        super.setBackground(color);
                        if (atomicBoolean.get()) {
                            component.setBackground(color);
                        }
                    }
                };
                jPanel.setBackground(component.getBackground());
                atomicBoolean.set(true);
                jPanel.add(component);
                return jPanel;
            }
        });
        this.setDefaultRenderer(Integer.class, new DefaultTableCellRenderer(){
            private static final long serialVersionUID = 1L;

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl2, boolean bl3, int n2, int n3) {
                float f2;
                Component component = super.getTableCellRendererComponent(jTable, object, bl2, bl3, n2, n3);
                JLabel jLabel = new JLabel();
                if (object instanceof Integer && (f2 = ((Integer)object).floatValue() / (float)SeriesSelectionTable.this.seriesFilter.a()) > 0.0f) {
                    jLabel.setIcon(new com.mimvista.gui.util.d(ImageManipulator.c("star_green", 16), 1.0f - f2));
                }
                JPanel jPanel = new JPanel();
                jPanel.setBackground(component.getBackground());
                jPanel.add(jLabel);
                return jPanel;
            }
        });
        this.a(list);
    }

    public boolean isCellEditable(int n2, int n3) {
        return false;
    }

    public void a(List<DcmSeries> list) {
        SeriesSelectionTableModel seriesSelectionTableModel = new SeriesSelectionTableModel(list);
        this.setModel(seriesSelectionTableModel);
        this.tca.adjustColumns();
        seriesSelectionTableModel.a();
    }

    public void a(DcmSeries dcmSeries) {
        TableModel tableModel = this.getModel();
        if (tableModel instanceof SeriesSelectionTableModel) {
            SeriesSelectionTableModel seriesSelectionTableModel = (SeriesSelectionTableModel)tableModel;
            seriesSelectionTableModel.a(dcmSeries);
        }
    }

    public List<DcmSeries> a() {
        ArrayList arrayList = Lists.newArrayList();
        if (this.getModel() instanceof SeriesSelectionTableModel) {
            arrayList.addAll(((SeriesSelectionTableModel)this.getModel()).series);
        }
        return arrayList;
    }

    public DcmSeries b() {
        int n2 = this.getSelectionModel().getLeadSelectionIndex();
        int n3 = this.convertRowIndexToModel(n2);
        if (this.getModel() instanceof SeriesSelectionTableModel) {
            List list = ((SeriesSelectionTableModel)this.getModel()).series;
            if (n3 >= 0 && n3 < list.size()) {
                return (DcmSeries)list.get(n3);
            }
        }
        return null;
    }

    public List<DcmSeries> c() {
        ArrayList arrayList = Lists.newArrayList();
        if (this.getModel() instanceof SeriesSelectionTableModel) {
            for (int n2 : this.getSelectedRows()) {
                int n3 = this.convertRowIndexToModel(n2);
                DcmSeries dcmSeries = (DcmSeries)((SeriesSelectionTableModel)this.getModel()).series.get(n3);
                arrayList.add(dcmSeries);
            }
        }
        return arrayList;
    }

    private class SeriesSelectionTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        private List<DcmSeries> series;

        public SeriesSelectionTableModel(List<DcmSeries> list) {
            this.series = new CopyOnWriteArrayList<DcmSeries>(list);
        }

        public void a(DcmSeries dcmSeries) {
            int n2 = this.series.indexOf(dcmSeries);
            if (n2 != -1) {
                this.series.remove(n2);
                this.fireTableRowsDeleted(n2, n2);
            }
            this.a();
        }

        public void a() {
            if (SeriesSelectionTable.this.seriesFilter != null && !this.series.isEmpty()) {
                int n2 = 0;
                DcmSeries dcmSeries = this.series.get(0);
                for (DcmSeries dcmSeries2 : this.series) {
                    int n3 = SeriesSelectionTable.this.seriesFilter.b(dcmSeries2);
                    if (n3 <= n2) continue;
                    n2 = n3;
                    dcmSeries = dcmSeries2;
                }
                int n4 = this.series.indexOf(dcmSeries);
                SeriesSelectionTable.this.setRowSelectionInterval(n4, n4);
            }
        }

        @Override
        public int getRowCount() {
            return this.series.size();
        }

        @Override
        public int getColumnCount() {
            int n2 = 5;
            if (SeriesSelectionTable.this.showModality) {
                ++n2;
            }
            if (SeriesSelectionTable.this.seriesFilter != null && SeriesSelectionTable.this.showMatch) {
                ++n2;
            }
            return n2;
        }

        @Override
        public Class<?> getColumnClass(int n2) {
            if (SeriesSelectionTable.this.seriesFilter != null && SeriesSelectionTable.this.showMatch && n2 == 0) {
                return Integer.class;
            }
            return String.class;
        }

        @Override
        public String getColumnName(int n2) {
            Messages messages = Messages.a("Archive");
            if (SeriesSelectionTable.this.seriesFilter != null && SeriesSelectionTable.this.showMatch) {
                if (n2 == 0) {
                    return messages.getProperty("REFERENCED_MATCH");
                }
                --n2;
            }
            if (SeriesSelectionTable.this.showModality) {
                if (n2 == 0) {
                    return messages.getProperty("PATIENTIMPORT_MODALITY_COL");
                }
                --n2;
            }
            switch (n2) {
                case 0: {
                    return messages.getProperty("PATIENTIMPORT_NAME_COL");
                }
                case 1: {
                    return messages.getProperty("PATIENTIMPORT_PID_COL");
                }
                case 2: {
                    return messages.getProperty("PATIENTIMPORT_DATE_COL");
                }
                case 3: {
                    return messages.getProperty("PATIENTIMPORT_TIME_COL");
                }
                case 4: {
                    return messages.getProperty("PATIENTIMPORT_SERIES_COL");
                }
            }
            return "";
        }

        @Override
        public Object getValueAt(int n2, int n3) {
            if (n2 >= 0 && n2 < this.series.size()) {
                DcmSeries dcmSeries = this.series.get(n2);
                if (SeriesSelectionTable.this.seriesFilter != null && SeriesSelectionTable.this.showMatch) {
                    if (n3 == 0) {
                        return SeriesSelectionTable.this.seriesFilter.b(dcmSeries);
                    }
                    --n3;
                }
                if (SeriesSelectionTable.this.showModality) {
                    if (n3 == 0) {
                        return dcmSeries.getModality();
                    }
                    --n3;
                }
                switch (n3) {
                    case 0: {
                        return NameFormatter.a(dcmSeries.getPatientName());
                    }
                    case 1: {
                        return dcmSeries.getPatientID();
                    }
                    case 2: {
                        Date date = dcmSeries.getDisplayDate();
                        if (date == null) {
                            return "";
                        }
                        return DateUtils.a(date, DateUtils.c[3]);
                    }
                    case 3: {
                        Date date = dcmSeries.getDisplayTime();
                        if (date != null) {
                            return DateUtils.a(date, "HH:mm:ss");
                        }
                        return "";
                    }
                    case 4: {
                        return SeriesSelectionTable.this.descBuilder.a(dcmSeries);
                    }
                }
            }
            return null;
        }
    }

    public static abstract class a {
        public abstract boolean a(g var1);

        public boolean c(g g2) {
            return this.b(g2) > 0;
        }

        public abstract int b(g var1);

        public abstract int a();

        public Comparator<? super DcmSeries> b() {
            return null;
        }
    }
}

