/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.swing.widgets;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.mimvista.internals.SimpleOrientationHelper;
import com.mimvista.internals.SliceInfo;
import com.mimvista.internals.volumes.SimpleImageVolume;
import com.mimvista.numerics.ImageCube;
import com.mimvista.numerics.helpers.FuncUtils;
import com.mimvista.util.Pair;
import com.mimvista.util.progress.Progress;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;

public class SliceShower
extends JComponent {
    private static final long serialVersionUID = -141444075642268842L;
    private final Progress progress;
    private final FuncUtils.f latch;
    private a completionListener = null;
    private final List<Vector3f> slicePos = Lists.newArrayList();
    private final List<Pair<Vector3f, Vector3f>> dataBounds = Lists.newArrayList();
    private final SimpleImageVolume<ImageCube.ImageCubeShort> vol;
    private Vector3f unitZ;
    private Point cursorLocation = new Point(5, 5);
    private static Color a = Color.BLACK;
    private static Color b = Color.GRAY;

    public SliceShower(SimpleImageVolume<ImageCube.ImageCubeShort> simpleImageVolume, Progress progress, FuncUtils.f f2) {
        this.vol = simpleImageVolume;
        this.progress = progress;
        this.latch = f2;
        this.unitZ = new Vector3f(SimpleOrientationHelper.a(simpleImageVolume.getUncopiedMutableInfo().imageOrientation, simpleImageVolume.getUncopiedMutableInfo().H()));
        this.d();
        this.e();
    }

    private void d() {
        List<SliceInfo> list = this.vol.ab();
        Vector3f vector3f = new Vector3f(list.get((int)0).sliceDicomCenter);
        for (int i2 = 0; i2 < list.size(); ++i2) {
            float f2;
            SliceInfo sliceInfo = list.get(i2);
            SliceInfo sliceInfo2 = i2 < list.size() - 1 ? list.get(i2 + 1) : null;
            Vector3f vector3f2 = new Vector3f(sliceInfo.sliceDicomCenter);
            this.slicePos.add(vector3f2);
            if (sliceInfo2 != null) {
                float f3 = com.mimvista.internals.volumes.a.a(this.unitZ, sliceInfo2.sliceDicomCenter, vector3f2);
                if (!(f3 * 0.25f > (f2 = sliceInfo.voxel.z / 2.0f + sliceInfo2.voxel.z / 2.0f))) continue;
                this.dataBounds.add(Pair.get(vector3f, new Vector3f(sliceInfo.sliceDicomCenter)));
                vector3f = new Vector3f(sliceInfo2.sliceDicomCenter);
                continue;
            }
            Vector3f vector3f3 = (Vector3f)vector3f.clone();
            vector3f3.sub((Tuple3f)vector3f2);
            f2 = vector3f3.length();
            if (!((double)f2 * 0.25 > (double)sliceInfo.voxel.z)) continue;
            this.dataBounds.add(Pair.get(vector3f, vector3f2));
        }
    }

    private Pair<Integer, Integer> b(Pair<Vector3f, Vector3f> pair) {
        Vector3f vector3f = this.slicePos.get(0);
        float[] fArray = new float[]{vector3f.x, vector3f.y, vector3f.z};
        float f2 = com.mimvista.internals.volumes.a.a(this.unitZ, fArray, this.slicePos.get(this.slicePos.size() - 1));
        Integer n2 = Math.round((float)(this.getHeight() - 3) * com.mimvista.internals.volumes.a.a(this.unitZ, fArray, (Vector3f)pair.x) / f2);
        Integer n3 = Math.round((float)(this.getHeight() - 3) * com.mimvista.internals.volumes.a.a(this.unitZ, fArray, (Vector3f)pair.y) / f2);
        int n4 = n3 - n2;
        if (n4 < 3) {
            return Pair.get(n2 - (3 - n4), n3 + (3 - n4));
        }
        return Pair.get(n2, n3);
    }

    private boolean a(float[] fArray, Pair<Vector3f, Vector3f> pair) {
        Vector3f vector3f = this.slicePos.get(0);
        float[] fArray2 = new float[]{vector3f.x, vector3f.y, vector3f.z};
        float f2 = com.mimvista.internals.volumes.a.a(this.unitZ, fArray2, new Vector3f(fArray));
        float f3 = com.mimvista.internals.volumes.a.a(this.unitZ, fArray2, (Vector3f)pair.x);
        float f4 = com.mimvista.internals.volumes.a.a(this.unitZ, fArray2, (Vector3f)pair.y);
        return f2 >= f3 && f2 <= f4;
    }

    private boolean a(int n2, Pair<Integer, Integer> pair) {
        return (Integer)pair.x <= n2 && (Integer)pair.y >= n2;
    }

    public static void a(Color color, Color color2) {
        if (color != null) {
            a = color;
        }
        if (color2 != null) {
            b = color2;
        }
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        int n2 = this.getWidth();
        Iterator<Pair<Vector3f, Vector3f>> iterator = this.dataBounds.iterator();
        while (iterator.hasNext()) {
            int n3 = this.cursorLocation.y;
            Pair<Vector3f, Vector3f> pair = iterator.next();
            Pair<Integer, Integer> pair2 = this.b(pair);
            Color color = this.a(n3, pair2) ? a : b;
            graphics.setColor(color);
            graphics.fillRect(0, (Integer)pair2.x, n2, (Integer)pair2.y - (Integer)pair2.x);
        }
        graphics.setColor(new Color(255, 255, 255, 128));
        graphics.drawLine(0, this.cursorLocation.y, n2, this.cursorLocation.y);
        graphics.drawLine(this.cursorLocation.x, 0, this.cursorLocation.x, this.getHeight());
    }

    private void e() {
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                SliceShower.this.cursorLocation = mouseEvent.getPoint();
                SliceShower.this.repaint();
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                int n2 = mouseEvent.getPoint().y;
                SliceShower.this.a(n2);
            }
        };
        this.addMouseListener(mouseAdapter);
        this.addMouseMotionListener(mouseAdapter);
    }

    public void a(a a2) {
        this.completionListener = a2;
    }

    public void a() {
        Pair pair = (Pair)Ordering.natural().onResultOf((Function)new Function<Pair<Vector3f, Vector3f>, Double>(){

            public Double a(Pair<Vector3f, Vector3f> pair) {
                Vector3f vector3f = new Vector3f((Vector3f)pair.x);
                vector3f.sub((Tuple3f)pair.y);
                return Math.sqrt(vector3f.lengthSquared());
            }

            public /* synthetic */ Object apply(Object object) {
                return this.a((Pair)object);
            }
        }).max(this.dataBounds);
        this.a(pair);
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension dimension = super.getMinimumSize();
        dimension.height = 200;
        dimension.width = 133;
        return dimension;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    private void a(int n2) {
        Pair<Vector3f, Vector3f> pair = null;
        for (Pair<Vector3f, Vector3f> pair2 : this.dataBounds) {
            if (!this.a(n2, this.b(pair2))) continue;
            pair = pair2;
            break;
        }
        if (pair != null) {
            this.a(pair);
        }
    }

    public void a(Pair<Vector3f, Vector3f> pair) {
        ArrayList arrayList = Lists.newArrayList();
        for (SliceInfo sliceInfo : this.vol.ab()) {
            boolean bl2 = this.a(sliceInfo.sliceDicomCenter, pair);
            if (!bl2) continue;
            arrayList.add(sliceInfo);
        }
        this.vol.getUncopiedMutableInfo().selectedExtent = pair;
        this.vol.a(this.progress, arrayList);
        if (this.completionListener != null) {
            this.completionListener.a();
        }
        this.latch.b();
    }

    public void b() {
        this.progress.j();
        if (this.completionListener != null) {
            this.completionListener.a();
        }
        this.latch.b();
    }

    public void c() {
        if (!this.latch.isDone()) {
            this.b();
        }
    }

    public static abstract class a {
        public void a() {
        }
    }
}

