/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.user;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.healthmarketscience.rmiio.GZIPRemoteInputStream;
import com.healthmarketscience.rmiio.GZIPRemoteOutputStream;
import com.healthmarketscience.rmiio.RemoteInputStreamServer;
import com.healthmarketscience.rmiio.RemoteOutputStreamServer;
import com.healthmarketscience.rmiio.SimpleRemoteInputStream;
import com.healthmarketscience.rmiio.SimpleRemoteOutputStream;
import com.mimvista.ExternallyVisible;
import com.mimvista.archive.remote.MIMPrefRMI;
import com.mimvista.archive.remote.MIMpacsConfig;
import com.mimvista.archive.remote.RemoteInputStreamProxy;
import com.mimvista.archive.remote.RemoteObjectInfo;
import com.mimvista.archive.remote.RemoteOutputStreamProxy;
import com.mimvista.archive.remote.sync.SyncFileStub;
import com.mimvista.archive.remote.sync.SyncMap;
import com.mimvista.d;
import com.mimvista.file.MIMFile;
import com.mimvista.file.Path;
import com.mimvista.file.PathUtils;
import com.mimvista.file.f;
import com.mimvista.license.AsymEncryptedEnvelope;
import com.mimvista.license.KeyBox;
import com.mimvista.license.LicenseClient;
import com.mimvista.license.LicenseTransformer;
import com.mimvista.preferences.PrefParsers;
import com.mimvista.preferencesNew.MIMPref;
import com.mimvista.preferencesNew.MIMPrefFile;
import com.mimvista.preferencesNew.MIMpacsGroupPrefs;
import com.mimvista.preferencesNew.MimpacsPrefs;
import com.mimvista.preferencesNew.UserLoginsPrefCascade;
import com.mimvista.preferencesNew.cascade.CascadeLevel;
import com.mimvista.preferencesNew.cascade.CascadeLevelFolder;
import com.mimvista.properties.LegacyMIMPrefsFile;
import com.mimvista.properties.am;
import com.mimvista.properties.security.SecurityLevel;
import com.mimvista.update.VersionNumber;
import com.mimvista.user.ActiveDirectorySSOAuthorizationService;
import com.mimvista.user.AuthenticationType;
import com.mimvista.user.Authenticator;
import com.mimvista.user.ConfigFile;
import com.mimvista.user.ConfigLevelManager;
import com.mimvista.user.Cookie;
import com.mimvista.user.CookieBox;
import com.mimvista.user.DefaultConfigFile;
import com.mimvista.user.LdapUsernamePasswordAuthorizationService;
import com.mimvista.user.NullAuthorizationService;
import com.mimvista.user.NullCookieBox;
import com.mimvista.user.SignedKey;
import com.mimvista.user.User;
import com.mimvista.user.UserDBAuthorizationService;
import com.mimvista.user.UserDBBackup;
import com.mimvista.user.UserDatabase;
import com.mimvista.user.UserInfo;
import com.mimvista.user.c;
import com.mimvista.user.ldap.LdapAuthorizationService;
import com.mimvista.user.ldap.b;
import com.mimvista.user.singlesignon.a;
import com.mimvista.util.MIMContext;
import com.mimvista.util.NetworkUtils;
import com.mimvista.util.ay;
import com.mimvista.util.ce;
import com.mimvista.util.cn;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.rmi.server.RemoteServer;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.Vector;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import sun.rmi.server.UnicastServerRef;

@ExternallyVisible
public abstract class AuthorizationService
implements Authenticator {
    public static final int AUTHORIZATION_SERVICE_OBJID = 17190;
    protected static AuthorizationService g = null;
    private static final Object a = new Object();
    protected UserDatabase h = null;
    protected UnicastServerRef i;
    protected AuthenticationType j = AuthenticationType.d;
    protected c k;

    public static AuthorizationService getInstanceForTest(@d c c2) {
        if (g != null) {
            return g;
        }
        String string = MimpacsPrefs.ldapProviderId.getValue();
        g = AuthorizationService.a(true, c2, com.mimvista.user.ldap.c.a(string));
        return g;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AuthorizationService getInstance() {
        if (g != null) {
            return g;
        }
        Object object = a;
        synchronized (object) {
            if (g != null) {
                return g;
            }
            String string = MimpacsPrefs.ldapProviderId.getValue();
            g = AuthorizationService.a(false, null, com.mimvista.user.ldap.c.a(string));
            return g;
        }
    }

    public static KeyBox getServiceLicense() {
        for (int i2 = 0; i2 < 4; ++i2) {
            ay.b((Object)("Getting key from license server... try #" + (i2 + 1)), AuthorizationService.class);
            KeyBox keyBox = LicenseClient.getAuthServerKey();
            if (keyBox != null) {
                return keyBox;
            }
            try {
                LicenseClient.destroyInstance();
                Thread.sleep(5000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return null;
    }

    protected static AuthorizationService a(boolean bl2, @d c c2, b b2) {
        AuthenticationType authenticationType = MimpacsPrefs.authServerMethod.getValue();
        AuthorizationService authorizationService = null;
        switch (authenticationType) {
            case a: {
                try {
                    com.mimvista.user.singlesignon.a.a();
                    authorizationService = new ActiveDirectorySSOAuthorizationService(bl2, c2, b2);
                    break;
                }
                catch (RemoteException remoteException) {
                    ay.d((Object)"Exception starting SSO service, falling back to LDAP username/password.", (Throwable)remoteException, AuthorizationService.class);
                }
            }
            case b: {
                if (b2 != null) {
                    authorizationService = new LdapAuthorizationService(bl2, c2, b2);
                    break;
                }
                authorizationService = new LdapUsernamePasswordAuthorizationService(bl2, c2);
                break;
            }
            case c: {
                authorizationService = new UserDBAuthorizationService(bl2, c2);
                break;
            }
            case d: {
                authorizationService = new NullAuthorizationService(bl2, c2);
                break;
            }
            case e: {
                authorizationService = com.mimvista.archive.a.a(bl2, c2);
                break;
            }
            default: {
                return null;
            }
        }
        if (authorizationService.c()) {
            return authorizationService;
        }
        return null;
    }

    protected AuthorizationService() {
        this(false, null);
    }

    protected AuthorizationService(boolean bl2) {
        this(bl2, null);
    }

    protected AuthorizationService(boolean bl2, @d c c2) {
        this.loadConfig();
        this.h = new UserDatabase(bl2);
        this.k = c2 != null ? c2 : this.b();
    }

    public void loadConfig() {
    }

    public void reloadConfiguration() {
        this.loadConfig();
    }

    public AuthenticationType getAuthType() {
        return this.j;
    }

    @Override
    public CookieBox authenticate(AsymEncryptedEnvelope<String[]> asymEncryptedEnvelope) throws RemoteException {
        return this.a(asymEncryptedEnvelope, this.k.a().getPrivate());
    }

    @Override
    public CookieBox authenticateUsingLongtermToken(AsymEncryptedEnvelope<String[]> asymEncryptedEnvelope) throws RemoteException {
        return this.a(asymEncryptedEnvelope, this.k.b().getPrivate());
    }

    private CookieBox a(AsymEncryptedEnvelope<String[]> asymEncryptedEnvelope, PrivateKey privateKey) {
        String[] stringArray = asymEncryptedEnvelope.getObject(privateKey);
        if (stringArray.length != 2) {
            return null;
        }
        try {
            String string = stringArray[0];
            String string2 = stringArray[1];
            CookieBox cookieBox = this.c(string, string2);
            if (cookieBox != null && cookieBox.b()) {
                ay.b((Object)("Successful login for user: " + string + "@" + this.d()), "auditlog");
            } else {
                ay.b((Object)("Failed login for user: " + string + "@" + this.d()), "auditlog");
            }
            return cookieBox;
        }
        catch (Throwable throwable) {
            ay.d((Object)throwable, this);
            throw Throwables.propagate((Throwable)throwable);
        }
    }

    private CookieBox c(String string, String string2) {
        CookieBox cookieBox = this.a(string, string2);
        if (cookieBox != null && cookieBox.b()) {
            try {
                String string3 = this.b(string, string2);
                cookieBox.a(this.a(string3, MimpacsPrefs.getUserPreferenceEncryptionSalt()));
            }
            catch (GeneralSecurityException generalSecurityException) {
                ay.d((Object)"Exception setting longterm user preference encrypter!", (Throwable)generalSecurityException, this);
            }
        }
        return cookieBox;
    }

    @Override
    public PublicKey getServerPublicKey() {
        return this.k.b().getPublic();
    }

    @Override
    public CookieBox authenticateHost() {
        String string = this.d();
        if (string == null || !string.equals("127.0.0.1")) {
            return new NullCookieBox();
        }
        Cookie cookie = new Cookie("host_admin");
        cookie.a(true);
        return new CookieBox(cookie, this.k.c(), this.k.a().getPrivate());
    }

    @Override
    public boolean deleteFile(String string, CookieBox cookieBox) throws RemoteException {
        String string2 = this.c(cookieBox);
        if (string2 == null) {
            return false;
        }
        return this.a(null, string, string2).delete();
    }

    @Override
    public RemoteObjectInfo getFileOutStream(CookieBox cookieBox, ConfigLevelManager.ConfigLevel configLevel, String string) throws RemoteException {
        String string2 = this.c(cookieBox);
        if (string2 == null || string2.isEmpty()) {
            return null;
        }
        return this.c(this.a(configLevel, string, string2));
    }

    @Override
    public RemoteObjectInfo getFileStream(CookieBox cookieBox, ConfigLevelManager.ConfigLevel configLevel, String string) throws RemoteException {
        String string2 = this.c(cookieBox);
        if (string2 == null) {
            return null;
        }
        File file = this.a(configLevel, string, string2);
        if (!file.exists()) {
            ay.c((Object)("Client asked for a file that doesn't exist: " + file), this);
            return null;
        }
        return this.b(file);
    }

    @Override
    public PublicKey getPublicKey() throws RemoteException {
        return this.k.a().getPublic();
    }

    @Override
    public String[] getRemotePatientListServers() throws RemoteException {
        return MimpacsPrefs.pacsServers.getValue();
    }

    @Override
    public HashMap<String, ConfigFile> getSystemConfig() throws RemoteException {
        HashMap<String, ConfigFile> hashMap = new HashMap<String, ConfigFile>();
        this.a(hashMap, false);
        this.a(hashMap, true);
        return hashMap;
    }

    private void a(HashMap<String, ConfigFile> hashMap, boolean bl2) {
        File file;
        File[] fileArray;
        String string = Path.getLegacyConfigBasePath() + "systemOverride" + File.separator;
        if (bl2) {
            string = string + "SERVICES" + File.separator;
        }
        if ((fileArray = (file = new File(string)).listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return !file.isDirectory() && file.canRead() && file.length() > 0L && file.getName().toLowerCase().endsWith(".txt");
            }
        })) == null) {
            return;
        }
        for (File file2 : fileArray) {
            LegacyMIMPrefsFile legacyMIMPrefsFile = new LegacyMIMPrefsFile(new am(file2.getName(), SecurityLevel.a), string);
            String[] stringArray = legacyMIMPrefsFile.getAllPropNames();
            ConfigFile configFile = hashMap.get(file2.getName());
            if (configFile == null && bl2) {
                hashMap.put("SERVICES/" + file2.getName(), new ConfigFile());
                configFile = hashMap.get("SERVICES/" + file2.getName());
                configFile.setFilename(file2.getName());
            } else if (configFile == null) {
                hashMap.put(file2.getName(), new ConfigFile());
                configFile = hashMap.get(file2.getName());
                configFile.setFilename(file2.getName());
            }
            configFile.getOptions().clear();
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                configFile.getOptions().put(stringArray[i2], legacyMIMPrefsFile.get(stringArray[i2]));
            }
        }
    }

    @Override
    public HashMap<String, UserInfo> getUserList() throws RemoteException {
        List<UserInfo> list = this.h.f();
        HashMap<String, UserInfo> hashMap = new HashMap<String, UserInfo>();
        for (UserInfo userInfo : list) {
            hashMap.put(userInfo.login, userInfo);
        }
        return hashMap;
    }

    @Override
    public HashMap<String, HashMap<String, String>> listFiles(CookieBox cookieBox, ConfigLevelManager.ConfigLevel configLevel) throws RemoteException {
        String string = this.c(cookieBox);
        if (string == null) {
            return null;
        }
        if (configLevel == ConfigLevelManager.ConfigLevel.d) {
            return this.a(new File(Path.getLegacyConfigBasePath(), "systemOverride"));
        }
        File file = Path.joinFile(Path.getLegacyConfigBasePath(), "users", string);
        HashMap<String, HashMap<String, String>> hashMap = this.a(file);
        file = new File(Path.getLegacyConfigBasePath(), "defaults");
        HashMap<String, HashMap<String, String>> hashMap2 = this.a(file);
        for (String string2 : hashMap2.keySet()) {
            HashMap<String, String> hashMap3 = hashMap2.get(string2);
            hashMap.put("DEFAULT_/" + string2, hashMap3);
        }
        return hashMap;
    }

    private HashMap<String, HashMap<String, String>> a(File file) {
        File[] fileArray;
        HashMap<String, HashMap<String, String>> hashMap = new HashMap<String, HashMap<String, String>>();
        if (!file.exists()) {
            file.mkdirs();
            return hashMap;
        }
        for (File file2 : fileArray = file.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (!file.isFile()) {
                    return false;
                }
                String string = file.getName().toLowerCase();
                return !string.endsWith(".txt") && !string.endsWith(".ds_store") && !string.equals("crashy");
            }
        })) {
            long l2 = file2.length();
            if (l2 > 0L) {
                String string = file2.getName();
                HashMap<String, String> hashMap2 = new HashMap<String, String>();
                hashMap2.put("size", Long.toString(l2));
                hashMap2.put("date", Long.toString(file2.lastModified()));
                hashMap.put(string, hashMap2);
                continue;
            }
            file2.delete();
            ay.a((Object)("File " + file2 + " is empty, remove it"), this);
        }
        return hashMap;
    }

    @Override
    public void saveUser(CookieBox cookieBox, User user) throws RemoteException {
        if (!this.a(cookieBox)) {
            return;
        }
        Cookie cookie = cookieBox.d();
        User user2 = this.h.a(cookie.f());
        if (user2 == null) {
            ay.c((Object)("AuthorizationService.saveUser(): A client passed a bad cookie.  The user database doesn't have an entry for: " + cookie.f()), this);
            return;
        }
        if (!user.getLogin().equals(user2.getLogin())) {
            ay.c((Object)String.format("AuthorizationService.saveUser(): A client attempted to save config settings for a user that didn't match its cookie: { cookie: '%s', user: '%s' }", user2.getLogin(), user.getLogin()), this);
            return;
        }
        ay.a((Object)("Saving settings for user: " + user.getLogin()), this);
        Map<String, ConfigFile> map = user.getConfigFiles();
        if (map != null) {
            map = new HashMap<String, ConfigFile>(map);
            user.getConfigFiles().clear();
            if (!map.isEmpty()) {
                for (String string : map.keySet()) {
                    ConfigFile configFile = map.get(string);
                    configFile.setUser(user);
                }
                this.h.a(user2.getLogin(), map);
            }
        }
    }

    @Override
    public boolean saveUserDB(HashMap<String, User> hashMap, CookieBox cookieBox) throws RemoteException {
        if (cookieBox == null || hashMap == null || !cookieBox.b() || cookieBox.d() == null) {
            return false;
        }
        for (User user : hashMap.values()) {
            this.h.b(user);
        }
        return true;
    }

    @Override
    public HashMap<String, User> getUserDB(CookieBox cookieBox) throws RemoteException {
        HashMap<String, User> hashMap = new HashMap<String, User>();
        for (User user : this.h.e()) {
            hashMap.put(user.getLogin(), user);
        }
        return hashMap;
    }

    @Override
    public void hello() throws RemoteException {
    }

    protected c b() {
        try {
            KeyBox keyBox = AuthorizationService.getServiceLicense();
            if (keyBox == null || keyBox.box == null || !keyBox.box.b()) {
                ay.d((Object)"Keybox is invalid", AuthorizationService.class);
                return null;
            }
            KeyPair keyPair = new KeyPair(keyBox.box.c(), keyBox.key);
            KeyPair keyPair2 = this.a();
            Vector<SignedKey> vector = keyBox.box.a();
            return new c(keyPair, keyPair2, vector);
        }
        catch (Throwable throwable) {
            ay.d((Object)"Unable to generate production auth keys", throwable, this);
            return null;
        }
    }

    private KeyPair a() {
        byte[] byArray = MimpacsPrefs.mimpacsPrivateKey.getValue();
        byte[] byArray2 = MimpacsPrefs.mimpacsPubKey.getValue();
        try {
            Serializable serializable;
            Object object;
            if (!PrefParsers.a((Object)byArray) && !PrefParsers.a((Object)byArray2) && AuthorizationService.validateRSAKeyPair((RSAPrivateCrtKey)(object = KeyFactory.getInstance("RSA").generatePrivate(new PKCS8EncodedKeySpec(byArray))), (RSAPublicKey)(serializable = KeyFactory.getInstance("RSA").generatePublic(new X509EncodedKeySpec(byArray2))))) {
                return new KeyPair((PublicKey)serializable, (PrivateKey)object);
            }
            ay.b((Object)"generating new RSA Keypair for permanent pacs logins", this);
            object = KeyPairGenerator.getInstance("RSA");
            ((KeyPairGenerator)object).initialize(1024);
            serializable = ((KeyPairGenerator)object).generateKeyPair();
            MimpacsPrefs.mimpacsPrivateKey.setValue(((KeyPair)serializable).getPrivate().getEncoded());
            MimpacsPrefs.mimpacsPubKey.setValue(((KeyPair)serializable).getPublic().getEncoded());
            return serializable;
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException generalSecurityException) {
            ay.d((Object)"error generating RSA keypair", (Throwable)generalSecurityException, this);
            return null;
        }
    }

    public static boolean validateRSAKeyPair(RSAPrivateCrtKey rSAPrivateCrtKey, RSAPublicKey rSAPublicKey) {
        BigInteger bigInteger = rSAPublicKey.getModulus();
        BigInteger bigInteger2 = rSAPublicKey.getPublicExponent();
        BigInteger bigInteger3 = rSAPrivateCrtKey.getPrivateExponent();
        BigInteger bigInteger4 = rSAPrivateCrtKey.getPrimeP();
        BigInteger bigInteger5 = rSAPrivateCrtKey.getPrimeQ();
        BigInteger bigInteger6 = bigInteger4.multiply(bigInteger5);
        BigInteger bigInteger7 = bigInteger4.add(BigInteger.valueOf(-1L)).multiply(bigInteger5.add(BigInteger.valueOf(-1L)));
        BigInteger bigInteger8 = bigInteger3.multiply(bigInteger2).mod(bigInteger7);
        return bigInteger.equals(bigInteger6) && BigInteger.ONE.equals(bigInteger8);
    }

    protected boolean c() {
        try {
            this.i = ce.a(17190, MIMpacsConfig.f, this);
            return true;
        }
        catch (RemoteException remoteException) {
            ay.d((Object)"Failed to create authorization service", (Throwable)remoteException, AuthorizationService.class);
            return false;
        }
    }

    public boolean unexportRmiObject() {
        if (ce.a(this, 5, 200L) || ce.a(this)) {
            this.i = null;
            g = null;
            return true;
        }
        return false;
    }

    protected String d() {
        try {
            return this.i.getClientHost();
        }
        catch (Throwable throwable) {
            ay.d((Object)"Server not active, can't get client host", this);
            return "";
        }
    }

    private String c(CookieBox cookieBox) {
        if (cookieBox == null) {
            return null;
        }
        return cookieBox.e();
    }

    private File a(ConfigLevelManager.ConfigLevel configLevel, String string, String string2) {
        String string3;
        File file;
        if (configLevel == ConfigLevelManager.ConfigLevel.d) {
            File file2 = new File(Path.getLegacyConfigBasePath(), "systemOverride");
            file2.mkdirs();
            return new File(file2, string.replace(File.separatorChar, '_'));
        }
        if (string.startsWith("DEFAULT_/")) {
            file = new File(Path.getLegacyConfigBasePath(), "defaults");
            string3 = string.substring("DEFAULT_/".length());
        } else {
            file = Path.joinFile(Path.getLegacyConfigBasePath(), "users", string2);
            string3 = string;
        }
        file.mkdirs();
        return new File(file, string3.replace(File.separatorChar, '_'));
    }

    protected ConfigFile a(DefaultConfigFile defaultConfigFile, User user) {
        ConfigFile configFile = new ConfigFile();
        String string = defaultConfigFile.getFilename();
        configFile.setFilename(string);
        configFile.setUser(user);
        configFile.setOptions(defaultConfigFile.getOptions());
        return configFile;
    }

    protected boolean a(CookieBox cookieBox) {
        return cookieBox != null && cookieBox.b();
    }

    protected void e() {
        if (LicenseTransformer.isDevelopment() || !MIMContext.Q()) {
            ay.d((Object)"Won't backup userdb when running under development", this);
            return;
        }
        UserDBBackup userDBBackup = UserDBBackup.a();
        userDBBackup.c();
        userDBBackup.b();
    }

    protected abstract CookieBox a(String var1, String var2);

    protected String b(String string, String string2) {
        return string2;
    }

    protected byte[] a(String string, byte[] byArray) throws GeneralSecurityException {
        SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
        PBEKeySpec pBEKeySpec = new PBEKeySpec(string.toCharArray(), byArray, 65536, 128);
        SecretKey secretKey = secretKeyFactory.generateSecret(pBEKeySpec);
        return secretKey.getEncoded();
    }

    @Override
    public VersionNumber getVersion() throws RemoteException {
        return VersionNumber.rawCurrentVersionNotAccountingForMIMviewer();
    }

    @Override
    public SyncMap getUserFilesToSync(CookieBox cookieBox, boolean bl2) throws RemoteException {
        SyncMap syncMap = new SyncMap();
        if (!this.b(cookieBox)) {
            return syncMap;
        }
        String string = cookieBox.e();
        if (bl2) {
            this.a(syncMap, Path.getMimpacsAdminDefaultsFolder(), string, bl2, false);
        } else {
            this.a(syncMap, Path.getMimpacsUserConfigFolder(string), string, bl2, false);
        }
        this.a(syncMap, Path.getMimpacsUserOverrideFolder(), string, bl2, true);
        this.a(syncMap, 0x100000L);
        return syncMap;
    }

    @Override
    public SyncMap getMachineFilesToSync(CookieBox cookieBox) throws RemoteException {
        SyncMap syncMap = new SyncMap();
        if (cookieBox == null || cookieBox instanceof NullCookieBox || cn.h(cookieBox.e())) {
            return syncMap;
        }
        this.a(syncMap, Path.getMimpacsMachineOverrideFolder(), null, false, true);
        this.a(syncMap, 0x100000L);
        return syncMap;
    }

    private void a(SyncMap syncMap, File file) {
        this.a(syncMap, file, null, false, false);
    }

    private void a(SyncMap syncMap, File file, String string, boolean bl2, boolean bl3) {
        this.a(syncMap, file, null, string, bl2, bl3);
    }

    private void a(SyncMap syncMap, File file, File file2, String string, boolean bl2, boolean bl3) {
        if (!file.exists()) {
            return;
        }
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            ay.c((Object)("Couldn't list the contents of folder: " + file), this);
            return;
        }
        for (File file3 : fileArray) {
            if (file3.isDirectory()) {
                this.a(syncMap, file3, new File(file2, file3.getName()), string, bl2, bl3);
                continue;
            }
            SyncFileStub syncFileStub = new SyncFileStub(file3.getAbsoluteFile(), new File(file2, file3.getName()), string, bl2, bl3);
            if (!com.mimvista.archive.remote.sync.a.get().shouldSync(syncFileStub)) continue;
            syncMap.a(syncFileStub);
        }
    }

    private void a(SyncMap syncMap, long l2) {
        for (SyncFileStub syncFileStub : syncMap) {
            try {
                if (syncFileStub.f() >= l2) continue;
                syncFileStub.j();
            }
            catch (IOException iOException) {
                ay.d((Object)("Couldn't compute file syncing hash for: " + syncFileStub.d()), (Throwable)iOException, this);
            }
        }
    }

    @Override
    public SyncMap getSyncedFiles(CookieBox cookieBox, String string) {
        File file;
        SyncMap syncMap = new SyncMap();
        if (!this.b(cookieBox)) {
            return syncMap;
        }
        File file2 = Path.getMimpacsSyncFolder();
        if (!Path.isParentOf(file2, file = new File(file2, string), true)) {
            String string2 = "Client attempted to sync to a folder outside of the MIMpacs sync folder:\nRelative Path: " + string + "\nAbsolute Path: " + PathUtils.getCanonicalOrAbsolutePath(file);
            ay.c((Object)string2, this);
            return syncMap;
        }
        this.a(syncMap, file);
        this.a(syncMap, 0x100000L);
        return syncMap;
    }

    @Override
    public SyncMap getSyncedFiles(CookieBox cookieBox, String string, Collection<String> collection) {
        SyncMap syncMap = new SyncMap();
        if (!this.b(cookieBox) || collection == null || collection.isEmpty()) {
            return syncMap;
        }
        File file = Path.getMimpacsSyncFolder();
        File file2 = new File(file, string);
        if (!file2.isDirectory()) {
            return syncMap;
        }
        for (String string2 : collection) {
            File file3 = new File(file2, string2);
            File file4 = new File(file2, f.a(string2));
            if (!Path.isParentOf(file, file3)) {
                String string3 = "Client attempted to sync a file outside of the MIMpacs sync folder:\nRelative Path: " + new File(string, string2).getPath() + "\nAbsolute Path: " + PathUtils.getCanonicalOrAbsolutePath(file3);
                ay.c((Object)string3, this);
                continue;
            }
            if (!file3.isFile() && !file4.isFile() || !com.mimvista.archive.remote.sync.a.get().shouldSync(file3)) continue;
            if (file3.isFile()) {
                syncMap.a(new SyncFileStub(file3, new File(string2), null, false, false));
            }
            if (!file4.isFile()) continue;
            syncMap.a(new SyncFileStub(file4, new File(file4.getName()), null, false, false));
        }
        this.a(syncMap, 0x100000L);
        return syncMap;
    }

    @Override
    public RemoteObjectInfo readFile(CookieBox cookieBox, String string, SyncFileStub syncFileStub) {
        if (!this.b(cookieBox)) {
            return null;
        }
        File file = Path.getMimpacsSyncFolder();
        File file2 = new File(file, string);
        File file3 = Path.joinFile(file2, syncFileStub.e());
        if (!Path.isParentOf(file, file3)) {
            throw new IllegalArgumentException("Client attempted to read a file outside of the MIMpacs sync folder: " + file3);
        }
        RemoteInputStreamServer remoteInputStreamServer = null;
        try {
            remoteInputStreamServer = this.d(file3);
            return new RemoteInputStreamProxy(remoteInputStreamServer).a();
        }
        catch (Throwable throwable) {
            ay.d((Object)("readFile: Error exporting input stream to client for: " + file3), throwable, this);
            if (remoteInputStreamServer != null) {
                remoteInputStreamServer.close();
            }
            return null;
        }
    }

    @Override
    public RemoteObjectInfo writeFile(CookieBox cookieBox, String string, SyncFileStub syncFileStub) {
        if (!this.b(cookieBox)) {
            return null;
        }
        if (!com.mimvista.archive.remote.sync.a.get().shouldSync(syncFileStub)) {
            return null;
        }
        File file = Path.getMimpacsSyncFolder();
        File file2 = new File(file, string);
        File file3 = Path.joinFile(file2, syncFileStub.e());
        if (!Path.isParentOf(file, file3)) {
            throw new IllegalArgumentException("Client attempted to write to a file outside of the MIMpacs sync folder: " + file3);
        }
        file3.getParentFile().mkdirs();
        RemoteOutputStreamServer remoteOutputStreamServer = null;
        try {
            remoteOutputStreamServer = this.a(file3, AuthorizationService.a(string));
            return new RemoteOutputStreamProxy(remoteOutputStreamServer).a();
        }
        catch (Throwable throwable) {
            ay.d((Object)("writeFile: Error exporting output stream to client for: " + file3), throwable, this);
            if (remoteOutputStreamServer != null) {
                remoteOutputStreamServer.close();
            }
            return null;
        }
    }

    private static CascadeLevel a(String string) {
        for (CascadeLevelFolder cascadeLevelFolder : CascadeLevelFolder.values()) {
            if (!string.contains(cascadeLevelFolder.b())) continue;
            return cascadeLevelFolder.a();
        }
        return null;
    }

    @Override
    public void deleteFile(CookieBox cookieBox, String string, SyncFileStub syncFileStub) {
        if (!this.b(cookieBox)) {
            throw new IllegalArgumentException("Invalid CookieBox");
        }
        File file = Path.getMimpacsSyncFolder();
        File file2 = new File(file, string);
        File file3 = Path.joinFile(file2, syncFileStub.e());
        if (!Path.isParentOf(file, file3)) {
            throw new IllegalArgumentException("Client attempted to delete a file outside of the MIMpacs sync folder: " + file3);
        }
        if (!f.a(file3, syncFileStub.g())) {
            throw new RuntimeException("Couldn't delete " + file3);
        }
    }

    @Override
    public void deleteFile(CookieBox cookieBox, SyncFileStub syncFileStub) throws RemoteException {
        File file = syncFileStub.a() ? Path.getMimpacsAdminDefaultsFolder() : Path.getMimpacsUserConfigFolder(cookieBox.e());
        File file2 = Path.joinFile(file, syncFileStub.e());
        if (!Path.isParentOf(Path.getMimpacsFolder(), file2)) {
            throw new IllegalArgumentException("Client attempted to delete a file outside of the MIMpacs sync folder: " + syncFileStub.e());
        }
        if (!f.a(file2, syncFileStub.g())) {
            throw new RuntimeException("Couldn't delete " + file2);
        }
    }

    @Override
    public RemoteObjectInfo getFileInputStream(CookieBox cookieBox, SyncFileStub syncFileStub) throws RemoteException {
        if (!Path.isParentOf(Path.getMimpacsFolder(), syncFileStub.d())) {
            throw new IllegalArgumentException("Client attempted to read file outside of the MIMpacs sync folder: " + syncFileStub.d());
        }
        return this.b(syncFileStub.d());
    }

    @Override
    public RemoteObjectInfo getFileOutputStream(CookieBox cookieBox, SyncFileStub syncFileStub) throws RemoteException {
        File file = syncFileStub.a() ? Path.getMimpacsAdminDefaultsFolder() : Path.getMimpacsUserConfigFolder(cookieBox.e());
        File file2 = Path.joinFile(file, syncFileStub.e());
        if (!Path.isParentOf(Path.getMimpacsFolder(), file2)) {
            throw new IllegalArgumentException("Client attempted to write to a file outside of the MIMpacs sync folder: " + syncFileStub.e());
        }
        return this.c(file2);
    }

    private RemoteObjectInfo b(File file) throws RemoteException {
        SimpleRemoteInputStream simpleRemoteInputStream = null;
        try {
            simpleRemoteInputStream = new SimpleRemoteInputStream((InputStream)new BufferedInputStream(new FileInputStream(file)));
            RemoteInputStreamProxy remoteInputStreamProxy = new RemoteInputStreamProxy((RemoteInputStreamServer)simpleRemoteInputStream);
            return remoteInputStreamProxy.a();
        }
        catch (FileNotFoundException fileNotFoundException) {
            ay.d((Object)("Can't find file " + file), (Throwable)fileNotFoundException, this);
        }
        catch (RemoteException remoteException) {
            ay.d((Object)("Couldn't export remote stream object for file: " + file), (Throwable)remoteException, this);
            try {
                ay.b((Object)"Trying to export once more....", this);
                Thread.sleep(500L);
                RemoteInputStreamProxy remoteInputStreamProxy = new RemoteInputStreamProxy((RemoteInputStreamServer)simpleRemoteInputStream);
                ay.b((Object)"Successfully exported after trying once more.", this);
                return remoteInputStreamProxy.a();
            }
            catch (Throwable throwable) {
                simpleRemoteInputStream.close();
            }
        }
        return null;
    }

    private RemoteObjectInfo c(File file) throws RemoteException {
        SimpleRemoteOutputStream simpleRemoteOutputStream = null;
        try {
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            simpleRemoteOutputStream = new SimpleRemoteOutputStream((OutputStream)new FileOutputStream(file));
            RemoteOutputStreamProxy remoteOutputStreamProxy = new RemoteOutputStreamProxy((RemoteOutputStreamServer)simpleRemoteOutputStream);
            return remoteOutputStreamProxy.a();
        }
        catch (FileNotFoundException fileNotFoundException) {
            ay.d((Object)("Can't find file " + file), (Throwable)fileNotFoundException, this);
        }
        catch (RemoteException remoteException) {
            ay.d((Object)"Couldn't export remote stream object", (Throwable)remoteException, this);
            try {
                ay.b((Object)"Trying to export once more....", this);
                Thread.sleep(500L);
                RemoteOutputStreamProxy remoteOutputStreamProxy = new RemoteOutputStreamProxy((RemoteOutputStreamServer)simpleRemoteOutputStream);
                ay.b((Object)"Successfully exported after trying once more.", this);
                return remoteOutputStreamProxy.a();
            }
            catch (Throwable throwable) {
                simpleRemoteOutputStream.close();
            }
        }
        return null;
    }

    private RemoteOutputStreamServer a(OutputStream outputStream) {
        if (MimpacsPrefs.useCompressionWhenSyncingConfigs.getValue().booleanValue()) {
            return new GZIPRemoteOutputStream(outputStream);
        }
        return new SimpleRemoteOutputStream(outputStream);
    }

    private RemoteInputStreamServer a(InputStream inputStream) throws IOException {
        if (MimpacsPrefs.useCompressionWhenSyncingConfigs.getValue().booleanValue()) {
            return new GZIPRemoteInputStream(inputStream);
        }
        return new SimpleRemoteInputStream(inputStream);
    }

    private RemoteOutputStreamServer a(File file, CascadeLevel cascadeLevel) throws FileNotFoundException {
        return this.a(new BufferedOutputStream(new FileOutputStream(file)));
    }

    private RemoteInputStreamServer d(File file) throws FileNotFoundException, IOException {
        return this.a(new BufferedInputStream(new FileInputStream(file)));
    }

    @Override
    public void setLastModified(CookieBox cookieBox, SyncFileStub syncFileStub) throws RemoteException {
        File file = syncFileStub.a() ? Path.getMimpacsAdminDefaultsFolder() : Path.getMimpacsUserConfigFolder(cookieBox.e());
        File file2 = Path.joinFile(file, syncFileStub.e());
        if (!Path.isParentOf(Path.getMimpacsFolder(), file2)) {
            throw new IllegalArgumentException("Client attempted to change last modified time of a file outside of the MIMpacs sync folder: " + syncFileStub.e());
        }
        file2.setLastModified(syncFileStub.g().getTime());
    }

    @Override
    public void setLastModified(CookieBox cookieBox, File file, SyncFileStub syncFileStub) {
        Preconditions.checkArgument((boolean)this.b(cookieBox), (Object)"Invalid CookieBox");
        Preconditions.checkArgument((!file.isAbsolute() ? 1 : 0) != 0, (Object)("remoteFolderPath cannot be an absolute path: " + file));
        File file2 = Path.getMimpacsSyncFolder();
        File file3 = new File(file2, file.getPath());
        File file4 = Path.joinFile(file3, syncFileStub.e());
        Preconditions.checkArgument((boolean)Path.isParentOf(file2, file4), (Object)("Client attempted to read a file outside of the MIMpacs sync folder: " + file4));
        file4.setLastModified(syncFileStub.g().getTime());
    }

    protected boolean b(CookieBox cookieBox) {
        if (cookieBox == null) {
            return false;
        }
        if (cookieBox instanceof NullCookieBox) {
            if (!cookieBox.e().equals("pacs-failover")) {
                return false;
            }
            String string = MimpacsPrefs.failover_otherPacsAddress.getValue();
            if (string == null) {
                return false;
            }
            String string2 = null;
            try {
                string2 = RemoteServer.getClientHost();
                return NetworkUtils.a(string2, string);
            }
            catch (Exception exception) {
                return false;
            }
        }
        return !cn.h(cookieBox.e());
    }

    @Override
    public void siteDefaultPushout(CookieBox cookieBox, CascadeLevel cascadeLevel, @d String string, Collection<MIMPrefRMI> collection, Collection<String> collection2) throws RemoteException {
        Object object;
        Optional<MIMpacsGroupPrefs.a> optional;
        if (!this.b(cookieBox)) {
            throw new IllegalArgumentException("Invalid CookieBox");
        }
        if (!cookieBox.d().g()) {
            throw new IllegalArgumentException("user must be admin to push out configurations");
        }
        if (cascadeLevel != CascadeLevel.f && cascadeLevel != CascadeLevel.g) {
            throw new IllegalArgumentException("only site and group defaults are supported for pushout");
        }
        MIMpacsGroupPrefs.a a3 = null;
        if (cascadeLevel == CascadeLevel.f) {
            if (cn.h(string)) {
                throw new IllegalArgumentException("group name must be provided in order to push out configs to a group");
            }
            optional = MimpacsPrefs.groups.getValue().stream().filter(a2 -> a2.getMimpacsGroupName().equals(string)).findAny();
            if (!optional.isPresent()) {
                throw new IllegalArgumentException("invalid group name: " + string);
            }
            a3 = (MIMpacsGroupPrefs.a)optional.get();
            if (a3 == null) {
                throw new RemoteException("unable to find group " + string);
            }
        }
        optional = new File(new File(Path.getMimpacsSyncFolder(), MIMContext.G()), CascadeLevelFolder.d.b());
        HashMap hashMap = new HashMap();
        HashMultimap hashMultimap = HashMultimap.create();
        for (MIMPrefRMI mIMPrefRMI : collection) {
            MIMPref<?> mIMPref = MIMPrefRMI.a(mIMPrefRMI);
            if (mIMPref != null) {
                hashMap.put(mIMPrefRMI, mIMPref);
                hashMultimap.put(mIMPref.getPrefFile(), mIMPref);
                continue;
            }
            ay.c((Object)("invalid pref: " + mIMPrefRMI.b() + " - " + mIMPrefRMI.a()), this);
        }
        if (a3 != null) {
            try {
                object = this.getAllMembersOfGroup(cookieBox, a3.getLdapGroupName());
            }
            catch (Exception exception) {
                throw new RemoteException("error trying to find members of group " + a3, exception);
            }
        } else {
            object = null;
        }
        Lists.newArrayList((Object[])((File)((Object)optional)).listFiles()).stream().filter(arg_0 -> AuthorizationService.a((Collection)object, arg_0)).forEach(arg_0 -> this.a((Multimap)hashMultimap, collection2, arg_0));
    }

    @Override
    public String getAssistantLoginToken(CookieBox cookieBox) throws RemoteException {
        if (!this.b(cookieBox)) {
            ay.c((Object)"null or invalid cookie when asking for an assistant token", this);
            return null;
        }
        if (cookieBox.d() == null || !cookieBox.d().g()) {
            ay.c((Object)"null or non-admin user when asking for an assistant token", this);
            return null;
        }
        String string = MimpacsPrefs.assistantLoginToken.getValue();
        if (cn.h(string)) {
            string = UUID.randomUUID().toString();
            MimpacsPrefs.assistantLoginToken.setValue(string);
        }
        return string;
    }

    @Override
    public CookieBox authenticateAssistant(String string) throws RemoteException {
        if (cn.h(string)) {
            ay.c((Object)"null assistant auth token!", this);
            return new NullCookieBox();
        }
        String string2 = MimpacsPrefs.assistantLoginToken.getValue();
        if (cn.h(string2)) {
            ay.c((Object)"getting ahead of ourselves there...", this);
            return new NullCookieBox();
        }
        if (!string.equals(string2)) {
            ay.c((Object)"invalid assistant auth token!", this);
            return new NullCookieBox();
        }
        Cookie cookie = new Cookie("Assistant Proxy User");
        cookie.a(false);
        cookie.a(MimpacsPrefs.name.getValue());
        CookieBox cookieBox = new CookieBox(cookie, this.k.c(), this.k.a().getPrivate());
        ay.b((Object)("Successful login for assistant proxy user @" + this.d()), this);
        return cookieBox;
    }

    public abstract String getConfigurationString();

    private /* synthetic */ void a(Multimap multimap, Collection collection, File file) {
        String string2 = file.getName();
        multimap.keySet().forEach(clazz -> {
            UserLoginsPrefCascade userLoginsPrefCascade = new UserLoginsPrefCascade((Class<? extends MIMPrefFile>)clazz, string2, UserLoginsPrefCascade.LoginType.c);
            multimap.get(clazz).stream().forEach(mIMPref -> userLoginsPrefCascade.removePrefValue(mIMPref));
            userLoginsPrefCascade.flush();
        });
        collection.stream().forEach(string -> {
            try {
                MIMFile.n(new File(file, (String)string));
            }
            catch (Exception exception) {
                ay.c((Object)("unable to config pushout file " + new File(file, (String)string)), this);
            }
        });
    }

    private static /* synthetic */ boolean a(Collection collection, File file) {
        return collection == null || collection.contains(file.getName());
    }
}

