/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.user;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.mimvista.user.ConfigLevelManager;
import com.mimvista.user.User;
import com.mimvista.util.MIMContext;
import com.mimvista.util.ay;
import com.mimvista.util.cn;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;

@Entity
@Table(name="config_files", uniqueConstraints={@UniqueConstraint(columnNames={"filename", "user"})})
public class ConfigFile
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    private Long id;
    private String filename;
    @ManyToOne(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @JoinColumn(name="user", insertable=true, updatable=true)
    private User user;
    private HashMap<String, String> options = new HashMap();

    public static void mungeConfigFileNames(Map<String, ConfigFile> map) {
        String string = ConfigFile.getSuffixFromCurrentMIMContext();
        for (String string2 : Lists.newArrayList(map.keySet())) {
            if (string2.endsWith(string)) continue;
            ConfigFile configFile = map.remove(string2);
            String string3 = string2 + string;
            configFile.setFilename(configFile.getFilename() + string);
            map.put(string3, configFile);
        }
    }

    public static void unmungeConfigFileNames(Map<String, ConfigFile> map) {
        String string = ConfigFile.getSuffixFromCurrentMIMContext();
        for (String string2 : map.keySet()) {
            ConfigFile configFile = map.remove(string2);
            String string3 = ConfigFile.unMungeConfigFilename(string, string2);
            configFile.setFilename(ConfigFile.unMungeConfigFilename(string, configFile.getFilename()));
            map.put(string3, configFile);
        }
    }

    public static String unMungeConfigFilename(String string) {
        return ConfigFile.unMungeConfigFilename(ConfigFile.getSuffixFromCurrentMIMContext(), string);
    }

    public static String unMungeConfigFilename(String string, String string2) {
        return string2.replaceFirst(string, "");
    }

    public static String getSuffixFromProductName(String string) {
        String string2 = string + "_MUNGINATION_SUFFIX_";
        for (MIMTypeConfigSuffixesForPacs mIMTypeConfigSuffixesForPacs : MIMTypeConfigSuffixesForPacs.values()) {
            if (!mIMTypeConfigSuffixesForPacs.a().equals(string2)) continue;
            return mIMTypeConfigSuffixesForPacs.a();
        }
        return null;
    }

    public static String getSuffixFromCurrentMIMContext() {
        String string = "";
        MIMTypeConfigSuffixesForPacs mIMTypeConfigSuffixesForPacs = ConfigFile.getMIMTypeFromCurrentContext();
        string = mIMTypeConfigSuffixesForPacs.a();
        return string;
    }

    public static MIMTypeConfigSuffixesForPacs getMIMTypeFromCurrentContext() {
        MIMTypeConfigSuffixesForPacs mIMTypeConfigSuffixesForPacs = null;
        if (MIMContext.j()) {
            mIMTypeConfigSuffixesForPacs = MIMTypeConfigSuffixesForPacs.b;
        } else if (MIMContext.h()) {
            mIMTypeConfigSuffixesForPacs = MIMTypeConfigSuffixesForPacs.a;
        }
        return mIMTypeConfigSuffixesForPacs;
    }

    public static boolean isConfigFromOtherMIMContext(String string) {
        return !string.endsWith(ConfigFile.getMIMTypeFromCurrentContext().a());
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String string) {
        this.filename = string;
    }

    @Deprecated
    public void writeToDisk(String string) {
        boolean bl2 = true;
        this.writeToDisk(bl2, string);
    }

    public void writeToDisk(boolean bl2, String string) {
        this.writeToDisk(bl2, string, false);
    }

    private static String removeSlash(String string) {
        int n2 = string.lastIndexOf("\\");
        if (n2 != -1 && n2 == string.length() - 1) {
            string = string.substring(0, n2);
        }
        return string;
    }

    public static HashMap<String, String> readConfig(String string, String string2) {
        return ConfigFile.readConfig(new File(string + File.separator + string2));
    }

    public static HashMap<String, String> readConfig(String string) {
        return ConfigFile.readConfig(new File(string));
    }

    public static HashMap<String, String> readConfig(File file) {
        return ConfigFile.readConfig(file, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashMap<String, String> readConfig(File file, boolean bl2) {
        BufferedReader bufferedReader = null;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        try {
            String string;
            bufferedReader = new BufferedReader(new FileReader(file));
            String[] stringArray = null;
            String string2 = null;
            String string3 = null;
            while ((string = bufferedReader.readLine()) != null) {
                if (string.length() <= 0 || string.indexOf("#") == 0 || string.indexOf(":=") == -1) continue;
                stringArray = cn.a(string, " := ");
                string2 = stringArray[0];
                string3 = ConfigFile.removeSlash(stringArray[1]);
                if (ConfigLevelManager.a(file.getName(), string2).equals((Object)ConfigLevelManager.ConfigLevel.a) && !bl2) continue;
                if (string.length() > 0 && string.indexOf("#") != 0 && string.indexOf(":=") == -1) {
                    string3 = string3 + ConfigFile.removeSlash(string);
                }
                if (string.indexOf("\\") == string.length() - 1) continue;
                String string4 = string2.toUpperCase();
                hashMap.put(string4, string3);
            }
        }
        catch (Exception exception) {
            HashMap<String, String> hashMap2 = hashMap;
            return hashMap2;
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    return hashMap;
                }
            }
        }
        return hashMap;
    }

    private void readDefaultsFromDisk(String string) {
        HashMap<String, String> hashMap = ConfigFile.readConfig(new File(string, this.filename), true);
        for (String string2 : hashMap.keySet()) {
            if (ConfigLevelManager.a(this.filename, string2).equals((Object)ConfigLevelManager.ConfigLevel.a)) {
                this.options.put(string2, hashMap.get(string2));
                continue;
            }
            if (this.options.containsKey(string2)) continue;
            this.options.put(string2, hashMap.get(string2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToDisk(boolean bl2, String string, boolean bl3) {
        String string2;
        Object object;
        if (bl2) {
            object = ConfigFile.getSuffixFromCurrentMIMContext();
            string2 = this.filename.replaceFirst((String)object, "");
        } else {
            string2 = this.filename;
        }
        object = ConfigLevelManager.a();
        if (((ConfigLevelManager)object).b(string2, "*") == ConfigLevelManager.ConfigLevel.c) {
            return;
        }
        File file = new File(string, string2);
        HashMap<String, String> hashMap = ConfigFile.readConfig(file);
        if (hashMap != null) {
            for (Map.Entry<String, String> entry : hashMap.entrySet()) {
                if (this.options.containsKey(entry.getKey())) continue;
                this.options.put(entry.getKey(), (String)entry.getValue());
            }
        }
        this.readDefaultsFromDisk(string);
        Object object2 = null;
        try {
            object2 = new BufferedWriter(new FileWriter(file, bl3));
            for (String string3 : this.options.keySet()) {
                String string4 = this.options.get(string3);
                String string5 = string3 + " := " + string4;
                ((BufferedWriter)object2).write(string5, 0, string5.length());
                ((BufferedWriter)object2).newLine();
            }
        }
        catch (IOException iOException) {
            ay.d((Object)("Error writing config to file " + file), (Throwable)iOException, this);
        }
        finally {
            if (object2 != null) {
                try {
                    ((BufferedWriter)object2).flush();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                try {
                    ((BufferedWriter)object2).close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public String getOption(String string) {
        return this.options.get(string);
    }

    public HashMap<String, String> getOptions() {
        return this.options;
    }

    public void setOptions(HashMap<String, String> hashMap) {
        this.options = hashMap;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long l2) {
        this.id = l2;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("id", (Object)this.id).add("filename", (Object)this.filename).toString();
    }

    public static enum MIMTypeConfigSuffixesForPacs {
        a,
        b,
        c;


        public String a() {
            return this.toString();
        }
    }
}

