/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.user;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mimvista.user.ConfigFile;
import com.mimvista.util.ay;
import com.mimvista.util.cn;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.MapKey;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import sun.misc.BASE64Encoder;

@Entity
@Table(name="users")
public class User
implements Serializable {
    @Transient
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    private Long id;
    @Column(unique=true)
    private String login = "";
    private String fullname = "";
    private String title = "";
    private String department = "";
    private String supervisor = "";
    @Column(name="hashed_pass")
    private String hashedPass = "";
    @OneToMany(targetEntity=ConfigFile.class, cascade={CascadeType.REMOVE}, fetch=FetchType.EAGER, mappedBy="user")
    @MapKey(name="filename")
    private Map<String, ConfigFile> configFiles;
    private ArrayList<String> groups;
    private boolean admin = false;
    private String primaryGroup = "";

    public Long getId() {
        return this.id;
    }

    public void setId(Long l2) {
        this.id = l2;
    }

    public static User build(String string) {
        User user = new User();
        String[] stringArray = string.split(":", 7);
        if (!user.readValues(stringArray)) {
            return null;
        }
        return user;
    }

    public void assign(User user) {
        if (user == this) {
            return;
        }
        this.setAdmin(user.isAdmin());
        this.setId(user.getId());
        this.setDepartment(user.getDepartment());
        this.setFullname(user.getFullname());
        this.setSupervisor(user.getSupervisor());
        this.setTitle(user.getTitle());
        this.setGroups(user.getGroups());
        this.setPrimaryGroup(user.getPrimaryGroup());
        this.setHashedPass(user.getHashedPass());
        this.setLogin(user.getLogin());
        this.setConfigFiles(user.getConfigFiles());
    }

    public void assignWithoutKey(User user) {
        if (user == this) {
            return;
        }
        this.setAdmin(user.isAdmin());
        this.setDepartment(user.getDepartment());
        this.setFullname(user.getFullname());
        this.setSupervisor(user.getSupervisor());
        this.setTitle(user.getTitle());
        this.setGroups(user.getGroups());
        this.setPrimaryGroup(user.getPrimaryGroup());
        this.setHashedPass(user.getHashedPass());
    }

    private boolean readValues(String[] stringArray) {
        if (stringArray.length < 3) {
            System.out.println("Cannot read: length is " + stringArray.length + stringArray);
            return false;
        }
        if (stringArray.length >= 3) {
            this.setLogin(stringArray[0]);
            this.setHashedPass(stringArray[1]);
            this.setAdmin(stringArray[2].equals(User.hashPass(stringArray[0], "QQQRRXXXXVV")));
        }
        if (stringArray.length == 7) {
            this.setFullname(stringArray[3]);
            this.setTitle(stringArray[4]);
            this.setDepartment(stringArray[5]);
            this.setSupervisor(stringArray[6]);
        } else {
            this.setFullname("");
            this.setTitle("");
            this.setDepartment("");
            this.setSupervisor("");
        }
        return true;
    }

    public static String hashPass(String string, String string2) {
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("SHA");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
        try {
            messageDigest.update(string.getBytes("UTF-8"));
            messageDigest.update(string2.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
        byte[] byArray = messageDigest.digest();
        String string3 = new BASE64Encoder().encode(byArray);
        return string3;
    }

    public void setPassword(String string) {
        this.hashedPass = User.hashPass(this.login, string);
    }

    public boolean isPassword(String string) {
        return User.hashPass(this.login, string).equals(this.hashedPass);
    }

    public String getEntry() {
        return this.login + ":" + this.hashedPass + ":" + User.hashPass(this.login, this.admin ? "QQQRRXXXXVV" : "0") + ":" + this.fullname + ":" + this.title + ":" + this.department + ":" + this.supervisor;
    }

    public String getLogin() {
        return this.login;
    }

    public void setLogin(String string) {
        this.login = string;
    }

    public String getFullname() {
        return this.fullname;
    }

    public void setFullname(String string) {
        this.fullname = string;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public String getDepartment() {
        return this.department;
    }

    public void setDepartment(String string) {
        this.department = string;
    }

    public String getSupervisor() {
        return this.supervisor;
    }

    public void setSupervisor(String string) {
        this.supervisor = string;
    }

    public String getHashedPass() {
        return this.hashedPass;
    }

    public void setHashedPass(String string) {
        this.hashedPass = string;
    }

    public boolean isAdmin() {
        return this.admin;
    }

    public void setAdmin(boolean bl2) {
        this.admin = bl2;
    }

    public Map<String, ConfigFile> getConfigFiles() {
        return this.configFiles;
    }

    public ConfigFile getConfigFile(String string) {
        if (this.configFiles == null) {
            return null;
        }
        return this.configFiles.get(string);
    }

    public void setConfigFiles(Map<String, ConfigFile> map) {
        this.configFiles = map;
    }

    public ArrayList<String> getGroups() {
        return this.groups == null ? new ArrayList() : Lists.newArrayList(this.groups);
    }

    public void setGroups(List<String> list) {
        this.groups = Lists.newArrayList(list);
    }

    public void addGroup(String string) {
        this.groups.add(string);
    }

    public void removeGroup(String string) {
        this.groups.remove(string);
    }

    public int hashCode() {
        return this.login.hashCode();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        Map<String, ConfigFile> map = this.configFiles;
        if (map != null) {
            this.configFiles = Maps.newHashMap(map);
        }
        objectOutputStream.defaultWriteObject();
        this.configFiles = map;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        return object instanceof User && ((User)object).login.equals(this.login);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("id", (Object)this.id).add("login", (Object)this.login).add("primaryGroup", (Object)this.primaryGroup).add("#configFiles", this.configFiles == null ? 0 : this.configFiles.size()).toString();
    }

    public String getPrimaryGroup() {
        if (!cn.h(this.primaryGroup) && this.getGroups().contains(this.primaryGroup)) {
            return this.primaryGroup;
        }
        return this.groups == null || this.groups.isEmpty() ? "" : this.groups.get(0);
    }

    public void setPrimaryGroup(String string) {
        if (cn.g(string)) {
            ay.c((Object)"empty string group?", this);
            return;
        }
        if (!this.getGroups().contains(string)) {
            ay.c((Object)("trying to set primary group " + string + " but it looks like this user isn't a member of it"), this);
            return;
        }
        this.primaryGroup = string;
    }
}

