/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.user;

import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import com.mimvista.ExternallyVisible;
import com.mimvista.metabase.s;
import com.mimvista.user.Authenticator;
import com.mimvista.user.CookieBox;
import com.mimvista.user.LoginChecker;
import com.mimvista.user.User;
import com.mimvista.user.b;
import com.mimvista.util.ay;
import java.net.MalformedURLException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.ServerException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

@ExternallyVisible
public abstract class UserContainer {
    protected Map<String, User> a = new TreeMap<String, User>(String.CASE_INSENSITIVE_ORDER);
    protected HashSet<User> b = new HashSet();
    protected HashSet<User> c = new HashSet();
    protected HashSet<User> d = new HashSet();

    public static UserContainer createUserContainer() {
        b b2 = com.mimvista.user.b.a();
        if (b2.l()) {
            return new NetworkUserContainer();
        }
        return new LocalUserContainer();
    }

    public static UserContainer createLocalUserContainer() {
        return new LocalUserContainer();
    }

    public static UserContainer createNetworkUserContainer() {
        try {
            return UserContainer.createNetworkUserContainer(s.a());
        }
        catch (MalformedURLException | NotBoundException | RemoteException exception) {
            ay.d((Object)"Can't get authenticator for creating a network user container", (Throwable)exception, UserContainer.class);
            return null;
        }
    }

    public static UserContainer createNetworkUserContainer(Authenticator authenticator) {
        return new NetworkUserContainer(authenticator);
    }

    public boolean hasAdministrator() {
        return Iterables.any(this.a.values(), User::isAdmin);
    }

    public boolean isEmpty() {
        return this.a.isEmpty();
    }

    public User getUser(String string) {
        return this.a.get(string);
    }

    public boolean hasChanged() {
        return !this.b.isEmpty() || !this.c.isEmpty() || !this.d.isEmpty();
    }

    public List<User> getUsers() {
        return Ordering.natural().onResultOf(User::getLogin).sortedCopy(this.a.values());
    }

    public boolean isAdmin(String string) {
        User user = this.getUser(string);
        return user != null && user.isAdmin();
    }

    public void add(User user) {
        this.d.remove(user);
        this.b.add(user);
        this.a.put(user.getLogin(), user);
    }

    public void remove(String string) {
        User user = this.a.get(string);
        if (user != null) {
            this.d.remove(user);
            this.b.remove(user);
            this.a.remove(string);
            if (user.getId() != null) {
                this.c.add(user);
            }
        }
    }

    public void modify(User user) {
        User user2 = this.a.get(user.getLogin());
        if (user2 != null) {
            user2.assign(user);
            this.b.remove(user2);
            this.c.remove(user2);
            this.d.add(user2);
        }
    }

    public void changePassword(String string, String string2) {
        User user = this.a.get(string);
        if (user != null) {
            user.setPassword(string2);
            this.modify(user);
        }
    }

    public boolean isNetworkUserContainer() {
        return this instanceof NetworkUserContainer;
    }

    public abstract boolean flushUserDB();

    public abstract boolean canChangePassword();

    protected abstract void reload();

    protected void a() {
        this.b.clear();
        this.c.clear();
        this.d.clear();
    }

    private static class NetworkUserContainer
    extends UserContainer {
        private Authenticator e;

        public NetworkUserContainer(Authenticator authenticator) {
            this.e = authenticator;
            this.reload();
        }

        public NetworkUserContainer() {
            this(com.mimvista.user.b.a().i());
        }

        @Override
        public boolean flushUserDB() {
            HashMap<String, User> hashMap = new HashMap<String, User>();
            for (User user : this.b) {
                hashMap.put(user.getLogin(), user);
            }
            for (User user : this.c) {
                if (user.getId() == null || user.getId() <= 0L) continue;
                user.setId(-user.getId().longValue());
                hashMap.put(user.getLogin(), user);
            }
            for (User user : this.d) {
                hashMap.put(user.getLogin(), user);
            }
            try {
                if (this.e.saveUserDB(hashMap, LoginChecker.getInstance().currentCookieBox())) {
                    this.reload();
                    return true;
                }
                ay.a((Object)"UserDB could not be saved", this);
            }
            catch (RemoteException remoteException) {
                ay.d((Object)"UserDB could not be saved", (Throwable)remoteException, this);
            }
            return false;
        }

        @Override
        public void reload() {
            HashMap<String, User> hashMap = null;
            CookieBox cookieBox = LoginChecker.getInstance().currentCookieBox();
            try {
                hashMap = this.e.getUserDB(cookieBox);
            }
            catch (ServerException serverException) {
                try {
                    hashMap = this.e.getUsers(cookieBox);
                }
                catch (RemoteException remoteException) {
                    ay.d((Object)"Failed to reload users from authorization server", (Throwable)remoteException, this);
                }
            }
            catch (RemoteException remoteException) {
                ay.d((Object)"Failed to reload users from authorization server", (Throwable)remoteException, this);
            }
            if (hashMap != null) {
                this.a.clear();
                this.a.putAll(hashMap);
                this.a();
            }
        }

        @Override
        public boolean canChangePassword() {
            if (this.e == null || LoginChecker.getInstance().isNetworkAuthFailed()) {
                return false;
            }
            try {
                return this.e.canChangePassword();
            }
            catch (Exception exception) {
                ay.d((Object)"Access authorization server failed", (Throwable)exception, this);
                return false;
            }
        }
    }

    private static class LocalUserContainer
    extends UserContainer {
        public LocalUserContainer() {
            this.reload();
        }

        @Override
        public boolean flushUserDB() {
            boolean bl2 = com.mimvista.user.b.a(this.a);
            if (bl2) {
                this.a();
            }
            return bl2;
        }

        @Override
        public void reload() {
            this.a.clear();
            this.a.putAll(com.mimvista.user.b.b());
            this.a();
        }

        @Override
        public boolean canChangePassword() {
            return true;
        }

        @Override
        public boolean isNetworkUserContainer() {
            return false;
        }
    }
}

