/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.user.ldap;

import com.google.common.base.Preconditions;
import com.mimvista.archive.remote.MIMpacsConfig;
import com.mimvista.preferencesNew.MIMpacsGroupPrefs;
import com.mimvista.preferencesNew.MimpacsPrefs;
import com.mimvista.properties.services.a;
import com.mimvista.user.AbstractExternalAuthAuthorizationService;
import com.mimvista.user.AuthenticationType;
import com.mimvista.user.CookieBox;
import com.mimvista.user.c;
import com.mimvista.user.h;
import com.mimvista.user.ldap.b;
import com.mimvista.util.ay;
import com.mimvista.util.cn;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.naming.CommunicationException;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;

public class LdapAuthorizationService
extends AbstractExternalAuthAuthorizationService {
    private b a;

    public LdapAuthorizationService(boolean bl2, c c2, b b2) {
        super(bl2, c2);
        this.a = (b)Preconditions.checkNotNull((Object)b2);
    }

    @Override
    protected AuthenticationType a() {
        return AuthenticationType.b;
    }

    @Override
    public void reloadConfiguration() {
        String string;
        super.reloadConfiguration();
        String string2 = null;
        if (this.a != null) {
            string2 = this.a.a();
        }
        if (string2 != (string = MimpacsPrefs.ldapProviderId.getValue())) {
            this.a = com.mimvista.user.ldap.c.a(string);
            if (this.a == null) {
                ay.c((Object)("Couldn't find an LDAP provider with id: " + string + " -- we'll have to fallback to old-style LDAP methods"), this);
            }
        }
    }

    private String f() {
        String string = MimpacsPrefs.ldapServerAddress.getValue();
        int n2 = MimpacsPrefs.ldapServerPort.getValue();
        return com.mimvista.user.h.a(string, n2, null);
    }

    private DirContext a(String string, String string2, String string3) {
        try {
            DirContext dirContext = com.mimvista.user.h.a(string2, string3, string);
            ay.b((Object)("LDAP_AUTH: Authentication succeeded for user " + string2 + " from host " + string), this);
            return dirContext;
        }
        catch (CommunicationException communicationException) {
            ay.d((Object)("LDAP_AUTH: Failed to connect to LDAP server: " + string + " - " + communicationException.getMessage()), this);
        }
        catch (NamingException namingException) {
            ay.d((Object)("LDAP_AUTH: Authentication failed for user: " + string2 + " - " + namingException.getMessage()), this);
        }
        return null;
    }

    @Override
    protected synchronized CookieBox a(String string, String string2) {
        int n2;
        if (cn.h(string2)) {
            ay.c((Object)("LDAP_AUTH: Blank passwords are not allowed, rejecting authentication attempt for user: " + string + "@" + this.d()), this);
            return null;
        }
        String string3 = MimpacsPrefs.ldapServerAddress.getValue();
        String string4 = com.mimvista.user.h.a(string3, n2 = MimpacsPrefs.ldapServerPort.getValue().intValue(), null);
        CookieBox cookieBox = this.b(string4, string, string2);
        if (cookieBox == null && !cn.h(MimpacsPrefs.ldapBackupServerAddress.getValue())) {
            string3 = MimpacsPrefs.ldapBackupServerAddress.getValue();
            Integer n3 = MimpacsPrefs.ldapBackupServerPort.getValue();
            if (n3 != null) {
                n2 = n3;
            }
            string4 = com.mimvista.user.h.a(string3, n2, null);
            cookieBox = this.b(string4, string, string2);
        }
        return cookieBox;
    }

    private synchronized CookieBox b(String string2, String string3, String string4) {
        List<String> list;
        Object object;
        String string5 = null;
        Context context = null;
        DirContext dirContext = null;
        Object object2 = MimpacsPrefs.ldapPrincipalFormat.getValue();
        int n2 = ((String[])object2).length;
        for (int i2 = 0; i2 < n2 && (context = this.a(string2, string5 = ((String)(object = object2[i2])).replaceAll(com.mimvista.properties.services.a.x, string3), string4)) == null; ++i2) {
        }
        if (context == null) {
            return null;
        }
        if (MIMpacsConfig.p()) {
            object2 = MimpacsPrefs.ldapServiceAccountName.getValue();
            String string6 = MimpacsPrefs.ldapServiceAccountPassword.getValue();
            if (object2 != null && string6 != null) {
                String string7;
                String string8;
                String[] stringArray = MimpacsPrefs.ldapPrincipalFormat.getValue();
                int n3 = stringArray.length;
                for (int i3 = 0; i3 < n3 && (dirContext = this.a(string2, string8 = (string7 = stringArray[i3]).replaceAll(com.mimvista.properties.services.a.x, (String)object2), string6)) == null; ++i3) {
                }
            }
        }
        object2 = context;
        if (dirContext != null) {
            try {
                context.close();
            }
            catch (NamingException namingException) {
                // empty catch block
            }
            context = null;
            object2 = dirContext;
        }
        if ((list = this.a.a((DirContext)object2, string3, string5)) == null) {
            ay.b((Object)("Group search failed for user: " + string5 + " @ " + this.d()), this);
            return null;
        }
        Map<String, MIMpacsGroupPrefs.a> map = com.mimvista.user.h.a();
        object = list.stream().map(string -> (MIMpacsGroupPrefs.a)map.get(string.toLowerCase())).filter(Objects::nonNull).collect(Collectors.toList());
        List<String> list2 = object.stream().map(MIMpacsGroupPrefs.a::getMimpacsGroupName).collect(Collectors.toList());
        boolean bl2 = object.stream().anyMatch(MIMpacsGroupPrefs.a::isAdministratorGroup);
        return this.a(string3, string4, list2, bl2);
    }

    @Override
    public Collection<String> getAllMembersOfGroup(CookieBox cookieBox, String string) throws RemoteException, IllegalAccessException, NamingException {
        List list;
        if (cookieBox == null || !cookieBox.b()) {
            throw new IllegalAccessException("user is not authenticated");
        }
        DirContext dirContext = null;
        if (MIMpacsConfig.p()) {
            list = MimpacsPrefs.ldapServiceAccountName.getValue();
            String string2 = MimpacsPrefs.ldapServiceAccountPassword.getValue();
            if (list != null && string2 != null) {
                for (String string3 : MimpacsPrefs.ldapPrincipalFormat.getValue()) {
                    String string4 = string3.replaceAll(com.mimvista.properties.services.a.x, (String)((Object)list));
                    dirContext = this.a(this.f(), string4, string2);
                    if (dirContext == null) {
                        continue;
                    }
                    break;
                }
            }
        } else {
            dirContext = com.mimvista.user.h.a(this.f());
        }
        if ((list = this.a.a(dirContext, string)) == null) {
            ay.d((Object)("Unable to determine which users are in group: " + string + " - the group may not exist"), this);
            list = Collections.emptyList();
        }
        return list;
    }

    @Override
    public boolean testAuthentication(String string, String string2) {
        return this.a(this.f(), string, string2) != null;
    }

    @Override
    public String getConfigurationString() {
        StringBuilder stringBuilder = new StringBuilder(512);
        String string = "\n   ";
        stringBuilder.append(this.getClass().getSimpleName());
        stringBuilder.append(string).append("AuthType: ").append(this.a());
        stringBuilder.append(string).append("LDAP Server: ").append(MimpacsPrefs.ldapServerAddress.getValue());
        stringBuilder.append(string).append("LDAP Server Port: ").append(MimpacsPrefs.ldapServerPort.getValue());
        stringBuilder.append(string).append("Use SSL/TLS: ").append(MimpacsPrefs.ldapUseSsl.getValue() != false ? "YES" : "NO");
        if (this.a != null) {
            stringBuilder.append(string).append("LDAP Provider: ").append(this.a.b());
        } else {
            stringBuilder.append(string).append("LDAP Provider: NONE SELECTED (using backwards compatible default)");
        }
        if (MIMpacsConfig.p()) {
            stringBuilder.append(string).append("LDAP Service Account Enabled: YES");
            stringBuilder.append(string).append("LDAP Service Account Name: ").append(AuthenticationType.b);
        } else {
            stringBuilder.append(string).append("LDAP Service Account Enabled: NO");
        }
        stringBuilder.append(string).append("Principal Name Formats: ").append(Arrays.asList((Object[])MimpacsPrefs.ldapPrincipalFormat.getValue()));
        stringBuilder.append(string).append("User Roots: ").append(Arrays.asList((Object[])MimpacsPrefs.ldapUserRoots.getValue()));
        stringBuilder.append(string).append("Group Roots: ").append(Arrays.asList((Object[])MimpacsPrefs.ldapGroupRoots.getValue()));
        return stringBuilder.toString();
    }
}

