/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.util;

import com.google.common.collect.Lists;
import com.mimvista.archive.Archiver;
import com.mimvista.archive.gui.LocalDestination;
import com.mimvista.archive.remote.SeriesQuery;
import com.mimvista.archive.remote.c.h;
import com.mimvista.archive.search.DicomSearchSource;
import com.mimvista.archive.search.LocalSearchSource;
import com.mimvista.archive.search.RemoteSearchSource;
import com.mimvista.archive.search.SearchSource;
import com.mimvista.archive.search.g;
import com.mimvista.dicom.DcmSeries;
import com.mimvista.dicom.SeriesParameters;
import com.mimvista.dicom.factories.DcmSeriesFactory;
import com.mimvista.dicom.read.DicomReader;
import com.mimvista.file.MIMFile;
import com.mimvista.preferencesNew.ArchivePrefs;
import com.mimvista.preferencesNew.DicomStorePrefs;
import com.mimvista.rmi.TransferDialog;
import com.mimvista.rmi.b;
import com.mimvista.swing.widgets.ProgressQueueNotification;
import com.mimvista.util.Messages;
import com.mimvista.util.ay;
import com.mimvista.util.progress.Progress;
import com.mimvista.util.progress.ProgressPanel;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import org.dcm4che2.data.DicomObject;

public class ChainSearcher {
    private SeriesParameters a = new SeriesParameters();
    private List<SearchSource> b;
    private List<DcmSeries> c;
    private static final long d = 15000L;

    public ChainSearcher() {
        this.b = new ArrayList<SearchSource>();
    }

    public ChainSearcher(int n2) {
        this.b = new ArrayList<SearchSource>(n2);
    }

    public ChainSearcher(List<SearchSource> list) {
        this.b = list;
    }

    public ChainSearcher(SearchSource[] searchSourceArray) {
        this.b = new ArrayList<SearchSource>(searchSourceArray.length);
        this.b.addAll(Arrays.asList(searchSourceArray));
    }

    public void a(SearchSource searchSource) {
        this.b.add(searchSource);
    }

    public void b(SearchSource searchSource) {
        this.b.remove(searchSource);
    }

    public void a(SeriesParameters seriesParameters) {
        if (seriesParameters.uidList != null) {
            this.a.uidList = seriesParameters.uidList;
        }
        if (seriesParameters.contentDate != null) {
            this.a.contentDate = seriesParameters.contentDate;
        }
        if (seriesParameters.studyDate != null) {
            this.a.studyDate = seriesParameters.studyDate;
        }
        if (seriesParameters.archivePath != null) {
            this.a.archivePath = seriesParameters.archivePath;
        }
        if (seriesParameters.name != null) {
            this.a.name = seriesParameters.name;
        }
        if (seriesParameters.modality != null) {
            this.a.modality = seriesParameters.modality;
        }
        if (seriesParameters.referencingFilePath != null) {
            this.a.referencingFilePath = seriesParameters.referencingFilePath;
        }
        if (seriesParameters.searchType != -1) {
            this.a.searchType = seriesParameters.searchType;
        }
    }

    public List<DcmSeries> a() {
        List<DcmSeries> list = null;
        for (SearchSource searchSource : this.b) {
            SeriesQuery seriesQuery = new SeriesQuery(searchSource, this.a);
            list = seriesQuery.search();
            if (list == null || list.size() <= 0) continue;
            list = this.a(list, searchSource, seriesQuery);
            break;
        }
        return list;
    }

    private List<DcmSeries> a(List<DcmSeries> list, SearchSource searchSource, SeriesQuery seriesQuery) {
        String string = ArchivePrefs.archivePath.getValue().getAbsolutePath();
        this.c = new ArrayList<DcmSeries>(list.size());
        if (searchSource instanceof LocalSearchSource) {
            if (!string.equals(((LocalSearchSource)searchSource).a())) {
                this.a(list, string);
            } else {
                this.c.addAll(list);
            }
        } else if (searchSource instanceof RemoteSearchSource) {
            this.a(list, (RemoteSearchSource)searchSource);
        } else if (searchSource instanceof DicomSearchSource) {
            this.a(list, seriesQuery);
            File file = (File)DicomStorePrefs.defaultAETitle.getPathPref().getValue();
            if (!new File(string).equals(file)) {
                Cloneable cloneable = new ArrayList<DcmSeries>(this.c);
                this.c.clear();
                this.a((List<DcmSeries>)((Object)cloneable), string);
            }
        }
        for (Cloneable cloneable : this.c) {
            cloneable.setSearchSource(g.d());
        }
        return this.c;
    }

    private void a(List<DcmSeries> list, RemoteSearchSource remoteSearchSource) {
        Messages messages = Messages.a("PatientList");
        String string = ArchivePrefs.archivePath.getValue().getAbsolutePath();
        String string2 = messages.getProperty("CHAIN_PRIMARY");
        for (DcmSeries dcmSeries : list) {
            a a2 = new a();
            int n2 = this.c.size() + 1;
            LocalDestination localDestination = new LocalDestination(string2 + " - " + string, string);
            h h2 = new h();
            h2.addObserver(a2);
            h2.a(localDestination, remoteSearchSource.y().h(), remoteSearchSource.y().k(), dcmSeries.getLocalDir());
            this.a(a2, n2);
            if (h2.getStatus() != Progress.Status.c || h2.a().isEmpty()) continue;
            for (File file : h2.a()) {
                DcmSeries dcmSeries2 = DcmSeriesFactory.getDcmSeriesFromArchiveDirectory(file.getAbsolutePath());
                dcmSeries2.setLocalDir(file.getAbsolutePath());
                this.c.add(dcmSeries2);
            }
        }
    }

    private void a(List<DcmSeries> list, SeriesQuery seriesQuery) {
        this.a(list);
        for (DcmSeries dcmSeries : list) {
            a a2 = new a();
            int n2 = this.c.size() + 1;
            seriesQuery.addObserver(a2);
            seriesQuery.observableDicomPull(Lists.newArrayList((Object[])new DcmSeries[]{dcmSeries}));
            this.a(a2, n2);
            seriesQuery.deleteObservers();
        }
    }

    private void a(List<DcmSeries> list) {
        try {
            TransferDialog transferDialog = TransferDialog.a();
            for (DcmSeries dcmSeries : list) {
                String string = dcmSeries.getSeriesInstanceUID();
                b b2 = this.a(string);
                transferDialog.a(b2);
            }
        }
        catch (RemoteException remoteException) {
            ay.d((Object)remoteException, this);
        }
    }

    private b a(final String string) {
        return new b(){

            @Override
            public void a(String string3) {
                File file = new File(string3);
                if (!file.isDirectory()) {
                    return;
                }
                DcmSeries dcmSeries = DcmSeriesFactory.getDcmSeriesFromArchiveDirectory(string3);
                dcmSeries.setLocalDir(string3);
                String string2 = dcmSeries.getSeriesInstanceUID();
                if (!string2.equals(string)) {
                    return;
                }
                try {
                    ChainSearcher.this.c.add(dcmSeries);
                    TransferDialog transferDialog = TransferDialog.a();
                    transferDialog.b(this);
                }
                catch (RemoteException remoteException) {
                    ay.d((Object)"TransferCallback could not get TransferDialog instance!", (Throwable)remoteException, this);
                }
                catch (Exception exception) {
                    ay.d((Object)"TransferCallback could not get TransferDialog instance!", (Throwable)exception, this);
                }
            }
        };
    }

    private void a(a a2, int n2) {
        long l2;
        long l3 = 0L;
        long l4 = l2 = Calendar.getInstance().getTimeInMillis();
        while (this.c.size() < n2 && l3 < 15000L && !a2.b()) {
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            l2 = Calendar.getInstance().getTimeInMillis();
            if (a2.a()) {
                l4 = l2;
            }
            l3 = l2 - l4;
        }
    }

    private void a(List<DcmSeries> list, String string) {
        if (string == null) {
            return;
        }
        try {
            final ProgressPanel progressPanel = new ProgressPanel();
            ProgressQueueNotification.a(progressPanel);
            final int n2 = list.size();
            int n3 = 1;
            for (DcmSeries dcmSeries : list) {
                final MIMFile mIMFile = new MIMFile(dcmSeries.getLocalDir());
                final long l2 = mIMFile.length();
                final int n4 = n3++;
                String string2 = this.b(dcmSeries.getLocalDir());
                String string3 = string2 + File.separator + mIMFile.getName();
                MIMFile mIMFile2 = new MIMFile(string, string3);
                Archiver.postSeriesArchived(mIMFile2);
                final MIMFile mIMFile3 = mIMFile2;
                final IOException[] iOExceptionArray = new IOException[1];
                Thread thread = new Thread(){

                    @Override
                    public void run() {
                        try {
                            MIMFile.a(mIMFile, mIMFile3, new MIMFile.a(){
                                long a = 0L;

                                @Override
                                public void a(int n2) {
                                    this.a += (long)n2;
                                    progressPanel.b((int)(this.a / l2));
                                }

                                @Override
                                public void a(String string) {
                                    progressPanel.b_("Copying file " + n4 + " of " + n2 + ": " + string);
                                }

                                @Override
                                public boolean a(Exception exception, MIMFile mIMFile, MIMFile mIMFile2) {
                                    return false;
                                }
                            });
                        }
                        catch (IOException iOException) {
                            iOExceptionArray[0] = iOException;
                        }
                        finally {
                            progressPanel.b();
                        }
                    }
                };
                thread.start();
                if (iOExceptionArray[0] != null) {
                    throw iOExceptionArray[0];
                }
                DcmSeries dcmSeries2 = DcmSeriesFactory.getDcmSeriesFromArchiveDirectory(mIMFile2.getAbsolutePath());
                dcmSeries2.setLocalDir(mIMFile2.getAbsolutePath());
                this.c.add(dcmSeries2);
            }
        }
        catch (IOException iOException) {
            ay.d((Object)"IOException while copying search results ", (Throwable)iOException, this);
        }
        catch (Exception exception) {
            ay.d((Object)"Exception while copying search results ", (Throwable)exception, this);
        }
    }

    private String b(String string) {
        File file;
        DicomObject dicomObject;
        String string2 = null;
        File file2 = new File(string);
        if (!file2.isDirectory()) {
            return string2;
        }
        File[] fileArray = file2.listFiles();
        if (fileArray.length < 1) {
            return string2;
        }
        int n2 = 0;
        while ((dicomObject = DicomReader.readFileIntoDicomObject(file = fileArray[n2])) == null && ++n2 < fileArray.length) {
        }
        if (dicomObject == null) {
            return string2;
        }
        String string3 = dicomObject.getString(524320);
        if (string3.length() < 6) {
            return string2;
        }
        String string4 = string3.substring(0, 4);
        String string5 = string3.substring(4, 6);
        string2 = string4 + "-" + string5 + "__Studies";
        return string2;
    }

    public static void main(String[] stringArray) {
        ArrayList<SearchSource> arrayList = new ArrayList<SearchSource>();
        arrayList.add(g.d());
        arrayList.add(g.e().get(1));
        SeriesParameters seriesParameters = new SeriesParameters();
        seriesParameters.name = "Sample^PETCT^ABDOMEN";
        seriesParameters.contentDate = "";
        seriesParameters.studyDate = "";
        seriesParameters.modality = "CT";
        seriesParameters.uidList = Lists.newArrayList((Object[])new String[]{"2.16.840.1.114362.1.3227061.391.134099124.579.1"});
        seriesParameters.searchType = 0;
        ChainSearcher chainSearcher = new ChainSearcher(arrayList);
        chainSearcher.a(seriesParameters);
        List<DcmSeries> list = chainSearcher.a();
        ay.e("CHAIN SEARCHER FINAL RESULTS (" + list.size() + "): ");
        for (DcmSeries dcmSeries : list) {
            ay.e("  " + dcmSeries.getLocalDir());
        }
        System.exit(0);
    }

    private class a
    implements Observer {
        boolean a = true;
        boolean b = false;

        private a() {
        }

        @Override
        public void update(Observable observable, Object object) {
            this.a = true;
            this.b = object != null && "canceled".equalsIgnoreCase((String)object);
        }

        public boolean a() {
            boolean bl2 = this.a;
            this.a = false;
            return bl2;
        }

        public boolean b() {
            return this.b;
        }
    }
}

