/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.util;

import com.google.common.base.Strings;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;

public class FixedWidthFormat
extends NumberFormat {
    private static final long serialVersionUID = 1L;
    final int digits;

    public FixedWidthFormat(int n2) {
        if (n2 < 2) {
            throw new IllegalArgumentException("Needs more digits");
        }
        this.digits = n2;
    }

    @Override
    public StringBuffer format(double d2, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        if (Double.isNaN(d2)) {
            return stringBuffer.append("N/A");
        }
        if (Double.isInfinite(d2)) {
            return stringBuffer.append(Double.toString(d2));
        }
        if (d2 == 0.0) {
            return stringBuffer.append("0");
        }
        int n2 = (int)Math.ceil(Math.log10(Math.abs(d2)));
        String string = "0." + Strings.repeat((String)"#", (int)(this.digits - 2)) + "E0";
        DecimalFormat decimalFormat = new DecimalFormat(string);
        String string2 = decimalFormat.format(d2);
        if (Math.abs(n2) > this.digits) {
            return stringBuffer.append(string2);
        }
        if (d2 == (double)((long)d2)) {
            return stringBuffer.append(Long.toString((long)d2));
        }
        String string3 = Strings.repeat((String)"#", (int)this.digits);
        string = n2 <= 0 ? "0." + Strings.repeat((String)"#", (int)(this.digits - 1)) : string3.substring(0, Math.abs(n2)) + "." + string3.substring(Math.abs(n2));
        DecimalFormat decimalFormat2 = new DecimalFormat(string);
        String string4 = decimalFormat2.format(d2);
        if (Double.parseDouble(string4) == 0.0) {
            return stringBuffer.append(string2);
        }
        double d3 = Math.abs(d2 - Double.parseDouble(string4));
        double d4 = Math.abs(d2 - Double.parseDouble(string2));
        if (d4 < d3) {
            return stringBuffer.append(string2);
        }
        return stringBuffer.append(string4);
    }

    @Override
    public StringBuffer format(long l2, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        return this.format((double)l2, stringBuffer, (FieldPosition)null);
    }

    @Override
    public Number parse(String string, ParsePosition parsePosition) {
        if ("N/A".equals(string)) {
            return Double.NaN;
        }
        if (parsePosition == null) {
            parsePosition = new ParsePosition(0);
        }
        return NumberFormat.getInstance().parse(string, parsePosition);
    }
}

