/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.util;

import com.mimvista.ExternallyVisible;
import com.mimvista.preferencesNew.DebugPrefs;
import com.mimvista.preferencesNew.LoggingPrefs;
import com.mimvista.util.logging.a.c;
import com.mimvista.util.logging.r;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.spi.Filter;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.ThrowableInformation;

@ExternallyVisible
public class MIMLog4JAppender
extends AppenderSkeleton {
    private String a = LoggingPrefs.defaultLogFile.getValue();
    private long b = LoggingPrefs.defaultLogsize.getValue().intValue();
    private int c = LoggingPrefs.defaultBackups.getValue();

    public static void activateAsLog4JAppender() {
        Properties properties = new Properties();
        properties.setProperty("log4j.rootCategory", "INFO, DEFAULT");
        properties.setProperty("log4j.appender.DEFAULT", MIMLog4JAppender.class.getCanonicalName().toString());
        properties.setProperty("log4j.appender.DEFAULT.File", "libs.log");
        PropertyConfigurator.configure((Properties)properties);
    }

    public MIMLog4JAppender() {
        if (DebugPrefs.disableDcm4che2Logging.getValue().booleanValue()) {
            this.addFilter(this.a("^org\\.dcm4che2\\."));
        }
        if (DebugPrefs.disableKeyczarLogging.getValue().booleanValue()) {
            this.addFilter(this.a("^org\\.keyczar\\."));
        }
    }

    private Filter a(String string) {
        final Pattern pattern = Pattern.compile(string);
        return new Filter(){

            public int decide(LoggingEvent loggingEvent) {
                StackTraceElement[] stackTraceElementArray;
                for (StackTraceElement stackTraceElement : stackTraceElementArray = new Throwable().getStackTrace()) {
                    if (!pattern.matcher(stackTraceElement.getClassName()).find()) continue;
                    return -1;
                }
                return 0;
            }
        };
    }

    public void activateOptions() {
    }

    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
    }

    public boolean requiresLayout() {
        return false;
    }

    protected void append(LoggingEvent loggingEvent) {
        String string = loggingEvent.getLoggerName();
        c c2 = r.a("libs.log", (int)this.b, this.c, string);
        Level level = loggingEvent.getLevel();
        Throwable throwable = null;
        ThrowableInformation throwableInformation = loggingEvent.getThrowableInformation();
        if (throwableInformation != null) {
            throwable = throwableInformation.getThrowable();
        }
        String string2 = "";
        string2 = loggingEvent.getMessage().toString();
        string2 = string2.replaceAll("[\n\r]++$", "");
        if (level == Level.ERROR || level == Level.FATAL) {
            c2.c(string2, throwable);
        } else if (level == Level.WARN) {
            c2.b(string2, throwable);
        } else if (level == Level.INFO) {
            c2.a((Object)string2, throwable);
        } else if (level == Level.DEBUG) {
            c2.d(string2, throwable);
        } else {
            c2.a((Object)string2, throwable);
        }
    }

    public void setFile(String string) {
        String string2;
        this.a = string2 = string.trim();
    }

    public String getFile() {
        return this.a;
    }

    public void setMaxBackupIndex(String string) {
        String string2 = string.trim();
        try {
            this.c = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void setMaxFileSize(String string) {
        String string2 = string.trim();
        try {
            this.b = Long.parseLong(string2);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public static void main(String ... stringArray) {
        PropertyConfigurator.configure((String)"config/mimvistalogging.conf");
        Logger logger = Logger.getLogger(MIMLog4JAppender.class);
        for (int i2 = 0; i2 < 100; ++i2) {
            logger.error((Object)("Start logging error ...  " + i2));
            logger.info((Object)("Start logging info ...  " + i2));
            try {
                Thread.sleep(10L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

