/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.util;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mimvista.util.json.b;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class MutableMapView<K, V>
implements Serializable,
Map<K, V> {
    private static final long serialVersionUID = 1L;
    private Map<K, V> parent;
    private Map<K, V> overlay;
    private Set<Object> removedKeys;
    private transient Map<K, V> a;

    public MutableMapView(Map<K, V> map) {
        this.parent = (Map)Preconditions.checkNotNull(map);
        Preconditions.checkArgument((boolean)(map instanceof Serializable), (Object)"The map that was passed in is not serializable");
        this.overlay = Maps.newHashMap();
        this.removedKeys = Sets.newHashSet();
        this.d();
    }

    private void d() {
        this.a = Maps.filterEntries(this.parent, (Predicate)new Predicate<Map.Entry<K, V>>(){

            public boolean a(Map.Entry<K, V> entry) {
                return !MutableMapView.this.removedKeys.contains(entry.getKey());
            }

            public /* synthetic */ boolean apply(Object object) {
                return this.a((Map.Entry)object);
            }
        });
    }

    public Map<K, V> a() {
        return this.parent;
    }

    @Override
    public int size() {
        return this.parent.size() + this.overlay.size() - Sets.intersection(this.overlay.keySet(), this.parent.keySet()).size() - Sets.intersection(this.removedKeys, this.parent.keySet()).size();
    }

    @Override
    public boolean isEmpty() {
        return this.overlay.isEmpty() && Sets.difference(this.parent.keySet(), this.removedKeys).isEmpty();
    }

    @Override
    public boolean containsKey(Object object) {
        return this.overlay.containsKey(object) || !this.removedKeys.contains(object) && this.parent.containsKey(object);
    }

    @Override
    public boolean containsValue(Object object) {
        return this.overlay.containsValue(object) || this.a.containsValue(object);
    }

    @Override
    public V get(Object object) {
        if (this.overlay.containsKey(object)) {
            return this.overlay.get(object);
        }
        return this.a.get(object);
    }

    @Override
    public V put(K k2, V v2) {
        if (this.removedKeys.contains(k2)) {
            this.removedKeys.remove(k2);
            this.overlay.put(k2, v2);
            return null;
        }
        if (this.overlay.containsKey(k2)) {
            return this.overlay.put(k2, v2);
        }
        V v3 = null;
        if (this.parent.containsKey(k2)) {
            v3 = this.parent.get(k2);
        }
        this.overlay.put(k2, v2);
        return v3;
    }

    @Override
    public V remove(Object object) {
        if (this.removedKeys.contains(object)) {
            return null;
        }
        if (this.overlay.containsKey(object)) {
            this.removedKeys.add(object);
            return this.overlay.remove(object);
        }
        if (this.parent.containsKey(object)) {
            V v2 = this.parent.get(object);
            this.removedKeys.add(object);
            return v2;
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        this.removedKeys.removeAll(map.keySet());
        this.overlay.putAll(map);
    }

    @Override
    public void clear() {
        this.c();
        this.removedKeys.addAll(this.parent.keySet());
    }

    public Map<K, V> b() {
        HashMap hashMap = Maps.newHashMap(this.a);
        hashMap.putAll(this.overlay);
        return hashMap;
    }

    public void c() {
        this.overlay.clear();
        this.removedKeys.clear();
    }

    public void a(Object object) {
        this.removedKeys.remove(object);
        this.overlay.remove(object);
    }

    @Override
    public Set<K> keySet() {
        return Sets.difference((Set)Sets.union(this.parent.keySet(), this.overlay.keySet()), this.removedKeys);
    }

    @Override
    public Collection<V> values() {
        return Lists.newArrayList((Iterable)Iterables.transform(this.entrySet(), (Function)new Function<Map.Entry<K, V>, V>(){

            public V a(Map.Entry<K, V> entry) {
                return entry.getValue();
            }

            public /* synthetic */ Object apply(Object object) {
                return this.a((Map.Entry)object);
            }
        }));
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new a();
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).addValue((Object)b.a(this)).toString();
    }

    public static <K, V> MutableMapView<K, V> a(Map<K, V> map) {
        return new MutableMapView<K, V>(map);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.d();
    }

    private final class a
    extends AbstractSet<Map.Entry<K, V>> {
        private a() {
        }

        @Override
        public int size() {
            return MutableMapView.this.size();
        }

        @Override
        public boolean isEmpty() {
            return MutableMapView.this.isEmpty();
        }

        @Override
        public boolean contains(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return MutableMapView.this.containsKey(entry.getKey()) && Objects.equal(MutableMapView.this.get(entry.getKey()), entry.getValue());
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return Iterators.transform(MutableMapView.this.keySet().iterator(), (Function)new Function<K, Map.Entry<K, V>>(){

                public Map.Entry<K, V> a(final K k2) {
                    return new Map.Entry<K, V>(){

                        @Override
                        public K getKey() {
                            return k2;
                        }

                        @Override
                        public V getValue() {
                            return MutableMapView.this.get(k2);
                        }

                        @Override
                        public V setValue(V v2) {
                            throw new UnsupportedOperationException();
                        }
                    };
                }

                public /* synthetic */ Object apply(Object object) {
                    return this.a(object);
                }
            });
        }

        public boolean a(Map.Entry<K, V> entry) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends Map.Entry<K, V>> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public /* synthetic */ boolean add(Object object) {
            return this.a((Map.Entry)object);
        }
    }
}

