/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.util;

import com.google.common.collect.Lists;
import com.mimvista.file.MIMFile;
import com.mimvista.file.PathUtils;
import com.mimvista.license.g;
import com.mimvista.osdep.GetOSPath;
import com.mimvista.preferencesNew.PerformanceMonitorPrefs;
import com.mimvista.util.DateUtils;
import com.mimvista.util.MIMContext;
import com.mimvista.util.MIMFormat;
import com.mimvista.util.Messages;
import com.mimvista.util.ay;
import com.mimvista.util.by;
import com.mimvista.util.cn;
import com.sun.management.OperatingSystemMXBean;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.io.Writer;
import java.lang.management.ManagementFactory;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class SystemPerformanceMonitor {
    private static final int a = PerformanceMonitorPrefs.intervalTime.getValue();
    private static final int b = PerformanceMonitorPrefs.effectiveSampleCount.getValue();
    private static final int c = PerformanceMonitorPrefs.freeMemoryMinPercent.getValue();
    private static final int d = PerformanceMonitorPrefs.pagesPerSecondThreshold.getValue();
    private static final float e = PerformanceMonitorPrefs.pagesOverLimitRatio.getValue().floatValue();
    private static final int f = 5;
    private static final int g = 10;
    private static final String h = "performance";
    private static final Messages i = Messages.a("Util");
    private static final File j = new File(PathUtils.getLogBasePath(), "performance");
    private static final DateFormat k = new SimpleDateFormat("yyyy_MM_dd");
    private c l;
    private OperatingSystemMXBean m;
    private final Map<DataType, List<Long>> n = new HashMap<DataType, List<Long>>();
    private ScheduledExecutorService o = Executors.newSingleThreadScheduledExecutor();
    private b p = null;
    private Runnable q = new Runnable(){

        @Override
        public void run() {
            try {
                SystemPerformanceMonitor.this.a(SystemPerformanceMonitor.this.e());
                if (PerformanceMonitorPrefs.recordDataOnly.getValue().booleanValue()) {
                    return;
                }
                boolean bl2 = SystemPerformanceMonitor.this.g();
                boolean bl3 = SystemPerformanceMonitor.this.h();
                if (bl2 && bl3) {
                    ay.c((Object)"Free memory is low and swapping is heavy", SystemPerformanceMonitor.class);
                } else if (bl2) {
                    ay.c((Object)"Swapping is heavy", SystemPerformanceMonitor.class);
                } else if (bl3) {
                    ay.c((Object)"Free memory is low", SystemPerformanceMonitor.class);
                }
                if (bl2 || bl3) {
                    SystemPerformanceMonitor.this.a(MIMFormat.a(i.b("SWAPPING_IS_HEAVY"), MIMContext.F()));
                }
            }
            catch (Throwable throwable) {
                ay.d((Object)"Unknown exception happened when monitoring system performance", throwable, SystemPerformanceMonitor.class);
                throw new RuntimeException(throwable);
            }
        }
    };

    public static String a() {
        return "performance/monitor.log";
    }

    private static c d() {
        if (GetOSPath.isWindows()) {
            return new e();
        }
        if (GetOSPath.isMacOs()) {
            return new a();
        }
        return null;
    }

    public SystemPerformanceMonitor(b b2) {
        this();
        this.p = b2;
    }

    public SystemPerformanceMonitor() {
        this.l = SystemPerformanceMonitor.d();
        this.m = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
    }

    private List<Long> e() {
        ArrayList arrayList = Lists.newArrayList();
        for (DataType dataType : DataType.values()) {
            long l2 = this.a(dataType);
            Long l3 = l2 >= 0L ? Long.valueOf(l2) : null;
            arrayList.add(l3);
            ArrayList arrayList2 = this.n.get((Object)dataType);
            if (arrayList2 == null) {
                arrayList2 = Lists.newArrayList();
                this.n.put(dataType, arrayList2);
            }
            arrayList2.add(l3);
            if (arrayList2.size() <= b) continue;
            arrayList2.remove(0);
        }
        return arrayList;
    }

    private long a(DataType dataType) {
        switch (dataType) {
            case a: {
                return this.m.getFreePhysicalMemorySize() / 0x100000L;
            }
            case b: {
                long l2 = this.m.getFreePhysicalMemorySize();
                long l3 = this.m.getTotalPhysicalMemorySize();
                return (long)((double)l2 / (double)l3 * 100.0);
            }
        }
        return this.l.a(dataType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(List<Long> list) {
        Date date = new Date(Calendar.getInstance().getTimeInMillis());
        File file = new File(j, k.format(date) + ".csv");
        if (file.exists() && !file.isFile()) {
            ay.d((Object)"Failed to create a csv file to record system performace", SystemPerformanceMonitor.class);
            return;
        }
        ArrayList arrayList = Lists.newArrayList();
        if (!file.exists()) {
            this.a(date);
            arrayList.add(this.f());
        }
        arrayList.add(this.a(date, list));
        a.a.a.a.b b2 = null;
        try {
            b2 = new a.a.a.a.b((Writer)new FileWriter(file, true), ',', '\"', MIMFile.a);
            b2.a(arrayList);
        }
        catch (IOException iOException) {
            ay.d((Object)"Failed to create a csv file to record system performace", (Throwable)iOException, SystemPerformanceMonitor.class);
        }
        finally {
            if (b2 != null) {
                try {
                    b2.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void a(Date date) {
        File[] fileArray = j.listFiles();
        if (fileArray == null) {
            return;
        }
        for (File file : fileArray) {
            String string;
            if (!file.isFile() || !(string = file.getName().toLowerCase()).endsWith(".csv")) continue;
            try {
                Date date2 = k.parse(string.substring(0, string.length() - ".csv".length()));
                Date date3 = DateUtils.f(date);
                if (date3.getTime() - date2.getTime() <= 604800000L) continue;
                if (file.delete()) {
                    ay.b((Object)("Removed the old log file of recording performance data: " + file.getAbsolutePath()), SystemPerformanceMonitor.class);
                    continue;
                }
                ay.c((Object)("Failed to remove the old log file of recording performance data: " + file.getAbsolutePath()), SystemPerformanceMonitor.class);
            }
            catch (ParseException parseException) {
                ay.c((Object)("There is a unknown file in directory of recording performance data: " + file.getAbsolutePath()), (Throwable)parseException, SystemPerformanceMonitor.class);
            }
        }
    }

    private String[] f() {
        ArrayList arrayList = Lists.newArrayList();
        arrayList.add("Time Point");
        for (DataType dataType : DataType.values()) {
            arrayList.add(dataType.toString());
        }
        return arrayList.toArray(new String[0]);
    }

    private String[] a(Date date, List<Long> list) {
        ArrayList arrayList = Lists.newArrayList();
        arrayList.add(new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").format(date));
        for (Long l2 : list) {
            if (l2 == null) {
                arrayList.add("N/A");
                continue;
            }
            arrayList.add(l2.toString());
        }
        return arrayList.toArray(new String[0]);
    }

    private boolean g() {
        return !this.a(DataType.c, d, true, e);
    }

    private boolean h() {
        return !this.a(DataType.b, c, false, 1.0f);
    }

    private boolean a(DataType dataType, long l2, boolean bl2, float f2) {
        List<Long> list = this.n.get((Object)dataType);
        if (list.size() < b) {
            return true;
        }
        int n2 = 0;
        for (Long l3 : list) {
            if (l3 == null) continue;
            if (bl2) {
                if (l3 <= l2) continue;
                ++n2;
                continue;
            }
            if (l3 >= l2) continue;
            ++n2;
        }
        return (float)b * f2 > (float)n2;
    }

    private void a(String string) {
        if (this.p != null) {
            this.p.a(string);
        }
    }

    private String i() {
        String string = i.b("SWAPPING_IS_HEAVY");
        List<d> list = this.j();
        if (!list.isEmpty()) {
            string = string + "Please check following processes:";
            string = string + "\n\n";
            for (d d2 : list) {
                string = string + d2.b + " (ID:" + d2.a + ")";
                string = string + "\n";
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<d> j() {
        ArrayList arrayList = Lists.newArrayList();
        if (!GetOSPath.isMacOs()) {
            return arrayList;
        }
        String[] stringArray = new String[]{"top", "-d", "-stats", "pid,command,pageins", "-l", "2"};
        BufferedReader bufferedReader = null;
        try {
            Process process = Runtime.getRuntime().exec(stringArray);
            String string = by.a(process);
            if (string == null) {
                ay.d((Object)("Failed to acquire the output of following command: \n" + cn.a(stringArray, " ")), SystemPerformanceMonitor.class);
                ArrayList arrayList2 = arrayList;
                return arrayList2;
            }
            bufferedReader = new BufferedReader(new StringReader(string));
            String string2 = null;
            boolean bl2 = false;
            while ((string2 = bufferedReader.readLine()) != null) {
                if (!string2.trim().matches("PID +COMMAND +PAGEINS")) continue;
                if (bl2) break;
                bl2 = true;
            }
            if (string2 == null) {
                ay.d((Object)"Failed to acquire value of pageins increment in last second", SystemPerformanceMonitor.class);
                ArrayList arrayList3 = arrayList;
                return arrayList3;
            }
            while ((string2 = bufferedReader.readLine()) != null) {
                String[] stringArray2 = string2.trim().split(" +");
                if (stringArray2.length != 3) continue;
                try {
                    int n2 = Integer.valueOf(stringArray2[2]);
                    if (n2 <= 10) continue;
                    arrayList.add(new d(Integer.valueOf(stringArray2[0]), stringArray2[1], n2));
                }
                catch (NumberFormatException numberFormatException) {
                    ay.d((Object)("Failed to acquire information for process " + stringArray2[1] + ", just skip it"), SystemPerformanceMonitor.class);
                }
            }
            Collections.sort(arrayList);
            while (arrayList.size() > 5) {
                arrayList.remove(arrayList.size() - 1);
            }
            return arrayList;
        }
        catch (IOException iOException) {
            ay.d((Object)"Failed to acquire value of pageins increment in last second", (Throwable)iOException, SystemPerformanceMonitor.class);
            return arrayList;
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void b() {
        if (this.l == null) {
            ay.d((Object)"Performance monitor doesn't support current os platform", SystemPerformanceMonitor.class);
            return;
        }
        if (!j.isDirectory() && !j.mkdirs()) {
            ay.d((Object)"Failed to start performance monitor because of failure in creating directory to record performance data", SystemPerformanceMonitor.class);
            return;
        }
        this.o.scheduleWithFixedDelay(this.q, a, a, TimeUnit.SECONDS);
    }

    public static void main(String[] stringArray) {
        new SystemPerformanceMonitor().b();
    }

    private static class d
    implements Comparable<d> {
        private int a;
        private String b;
        private int c;

        private d(int n2, String string, int n3) {
            this.a = n2;
            this.b = string;
            this.c = n3;
        }

        public int a(d d2) {
            return d2.c - this.c;
        }

        @Override
        public /* synthetic */ int compareTo(Object object) {
            return this.a((d)object);
        }
    }

    private static class a
    implements c {
        private a() {
        }

        @Override
        public long a(DataType dataType) {
            switch (dataType) {
                case c: {
                    return this.a();
                }
            }
            return -1L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private long a() {
            String[] stringArray = new String[]{"sar", "-gp", "1", "1"};
            BufferedReader bufferedReader = null;
            try {
                Long l2;
                Long l3;
                block45: {
                    Process process = Runtime.getRuntime().exec(stringArray);
                    String string = by.a(process);
                    if (string == null) {
                        ay.d((Object)("Failed to acquire the output of following command: \n" + cn.a(stringArray, " ")), SystemPerformanceMonitor.class);
                        long l4 = -1L;
                        return l4;
                    }
                    bufferedReader = new BufferedReader(new StringReader(string));
                    String string2 = null;
                    l3 = null;
                    l2 = null;
                    while ((string2 = bufferedReader.readLine()) != null) {
                        String[] stringArray2 = string2.trim().split(" +");
                        if (stringArray2 == null || stringArray2.length < 2 || !"Average:".equalsIgnoreCase(stringArray2[0])) continue;
                        int n2 = -1;
                        int n3 = -1;
                        for (int i2 = 1; i2 < stringArray2.length; ++i2) {
                            if ("pgout/s".equalsIgnoreCase(stringArray2[i2])) {
                                n3 = i2;
                                continue;
                            }
                            if (!"pgin/s".equalsIgnoreCase(stringArray2[i2])) continue;
                            n2 = i2;
                        }
                        if (n2 == -1 && n3 == -1) continue;
                        string2 = bufferedReader.readLine();
                        if (string2 == null) {
                            long l5 = -1L;
                            return l5;
                        }
                        stringArray2 = string2.trim().split(" +");
                        if (stringArray2 == null) {
                            long l6 = -1L;
                            return l6;
                        }
                        if (n2 != -1) {
                            if (stringArray2.length < n2 + 1) {
                                long l7 = -1L;
                                return l7;
                            }
                            l3 = (long)Double.parseDouble(stringArray2[n2]);
                        }
                        if (n3 != -1) {
                            if (stringArray2.length < n3 + 1) {
                                long l8 = -1L;
                                return l8;
                            }
                            l2 = (long)Double.parseDouble(stringArray2[n3]);
                        }
                        if (l3 == null || l2 == null) {
                            continue;
                        }
                        break block45;
                    }
                    return -1L;
                }
                long l9 = l3 + l2;
                return l9;
            }
            catch (IOException iOException) {
                ay.d((Object)("Failed to acquire valid counter for " + (Object)((Object)DataType.c)), (Throwable)iOException, SystemPerformanceMonitor.class);
                return -1L;
            }
            catch (NumberFormatException numberFormatException) {
                ay.d((Object)("Failed to acquire valid counter for " + (Object)((Object)DataType.c)), (Throwable)numberFormatException, SystemPerformanceMonitor.class);
                return -1L;
            }
            finally {
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    private static class e
    implements c {
        private Map<DataType, Boolean> a = new HashMap<DataType, Boolean>();

        private e() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public long a(DataType dataType) {
            if (!this.b(dataType)) {
                return -1L;
            }
            String[] stringArray = new String[]{"typeperf", "\"" + dataType.a() + "\"", "-si", "1", "-sc", "1"};
            a.a.a.a.a a2 = null;
            try {
                Process process = Runtime.getRuntime().exec(stringArray);
                String string = by.a(process);
                if (string == null) {
                    ay.d((Object)("Failed to acquire the output of following command: \n" + cn.a(stringArray, " ")), SystemPerformanceMonitor.class);
                    long l2 = -1L;
                    return l2;
                }
                a2 = new a.a.a.a.a(new StringReader(string));
                String[] stringArray2 = null;
                block24: while ((stringArray2 = a2.b()) != null) {
                    for (String string2 : stringArray2) {
                        if (string2.toUpperCase().contains(dataType.a().toUpperCase())) break block24;
                    }
                }
                if (stringArray2 == null) {
                    ay.d((Object)("Failed to acquire the counter value from following output: \n" + string), SystemPerformanceMonitor.class);
                    long l3 = -1L;
                    return l3;
                }
                while ((stringArray2 = a2.b()) != null && stringArray2.length != 2) {
                }
                if (stringArray2 == null) {
                    ay.d((Object)("Failed to acquire the counter value from following output: \n" + string), SystemPerformanceMonitor.class);
                    long l4 = -1L;
                    return l4;
                }
                long l5 = (long)Double.parseDouble(stringArray2[1]);
                return l5;
            }
            catch (IOException iOException) {
                ay.d((Object)("Failed to acquire valid counter on Windows for " + (Object)((Object)dataType)), (Throwable)iOException, SystemPerformanceMonitor.class);
                return -1L;
            }
            catch (NumberFormatException numberFormatException) {
                ay.d((Object)("Failed to acquire valid counter on Windows for " + (Object)((Object)dataType)), (Throwable)numberFormatException, SystemPerformanceMonitor.class);
                return -1L;
            }
            finally {
                if (a2 != null) {
                    try {
                        a2.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }

        private boolean b(DataType dataType) {
            String string = dataType.a();
            if (string == null) {
                ay.d((Object)("No counter for performance data  " + (Object)((Object)dataType) + " on Windows"), SystemPerformanceMonitor.class);
                return false;
            }
            if (this.a.get((Object)dataType) != null) {
                return this.a.get((Object)dataType);
            }
            String[] stringArray = new String[]{"typeperf", "-q", "\"" + string + "\""};
            try {
                Process process = Runtime.getRuntime().exec(stringArray);
                String string2 = by.a(process);
                if (string2 == null) {
                    ay.d((Object)("Failed to check the availability of counter on Windows for " + string + " via command " + cn.a(stringArray, " ")), SystemPerformanceMonitor.class);
                    return false;
                }
                string2 = string2.replace("\r\n", "\n");
                if (!com.mimvista.license.g.a()) {
                    ay.b((Object)("Output for command " + cn.a(stringArray, " ") + " is: \n" + string2), SystemPerformanceMonitor.class);
                }
                this.a.put(dataType, string2.contains(string));
                if (!this.a.get((Object)dataType).booleanValue()) {
                    ay.d((Object)("No available counter  " + string + " on Windows, don't sample this data any more"), SystemPerformanceMonitor.class);
                }
                return this.a.get((Object)dataType);
            }
            catch (IOException iOException) {
                ay.d((Object)("Failed to check the availability of counter on Windows for " + string), (Throwable)iOException, SystemPerformanceMonitor.class);
                return false;
            }
        }
    }

    private static interface c {
        public long a(DataType var1);
    }

    private static enum DataType {
        a("Free Physical Memory", "MB"),
        b("Free Physical Memory Percentage"),
        c("Pages In and Out", "/sec", "\\Memory\\Pages/sec");

        private String name;
        private String unit;
        private String counterPathForWindows;

        private DataType(String string2) {
            this(string2, null);
        }

        private DataType(String string2, String string3) {
            this(string2, string3, null);
        }

        private DataType(String string2, String string3, String string4) {
            this.name = string2;
            this.unit = string3;
            this.counterPathForWindows = string4;
        }

        public String toString() {
            return this.unit != null ? this.name + " (" + this.unit + ")" : this.name;
        }

        public String a() {
            return this.counterPathForWindows;
        }
    }

    public static interface b {
        public void a(String var1);
    }
}

