/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.util.extents;

import com.google.common.collect.Lists;
import com.mimvista.internals.ImageFrame;
import com.mimvista.internals.SimpleImageFrame;
import com.mimvista.internals.s;
import com.mimvista.mui.PresentationType;
import com.mimvista.numerics.MetricPoint3f;
import com.mimvista.numerics.Point3f;
import com.mimvista.numerics.VoxelIndexPoint3f;
import com.mimvista.numerics.VoxelIndexPoint3i;
import com.mimvista.numerics.VoxelPoint3f;
import com.mimvista.numerics.VoxelViewingPoint3f;
import com.mimvista.numerics.bk;
import com.mimvista.numerics.bm;
import com.mimvista.state.ReadHelper;
import com.mimvista.util.Pair;
import java.awt.Point;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;

public class VolumeExtent
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int xStart;
    private int xEnd;
    private int yStart;
    private int yEnd;
    private int zStart;
    private int zEnd;
    private int frameIndex;

    public static VolumeExtent a(s s2) {
        Pair<VoxelIndexPoint3i, VoxelIndexPoint3i> pair = VolumeExtent.b(s2);
        VoxelIndexPoint3i voxelIndexPoint3i = (VoxelIndexPoint3i)((Object)pair.x);
        VoxelIndexPoint3i voxelIndexPoint3i2 = (VoxelIndexPoint3i)((Object)pair.y);
        return new VolumeExtent(s2.cw().a(), voxelIndexPoint3i.x, voxelIndexPoint3i2.x, voxelIndexPoint3i.y, voxelIndexPoint3i2.y, voxelIndexPoint3i.z, voxelIndexPoint3i2.z, s2.cl());
    }

    public static VolumeExtent a(ImageFrame imageFrame, ImageFrame imageFrame2, Matrix4f matrix4f) {
        Pair<VoxelIndexPoint3i, VoxelIndexPoint3i> pair = VolumeExtent.b(imageFrame, imageFrame2, matrix4f);
        VoxelIndexPoint3i voxelIndexPoint3i = (VoxelIndexPoint3i)((Object)pair.x);
        VoxelIndexPoint3i voxelIndexPoint3i2 = (VoxelIndexPoint3i)((Object)pair.y);
        return new VolumeExtent(imageFrame.a(), voxelIndexPoint3i.x, voxelIndexPoint3i2.x, voxelIndexPoint3i.y, voxelIndexPoint3i2.y, voxelIndexPoint3i.z, voxelIndexPoint3i2.z, 0);
    }

    public static Pair<VoxelIndexPoint3i, VoxelIndexPoint3i> b(s s2) {
        return VolumeExtent.b(s2.cw(), s2.C(), s2.M());
    }

    public static Pair<VoxelIndexPoint3i, VoxelIndexPoint3i> b(ImageFrame imageFrame, ImageFrame imageFrame2, Matrix4f matrix4f) {
        int n2;
        int[] nArray = imageFrame2.a();
        VoxelPoint3f[] voxelPoint3fArray = new VoxelPoint3f[8];
        for (int i2 = 0; i2 < 8; ++i2) {
            n2 = i2 / 4 == 0 ? 0 : nArray[2];
            int n3 = i2 / 2 % 2 == 0 ? 0 : nArray[1];
            int n4 = i2 % 2 == 0 ? 0 : nArray[0];
            voxelPoint3fArray[i2] = new VoxelPoint3f((float)n4, (float)n3, (float)n2, imageFrame2);
        }
        VoxelPoint3f[] voxelPoint3fArray2 = new VoxelPoint3f[8];
        for (n2 = 0; n2 < 8; ++n2) {
            MetricPoint3f metricPoint3f = new MetricPoint3f(imageFrame);
            matrix4f.transform((Point3f)voxelPoint3fArray[n2].b(), (Point3f)metricPoint3f);
            voxelPoint3fArray2[n2] = metricPoint3f.b();
        }
        float f2 = Float.POSITIVE_INFINITY;
        float f3 = Float.POSITIVE_INFINITY;
        float f4 = Float.POSITIVE_INFINITY;
        float f5 = Float.NEGATIVE_INFINITY;
        float f6 = Float.NEGATIVE_INFINITY;
        float f7 = Float.NEGATIVE_INFINITY;
        for (int i3 = 0; i3 < 8; ++i3) {
            if (voxelPoint3fArray2[i3].x < f2) {
                f2 = voxelPoint3fArray2[i3].x;
            }
            if (voxelPoint3fArray2[i3].y < f3) {
                f3 = voxelPoint3fArray2[i3].y;
            }
            if (voxelPoint3fArray2[i3].z < f4) {
                f4 = voxelPoint3fArray2[i3].z;
            }
            if (voxelPoint3fArray2[i3].x > f5) {
                f5 = voxelPoint3fArray2[i3].x;
            }
            if (voxelPoint3fArray2[i3].y > f6) {
                f6 = voxelPoint3fArray2[i3].y;
            }
            if (!(voxelPoint3fArray2[i3].z > f7)) continue;
            f7 = voxelPoint3fArray2[i3].z;
        }
        return Pair.get(new VoxelIndexPoint3i((int)Math.floor(f2), (int)Math.floor(f3), (int)Math.floor(f4), imageFrame), new VoxelIndexPoint3i((int)Math.floor(f5), (int)Math.floor(f6), (int)Math.floor(f7), imageFrame));
    }

    protected VolumeExtent(int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this.xStart = n2;
        this.xEnd = n3;
        this.yStart = n4;
        this.yEnd = n5;
        this.zStart = n6;
        this.zEnd = n7;
        this.frameIndex = n8;
    }

    public String toString() {
        return this.xStart + "-" + this.xEnd + ", " + this.yStart + "-" + this.yEnd + ", " + this.zStart + "-" + this.zEnd;
    }

    public VolumeExtent(VolumeExtent volumeExtent) {
        this(volumeExtent.xStart, volumeExtent.xEnd, volumeExtent.yStart, volumeExtent.yEnd, volumeExtent.zStart, volumeExtent.zEnd, volumeExtent.frameIndex);
    }

    public VolumeExtent(int[][] nArray, int n2) {
        this(nArray[0][0], nArray[1][0] - 1, nArray[0][1], nArray[1][1] - 1, nArray[0].length > 2 ? nArray[0][2] : 0, nArray[1].length > 2 ? nArray[1][2] - 1 : 0, n2);
    }

    public VolumeExtent(SimpleImageFrame simpleImageFrame) {
        this(0, simpleImageFrame.a()[0] - 1, 0, simpleImageFrame.a()[1] - 1, 0, simpleImageFrame.a()[2] - 1, simpleImageFrame.am_());
    }

    public VolumeExtent(int[] nArray, int n2) {
        this(0, nArray[0] - 1, 0, nArray[1] - 1, 0, nArray[2] - 1, n2);
    }

    public VolumeExtent(int[] nArray, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        int[] nArray2 = new int[]{n2, n3, n4, n5, n6, n7};
        this.a(nArray, nArray2);
        this.frameIndex = n8;
    }

    public VolumeExtent(int[] nArray, PresentationType presentationType, int[] nArray2, int n2) {
        int[] nArray3 = new int[]{0, nArray[0] - 1, 0, nArray[1] - 1, 0, nArray[2] - 1};
        nArray3[presentationType.a()[2] * 2] = nArray2[0];
        nArray3[presentationType.a()[2] * 2 + 1] = nArray2[1];
        this.a(nArray, nArray3);
        this.frameIndex = n2;
    }

    private void a(int[] nArray, int[] nArray2) {
        int n2;
        this.xStart = nArray2[0] < 0 ? 0 : (nArray2[0] >= nArray[0] ? nArray[0] - 1 : nArray2[0]);
        this.xEnd = nArray2[1] < 0 ? 0 : (nArray2[1] >= nArray[0] ? nArray[0] - 1 : nArray2[1]);
        if (this.xStart > this.xEnd) {
            n2 = this.xEnd;
            this.xEnd = this.xStart;
            this.xStart = n2;
        }
        this.yStart = nArray2[2] < 0 ? 0 : (nArray2[2] >= nArray[1] ? nArray[1] - 1 : nArray2[2]);
        this.yEnd = nArray2[3] < 0 ? 0 : (nArray2[3] >= nArray[1] ? nArray[1] - 1 : nArray2[3]);
        if (this.yStart > this.yEnd) {
            n2 = this.yEnd;
            this.yEnd = this.yStart;
            this.yStart = n2;
        }
        this.zStart = nArray2[4] < 0 ? 0 : (nArray2[4] >= nArray[2] ? nArray[2] - 1 : nArray2[4]);
        this.zEnd = nArray2[5] < 0 ? 0 : (nArray2[5] >= nArray[2] ? nArray[2] - 1 : nArray2[5]);
        if (this.zStart > this.zEnd) {
            n2 = this.zEnd;
            this.zEnd = this.zStart;
            this.zStart = n2;
        }
    }

    public int a() {
        return this.frameIndex;
    }

    public int b() {
        return this.xStart;
    }

    public void a(int n2) {
        this.xStart = n2;
    }

    public int c() {
        return this.xEnd;
    }

    public void b(int n2) {
        this.xEnd = n2;
    }

    public int d() {
        return this.yStart;
    }

    public void c(int n2) {
        this.yStart = n2;
    }

    public int e() {
        return this.yEnd;
    }

    public void d(int n2) {
        this.yEnd = n2;
    }

    public int f() {
        return this.zStart;
    }

    public void e(int n2) {
        this.zStart = n2;
    }

    public int g() {
        return this.zEnd;
    }

    public void f(int n2) {
        this.zEnd = n2;
    }

    public int h() {
        return this.xEnd - this.xStart + 1;
    }

    public int i() {
        return this.yEnd - this.yStart + 1;
    }

    public int j() {
        return this.zEnd - this.zStart + 1;
    }

    public int[] k() {
        return new int[]{this.h(), this.i(), this.j()};
    }

    public VoxelIndexPoint3f a(SimpleImageFrame simpleImageFrame) {
        return this.a(new Point3f.PointVolumeInfo(simpleImageFrame));
    }

    public VoxelIndexPoint3f a(Point3f.PointVolumeInfo pointVolumeInfo) {
        return new VoxelIndexPoint3f((float)(this.xStart + this.xEnd) / 2.0f, (float)(this.yStart + this.yEnd) / 2.0f, (float)(this.zEnd + this.zStart) / 2.0f, pointVolumeInfo);
    }

    public VoxelIndexPoint3f b(SimpleImageFrame simpleImageFrame) {
        return this.b(new Point3f.PointVolumeInfo(simpleImageFrame));
    }

    public VoxelIndexPoint3f b(Point3f.PointVolumeInfo pointVolumeInfo) {
        return new VoxelIndexPoint3f((float)this.xStart - 0.5f, (float)this.yStart - 0.5f, (float)this.zStart - 0.5f, pointVolumeInfo);
    }

    public VoxelIndexPoint3f c(SimpleImageFrame simpleImageFrame) {
        return this.c(new Point3f.PointVolumeInfo(simpleImageFrame));
    }

    public VoxelIndexPoint3f c(Point3f.PointVolumeInfo pointVolumeInfo) {
        return new VoxelIndexPoint3f((float)this.xEnd + 0.5f, (float)this.yEnd + 0.5f, (float)this.zEnd + 0.5f, pointVolumeInfo);
    }

    public bk d(SimpleImageFrame simpleImageFrame) {
        int[] nArray = this.k();
        VoxelViewingPoint3f voxelViewingPoint3f = new VoxelViewingPoint3f((float)this.xStart, (float)this.yStart, 0.0f, simpleImageFrame);
        bm bm2 = new bm(voxelViewingPoint3f, new Point(0, 0));
        VoxelViewingPoint3f voxelViewingPoint3f2 = new VoxelViewingPoint3f((float)this.xStart, (float)this.yEnd + 1.0f, 0.0f, simpleImageFrame);
        bm bm3 = new bm(voxelViewingPoint3f2, new Point(0, nArray[1]));
        VoxelViewingPoint3f voxelViewingPoint3f3 = new VoxelViewingPoint3f((float)this.xEnd + 1.0f, (float)this.yStart, 0.0f, simpleImageFrame);
        bm bm4 = new bm(voxelViewingPoint3f3, new Point(nArray[0], 0));
        VoxelViewingPoint3f voxelViewingPoint3f4 = new VoxelViewingPoint3f((float)this.xEnd + 1.0f, (float)this.yEnd + 1.0f, 0.0f, simpleImageFrame);
        bm bm5 = new bm(voxelViewingPoint3f4, new Point(nArray[0], nArray[1]));
        return new bk(bm2, bm3, bm4, bm5);
    }

    public List<VoxelPoint3f> e(SimpleImageFrame simpleImageFrame) {
        ArrayList arrayList = Lists.newArrayListWithCapacity((int)8);
        arrayList.add(new VoxelPoint3f((float)this.xStart, (float)this.yStart, (float)this.zStart, simpleImageFrame));
        arrayList.add(new VoxelPoint3f((float)(this.xEnd + 1), (float)this.yStart, (float)this.zStart, simpleImageFrame));
        arrayList.add(new VoxelPoint3f((float)(this.xEnd + 1), (float)(this.yEnd + 1), (float)this.zStart, simpleImageFrame));
        arrayList.add(new VoxelPoint3f((float)this.xStart, (float)(this.yEnd + 1), (float)this.zStart, simpleImageFrame));
        arrayList.add(new VoxelPoint3f((float)this.xStart, (float)this.yStart, (float)(this.zEnd + 1), simpleImageFrame));
        arrayList.add(new VoxelPoint3f((float)(this.xEnd + 1), (float)this.yStart, (float)(this.zEnd + 1), simpleImageFrame));
        arrayList.add(new VoxelPoint3f((float)(this.xEnd + 1), (float)(this.yEnd + 1), (float)(this.zEnd + 1), simpleImageFrame));
        arrayList.add(new VoxelPoint3f((float)this.xStart, (float)(this.yEnd + 1), (float)(this.zEnd + 1), simpleImageFrame));
        return arrayList;
    }

    public VolumeExtent l() {
        return new VolumeExtent(this.yStart, this.yEnd, this.zStart, this.zEnd, this.xStart, this.xEnd, this.frameIndex);
    }

    public VolumeExtent m() {
        return new VolumeExtent(this.xStart, this.xEnd, this.zStart, this.zEnd, this.yStart, this.yEnd, this.frameIndex);
    }

    public VolumeExtent a(PresentationType presentationType) {
        if (presentationType.k()) {
            return this.m();
        }
        if (presentationType.j()) {
            return this.l();
        }
        return this;
    }

    public int[] n() {
        return new int[]{this.xStart, this.xEnd, this.yStart, this.yEnd, this.zStart, this.zEnd};
    }

    public int[][] o() {
        return new int[][]{{this.xStart, this.yStart, this.zStart}, {this.xEnd + 1, this.yEnd + 1, this.zEnd + 1}};
    }

    public boolean a(VoxelIndexPoint3f voxelIndexPoint3f) {
        int n2 = Math.round(voxelIndexPoint3f.x);
        int n3 = Math.round(voxelIndexPoint3f.y);
        int n4 = Math.round(voxelIndexPoint3f.z);
        return n2 >= this.xStart && n2 <= this.xEnd && n3 >= this.yStart && n3 <= this.yEnd && n4 >= this.zStart && n4 <= this.zEnd;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        ReadHelper readHelper = new ReadHelper();
        readHelper.a("frameIndex", (Object)-1);
        readHelper.a(objectInputStream, (Object)this);
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + this.frameIndex;
        n3 = 31 * n3 + this.xEnd;
        n3 = 31 * n3 + this.xStart;
        n3 = 31 * n3 + this.yEnd;
        n3 = 31 * n3 + this.yStart;
        n3 = 31 * n3 + this.zEnd;
        n3 = 31 * n3 + this.zStart;
        return n3;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        VolumeExtent volumeExtent = (VolumeExtent)object;
        if (this.frameIndex != volumeExtent.frameIndex) {
            return false;
        }
        if (this.xEnd != volumeExtent.xEnd) {
            return false;
        }
        if (this.xStart != volumeExtent.xStart) {
            return false;
        }
        if (this.yEnd != volumeExtent.yEnd) {
            return false;
        }
        if (this.yStart != volumeExtent.yStart) {
            return false;
        }
        if (this.zEnd != volumeExtent.zEnd) {
            return false;
        }
        return this.zStart == volumeExtent.zStart;
    }
}

