/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.util.logview;

import com.mimvista.ExternallyVisible;
import com.mimvista.MimJsonSerializable;
import com.mimvista.d;
import com.mimvista.util.logging.MIMLogLevel;
import java.awt.Color;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;

@ExternallyVisible
@MimJsonSerializable
public class LogEntry
implements Comparable<LogEntry> {
    static final String DATE_PATTERN = "MMM dd, uuuu HH:mm:ss.SSS";
    static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ofPattern("MMM dd, uuuu HH:mm:ss.SSS");
    static final String ORIGINAL_DATE_PATTERN = "MMM-dd-uuuu HH:mm:ss.SSS";
    static final DateTimeFormatter ORIGINAL_DATE_FORMAT = DateTimeFormatter.ofPattern("MMM-dd-uuuu HH:mm:ss.SSS");
    static final byte[] EMPTY = new byte[0];
    protected LocalDateTime timestamp;
    protected MIMLogLevel level;
    protected byte[] category;
    protected byte[] build;
    protected byte[] message;
    private Color color;
    private boolean generatedTimestamp;

    public LogEntry(LocalDateTime localDateTime) {
        this(localDateTime, null);
    }

    public LogEntry(LocalDateTime localDateTime, @d String string) {
        this(localDateTime, null, null, null, string);
    }

    public LogEntry(LocalDateTime localDateTime, @d MIMLogLevel mIMLogLevel, @d String string, @d String string2, @d String string3) {
        this.timestamp = localDateTime;
        this.level = mIMLogLevel == null ? MIMLogLevel.e : mIMLogLevel;
        this.category = this.a(string);
        this.build = this.a(string2);
        this.message = this.a(string3);
        this.generatedTimestamp = false;
    }

    protected LogEntry(LogEntry logEntry) {
        this.timestamp = logEntry.timestamp;
        this.level = logEntry.level;
        this.category = logEntry.category;
        this.build = logEntry.build;
        this.message = logEntry.message;
        this.generatedTimestamp = logEntry.generatedTimestamp;
        this.color = logEntry.color;
    }

    public LocalDateTime getTimestamp() {
        return this.timestamp;
    }

    public String getFormattedTimestamp() {
        return this.timestamp.format(DATE_FORMAT);
    }

    public String getOriginalFormattedTimestamp() {
        return this.timestamp.format(ORIGINAL_DATE_FORMAT);
    }

    public MIMLogLevel getLogLevel() {
        return this.level;
    }

    public String getCategory() {
        return this.a(this.category);
    }

    public String getBuild() {
        return this.a(this.build);
    }

    public void setMessage(String string) {
        this.message = this.a(string);
    }

    public String getMessage() {
        return this.a(this.message);
    }

    public String getOriginalFormatString() {
        return this.getOriginalFormattedTimestamp() + "\t" + (Object)((Object)this.getLogLevel()) + "\t[" + this.getBuild() + "|" + this.getCategory() + "]\t" + this.getMessage();
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Color getColor() {
        return this.color;
    }

    public void setGeneratedTimestamp(boolean bl2) {
        this.generatedTimestamp = bl2;
    }

    public boolean isGeneratedTimestamp() {
        return this.generatedTimestamp;
    }

    public String toString() {
        return "[" + this.getFormattedTimestamp() + " : " + (Object)((Object)this.getLogLevel()) + " : " + this.getCategory() + " : " + this.getBuild() + " : " + this.getMessage() + "]";
    }

    @Override
    public int compareTo(LogEntry logEntry) {
        if (logEntry == null) {
            return -1;
        }
        return logEntry.timestamp.compareTo(this.timestamp);
    }

    private byte[] a(String string) {
        if (string == null) {
            return EMPTY;
        }
        return string.getBytes(StandardCharsets.UTF_8);
    }

    private String a(byte[] byArray) {
        return new String(byArray, StandardCharsets.UTF_8);
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + Arrays.hashCode(this.build);
        n3 = 31 * n3 + Arrays.hashCode(this.category);
        n3 = 31 * n3 + (this.color == null ? 0 : this.color.hashCode());
        n3 = 31 * n3 + (this.generatedTimestamp ? 1231 : 1237);
        n3 = 31 * n3 + (this.level == null ? 0 : this.level.hashCode());
        n3 = 31 * n3 + Arrays.hashCode(this.message);
        n3 = 31 * n3 + (this.timestamp == null ? 0 : this.timestamp.hashCode());
        return n3;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof LogEntry)) {
            return false;
        }
        LogEntry logEntry = (LogEntry)object;
        if (!Arrays.equals(this.build, logEntry.build)) {
            return false;
        }
        if (!Arrays.equals(this.category, logEntry.category)) {
            return false;
        }
        if (this.color == null ? logEntry.color != null : !this.color.equals(logEntry.color)) {
            return false;
        }
        if (this.generatedTimestamp != logEntry.generatedTimestamp) {
            return false;
        }
        if (this.level != logEntry.level) {
            return false;
        }
        if (!Arrays.equals(this.message, logEntry.message)) {
            return false;
        }
        return !(this.timestamp == null ? logEntry.timestamp != null : !this.timestamp.equals(logEntry.timestamp));
    }
}

