/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.util.logview;

import com.mimvista.gui.util.MIMSwingUtils;
import com.mimvista.util.Messages;
import com.mimvista.util.logging.MIMLogLevel;
import com.mimvista.util.logview.LogEntry;
import com.mimvista.util.logview.LogTableEntry;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.table.TableColumnExt;

public class LogTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private List<LogTableEntry> entries = Collections.synchronizedList(new ArrayList());

    @Override
    public int getRowCount() {
        return this.entries.size();
    }

    public void a() {
        MIMSwingUtils.b(() -> {
            this.entries.clear();
            this.fireTableDataChanged();
        });
    }

    public void a(List<LogTableEntry> list) {
        SwingUtilities.invokeLater(() -> {
            this.entries = list;
            this.fireTableDataChanged();
        });
    }

    public void a(LogTableEntry logTableEntry) {
        SwingUtilities.invokeLater(() -> {
            this.entries.add(logTableEntry);
            this.fireTableRowsInserted(this.entries.size() - 1, this.entries.size() - 1);
        });
    }

    public void b(LogTableEntry logTableEntry) {
        SwingUtilities.invokeLater(() -> this.entries.add(logTableEntry));
    }

    public void c(LogTableEntry logTableEntry) {
        SwingUtilities.invokeLater(() -> {
            this.entries.add(0, logTableEntry);
            this.fireTableRowsInserted(0, 0);
        });
    }

    public int a(int n2) {
        return this.d(n2).getPreferredHeight();
    }

    @Override
    public int getColumnCount() {
        return Column.values().length;
    }

    @Override
    public String getColumnName(int n2) {
        return Column.values()[n2].a();
    }

    @Override
    public Class<?> getColumnClass(int n2) {
        return Column.values()[n2].b();
    }

    public Object b(int n2) {
        return Column.values()[n2].c();
    }

    @Override
    public Object getValueAt(int n2, int n3) {
        switch (n3) {
            case 1: {
                return this.entries.get(n2).getBuild();
            }
            case 2: {
                return this.entries.get(n2).getFormattedTimestamp();
            }
            case 3: {
                return this.entries.get(n2).getLogLevel();
            }
            case 4: {
                return this.entries.get(n2).getCategory();
            }
            case 5: {
                return this.entries.get(n2).getMessage();
            }
        }
        return null;
    }

    public MIMLogLevel c(int n2) {
        return this.entries.get(n2).getLogLevel();
    }

    public LogTableEntry d(int n2) {
        if (n2 < 0) {
            return null;
        }
        return this.entries.get(n2);
    }

    public int a(LogEntry logEntry) {
        return this.a(Collections.binarySearch(this.entries, logEntry, new Comparator<LogEntry>(){

            public int a(LogEntry logEntry, LogEntry logEntry2) {
                return logEntry2.getTimestamp().compareTo(logEntry.getTimestamp());
            }

            @Override
            public /* synthetic */ int compare(Object object, Object object2) {
                return this.a((LogEntry)object, (LogEntry)object2);
            }
        }), logEntry);
    }

    private int a(int n2, LogEntry logEntry) {
        LogTableEntry logTableEntry;
        int n3;
        int n4 = n2;
        if (n4 < 0) {
            n4 = -(n4 + 1);
        } else if (this.entries.get(n2).equals(logEntry)) {
            return n2;
        }
        for (n3 = n4 - 1; n3 >= Math.max(0, n4 - 10); --n3) {
            logTableEntry = this.entries.get(n3);
            if (logTableEntry.equals(logEntry)) {
                return n3;
            }
            if (!logTableEntry.getTimestamp().equals(logEntry.getTimestamp())) break;
        }
        for (n3 = n4 + 1; n3 < Math.min(this.entries.size(), n4 + 11); ++n3) {
            logTableEntry = this.entries.get(n3);
            if (logTableEntry.equals(logEntry)) {
                return n3;
            }
            if (!logTableEntry.getTimestamp().equals(logEntry.getTimestamp())) break;
        }
        return n2;
    }

    static enum Column {
        a(null, Boolean.class, Messages.a("LogViewer", "FLAGS_COLUMN")),
        b(Messages.a("General", "BUILD_HEADING"), String.class, Messages.a("General", "BUILD_HEADING")),
        c(Messages.a("General", "DATE_TIME_HEADING"), LocalDateTime.class, Messages.a("General", "DATE_TIME_HEADING")),
        d(Messages.a("General", "LEVEL_HEADING"), MIMLogLevel.class, Messages.a("General", "LEVEL_HEADING")),
        e(Messages.a("General", "CATEGORY_HEADING"), String.class, Messages.a("General", "CATEGORY_HEADING")),
        f(Messages.a("General", "MESSAGE_HEADING"), JTextArea.class, Messages.a("General", "MESSAGE_HEADING"));

        private String name;
        private Class<?> colClass;
        private Object identifier;

        private Column(String string2, Class<?> clazz, Object object) {
            this.name = string2;
            this.colClass = clazz;
            this.identifier = object;
        }

        public String a() {
            return this.name;
        }

        public Class<?> b() {
            return this.colClass;
        }

        public Object c() {
            return this.identifier;
        }

        public TableColumnExt a(TableModel tableModel, JXTable jXTable) {
            for (int i2 = 0; i2 < tableModel.getColumnCount(); ++i2) {
                int n2 = jXTable.convertColumnIndexToView(i2);
                if (n2 == -1) continue;
                TableColumnExt tableColumnExt = jXTable.getColumnExt(n2);
                if (!this.c().equals(tableColumnExt.getIdentifier())) continue;
                return tableColumnExt;
            }
            return null;
        }
    }
}

