/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.util.logview;

import com.mimvista.gui.util.ImageManipulator;
import com.mimvista.gui.util.MIMSwingUtils;
import com.mimvista.numerics.helpers.FuncUtils;
import com.mimvista.proui.MIMLookAndFeel;
import com.mimvista.util.DateUtils;
import com.mimvista.util.Messages;
import com.mimvista.util.logging.MIMLogLevel;
import com.mimvista.util.logview.Bookmark;
import com.mimvista.util.logview.DeobfuscatedLogEntryWindow;
import com.mimvista.util.logview.LogEntry;
import com.mimvista.util.logview.LogTableEntry;
import com.mimvista.util.logview.LogTableModel;
import com.mimvista.util.logview.LogWindow;
import com.mimvista.util.logview.ResultsTab;
import com.mimvista.util.logview.c;
import com.mimvista.util.logview.deobfuscator.LogDeobfuscator;
import com.mimvista.util.logview.i;
import com.mimvista.util.work.m;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpinnerDateModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import org.jdesktop.swingx.JXDatePicker;
import org.jdesktop.swingx.decorator.ColorHighlighter;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.table.TableColumnExt;

class MIMResultsTab
extends ResultsTab {
    private static final long serialVersionUID = 1L;
    private JComboBox levelDropdown;
    private JPanel advancedOptions;
    private JComboBox<TimePeriod> timePeriod;
    private JButton reloadBookButton;
    private JButton clearButton;
    private JSpinner timeSpinner;
    private JButton deobTextButton;
    private JXDatePicker startDateSelector;
    private JXDatePicker endDateSelector;
    private LocalDateTime searchStart;
    private LocalDateTime searchEnd;
    private LocalDateTime customSearchStart;
    private LocalDateTime customSearchEnd;
    private Consumer<LogEntry> handler;
    private boolean isSynced;
    final Pattern exceptionPattern = Pattern.compile(Messages.a("LogViewer", "EXCEPTION_TEXT"), 2);
    private Color selectedErrorBackgroundColor;
    private Highlighter exceptionHighlighter;
    private Highlighter categorySearchMatchHighlighter;
    private ChangeListener spinnerListener;

    public MIMResultsTab(LogWindow logWindow, c c2) {
        super(logWindow, c2);
        this.timePeriod.setSelectedItem((Object)TimePeriod.c);
        this.isSynced = false;
        this.handler = logEntry -> {
            if (logEntry == null) {
                this.l();
            } else if (this.lastSearch.c((LogEntry)logEntry)) {
                this.timerStart = System.currentTimeMillis();
                SwingUtilities.invokeLater(() -> {
                    int n2 = this.u();
                    int n3 = this.v();
                    m.e.a(() -> {
                        LogTableEntry logTableEntry = this.a((LogEntry)logEntry, n2, n3);
                        SwingUtilities.invokeLater(() -> {
                            this.tableModel.c(logTableEntry);
                            this.d(false);
                        });
                    }, "Creating log table entry");
                });
            }
        };
        c2.a(this.handler);
    }

    @Override
    public JPanel a() {
        JPanel jPanel = super.a();
        JCheckBox jCheckBox = new JCheckBox(a);
        jCheckBox.setToolTipText(Messages.a("LogViewer", "TAB_SYNC_TOOLTIP"));
        jCheckBox.setSelectedIcon(a);
        jCheckBox.setContentAreaFilled(false);
        jCheckBox.setMargin(new Insets(0, 0, 0, -1));
        jCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 0));
        jCheckBox.addActionListener(actionEvent -> {
            jPanel.revalidate();
            this.b(jCheckBox.isSelected());
        });
        jPanel.add((Component)jCheckBox, 0);
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, -3, 0, 0));
        return jPanel;
    }

    public void a(Bookmark bookmark) {
        this.a(bookmark.state);
        FuncUtils.f f2 = this.q();
        m.e.a(() -> {
            f2.a();
            SwingUtilities.invokeLater(() -> {
                int n2 = this.tableModel.a(bookmark);
                if (n2 < 0) {
                    return;
                }
                if ((n2 = this.logTable.convertRowIndexToView(n2)) < 0) {
                    return;
                }
                this.logTable.scrollRowToVisible(n2);
                this.logTable.getSelectionModel().setSelectionInterval(n2, n2);
            });
        }, "Waiting on log viewer update to finish");
    }

    @Override
    protected void b() {
        Highlighter[] highlighterArray = new Highlighter[]{this.alternatingColorHighlighter, this.textAndSelectionHighlighter, this.categorySearchMatchHighlighter, this.messageSearchMatchHighlighter, this.exceptionHighlighter};
        for (LogTableModel.Column column : LogTableModel.Column.values()) {
            this.logTable.getColumnExt(column.c()).setHighlighters(highlighterArray);
        }
        if (!this.book.i()) {
            this.logTable.getColumnExt(LogTableModel.Column.a.c()).setHighlighters(new Highlighter[0]);
        }
    }

    @Override
    protected void c() {
        super.c();
        this.categorySearchMatchHighlighter = new ColorHighlighter((component, componentAdapter) -> this.r() && LogTableModel.Column.e.c().equals(this.logTable.getColumn(componentAdapter.column).getIdentifier()) && this.tableModel.d(componentAdapter.convertRowIndexToModel(componentAdapter.row)).isCategoryMatch(), this.searchResultBackgroundColor, null, this.selectedSearchResultBackgroundColor, null);
        this.selectedErrorBackgroundColor = MIMLookAndFeel.e(MIMLookAndFeel.r(), 0.2f);
        this.exceptionHighlighter = new ColorHighlighter((component, componentAdapter) -> this.tableModel.d(componentAdapter.convertRowIndexToModel(componentAdapter.row)).containsException(), this.errorBackgroundColor, null, this.selectedErrorBackgroundColor, null);
    }

    @Override
    protected void d() {
        this.timeSpinner = new JSpinner(new SpinnerDateModel());
        this.timeSpinner.setEditor(new JSpinner.DateEditor(this.timeSpinner, "MMM dd, yyyy HH:mm"));
        this.timeSpinner.setValue(new Date());
        this.spinnerListener = changeEvent -> this.a(new LogEntry(this.a((Date)this.timeSpinner.getValue())), true);
        this.timeSpinner.addChangeListener(this.spinnerListener);
        this.timeSpinner.setMaximumSize(new Dimension(100, 25));
        this.messageSearchbar = new JTextField(100);
        this.messageSearchbar.putClientProperty("com.mimvista.JTextField.InsideLabel", Messages.a("General", "SEARCH_LABEL"));
        this.messageSearchbar.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                MIMResultsTab.this.searchRunner.b();
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(this.padding, this.padding, this.padding, this.padding);
        this.add((Component)this.timeSpinner, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(this.padding, 0, this.padding, 0);
        this.add((Component)this.messageSearchbar, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets.top = 5;
        this.statusItem.setBackground(this.messageSearchbar.getBackground());
        this.add((Component)this.statusItem, gridBagConstraints);
        this.add(Box.createHorizontalStrut(this.padding), gridBagConstraints);
        this.y();
    }

    private void w() {
        this.timePeriod = new JComboBox<TimePeriod>(TimePeriod.values());
        this.timePeriod.putClientProperty("com.mimvista.JTextField.InsideLabel", Messages.a("LogViewer", "SEARCH_RANGE_TEXT"));
        this.timePeriod.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    switch ((TimePeriod)((Object)itemEvent.getItem())) {
                        case a: {
                            MIMResultsTab.this.searchStart = LocalDateTime.now().minusHours(1L);
                            MIMResultsTab.this.searchEnd = null;
                            break;
                        }
                        case b: {
                            MIMResultsTab.this.searchStart = LocalDateTime.now().minusDays(1L);
                            MIMResultsTab.this.searchEnd = null;
                            break;
                        }
                        case c: {
                            MIMResultsTab.this.searchStart = LocalDateTime.now().minusWeeks(1L);
                            MIMResultsTab.this.searchEnd = null;
                            break;
                        }
                        case d: {
                            MIMResultsTab.this.searchStart = LocalDateTime.now().minusMonths(1L);
                            MIMResultsTab.this.searchEnd = null;
                            break;
                        }
                        case e: {
                            MIMResultsTab.this.searchStart = LocalDateTime.now().minusYears(1L);
                            MIMResultsTab.this.searchEnd = null;
                            break;
                        }
                        case f: {
                            MIMResultsTab.this.searchStart = null;
                            MIMResultsTab.this.searchEnd = null;
                            break;
                        }
                        case g: {
                            MIMResultsTab.this.searchStart = MIMResultsTab.this.customSearchStart;
                            MIMResultsTab.this.searchEnd = MIMResultsTab.this.customSearchEnd;
                            break;
                        }
                        default: {
                            return;
                        }
                    }
                    MIMResultsTab.this.x();
                    MIMResultsTab.this.searchRunner.b();
                }
            }
        });
    }

    private Date a(LocalDateTime localDateTime) {
        return localDateTime == null ? null : Date.from(localDateTime.toInstant(localDateTime.atZone(ZoneId.systemDefault()).getOffset()));
    }

    private LocalDateTime a(Date date) {
        return date == null ? null : date.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
    }

    private void x() {
        this.startDateSelector.setDate(this.a(this.searchStart));
        this.endDateSelector.setDate(this.a(this.searchEnd));
    }

    private void y() {
        this.advancedOptions = new JPanel();
        this.advancedOptions.setBackground(this.tabBackgroundColor);
        this.advancedOptions.setLayout(new GridBagLayout());
        this.advancedOptions.setBorder(BorderFactory.createEmptyBorder());
        this.startDateSelector = this.c(Messages.a("LogViewer", "START_DATE_LABEL"));
        this.endDateSelector = this.c(Messages.a("LogViewer", "END_DATE_LABEL"));
        this.startDateSelector.setBorder(BorderFactory.createEmptyBorder());
        this.endDateSelector.setBorder(BorderFactory.createEmptyBorder());
        this.startDateSelector.addActionListener(actionEvent -> {
            Date date = this.startDateSelector.getDate();
            this.searchStart = this.a(date);
            this.z();
            this.searchRunner.b();
        });
        this.endDateSelector.addActionListener(actionEvent -> {
            Date date = this.endDateSelector.getDate();
            this.searchEnd = this.a(date);
            this.searchEnd = LocalDateTime.of(this.searchEnd.toLocalDate(), LocalTime.MAX);
            this.z();
            this.searchRunner.b();
        });
        this.w();
        this.levelDropdown = new JComboBox<MIMLogLevel>(new MIMLogLevel[]{MIMLogLevel.a, MIMLogLevel.b, MIMLogLevel.c, MIMLogLevel.d});
        this.levelDropdown.setSelectedItem((Object)MIMLogLevel.b);
        this.levelDropdown.putClientProperty("com.mimvista.JTextField.InsideLabel", Messages.a("General", "LEVEL_HEADING"));
        this.levelDropdown.addItemListener(itemEvent -> this.searchRunner.b());
        this.k();
        this.reloadBookButton = new JButton(Messages.a("LogViewer", "RELOAD_BUTTON_LABEL"));
        this.reloadBookButton.addActionListener(actionEvent -> this.m());
        this.reloadBookButton.setMargin(new Insets(1, 5, 2, 5));
        this.clearButton = new JButton(Messages.a("LogViewer", "CLEAR_BUTTON_LABEL"));
        this.clearButton.addActionListener(actionEvent -> this.tableModel.a());
        this.clearButton.setMargin(new Insets(1, 5, 2, 5));
        this.deobTextButton = new JButton(Messages.a("LogViewer", "DEOBFUSCATE_TEXT_LABEL"));
        this.deobTextButton.addActionListener(actionEvent -> this.A());
        this.deobTextButton.setVisible(this.parent.f().j());
        this.deobTextButton.setMargin(new Insets(1, 5, 2, 5));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, this.padding, 0, 0);
        this.advancedOptions.add((Component)new JLabel(Messages.a("LogViewer", "RANGE_LABEL")), gridBagConstraints);
        this.advancedOptions.add((Component)this.startDateSelector, gridBagConstraints);
        this.advancedOptions.add((Component)this.endDateSelector, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.a(this.advancedOptions, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, this.padding, 0, 0);
        this.advancedOptions.add((Component)this.levelDropdown, gridBagConstraints);
        this.advancedOptions.add(this.timePeriod, gridBagConstraints);
        this.a(this.advancedOptions, gridBagConstraints);
        this.advancedOptions.add((Component)this.regexSearchToggle, gridBagConstraints);
        this.advancedOptions.add((Component)this.filterLogsToggle, gridBagConstraints);
        this.a(this.advancedOptions, gridBagConstraints);
        this.advancedOptions.add((Component)this.reloadBookButton, gridBagConstraints);
        this.advancedOptions.add((Component)this.clearButton, gridBagConstraints);
        this.advancedOptions.add((Component)this.deobTextButton, gridBagConstraints);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.gridwidth = 7;
        gridBagConstraints2.fill = 0;
        gridBagConstraints2.anchor = 17;
        this.add((Component)this.advancedOptions, gridBagConstraints2);
    }

    private void a(JComponent jComponent, GridBagConstraints gridBagConstraints) {
        JSeparator jSeparator = new JSeparator(1);
        jSeparator.setMaximumSize(new Dimension(1, 1000));
        int n2 = gridBagConstraints.fill;
        gridBagConstraints.fill = 3;
        jComponent.add((Component)jSeparator, gridBagConstraints);
        gridBagConstraints.fill = n2;
    }

    private void z() {
        this.customSearchStart = this.searchStart;
        this.customSearchEnd = this.searchEnd;
        this.timePeriod.setSelectedItem((Object)TimePeriod.g);
    }

    @Override
    void a(boolean bl2) {
        this.deobTextButton.setVisible(bl2);
    }

    private void A() {
        DeobfuscatedLogEntryWindow deobfuscatedLogEntryWindow = new DeobfuscatedLogEntryWindow(this, Messages.a("LogViewer", "DEOBFUSCATE_TEXT_LABEL"));
        deobfuscatedLogEntryWindow.setPreferredSize(deobfuscatedLogEntryWindow.getPreferredSize());
        deobfuscatedLogEntryWindow.doLayout();
        MIMSwingUtils.a((Component)deobfuscatedLogEntryWindow, this.parent);
        deobfuscatedLogEntryWindow.setVisible(true);
    }

    @Override
    protected LogTableEntry a(LogEntry logEntry, int n2, int n3) {
        LogTableEntry logTableEntry = new LogTableEntry(logEntry, this.lastSearch.d(logEntry), this.lastSearch.e(logEntry), this.exceptionPattern.matcher(logEntry.getMessage()).find());
        logTableEntry.setPreferredHeight(this.b(logTableEntry, n2, n3));
        return logTableEntry;
    }

    private void a(i i2) {
        this.messageSearchbar.setText(i2.b);
        this.levelDropdown.setSelectedItem((Object)i2.d);
        this.searchStart = i2.e;
        this.searchEnd = i2.f;
        this.z();
        this.regexSearchToggle.setSelected(i2.h);
        this.filterLogsToggle.setSelected(i2.i);
    }

    @Override
    protected i e() {
        i i2;
        try {
            i2 = this.regexSearchToggle.isSelected() ? new i(Pattern.compile(this.messageSearchbar.getText(), 10), (MIMLogLevel)((Object)this.levelDropdown.getSelectedItem()), this.searchStart, this.searchEnd, this.filterLogsToggle.isSelected()) : new i(this.messageSearchbar.getText(), (MIMLogLevel)((Object)this.levelDropdown.getSelectedItem()), this.searchStart, this.searchEnd, this.filterLogsToggle.isSelected());
            this.messageSearchbar.setBackground(this.backgroundColor);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            i2 = i.a;
            this.messageSearchbar.setBackground(MIMLookAndFeel.r());
            SwingUtilities.invokeLater(() -> this.b(Messages.a("LogViewer", "BAD_SEARCH_REGEX")));
        }
        return i2;
    }

    private JXDatePicker c(String string) {
        JXDatePicker jXDatePicker = new JXDatePicker();
        jXDatePicker.getEditor().putClientProperty("com.mimvista.JTextField.InsideLabel", string);
        jXDatePicker.setLinkPanel(null);
        jXDatePicker.setFormats(new String[]{DateUtils.b()});
        jXDatePicker.setLightWeightPopupEnabled(true);
        jXDatePicker.setBorder((Border)new EmptyBorder(0, this.padding, 0, this.padding));
        return jXDatePicker;
    }

    @Override
    protected void f() {
        this.logTable.getColumn(0).setPreferredWidth(20);
        this.logTable.getColumn(1).setPreferredWidth(65);
        this.logTable.getColumn(2).setPreferredWidth(165);
        this.logTable.getColumn(3).setPreferredWidth(60);
        this.logTable.getColumn(4).setPreferredWidth(200);
        this.logTable.getColumn(0).setMinWidth(20);
        this.logTable.getColumn(1).setMinWidth(50);
        this.logTable.getColumn(2).setMinWidth(165);
        this.logTable.getColumn(3).setMinWidth(50);
        this.logTable.getColumn(4).setMinWidth(50);
        this.logTable.getColumn(5).setMinWidth(300);
        this.logTable.getColumn(0).setMaxWidth(20);
        this.logTable.getColumn(1).setMaxWidth(100);
        this.logTable.getColumn(2).setMaxWidth(165);
        this.logTable.getColumn(3).setMaxWidth(75);
        this.logTable.getColumn(4).setMaxWidth(500);
        this.logTable.setDefaultRenderer(Object.class, (TableCellRenderer)new LogTableCellRenderer());
        this.logTable.setDefaultRenderer(JTextArea.class, (TableCellRenderer)new ResultsTab.LogMessageCellRenderer(this));
        this.logTable.setDefaultRenderer(Boolean.class, (TableCellRenderer)new BooleanTableCellRenderer(this.parent));
        this.logTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                int n2 = MIMResultsTab.this.logTable.rowAtPoint(mouseEvent.getPoint());
                if (n2 < 0) {
                    return;
                }
                if (mouseEvent.getButton() == 3) {
                    if (!MIMResultsTab.this.logTable.isRowSelected(n2)) {
                        MIMResultsTab.this.parent.c().a(MIMResultsTab.this.tableModel.d(n2));
                        MIMResultsTab.this.logTable.getSelectionModel().setSelectionInterval(n2, n2);
                    }
                    MIMResultsTab.this.a(mouseEvent);
                } else if (mouseEvent.getButton() == 1) {
                    LogTableEntry logTableEntry = MIMResultsTab.this.tableModel.d(n2);
                    MIMResultsTab.this.timeSpinner.removeChangeListener(MIMResultsTab.this.spinnerListener);
                    MIMResultsTab.this.timeSpinner.setValue(MIMResultsTab.this.a(logTableEntry.getTimestamp()));
                    MIMResultsTab.this.timeSpinner.addChangeListener(MIMResultsTab.this.spinnerListener);
                    MIMResultsTab.this.parent.c().a(logTableEntry);
                    if (MIMResultsTab.this.isSynced) {
                        MIMResultsTab.this.parent.f().f().forEach(resultsTab -> {
                            MIMResultsTab mIMResultsTab;
                            if (resultsTab.getClass().equals(MIMResultsTab.class) && (mIMResultsTab = (MIMResultsTab)resultsTab) != MIMResultsTab.this) {
                                mIMResultsTab.searchStart = MIMResultsTab.this.searchStart;
                                mIMResultsTab.searchEnd = MIMResultsTab.this.searchEnd;
                                mIMResultsTab.b(logTableEntry);
                            }
                        });
                    }
                }
            }
        });
        this.logTable.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 3) {
                    MIMResultsTab.this.b(mouseEvent);
                }
            }
        });
    }

    private void a(MouseEvent mouseEvent) {
        int n2 = this.logTable.rowAtPoint(mouseEvent.getPoint());
        LogTableEntry logTableEntry = this.tableModel.d(n2);
        boolean bl2 = this.logTable.getSelectedRowCount() == 1;
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(this.a(Messages.a("LogViewer", "COPY_OPTION"), (ActionEvent actionEvent) -> this.p()));
        if (bl2) {
            if (this.parent.a(logTableEntry)) {
                jPopupMenu.add(this.a(Messages.a("LogViewer", "REMOVE_BOOKMARK_OPTION"), (ActionEvent actionEvent) -> this.parent.c().b(new Bookmark(this.book, logTableEntry, this.lastSearch))));
            } else {
                jPopupMenu.add(this.a(Messages.a("LogViewer", "ADD_BOOKMARK_OPTION"), (ActionEvent actionEvent) -> this.parent.c().a(new Bookmark(this.book, logTableEntry, this.lastSearch))));
            }
        }
        if (this.parent.f().j()) {
            jPopupMenu.add(this.a(Messages.a("LogViewer", "DEOBFUSCATE_LOG_OPTION"), (ActionEvent actionEvent) -> {
                LogTableEntry logTableEntry2 = new LogTableEntry(logTableEntry, logTableEntry.isCategoryMatch(), logTableEntry.isMessageMatch(), logTableEntry.containsException());
                m.e.a(() -> {
                    LogDeobfuscator logDeobfuscator = this.parent.f().a((Window)this.parent);
                    logDeobfuscator.a(logTableEntry2);
                    logDeobfuscator.a();
                    SwingUtilities.invokeLater(() -> this.a((LogEntry)logTableEntry2, Messages.a("LogViewer", "DEOBFUSCATED_LOG_WINDOW_TITLE")));
                }, "Deobfuscating single log entry");
            }));
        }
        jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
    }

    private void b(MouseEvent mouseEvent) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        for (LogTableModel.Column column : LogTableModel.Column.values()) {
            if (column.c() == LogTableModel.Column.a.c()) continue;
            TableColumnExt tableColumnExt = this.logTable.getColumnExt(column.c());
            JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(tableColumnExt.getHeaderValue().toString(), tableColumnExt.isVisible());
            jCheckBoxMenuItem.addChangeListener(changeEvent -> {
                if (jCheckBoxMenuItem.isSelected()) {
                    tableColumnExt.setVisible(true);
                } else if (this.logTable.getColumnCount(false) > 1) {
                    tableColumnExt.setVisible(false);
                } else {
                    jCheckBoxMenuItem.setSelected(true);
                }
            });
            jPopupMenu.add(jCheckBoxMenuItem);
        }
        jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
    }

    @Override
    String a(LogEntry logEntry) {
        return logEntry.getOriginalFormatString();
    }

    void a(LocalDateTime localDateTime, LocalDateTime localDateTime2, LogEntry logEntry) {
        this.B();
        this.searchStart = localDateTime;
        this.searchEnd = localDateTime2;
        this.x();
        this.b(logEntry);
    }

    private void B() {
        this.messageSearchbar.setText("");
        this.levelDropdown.setSelectedItem((Object)MIMLogLevel.b);
    }

    private void b(LogEntry logEntry) {
        FuncUtils.f f2 = this.c(false);
        m.e.a(() -> {
            f2.a();
            SwingUtilities.invokeLater(() -> this.a(logEntry, true));
        }, "Waiting for log viewer update to finish");
    }

    @Override
    boolean g() {
        return this.isSynced;
    }

    @Override
    boolean h() {
        return true;
    }

    @Override
    boolean i() {
        return true;
    }

    void b(boolean bl2) {
        this.isSynced = bl2;
    }

    @Override
    boolean j() {
        boolean bl2 = super.j();
        if (bl2) {
            this.book.a(this.handler);
        }
        return bl2;
    }

    static class BooleanTableCellRenderer
    extends JLabel
    implements TableCellRenderer {
        private static final long serialVersionUID = 1L;
        private static final Icon a = ImageManipulator.c("favorites", 13);
        private final LogWindow parent;

        public BooleanTableCellRenderer(LogWindow logWindow) {
            this.setOpaque(true);
            this.setBorder(BorderFactory.createEmptyBorder(2, 1, 0, 0));
            this.setVerticalAlignment(1);
            this.parent = logWindow;
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl2, boolean bl3, int n2, int n3) {
            LogTableModel logTableModel = (LogTableModel)jTable.getModel();
            LogTableEntry logTableEntry = logTableModel.d(jTable.convertRowIndexToModel(n2));
            boolean bl4 = this.parent.a(logTableEntry);
            this.setBackground(logTableEntry.getColor());
            this.setIcon(bl4 ? a : null);
            this.setToolTipText(bl4 ? Messages.a("LogViewer", "LOG_BOOKMARKED_LABEL") : null);
            return this;
        }
    }

    static class LogTableCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        public LogTableCellRenderer() {
            this.setBorder(BorderFactory.createEmptyBorder(0, 0, 2, 0));
            this.setVerticalAlignment(1);
        }
    }

    private static enum TimePeriod {
        a(Messages.a("LogViewer", "TIME_RANGE_LAST_HOUR")),
        b(Messages.a("LogViewer", "TIME_RANGE_LAST_DAY")),
        c(Messages.a("LogViewer", "TIME_RANGE_LAST_WEEK")),
        d(Messages.a("LogViewer", "TIME_RANGE_LAST_MONTH")),
        e(Messages.a("LogViewer", "TIME_RANGE_LAST_YEAR")),
        f(Messages.a("LogViewer", "TIME_RANGE_FOREVER")),
        g(Messages.a("LogViewer", "TIME_RANGE_CUSTOM"));

        private String str;

        private TimePeriod(String string2) {
            this.str = string2;
        }

        public String toString() {
            return this.str;
        }
    }
}

