/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.util.logview;

import com.mimvista.commands.keyboard.al;
import com.mimvista.d;
import com.mimvista.gui.util.ImageManipulator;
import com.mimvista.gui.util.MIMSwingUtils;
import com.mimvista.numerics.helpers.FuncUtils;
import com.mimvista.proui.MIMLookAndFeel;
import com.mimvista.swing.DelayedActionRunner;
import com.mimvista.util.MIMFormat;
import com.mimvista.util.Messages;
import com.mimvista.util.cn;
import com.mimvista.util.logging.MIMLogLevel;
import com.mimvista.util.logview.LogEntry;
import com.mimvista.util.logview.LogEntryWindow;
import com.mimvista.util.logview.LogTableEntry;
import com.mimvista.util.logview.LogTableModel;
import com.mimvista.util.logview.LogWindow;
import com.mimvista.util.logview.StatusItem;
import com.mimvista.util.logview.c;
import com.mimvista.util.logview.flatUI.FlatProTableHeaderUI;
import com.mimvista.util.logview.flatUI.FlatProTableUI;
import com.mimvista.util.logview.i;
import com.mimvista.util.work.f;
import com.mimvista.util.work.m;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.UndoableEditListener;
import javax.swing.plaf.TableUI;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.AbstractDocument;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.ColorHighlighter;
import org.jdesktop.swingx.decorator.CompoundHighlighter;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.table.TableColumnExt;

class ResultsTab
extends JPanel {
    private static final long serialVersionUID = 1L;
    protected static final Icon a = new ImageIcon(new BufferedImage(15, 15, 6));
    protected static final int b = 12;
    protected static final BufferedImage c = ImageManipulator.d("ui_dropdown", 12);
    protected static final Icon d = ImageManipulator.c("filter", 18);
    protected static final Icon e = ImageManipulator.c(ImageManipulator.d("filter", 18), 0.2f);
    protected static final Icon f = ImageManipulator.c("search_with_regex", 18);
    protected static final Icon g = ImageManipulator.c(ImageManipulator.d("search_without_regex", 18), 0.2f);
    LogWindow parent;
    c book;
    protected LogTableModel tableModel;
    protected JXTable logTable;
    private KeyAdapter scrollToNextLogAdapter;
    private MouseAdapter doubleClickAdapter;
    private KeyAdapter copyAdapter;
    protected DelayedActionRunner searchRunner;
    protected long timerStart;
    private Color normalTextColor = MIMLookAndFeel.getUserTextColor();
    protected Color tabBackgroundColor = new Color(64, 64, 64);
    protected Color backgroundColor = MIMLookAndFeel.E();
    protected Color altBackgroundColor = new Color(46, 46, 46);
    protected Color selectedBackgroundColor = MIMLookAndFeel.h().darker();
    protected Color errorBackgroundColor = MIMLookAndFeel.e(MIMLookAndFeel.r(), 0.1f);
    protected Color searchResultBackgroundColor = MIMLookAndFeel.e(MIMLookAndFeel.s(), 0.1f);
    protected Color selectedSearchResultBackgroundColor = MIMLookAndFeel.e(MIMLookAndFeel.s(), 0.2f);
    protected Highlighter alternatingColorHighlighter;
    protected Highlighter textAndSelectionHighlighter;
    protected Highlighter messageSearchMatchHighlighter;
    private boolean lightHighlightFirst = true;
    private JScrollPane tableView;
    protected JTextField messageSearchbar;
    protected JToggleButton regexSearchToggle;
    protected JToggleButton filterLogsToggle;
    protected int padding = 5;
    protected i lastSearch;
    protected StatusItem statusItem;
    protected boolean canceled = false;
    protected boolean parsingError = false;
    protected float turboscrollin = 0.0f;
    protected boolean finishedBuilding = false;
    private int maxRowHeight;

    public ResultsTab(LogWindow logWindow, c c2) {
        this.book = c2;
        this.parent = logWindow;
        this.setName(c2.c());
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setBackground(this.tabBackgroundColor);
        this.x();
        this.b("");
        this.tableModel = new LogTableModel();
        this.tableModel.addTableModelListener(tableModelEvent -> {
            Serializable serializable;
            if (tableModelEvent.getType() == 1 && tableModelEvent.getFirstRow() == 0 && tableModelEvent.getLastRow() == 0) {
                this.w();
                serializable = this.tableView.getViewport().getViewPosition();
                if (((Point)serializable).y > 0) {
                    ((Point)serializable).y += ((LogTableModel)this.logTable.getModel()).d(0).getPreferredHeight();
                    this.tableView.getViewport().setViewPosition((Point)serializable);
                }
            }
            if ((serializable = SwingUtilities.getWindowAncestor((Component)this.logTable)) != null) {
                int n2 = (int)Math.round(serializable.getGraphicsConfiguration().getBounds().getWidth());
                LogTableModel.Column.f.a(this.tableModel, this.logTable).setPreferredWidth(n2);
            }
        });
        this.a(this.tableModel);
        this.f();
        this.n();
        this.searchRunner = new DelayedActionRunner(200, () -> {
            if (this.finishedBuilding) {
                this.c(false);
            }
        });
        this.timerStart = -1L;
        this.c();
        this.b();
        this.d();
        this.lastSearch = i.a;
        this.finishedBuilding = true;
        this.searchRunner.b();
    }

    protected void b() {
        Highlighter[] highlighterArray = new Highlighter[]{this.alternatingColorHighlighter, this.textAndSelectionHighlighter, this.messageSearchMatchHighlighter};
        this.logTable.setHighlighters(highlighterArray);
    }

    protected void c() {
        ColorHighlighter colorHighlighter = new ColorHighlighter((component, componentAdapter) -> componentAdapter.row % 2 != 0 ^ this.lightHighlightFirst, this.altBackgroundColor, null);
        ColorHighlighter colorHighlighter2 = new ColorHighlighter((component, componentAdapter) -> componentAdapter.row % 2 == 0 ^ this.lightHighlightFirst, this.backgroundColor, null);
        this.alternatingColorHighlighter = new CompoundHighlighter(new Highlighter[]{colorHighlighter, colorHighlighter2});
        this.textAndSelectionHighlighter = new ColorHighlighter(null, this.normalTextColor, this.selectedBackgroundColor, this.normalTextColor);
        this.messageSearchMatchHighlighter = new ColorHighlighter((component, componentAdapter) -> this.r() && LogTableModel.Column.f.c().equals(this.logTable.getColumn(componentAdapter.column).getIdentifier()) && this.tableModel.d(componentAdapter.convertRowIndexToModel(componentAdapter.row)).isMessageMatch(), this.searchResultBackgroundColor, null, this.selectedSearchResultBackgroundColor, null);
    }

    private void w() {
        this.lightHighlightFirst ^= true;
    }

    protected void d() {
        this.messageSearchbar = new JTextField(100);
        this.messageSearchbar.putClientProperty("com.mimvista.JTextField.InsideLabel", Messages.a("General", "SEARCH_LABEL"));
        this.messageSearchbar.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                ResultsTab.this.searchRunner.b();
            }
        });
        this.k();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(this.padding, this.padding, this.padding + 4, 0);
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.messageSearchbar, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets.top = this.padding;
        this.statusItem.setBackground(this.messageSearchbar.getBackground());
        gridBagConstraints.insets.left = 0;
        gridBagConstraints.insets.right = this.padding;
        this.add((Component)this.statusItem, gridBagConstraints);
        gridBagConstraints.insets.top = this.padding;
        this.add((Component)this.regexSearchToggle, gridBagConstraints);
        this.add((Component)this.filterLogsToggle, gridBagConstraints);
    }

    public void k() {
        this.regexSearchToggle = new JToggleButton(g, false);
        this.regexSearchToggle.setMargin(new Insets(2, 2, 2, 2));
        this.regexSearchToggle.setSelectedIcon(f);
        this.regexSearchToggle.setToolTipText(Messages.a("LogViewer", "ENABLE_REGEX"));
        this.regexSearchToggle.addItemListener(itemEvent -> this.searchRunner.b());
        this.filterLogsToggle = new JToggleButton(e, true);
        this.filterLogsToggle.setMargin(new Insets(2, 2, 2, 2));
        this.filterLogsToggle.setSelectedIcon(d);
        this.filterLogsToggle.setToolTipText(Messages.a("LogViewer", "ENABLE_FILTER"));
        this.filterLogsToggle.addItemListener(itemEvent -> this.searchRunner.b());
    }

    synchronized FuncUtils.f c(boolean bl2) {
        final i i2 = this.e();
        final FuncUtils.f f2 = new FuncUtils.f();
        if (!bl2 && i2.equals(this.lastSearch)) {
            f2.b();
            return f2;
        }
        this.lastSearch = i2;
        final LogTableEntry logTableEntry = this.tableModel.d(this.logTable.getSelectedRow());
        com.mimvista.util.work.f.e.execute(new Runnable(){
            Timer a = new Timer(50, new ActionListener(){
                private int b = 0;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n2 = ResultsTab.this.tableModel.getRowCount();
                    if (n2 == 0) {
                        ResultsTab.this.tableModel.fireTableDataChanged();
                    } else {
                        ResultsTab.this.tableModel.fireTableRowsInserted(this.b, n2 == 0 ? 0 : n2 - 1);
                    }
                    this.b = n2;
                    ResultsTab.this.d(true);
                }
            });

            @Override
            public void run() {
                ResultsTab.this.tableModel.a();
                this.a.start();
                SwingUtilities.invokeLater(() -> {
                    int n2 = ResultsTab.this.u();
                    int n3 = ResultsTab.this.v();
                    m.e.a(() -> {
                        try (Stream<LogEntry> stream = ResultsTab.this.book.a(i22.e, i22.f);){
                            Iterator iterator = stream.iterator();
                            while (iterator.hasNext() && ResultsTab.this.a(i2)) {
                                if (ResultsTab.this.canceled) {
                                    ResultsTab.this.canceled = false;
                                    break;
                                }
                                LogEntry logEntry = (LogEntry)iterator.next();
                                if (logEntry == null) {
                                    ResultsTab.this.l();
                                    continue;
                                }
                                if (!i2.a(logEntry)) continue;
                                LogTableEntry logTableEntry2 = ResultsTab.this.a(logEntry, n2, n3);
                                ResultsTab.this.tableModel.b(logTableEntry2);
                            }
                        }
                        this.a.stop();
                        SwingUtilities.invokeLater(() -> {
                            this.a.getActionListeners()[0].actionPerformed(null);
                            ResultsTab.this.d(false);
                            if (logTableEntry != null) {
                                ResultsTab.this.a((LogEntry)logTableEntry, false);
                            }
                            f2.b();
                        });
                    }, "Adding parsed logs to the log table");
                });
            }
        });
        return f2;
    }

    protected void l() {
        SwingUtilities.invokeLater(() -> {
            this.parsingError = true;
        });
    }

    private synchronized boolean a(i i2) {
        return this.lastSearch == i2;
    }

    protected LogTableEntry a(LogEntry logEntry, int n2, int n3) {
        LogTableEntry logTableEntry = new LogTableEntry(logEntry, false, this.lastSearch.e(logEntry), false);
        logTableEntry.setPreferredHeight(this.b(logTableEntry, n2, n3));
        return logTableEntry;
    }

    protected i e() {
        i i2;
        try {
            i2 = this.regexSearchToggle.isSelected() ? new i(Pattern.compile(this.messageSearchbar.getText(), 10), MIMLogLevel.e, null, null, this.filterLogsToggle.isSelected()) : new i(this.messageSearchbar.getText(), MIMLogLevel.e, null, null, this.filterLogsToggle.isSelected());
            this.messageSearchbar.setBackground(this.backgroundColor);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            i2 = i.a;
            this.messageSearchbar.setBackground(MIMLookAndFeel.r());
            SwingUtilities.invokeLater(() -> this.b(Messages.a("LogViewer", "BAD_SEARCH_REGEX")));
        }
        return i2;
    }

    void m() {
        this.q();
    }

    protected void d(boolean bl2) {
        int n2 = this.tableModel.getRowCount();
        String string = n2 == 1 ? Messages.a("LogViewer", "SINGLE_LOG") : MIMFormat.a(Messages.a("LogViewer", "MULTIPLE_LOGS"), n2);
        if (bl2) {
            if (this.timerStart == -1L) {
                this.timerStart = System.currentTimeMillis();
            }
            string = Messages.a("LogViewer", "SEARCHING_STATUS") + " " + string;
        } else {
            if (this.lastSearch != null && !this.lastSearch.i && !this.lastSearch.a()) {
                string = string + MIMFormat.a(Messages.a("LogViewer", "SEARCH_RESULTS"), this.lastSearch.b());
            }
            if (this.timerStart == -1L) {
                return;
            }
            this.timerStart = System.currentTimeMillis() - this.timerStart;
            string = MIMFormat.a(Messages.a("LogViewer", "FOUND_STATUS"), string, this.timerStart);
            this.timerStart = -1L;
        }
        Runnable runnable = null;
        if (bl2) {
            runnable = () -> SwingUtilities.invokeLater(() -> {
                this.canceled = true;
            });
        }
        Runnable runnable2 = () -> SwingUtilities.invokeLater(() -> {
            this.parsingError = false;
        });
        this.a(string, runnable, runnable2);
    }

    void a(boolean bl2) {
    }

    public JPanel a() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 2));
        JLabel jLabel = new JLabel(this.getName());
        jLabel.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 0));
        JButton jButton = new JButton(new ImageIcon(ImageManipulator.d(ImageManipulator.d("x_white_alpha_70", 13), 0.3f)));
        jButton.setRolloverIcon(ImageManipulator.c("x_white_alpha_70", 13));
        jButton.setPressedIcon(ImageManipulator.c("x_red", 13));
        jButton.setContentAreaFilled(false);
        jButton.setMargin(new Insets(0, 0, 0, 0));
        jButton.setBorder(BorderFactory.createEmptyBorder(1, 1, 0, -1));
        jButton.addActionListener(actionEvent -> SwingUtilities.invokeLater(() -> this.parent.c(this)));
        jPanel.add(jLabel);
        jPanel.add(jButton);
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 14, 0, 0));
        jPanel.setBackground(this.t().e());
        jPanel.setOpaque(false);
        return jPanel;
    }

    void n() {
        this.tableView = new JScrollPane((Component)this.logTable);
        this.tableView.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0), BorderFactory.createMatteBorder(1, 0, 0, 0, MIMLookAndFeel.G())));
        this.tableView.setBackground(this.tabBackgroundColor);
        this.tableView.addMouseWheelListener(mouseWheelEvent -> {
            this.turboscrollin = (mouseWheelEvent.getModifiersEx() & al.f()) != 0 ? (this.turboscrollin * 5.0f + 1.0f) / 6.0f : 0.0f;
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 7;
        this.add((Component)this.tableView, gridBagConstraints);
    }

    protected void a(LogTableModel logTableModel) {
        this.logTable = new JXTable(logTableModel){
            private static final long serialVersionUID = 1L;

            public int getScrollableUnitIncrement(Rectangle rectangle, int n2, int n3) {
                return (int)(10.0f + ResultsTab.this.turboscrollin * 90.0f);
            }
        };
        this.logTable.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 17) {
                    ResultsTab.this.turboscrollin = 0.0f;
                }
            }
        });
        this.logTable.setFillsViewportHeight(true);
        this.logTable.setAutoResizeMode(3);
        this.logTable.setGridColor(MIMLookAndFeel.G());
        this.logTable.setShowVerticalLines(false);
        this.logTable.setSortable(false);
        this.logTable.setHorizontalScrollEnabled(true);
        this.logTable.setAutoscrolls(false);
        this.logTable.setEditable(false);
        this.logTable.setDragEnabled(false);
        this.logTable.setBorder(BorderFactory.createEmptyBorder());
        this.logTable.setUI((TableUI)new FlatProTableUI(null));
        this.logTable.setRowSorter(null);
        this.logTable.getTableHeader().setUI(new FlatProTableHeaderUI());
        this.logTable.getTableHeader().setReorderingAllowed(false);
        for (int i2 = 0; i2 < LogTableModel.Column.values().length; ++i2) {
            this.logTable.getColumn(i2).setIdentifier(this.tableModel.b(i2));
        }
        this.logTable.addKeyListener((KeyListener)this.scrollToNextLogAdapter);
        this.logTable.addMouseListener((MouseListener)this.doubleClickAdapter);
        this.logTable.addKeyListener((KeyListener)this.copyAdapter);
        this.logTable.getInputMap(1).getParent().remove(KeyStroke.getKeyStroke("PAGE_DOWN"));
        this.logTable.getInputMap(1).getParent().remove(KeyStroke.getKeyStroke("PAGE_UP"));
        this.logTable.getInputMap(1).put(KeyStroke.getKeyStroke("ENTER"), "OPEN_SINGLE_LOG_WINDOW");
        this.logTable.getActionMap().put("OPEN_SINGLE_LOG_WINDOW", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n2 = ResultsTab.this.logTable.getSelectedRow();
                if (n2 < 0) {
                    return;
                }
                ResultsTab.this.a((LogEntry)ResultsTab.this.tableModel.d(ResultsTab.this.logTable.convertRowIndexToModel(n2)), Messages.a("LogViewer", "FULL_LOG_WINDOW_TITLE"));
            }
        });
        this.maxRowHeight = this.a(8, this.u(), this.v());
    }

    protected void f() {
        this.logTable.setTableHeader(null);
        this.logTable.setDefaultRenderer(Object.class, (TableCellRenderer)new LogMessageCellRenderer());
        Object object = LogTableModel.Column.f.c();
        for (int i2 = 0; i2 < this.tableModel.getColumnCount(); ++i2) {
            TableColumnExt tableColumnExt = this.logTable.getColumnExt(this.logTable.convertColumnIndexToView(i2));
            if (object.equals(tableColumnExt.getIdentifier())) continue;
            tableColumnExt.setVisible(false);
        }
        TableColumnExt tableColumnExt = LogTableModel.Column.f.a(this.tableModel, this.logTable);
        tableColumnExt.setMinWidth(350);
        this.logTable.setComponentPopupMenu(this.o());
        this.logTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                int n2 = ResultsTab.this.logTable.rowAtPoint(mouseEvent.getPoint());
                if (n2 < 0) {
                    return;
                }
                if (mouseEvent.getButton() == 3 && !ResultsTab.this.logTable.isRowSelected(n2)) {
                    ResultsTab.this.logTable.getSelectionModel().setSelectionInterval(n2, n2);
                }
            }
        });
    }

    protected JPopupMenu o() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(this.a(Messages.a("LogViewer", "COPY_OPTION"), (ActionEvent actionEvent) -> this.p()));
        return jPopupMenu;
    }

    private void x() {
        this.scrollToNextLogAdapter = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                Consumer<Predicate> consumer = predicate -> ResultsTab.this.a(predicate);
                if ((keyEvent.getModifiersEx() & al.f()) == al.f()) {
                    consumer = predicate -> ResultsTab.this.b(predicate);
                }
                if (keyEvent.getKeyCode() == 114) {
                    consumer.accept(logTableEntry -> logTableEntry.isCategoryMatch() || logTableEntry.isMessageMatch());
                } else if (keyEvent.getKeyCode() == 115) {
                    consumer.accept(LogTableEntry::containsException);
                } else if (keyEvent.getKeyCode() == 116) {
                    consumer.accept(logTableEntry -> logTableEntry.getLogLevel() == MIMLogLevel.d);
                }
            }
        };
        this.doubleClickAdapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                int n2 = ResultsTab.this.logTable.rowAtPoint(mouseEvent.getPoint());
                if (n2 < 0) {
                    return;
                }
                if (mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 2) {
                    ResultsTab.this.a((LogEntry)ResultsTab.this.tableModel.d(ResultsTab.this.logTable.convertRowIndexToModel(n2)), Messages.a("LogViewer", "FULL_LOG_WINDOW_TITLE"));
                }
            }
        };
        this.copyAdapter = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.isControlDown() && keyEvent.getKeyCode() == 67) {
                    ResultsTab.this.p();
                    keyEvent.consume();
                }
            }
        };
    }

    private void a(Predicate<LogTableEntry> predicate) {
        int n2 = this.logTable.getSelectedRow();
        for (int i2 = n2 + 1; i2 < this.tableModel.getRowCount(); ++i2) {
            LogTableEntry logTableEntry = this.tableModel.d(i2);
            if (!predicate.test(logTableEntry)) continue;
            this.a(i2);
            this.logTable.setRowSelectionInterval(i2, i2);
            return;
        }
    }

    private void b(Predicate<LogTableEntry> predicate) {
        int n2 = this.logTable.getSelectedRow();
        for (int i2 = n2 - 1; i2 >= 0; --i2) {
            LogTableEntry logTableEntry = this.tableModel.d(i2);
            if (!predicate.test(logTableEntry)) continue;
            this.a(i2);
            this.logTable.setRowSelectionInterval(i2, i2);
            return;
        }
    }

    void a(LogEntry logEntry, String string) {
        LogEntryWindow logEntryWindow = new LogEntryWindow(this, string, logEntry);
        logEntryWindow.setPreferredSize(logEntryWindow.getPreferredSize());
        logEntryWindow.doLayout();
        MIMSwingUtils.a((Component)logEntryWindow, this.parent);
        logEntryWindow.setVisible(true);
    }

    void p() {
        this.a(Arrays.stream(this.logTable.getSelectedRows()).mapToObj(n2 -> this.a(this.tableModel.d(n2))).collect(Collectors.joining("\n")));
    }

    void a(String string) {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(new StringSelection(string), null);
    }

    void a(LogEntry logEntry, boolean bl2) {
        int n2;
        int n3 = this.tableModel.a(logEntry);
        int n4 = n3 < 0 ? ((n2 = Math.abs(n3) - 1) >= this.logTable.getRowCount() ? (n2 = this.logTable.getRowCount() - 1) : (n2 == 0 ? 0 : n2 - 1)) : (n2 = n3);
        if (this.logTable.getRowCount() > 0) {
            if (bl2) {
                this.logTable.setRowSelectionInterval(n2, n4);
            } else {
                this.logTable.setRowSelectionInterval(n2, n2);
            }
            this.a(n4);
        }
    }

    void a(int n2) {
        Rectangle rectangle = this.logTable.getCellRect(n2, 0, false);
        do {
            Rectangle rectangle2 = this.logTable.getCellRect(n2, 0, true);
            Rectangle rectangle3 = this.getVisibleRect();
            rectangle3.y = rectangle2.y;
            this.logTable.scrollRectToVisible(rectangle3);
            this.logTable.scrollRowToVisible(n2);
        } while (!rectangle.equals(rectangle = this.logTable.getCellRect(n2, 0, true)));
    }

    JMenuItem a(String string, ActionListener actionListener) {
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.addActionListener(actionListener);
        return jMenuItem;
    }

    String a(LogEntry logEntry) {
        return logEntry.getMessage();
    }

    FuncUtils.f q() {
        return this.c(true);
    }

    void b(String string) {
        this.a(string, null, null);
    }

    void a(String string, @d Runnable runnable, @d Runnable runnable2) {
        if (this.statusItem == null) {
            this.statusItem = new StatusItem(string, runnable);
        } else {
            this.statusItem.a(string, runnable);
        }
        this.statusItem.a(this.parsingError, runnable2);
        this.statusItem.setVisible(true);
        this.revalidate();
        this.repaint();
    }

    boolean r() {
        if (this.lastSearch == null) {
            return false;
        }
        return !this.lastSearch.a() && !this.lastSearch.i;
    }

    boolean i() {
        return false;
    }

    boolean h() {
        return false;
    }

    boolean g() {
        return false;
    }

    void s() {
        if (this.statusItem != null) {
            this.statusItem.a();
        }
        this.tableModel.a();
    }

    public c t() {
        return this.book;
    }

    boolean j() {
        c c2 = this.parent.e().b(this.book.c());
        if (c2 != null) {
            this.book = c2;
            return true;
        }
        return false;
    }

    protected int b(LogEntry logEntry, int n2, int n3) {
        return Math.min(this.a(logEntry.getMessage().split("\n").length, n2, n3), this.maxRowHeight);
    }

    private int a(int n2, int n3, int n4) {
        return n2 * n3 + n4;
    }

    protected int u() {
        return this.logTable.getRowHeight() - 2 * this.logTable.getRowMargin();
    }

    protected int v() {
        return 2 * this.logTable.getRowMargin();
    }

    class LogMessageCellRenderer
    extends JTextArea
    implements TableCellRenderer {
        private static final long serialVersionUID = 1L;
        private int iconPos;

        public LogMessageCellRenderer() {
            this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 0));
            for (UndoableEditListener undoableEditListener : ((AbstractDocument)this.getDocument()).getUndoableEditListeners()) {
                this.getDocument().removeUndoableEditListener(undoableEditListener);
            }
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl2, boolean bl3, int n2, int n3) {
            String string = cn.a(object, "");
            this.setText(string);
            int n4 = ((LogTableModel)jTable.getModel()).a(n2);
            if (jTable.getRowHeight(n2) != n4) {
                jTable.setRowHeight(n2, n4);
            }
            this.iconPos = n4 == ResultsTab.this.maxRowHeight ? n4 - 12 : -1;
            return this;
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            if (this.iconPos == -1) {
                return;
            }
            graphics.drawImage(c, 0, this.iconPos, null);
        }
    }
}

