/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.util.logview;

import com.mimvista.commands.keyboard.al;
import com.mimvista.file.MIMFile;
import com.mimvista.file.PathUtils;
import com.mimvista.file.i;
import com.mimvista.gui.util.ImageManipulator;
import com.mimvista.mui.MIMFileDialog;
import com.mimvista.proui.MIMLookAndFeel;
import com.mimvista.swing.DropdownBox;
import com.mimvista.util.Messages;
import com.mimvista.util.ay;
import com.mimvista.util.logview.Bookmark;
import com.mimvista.util.logview.LogEntry;
import com.mimvista.util.logview.LogTreeNode;
import com.mimvista.util.logview.LogWindow;
import com.mimvista.util.logview.MIMResultsTab;
import com.mimvista.util.logview.a;
import com.mimvista.util.logview.c;
import com.mimvista.util.logview.f;
import com.mimvista.util.logview.flatUI.FlatProSplitPaneUI;
import com.mimvista.util.logview.n;
import com.mimvista.util.work.m;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import net.tomahawk.ExtensionsFilter;
import org.apache.commons.io.FilenameUtils;
import org.jdesktop.swingx.JXList;
import org.jdesktop.swingx.decorator.ColorHighlighter;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterFactory;

class SidePanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final Icon a = ImageManipulator.c("arrow_up", 13);
    private static final Icon b = ImageManipulator.c("folder", 13);
    private static final Icon c = ImageManipulator.c("folder_closed", 13);
    private static final Icon d = new ImageIcon(ImageManipulator.d(ImageManipulator.d("mim_file", 20)));
    private static final Icon e = new ImageIcon(ImageManipulator.d(ImageManipulator.d("file", 20)));
    private static final int f = 250;
    private static final String g = "m78gmtyfspw,d59mz-3";
    private LogWindow parent;
    private f lib;
    private JSplitPane logsView;
    private JTree logtree;
    private DropdownBox bookmarkView;
    private JXList bookmarkList;
    private DefaultListModel<Bookmark> bookmarkModel;
    private JButton parentDir;
    private JButton refresh;
    private JButton changeDir;
    private JButton openZip;
    private Color normalTextColor = MIMLookAndFeel.getUserTextColor();
    private Color timestampTextColor = MIMLookAndFeel.getUserTextColor().darker();
    private Color backgroundColor = MIMLookAndFeel.E();
    private Color altBackgroundColor = MIMLookAndFeel.F();
    private Color selectedBackgroundColor = MIMLookAndFeel.h().darker().darker().darker();
    private Highlighter alternatingColorHighlighter = HighlighterFactory.createAlternateStriping((Color)this.altBackgroundColor, (Color)this.backgroundColor);
    private Highlighter textAndSelectionHighlighter = new ColorHighlighter(null, this.normalTextColor, this.selectedBackgroundColor, this.normalTextColor);

    public SidePanel(LogWindow logWindow, f f2) {
        this.parent = logWindow;
        this.lib = f2;
        this.g();
    }

    void a(Path path) {
        LogTreeNode logTreeNode = (LogTreeNode)this.logtree.getModel().getRoot();
        TreePath treePath = this.a(new TreePath(logTreeNode), path);
        if (treePath.getLastPathComponent() != logTreeNode) {
            this.logtree.expandPath(treePath);
            this.logtree.setSelectionPath(treePath);
            this.logtree.scrollPathToVisible(treePath);
        }
    }

    private TreePath a(TreePath treePath, Path path) {
        String string = path.getName(0).toString();
        LogTreeNode logTreeNode = (LogTreeNode)treePath.getLastPathComponent();
        for (int i2 = 0; i2 < logTreeNode.getChildCount(); ++i2) {
            LogTreeNode logTreeNode2 = (LogTreeNode)logTreeNode.getChildAt(i2);
            if (!string.equals(logTreeNode2.toString())) continue;
            if (path.getNameCount() == 1) {
                return treePath.pathByAddingChild(logTreeNode2);
            }
            return this.a(treePath.pathByAddingChild(logTreeNode2), path.subpath(1, path.getNameCount()));
        }
        return treePath;
    }

    void a(Bookmark bookmark) {
        this.bookmarkModel.addElement(bookmark);
        this.bookmarkList.setSelectedValue((Object)bookmark, true);
        this.logsView.setBottomComponent(this.bookmarkView);
        this.logsView.setDividerSize(this.parent.padding);
    }

    void b(Bookmark bookmark) {
        this.bookmarkModel.removeElement(bookmark);
        if (this.bookmarkModel.isEmpty()) {
            this.logsView.setBottomComponent(null);
            this.logsView.setDividerSize(0);
        }
    }

    void a(LogEntry logEntry) {
        if (logEntry == null) {
            return;
        }
        Enumeration<Bookmark> enumeration = this.bookmarkModel.elements();
        while (enumeration.hasMoreElements()) {
            Bookmark bookmark = enumeration.nextElement();
            if (!bookmark.equals(logEntry)) continue;
            this.bookmarkList.setSelectedValue((Object)bookmark, true);
            return;
        }
        this.bookmarkList.clearSelection();
    }

    boolean b(LogEntry logEntry) {
        if (logEntry == null) {
            return false;
        }
        return this.bookmarkModel.contains(logEntry);
    }

    void a() {
        this.parentDir.setEnabled(!this.parent.f().i().d().c());
    }

    void b() {
        this.refresh.setEnabled(!this.parent.f().i().d().c());
    }

    private void g() {
        this.setLayout(new BorderLayout());
        this.logsView = new JSplitPane(0);
        this.logsView.setResizeWeight(0.8);
        this.logsView.setUI(new FlatProSplitPaneUI());
        this.logsView.setBackground(MIMLookAndFeel.G());
        this.h();
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.j(), "First");
        JScrollPane jScrollPane = new JScrollPane(this.logtree);
        jScrollPane.setBorder(BorderFactory.createEmptyBorder());
        jPanel.add((Component)jScrollPane, "Center");
        DropdownBox dropdownBox = new DropdownBox(jPanel, Messages.a("LogViewer", "LOGS_HEADER"), DropdownBox.DropdownBoxStyle.b, false, null);
        dropdownBox.e().addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (SwingUtilities.isRightMouseButton(mouseEvent) && (mouseEvent.getModifiersEx() & al.f()) == al.f()) {
                    SidePanel.this.parent.f().k();
                }
            }
        });
        dropdownBox.b(25);
        this.logsView.setTopComponent(dropdownBox);
        this.logsView.setDividerSize(0);
        this.m();
        this.add((Component)this.logsView, "Center");
        this.setBorder(BorderFactory.createEmptyBorder(this.parent.padding, this.parent.padding, this.parent.padding, 0));
        this.setMaximumSize(new Dimension(250, 10000));
        this.setPreferredSize(new Dimension(250, 10000));
        this.setBackground(MIMLookAndFeel.G());
    }

    private void h() {
        this.logtree = this.lib.d().d();
        this.logtree.setCellRenderer(new DefaultTreeCellRenderer(){
            private static final long serialVersionUID = 1L;
            {
                this.setOpaque(true);
                this.setBorder(BorderFactory.createLineBorder(SidePanel.this.backgroundColor, 1));
            }

            @Override
            public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl2, boolean bl3, boolean bl4, int n2, boolean bl5) {
                super.getTreeCellRendererComponent(jTree, object, bl2, bl3, bl4, n2, bl5);
                LogTreeNode logTreeNode = (LogTreeNode)object;
                c c2 = logTreeNode.b();
                if (c2 != null) {
                    this.setIcon(c2.h() ? d : e);
                    this.setBackground(MIMLookAndFeel.e(c2.e(), 0.5f));
                    this.setBackgroundSelectionColor(c2.h() ? c2.e() : com.mimvista.util.logview.a.d);
                } else {
                    this.setIcon(bl3 ? b : c);
                    this.setBackground(MIMLookAndFeel.e(com.mimvista.util.logview.a.c, 0.3f));
                    this.setBackgroundSelectionColor(com.mimvista.util.logview.a.d);
                }
                return this;
            }
        });
        this.logtree.setBorder(BorderFactory.createEmptyBorder(this.parent.padding, this.parent.padding, this.parent.padding, this.parent.padding));
        this.logtree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 1) {
                    c c2;
                    TreePath treePath = SidePanel.this.logtree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                    if (treePath == null) {
                        return;
                    }
                    Object object = treePath.getLastPathComponent();
                    if (SidePanel.this.logtree.getModel().isLeaf(object) && (c2 = ((LogTreeNode)object).b()) != null) {
                        if (mouseEvent.getClickCount() == 1) {
                            SidePanel.this.parent.a(c2);
                        } else {
                            SidePanel.this.parent.b(c2);
                        }
                    }
                } else if (mouseEvent.getButton() == 3) {
                    TreePath treePath = SidePanel.this.logtree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                    if (treePath == null) {
                        return;
                    }
                    if (!SidePanel.this.logtree.isPathSelected(treePath)) {
                        SidePanel.this.logtree.setSelectionPath(treePath);
                    }
                    Object object = treePath.getLastPathComponent();
                    if (SidePanel.this.logtree.getModel().isLeaf(object)) {
                        SidePanel.this.a(mouseEvent);
                    }
                }
            }
        });
        this.logtree.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                c c2;
                if (keyEvent.getKeyCode() == 10 && (c2 = SidePanel.this.i()) != null) {
                    SidePanel.this.parent.b(c2);
                }
            }
        });
    }

    private c i() {
        if (this.logtree.isSelectionEmpty()) {
            return null;
        }
        if (this.logtree.getSelectionCount() == 1) {
            return ((LogTreeNode)this.logtree.getSelectionPath().getLastPathComponent()).b();
        }
        List<c> list = Arrays.stream(this.logtree.getSelectionPaths()).map(treePath -> ((LogTreeNode)treePath.getLastPathComponent()).b()).filter(c2 -> c2 != null && c2.i() && c2.h()).collect(Collectors.toList());
        if (list.size() > 1) {
            return new n(list);
        }
        if (list.size() == 1) {
            return list.get(0);
        }
        return null;
    }

    private void a(MouseEvent mouseEvent) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(this.a(Messages.a("LogViewer", "OPEN_OPTION"), (ActionEvent actionEvent) -> {
            c c2 = this.i();
            if (c2 != null) {
                this.parent.b(c2);
            }
        }));
        jPopupMenu.add(this.a(Messages.a("LogViewer", "OPEN_NEW_WINDOW_OPTION"), (ActionEvent actionEvent) -> {
            c c2 = this.i();
            if (c2 != null) {
                LogWindow logWindow = this.parent.f().b();
                logWindow.b(c2);
            }
        }));
        jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
    }

    private JPanel j() {
        JPanel jPanel = new JPanel();
        jPanel.setBackground(MIMLookAndFeel.E());
        this.parentDir = new JButton(a);
        this.refresh = new JButton(Messages.a("LogViewer", "REFRESH_BUTTON_LABEL"));
        this.changeDir = new JButton(Messages.a("LogViewer", "CHOOSE_DIRECTORY_BUTTON_LABEL"));
        this.openZip = new JButton(Messages.a("LogViewer", "OPEN_ZIP_BUTTON_LABEL"));
        Border border = BorderFactory.createEmptyBorder(2, 4, 2, 4);
        this.parentDir.setBorder(border);
        this.refresh.setBorder(border);
        this.changeDir.setBorder(border);
        this.openZip.setBorder(border);
        this.refresh.setFont(this.refresh.getFont().deriveFont(10.0f));
        this.changeDir.setFont(this.refresh.getFont());
        this.openZip.setFont(this.refresh.getFont());
        this.parentDir.addActionListener(actionEvent -> {
            MIMFile mIMFile = new MIMFile(this.parent.e().d().e());
            this.a(mIMFile.getParent());
        });
        this.parentDir.setToolTipText(Messages.a("LogViewer", "PARENT_DIR_TIP"));
        jPanel.add(this.parentDir);
        this.refresh.addActionListener(actionEvent -> {
            this.l();
            m.e.submit(() -> {
                try {
                    this.parent.e().a();
                }
                finally {
                    this.parent.f().h();
                    this.k();
                }
            });
        });
        jPanel.add(this.refresh);
        this.changeDir.addActionListener(actionEvent -> {
            MIMFileDialog mIMFileDialog = MIMFileDialog.a(this.parent, Messages.a("LogViewer", "CHOOSE_DIRECTORY_BUTTON_LABEL"), MIMFileDialog.FileDialogType.a, MIMFileDialog.FileDialogSelectionMode.b, this.parent.e().d().e(), true);
            mIMFileDialog.a(true);
            this.a(mIMFileDialog.a());
        });
        jPanel.add(this.changeDir);
        this.openZip.addActionListener(actionEvent -> {
            MIMFileDialog mIMFileDialog = MIMFileDialog.a(this.parent, Messages.a("LogViewer", "OPEN_ZIP_BUTTON_LABEL"), MIMFileDialog.FileDialogType.a, MIMFileDialog.FileDialogSelectionMode.a, this.parent.e().d().e(), true);
            mIMFileDialog.a(new ExtensionsFilter("Zip Files", "zip", "mzlog"));
            mIMFileDialog.a(true);
            if (mIMFileDialog.a() != null) {
                this.l();
                m.e.submit(() -> {
                    if (mIMFileDialog.c().endsWith(".zip")) {
                        MIMFile mIMFile = PathUtils.getTempPathUnique("mimlogs");
                        mIMFile.deleteOnExit();
                        if (!mIMFile.exists()) {
                            mIMFile.mkdir();
                        }
                        try {
                            com.mimvista.util.b.a.b(new File(mIMFileDialog.a()), mIMFile);
                        }
                        catch (Exception exception) {
                            ay.d((Object)exception, SidePanel.class);
                        }
                        this.parent.e().a(mIMFile.getPath(), true);
                    } else if (this.parent.f().j()) {
                        i.a(new File(mIMFileDialog.a()), g);
                        this.parent.e().a(FilenameUtils.removeExtension((String)mIMFileDialog.a()) + "/", true);
                    }
                    this.k();
                });
            }
        });
        jPanel.add(this.openZip);
        return jPanel;
    }

    private void k() {
        SwingUtilities.invokeLater(() -> {
            this.a();
            this.b();
            this.changeDir.setEnabled(true);
            this.openZip.setEnabled(true);
        });
    }

    private void l() {
        SwingUtilities.invokeLater(() -> {
            this.parentDir.setEnabled(false);
            this.refresh.setEnabled(false);
            this.changeDir.setEnabled(false);
            this.openZip.setEnabled(false);
        });
    }

    private void a(String string) {
        if (string != null) {
            this.l();
            m.e.a(() -> {
                try {
                    this.parent.e().a(string);
                }
                finally {
                    this.parent.f().g();
                    this.k();
                }
            }, "Updating LogViewer library location");
        }
    }

    private void m() {
        this.bookmarkModel = new DefaultListModel();
        this.bookmarkList = new JXList(this.bookmarkModel);
        this.bookmarkList.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                Bookmark bookmark = (Bookmark)SidePanel.this.bookmarkList.getSelectedValue();
                if (mouseEvent.getButton() == 1) {
                    if (bookmark != null) {
                        SidePanel.this.parent.a(bookmark);
                    }
                } else {
                    SidePanel.this.b(mouseEvent);
                }
            }
        });
        this.bookmarkList.setCellRenderer((ListCellRenderer)new ListCellRenderer<Bookmark>(){

            public Component a(JList<? extends Bookmark> jList, Bookmark bookmark, int n2, boolean bl2, boolean bl3) {
                JPanel jPanel = new JPanel(new BorderLayout());
                jPanel.setBorder(BorderFactory.createEmptyBorder(2, ((SidePanel)SidePanel.this).parent.padding, 2, ((SidePanel)SidePanel.this).parent.padding));
                jPanel.setOpaque(true);
                Dimension dimension = new Dimension(250 - ((SidePanel)SidePanel.this).parent.padding * 2, 40);
                jPanel.setMaximumSize(dimension);
                jPanel.setPreferredSize(dimension);
                JLabel jLabel = new JLabel(bookmark.getFormattedTimestamp());
                jLabel.setForeground(SidePanel.this.timestampTextColor);
                jPanel.add((Component)jLabel, "First");
                jPanel.add((Component)new JLabel(bookmark.getMessage()), "Center");
                return jPanel;
            }

            @Override
            public /* synthetic */ Component getListCellRendererComponent(JList jList, Object object, int n2, boolean bl2, boolean bl3) {
                return this.a(jList, (Bookmark)object, n2, bl2, bl3);
            }
        });
        this.bookmarkList.addHighlighter(this.alternatingColorHighlighter);
        this.bookmarkList.addHighlighter(this.textAndSelectionHighlighter);
        this.bookmarkList.setSelectionMode(0);
        JScrollPane jScrollPane = new JScrollPane((Component)this.bookmarkList);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.bookmarkView = new DropdownBox(jScrollPane, Messages.a("LogViewer", "BOOKMARKS_HEADER"), DropdownBox.DropdownBoxStyle.b, false, null);
        this.bookmarkView.b(25);
    }

    private void b(MouseEvent mouseEvent) {
        Bookmark bookmark = this.bookmarkModel.get(this.bookmarkList.locationToIndex(mouseEvent.getPoint()));
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(this.a(Messages.a("LogViewer", "OPEN_OPTION"), (ActionEvent actionEvent) -> ((MIMResultsTab)this.parent.b(bookmark.book)).a(bookmark)));
        jPopupMenu.add(this.a(Messages.a("LogViewer", "DELETE_OPTION"), (ActionEvent actionEvent) -> this.b(bookmark)));
        jPopupMenu.add(this.c(bookmark));
        jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
    }

    private JMenu c(Bookmark bookmark) {
        Bookmark bookmark2 = bookmark;
        LocalDateTime localDateTime = bookmark2.getTimestamp();
        JMenu jMenu = new JMenu(Messages.a("LogViewer", "LOCATE_SIMILAR_TIME_OPTION"));
        for (c c2 : this.parent.e().b()) {
            if (!c2.h()) continue;
            jMenu.add(this.a(c2.c(), (ActionEvent actionEvent) -> {
                MIMResultsTab mIMResultsTab = (MIMResultsTab)this.parent.b(c2);
                mIMResultsTab.a(localDateTime.minusWeeks(1L), localDateTime.plusWeeks(1L), bookmark2);
            }));
        }
        return jMenu;
    }

    private JMenuItem a(String string, ActionListener actionListener) {
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.addActionListener(actionListener);
        return jMenuItem;
    }
}

