/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.util.logview;

import com.mimvista.gui.util.CursorFactory;
import com.mimvista.gui.util.MIMSwingUtils;
import com.mimvista.proui.MIMLookAndFeel;
import com.mimvista.util.Messages;
import com.mimvista.util.logview.ColoredSquaredOffTabbedPaneUI;
import com.mimvista.util.logview.LogWindow;
import com.mimvista.util.logview.ResultsTab;
import com.mimvista.util.logview.c;
import com.mimvista.util.logview.o;
import com.mimvista.util.logview.p;
import java.awt.AWTKeyStroke;
import java.awt.Insets;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

class TabView
extends JTabbedPane
implements o {
    private static final long serialVersionUID = 1L;
    private LogWindow parent;

    public TabView(LogWindow logWindow) {
        this.parent = logWindow;
        this.e();
        MouseListener[] mouseListenerArray = this.getMouseListeners();
        for (MouseListener mouseListener : mouseListenerArray) {
            this.removeMouseListener(mouseListener);
        }
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                int n2 = TabView.this.indexAtLocation(mouseEvent.getX(), mouseEvent.getY());
                if (n2 == -1) {
                    return;
                }
                ResultsTab resultsTab = (ResultsTab)TabView.this.getComponentAt(n2);
                if (mouseEvent.getButton() == 2) {
                    TabView.this.d(resultsTab);
                } else if (mouseEvent.getButton() == 3 && n2 >= 0) {
                    TabView.this.e(resultsTab).show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
        for (MouseListener mouseListener : mouseListenerArray) {
            this.addMouseListener(mouseListener);
        }
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setBackground(MIMLookAndFeel.G());
        this.setUI(new ColoredSquaredOffTabbedPaneUI(this));
        DragSource dragSource = new DragSource();
        dragSource.createDefaultDragGestureRecognizer(this, 2, this);
        new DropTarget(this, 2, this, true, null);
        this.setBorder(MIMLookAndFeel.H());
        this.putClientProperty("SquaredOffTabbedPaneUI.tabInsetOverride", new Insets(-2, -3, 0, 5));
    }

    public ResultsTab a() {
        return (ResultsTab)this.getSelectedComponent();
    }

    public List<ResultsTab> b() {
        ArrayList<ResultsTab> arrayList = new ArrayList<ResultsTab>(this.getTabCount());
        for (int i2 = 0; i2 < this.getTabCount(); ++i2) {
            arrayList.add((ResultsTab)this.getComponentAt(i2));
        }
        return arrayList;
    }

    public List<ResultsTab> c() {
        return this.b().stream().filter(resultsTab -> resultsTab.g()).collect(Collectors.toList());
    }

    public ResultsTab a(ResultsTab resultsTab) {
        resultsTab.parent = this.parent;
        this.addTab(resultsTab.getName(), resultsTab);
        int n2 = this.indexOfComponent(resultsTab);
        this.setTabComponentAt(n2, resultsTab.a());
        this.setSelectedComponent(resultsTab);
        resultsTab.q();
        return resultsTab;
    }

    public void a(c c2) {
        for (ResultsTab resultsTab : this.b()) {
            if (!resultsTab.t().equals(c2)) continue;
            this.b(resultsTab);
        }
    }

    public void b(ResultsTab resultsTab) {
        this.setSelectedComponent(resultsTab);
    }

    public boolean b(c c2) {
        for (ResultsTab resultsTab : this.b()) {
            if (!resultsTab.t().equals(c2)) continue;
            return true;
        }
        return false;
    }

    public boolean c(ResultsTab resultsTab) {
        return this.b().contains(resultsTab);
    }

    public ResultsTab d(ResultsTab resultsTab) {
        int n2 = this.indexOfComponent(resultsTab);
        if (n2 == -1) {
            return resultsTab;
        }
        int n3 = this.getSelectedIndex();
        resultsTab.s();
        this.remove(n2);
        if (this.getTabCount() > 0) {
            SwingUtilities.invokeLater(() -> {
                if (this.getTabCount() > 0) {
                    if (n2 < n3) {
                        this.setSelectedIndex(n3 - 1);
                    } else if (n2 > n3) {
                        this.setSelectedIndex(n3);
                    }
                }
            });
        } else {
            this.parent.a(this);
        }
        return resultsTab;
    }

    private void d() {
        this.removeAll();
    }

    private JPopupMenu e(ResultsTab resultsTab) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(this.a(Messages.a("LogViewer", "CLOSE_OPTION"), (ActionEvent actionEvent) -> this.d(resultsTab)));
        jPopupMenu.add(this.a(Messages.a("LogViewer", "CLOSE_OTHERS_OPTION"), (ActionEvent actionEvent) -> {
            this.d();
            this.a(resultsTab);
        }));
        jPopupMenu.add(this.a(Messages.a("LogViewer", "CLOSE_ALL_OPTION"), (ActionEvent actionEvent) -> {
            this.d();
            this.parent.a(this);
        }));
        if (this.parent.k() > 1) {
            jPopupMenu.add(this.f(resultsTab));
        }
        if (this.getTabCount() > 1 && this.parent.k() < 2) {
            jPopupMenu.add(this.a(Messages.a("LogViewer", "SPLIT_TO_NEW_PANE_OPTION"), (ActionEvent actionEvent) -> {
                this.d(resultsTab);
                this.parent.b(resultsTab);
            }));
        }
        return jPopupMenu;
    }

    private JMenu f(ResultsTab resultsTab) {
        JMenu jMenu = new JMenu(Messages.a("LogViewer", "MOVE_TO_OPTION"));
        TabView tabView = this.parent.a(0);
        TabView tabView2 = this.parent.a(1);
        if (this.equals(tabView)) {
            jMenu.add(this.a(Messages.a("LogViewer", "RIGHT_PANE_LABEL"), (ActionEvent actionEvent) -> {
                this.d(resultsTab);
                this.parent.a(tabView2, resultsTab);
            }));
        } else if (this.equals(tabView2)) {
            jMenu.add(this.a(Messages.a("LogViewer", "LEFT_PANE_LABEL"), (ActionEvent actionEvent) -> {
                this.d(resultsTab);
                this.parent.a(tabView, resultsTab);
            }));
        }
        return jMenu;
    }

    private JMenuItem a(String string, ActionListener actionListener) {
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.addActionListener(actionListener);
        return jMenuItem;
    }

    private void e() {
        KeyStroke keyStroke = KeyStroke.getKeyStroke("ctrl TAB");
        KeyStroke keyStroke2 = KeyStroke.getKeyStroke("ctrl shift TAB");
        HashSet<AWTKeyStroke> hashSet = new HashSet<AWTKeyStroke>(this.getFocusTraversalKeys(0));
        hashSet.remove(keyStroke);
        this.setFocusTraversalKeys(0, hashSet);
        HashSet<AWTKeyStroke> hashSet2 = new HashSet<AWTKeyStroke>(this.getFocusTraversalKeys(1));
        hashSet2.remove(keyStroke2);
        this.setFocusTraversalKeys(1, hashSet2);
        InputMap inputMap = this.getInputMap(1);
        inputMap.put(keyStroke, "navigateNext");
        inputMap.put(keyStroke2, "navigatePrevious");
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        int n2 = this.indexAtLocation((int)dragGestureEvent.getDragOrigin().getX(), (int)dragGestureEvent.getDragOrigin().getY());
        if (n2 >= 0) {
            ResultsTab resultsTab = (ResultsTab)this.getComponentAt(n2);
            JPanel jPanel = (JPanel)this.getTabComponentAt(n2);
            jPanel.setOpaque(true);
            BufferedImage bufferedImage = MIMSwingUtils.f(jPanel);
            jPanel.setOpaque(false);
            this.d(resultsTab);
            dragGestureEvent.startDrag(CursorFactory.b(), bufferedImage, new Point(0, 0), new p(resultsTab), this);
        }
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        try {
            Transferable transferable = dropTargetDropEvent.getTransferable();
            ResultsTab resultsTab = (ResultsTab)transferable.getTransferData(p.a);
            if (dropTargetDropEvent.isDataFlavorSupported(p.a)) {
                dropTargetDropEvent.acceptDrop(2);
                this.a(resultsTab);
                this.parent.j();
                dropTargetDropEvent.dropComplete(true);
                return;
            }
            dropTargetDropEvent.rejectDrop();
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            dropTargetDropEvent.rejectDrop();
        }
        catch (IOException iOException) {
            dropTargetDropEvent.rejectDrop();
        }
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
        if (dragSourceDropEvent.getDropSuccess()) {
            return;
        }
        try {
            Transferable transferable = dragSourceDropEvent.getDragSourceContext().getTransferable();
            ResultsTab resultsTab = (ResultsTab)transferable.getTransferData(p.a);
            LogWindow logWindow = this.parent.f().b();
            logWindow.setLocation(dragSourceDropEvent.getLocation());
            logWindow.a(resultsTab);
            this.parent.j();
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

