/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.util.service;

import com.mimvista.osdep.GetOSPath;
import com.mimvista.util.MIMContext;
import com.mimvista.util.ay;
import com.mimvista.util.cm;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;

public abstract class SimpleServiceControl {
    private static final String unsupported = "???";

    public static enum MimServiceState {
        a,
        b,
        c,
        d,
        e,
        f;


        public boolean a() {
            return this == d || this == b || this == c || this == e;
        }

        public boolean b() {
            return this == d || this == f || this == c || this == e;
        }
    }

    public static enum MimServiceCommand {
        a("net start {1}", "launchctl start {0}"),
        b("net stop {1}", "launchctl stop {0}"),
        c(new String[]{"services/{2}/bin/{2}{3}.exe", "--WinRun4J:RegisterService"}, "./bin/install_service {0}", true),
        d(new String[]{"services/{2}/bin/{2}{3}.exe", "--WinRun4J:UnregisterService"}, "./bin/uninstall_service {0}", true),
        e("sc query {1}", "./bin/service_running[{0}"),
        f("sc config {1} start= demand", "{0}"),
        g("sc config {1} start= auto", "{0}"),
        h("sc qc {1}", "Unknown command");

        private boolean dirSensitive = false;
        private String[] winCmd;
        private String macCmd;

        private MimServiceCommand(String string2, String string3, boolean bl2) {
            this(new String[]{string2}, string3, bl2);
        }

        private MimServiceCommand(String[] stringArray, String string2, boolean bl2) {
            this.winCmd = stringArray;
            this.macCmd = string2;
            this.dirSensitive = bl2;
        }

        private MimServiceCommand(String string2, String string3) {
            this(new String[]{string2}, string3, false);
        }

        public String[] a() {
            return (String[])this.winCmd.clone();
        }

        public String b() {
            return this.macCmd;
        }

        public boolean c() {
            return this.dirSensitive;
        }
    }

    public static enum MimService {
        a("com.mimvista.dcmstore", "MIMDcmStore", "DcmStorageServer", "dcmstore", 512),
        b("com.mimvista.dcmquery", "MIMDcmQuery", "MIMDcmQueryServer", "dcmquery", 1024),
        c("com.mimvista.license", "MIMLicense", "LicenseServer", "license", 256),
        d("com.mimvista.pacs", "MIMpacs", "MIMpacsServer", "pacs", 1024),
        e("com.mimvista.mobile", "MIMMobile", "MobileServer", "mobile", 900),
        f("com.mimvista.automator", "MIMAutomator", "AutomatorServer", "assistant", 1024),
        g("com.mimvista.mimcloudexpress", "MIMcloudExpress", "MIMcloudExpress", "mimcloud_assistant", 1024),
        h("com.mimvista.admin", "MIMadmin", "MIMadmin", "admin", 512),
        i("???", "MIMMobileOEM", "OemMobileServer", "mobileOem", 1350),
        j("com.mimvista.oisintegration", "MIMpacsOISIntegrationService", "MIMpacsOISIntegrationServer", "oisintegration", 128),
        k("com.mimvista.dcmstore", "MIMDcmStore_Extra", "DcmStorageServer_Extra", "dcmstore_extra", 256),
        l("???", "???", "???", "???", false, true, 0),
        m("???", "storescp", "deprecated dicom store", "deprecateddicomstore", true, 0),
        n("???", "mimquery", "deprecated dicom query", "deprecated dicom query", true, 0),
        o("???", "mimmetabase", "deprecated metabase", "deprecated metabase", true, 0),
        p("???", "mimhttpd", "deprecated web patient list", "deprecated web patient list", true, 0);

        private String macServiceName;
        private String winServiceName;
        private String fileName;
        private String logDirName;
        private final boolean deprecated;
        private final boolean contained;
        private final int minHeapMb;

        private MimService(String string2, String string3, String string4, String string5, int n3) {
            this(string2, string3, string4, string5, false, false, n3);
        }

        private MimService(String string2, String string3, String string4, String string5, boolean bl2, int n3) {
            this(string2, string3, string4, string5, bl2, false, n3);
        }

        private MimService(String string2, String string3, String string4, String string5, boolean bl2, boolean bl3, int n3) {
            this.macServiceName = string2;
            this.winServiceName = string3;
            this.fileName = string4;
            this.logDirName = string5;
            this.deprecated = bl2;
            this.contained = bl3;
            this.minHeapMb = n3;
        }

        public boolean a() {
            if (GetOSPath.isWindows()) {
                return !SimpleServiceControl.unsupported.equals(this.f());
            }
            return !SimpleServiceControl.unsupported.equals(this.e());
        }

        public boolean b() {
            return this.deprecated;
        }

        public boolean c() {
            return this.contained;
        }

        public int d() {
            return this.minHeapMb;
        }

        public String e() {
            return this.macServiceName;
        }

        public String f() {
            return this.winServiceName;
        }

        public String g() {
            if (GetOSPath.isWindows()) {
                return this.winServiceName;
            }
            if (GetOSPath.isMacOs()) {
                return this.macServiceName;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String h() {
            if (GetOSPath.isWindows()) {
                FileInputStream fileInputStream;
                block6: {
                    String string;
                    fileInputStream = null;
                    try {
                        File file = new File("services/" + this.i() + "/bin/serviceConfig.txt");
                        Properties properties = new Properties();
                        fileInputStream = new FileInputStream(file);
                        properties.load(fileInputStream);
                        if (!properties.containsKey("service.name")) break block6;
                        string = properties.getProperty("service.name");
                    }
                    catch (Throwable throwable) {
                        try {
                            ay.d((Object)"Couldn't read pretty name.", throwable, (Object)this);
                        }
                        catch (Throwable throwable2) {
                            throw throwable2;
                        }
                        finally {
                            cm.a(fileInputStream);
                        }
                    }
                    cm.a((Closeable)fileInputStream);
                    return string;
                }
                cm.a((Closeable)fileInputStream);
            }
            return this.g();
        }

        public String i() {
            return this.fileName;
        }

        public String j() {
            return this.logDirName;
        }

        public static MimService k() {
            String string = MIMContext.f();
            if (string == null) {
                ay.e((Object)"Not currently running as a service; don't try to ask me what service I am", MimService.class);
                return null;
            }
            for (MimService mimService : MimService.values()) {
                if (!mimService.i().equals(string)) continue;
                return mimService;
            }
            ay.b((Object)("Service name claims to be " + string + ", but I don't know what that is"), MimService.class);
            return null;
        }

        public static MimService a(String string) {
            for (MimService mimService : MimService.values()) {
                if (mimService.contained || !mimService.fileName.equalsIgnoreCase(string)) continue;
                return mimService;
            }
            return null;
        }

        public static MimService b(String string) {
            for (MimService mimService : MimService.values()) {
                if (mimService.contained || !mimService.winServiceName.equalsIgnoreCase(string)) continue;
                return mimService;
            }
            return null;
        }
    }
}

