/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.util.state;

import com.google.common.collect.Lists;
import com.mimvista.gui.util.MIMSwingUtils;
import com.mimvista.mui.Session;
import com.mimvista.swing.widgets.ProgressQueueNotification;
import com.mimvista.util.MIMFormat;
import com.mimvista.util.Messages;
import com.mimvista.util.ay;
import com.mimvista.util.cn;
import com.mimvista.util.progress.Progress;
import com.mimvista.util.progress.ProgressPanel;
import com.mimvista.util.progress.o;
import com.mimvista.util.state.EditState;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;

public abstract class MIMUndoableEdit
extends AbstractUndoableEdit {
    private static Messages props = Messages.a("Util");
    private static final long serialVersionUID = 1L;
    protected List<EditState> newStates = new ArrayList<EditState>();
    protected List<EditState> oldStates = new ArrayList<EditState>();
    protected boolean compileStates = false;
    private transient Session session;
    protected Object fuseKey = null;
    protected boolean mustShareClass = true;
    protected Progress prog = new o();
    private boolean done = true;
    private boolean isAlive = true;

    public void setCompileStates(boolean bl2) {
        this.compileStates = bl2;
    }

    public List<EditState> getOldStates() {
        return this.oldStates;
    }

    public List<EditState> getNewStates() {
        return this.newStates;
    }

    public Object getFuseKey() {
        return this.fuseKey;
    }

    public void setMustShareClass(boolean bl2) {
        this.mustShareClass = bl2;
    }

    @Override
    public boolean addEdit(UndoableEdit undoableEdit) {
        if (undoableEdit instanceof MIMUndoableEdit) {
            MIMUndoableEdit mIMUndoableEdit = (MIMUndoableEdit)undoableEdit;
            if ((this.getClass() == mIMUndoableEdit.getClass() || !this.mustShareClass) && this.fuseKey != null && this.fuseKey.equals(mIMUndoableEdit.fuseKey)) {
                if (this.compileStates) {
                    System.out.println("COMPILE EDITS");
                    this.newStates.addAll(mIMUndoableEdit.newStates);
                    this.oldStates.addAll(mIMUndoableEdit.oldStates);
                } else {
                    for (int i2 = 0; i2 < this.newStates.size() && i2 < mIMUndoableEdit.newStates.size(); ++i2) {
                        this.newStates.get(i2).merge(mIMUndoableEdit.newStates.get(i2));
                    }
                    this.newStates = mIMUndoableEdit.newStates;
                }
                return true;
            }
        }
        return false;
    }

    protected void setSession(Session session) {
        this.session = session;
    }

    protected Session getSession() {
        return this.session;
    }

    @Override
    public String getPresentationName() {
        return props.getProperty("MIM_UNDO_NAME");
    }

    @Override
    public String getUndoPresentationName() {
        String string = this.getPresentationName();
        String string2 = props.getProperty("AbstractUndoableEdit.undoText");
        string = MIMFormat.a(string2, string);
        return string;
    }

    @Override
    public String getRedoPresentationName() {
        String string = this.getPresentationName();
        String string2 = props.getProperty("AbstractUndoableEdit.redoText");
        string = MIMFormat.a(string2, string);
        return string;
    }

    @Override
    public void die() {
        this.isAlive = false;
    }

    public boolean isAlive() {
        return this.isAlive;
    }

    @Override
    public void redo() throws CannotRedoException {
        this.doUndoRedo(new Runnable(){

            @Override
            public void run() {
                MIMUndoableEdit.this.done = true;
                for (EditState editState : MIMUndoableEdit.this.newStates) {
                    if (editState.getSession() == null) {
                        editState.setSession(MIMUndoableEdit.this.session);
                    }
                    editState.stamp();
                    MIMUndoableEdit.this.prog.N_();
                }
            }
        }, this.newStates.size());
    }

    void doit() {
        System.out.println("Doing edit: " + this);
        this.done = true;
        for (EditState editState : this.newStates) {
            System.out.println("Gonna stamp: " + editState);
            editState.setSession(this.session);
            if (this.session == null) {
                System.out.println("Edit has a null session, failure is likely");
            }
            editState.stamp();
        }
    }

    private void doUndoRedo(final Runnable runnable, final int n2) {
        Runnable runnable2 = new Runnable(){

            @Override
            public void run() {
                if (MIMUndoableEdit.this.showProgress() && !MIMUndoableEdit.this.shouldStampOnEventThread()) {
                    ProgressPanel progressPanel = new ProgressPanel();
                    if (n2 > 1) {
                        progressPanel.a(false);
                        progressPanel.a(n2);
                    } else {
                        progressPanel.a(true);
                    }
                    MIMUndoableEdit.this.prog = progressPanel;
                    ProgressQueueNotification.a(progressPanel);
                }
                try {
                    boolean bl2 = MIMUndoableEdit.this.useLoadScreen();
                    if (bl2) {
                        MIMUndoableEdit.this.session.a(this, MIMUndoableEdit.this.prog, Session.SessionLoadingJobType.a);
                    }
                    runnable.run();
                    if (bl2) {
                        MIMUndoableEdit.this.session.a((Object)this);
                    }
                    if (MIMUndoableEdit.this.session != null) {
                        MIMUndoableEdit.this.session.r().c();
                        MIMUndoableEdit.this.session.Q();
                    }
                }
                catch (Throwable throwable) {
                    ay.d((Object)"Error executing undo/redo.", throwable, MIMUndoableEdit.class);
                }
                finally {
                    MIMUndoableEdit.this.prog.b();
                }
            }
        };
        if (this.shouldStampOnEventThread()) {
            MIMSwingUtils.a(runnable2);
        } else {
            runnable2.run();
        }
    }

    @Override
    public void undo() throws CannotUndoException {
        this.doUndoRedo(new Runnable(){

            @Override
            public void run() {
                MIMUndoableEdit.this.done = false;
                for (int i2 = MIMUndoableEdit.this.oldStates.size() - 1; i2 >= 0; --i2) {
                    if (MIMUndoableEdit.this.oldStates.get(i2).getSession() == null) {
                        MIMUndoableEdit.this.oldStates.get(i2).setSession(MIMUndoableEdit.this.session);
                    }
                    MIMUndoableEdit.this.oldStates.get(i2).stamp();
                    MIMUndoableEdit.this.prog.N_();
                }
            }
        }, this.oldStates.size());
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        try {
            objectOutputStream.defaultWriteObject();
        }
        catch (IOException iOException) {
            ay.d((Object)"Error during session save for edit: ", this);
            throw new RuntimeException("Session Save Fail", iOException);
        }
    }

    protected boolean shouldStampOnEventThread() {
        return true;
    }

    protected boolean useLoadScreen() {
        return false;
    }

    protected boolean showProgress() {
        return false;
    }

    @Override
    public boolean canRedo() {
        return this.isAlive && !this.done;
    }

    @Override
    public boolean canUndo() {
        return this.isAlive && this.done;
    }

    public static class SnapshotEdit
    extends MIMUndoableEdit {
        private static final long serialVersionUID = 1L;
        private String presentationName;

        public SnapshotEdit(EditState editState, EditState editState2) {
            this(editState, editState2, "");
        }

        public SnapshotEdit(EditState editState, EditState editState2, String string) {
            this(Lists.newArrayList((Object[])new EditState[]{editState}), Lists.newArrayList((Object[])new EditState[]{editState2}), string);
        }

        public SnapshotEdit(List<? extends EditState> list, List<? extends EditState> list2) {
            this.oldStates = Lists.newArrayList(list);
            this.newStates = Lists.newArrayList(list2);
        }

        public SnapshotEdit(List<? extends EditState> list, List<? extends EditState> list2, String string) {
            this.oldStates = Lists.newArrayList(list);
            this.newStates = Lists.newArrayList(list2);
            this.presentationName = string;
        }

        @Override
        public String getPresentationName() {
            if (cn.h(this.presentationName)) {
                return super.getPresentationName();
            }
            return this.presentationName;
        }
    }
}

