/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.viewer;

import com.mimvista.numerics.MathUtils;
import java.io.Serializable;

public class BeatHistogramData
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int[] binnedData;
    private double binWidth = 10.0;
    private double startVal = 0.0;
    private float[] beatLengths;
    private int[] lowHighRR;

    public BeatHistogramData(double d2, double d3, short[] sArray) {
        this.startVal = d2;
        this.binWidth = d3;
        this.binnedData = new int[sArray.length];
        for (int i2 = 0; i2 < sArray.length; ++i2) {
            this.binnedData[i2] = sArray[i2];
        }
    }

    public double a() {
        return this.startVal;
    }

    public double b() {
        return this.binWidth;
    }

    public int[] c() {
        return this.lowHighRR;
    }

    public void a(int[] nArray) {
        this.lowHighRR = nArray;
    }

    public int[] d() {
        if (this.binnedData != null) {
            return this.binnedData;
        }
        int n2 = Math.round(MathUtils.u(this.beatLengths));
        int n3 = (int)Math.floor(((double)n2 - this.startVal) / this.binWidth + 1.0);
        this.binnedData = new int[n3];
        for (int i2 = 0; i2 < this.beatLengths.length; ++i2) {
            int n4 = Math.min(this.binnedData.length - 1, (int)(((double)this.beatLengths[i2] - this.startVal) / this.binWidth));
            this.binnedData[n4] = this.binnedData[n4] + 1;
        }
        return this.binnedData;
    }
}

