/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.viewer;

import com.mimvista.iphone.BundleSeries;
import com.mimvista.iphone.a.a;
import com.mimvista.viewer.ContrastBolusInfo;
import com.mimvista.viewer.ModalitySeriesInfo;
import com.mimvista.viewer.SeriesInfo;
import org.dcm4che2.data.DicomObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CTSeriesInfo
extends ModalitySeriesInfo {
    private static final long serialVersionUID = 1L;
    public float kvp = Float.NaN;
    public String scanOptions = "";
    public float dataCollectionDiameter = Float.NaN;
    public float reconstructionDiameter = Float.NaN;
    public float distanceSourceToDetector = Float.NaN;
    public float distanceSourceToPatient = Float.NaN;
    public int exposureTime;
    public int exposure;
    public int xrayTubeCurrent;
    public int generatorPower;
    public float[] focalSpots;
    public float gantryDetectorTilt = Float.NaN;
    public float tableHeight = Float.NaN;
    public String convolutionKernel;
    public ContrastBolusInfo contrastBolusInfo;
    private SeriesInfo info;

    public CTSeriesInfo(DicomObject dicomObject, SeriesInfo seriesInfo) {
        this(seriesInfo);
        this.kvp = dicomObject.getFloat(1572960, Float.NaN);
        this.scanOptions = dicomObject.getString(1572898, "");
        this.dataCollectionDiameter = dicomObject.getFloat(1573008, Float.NaN);
        this.reconstructionDiameter = dicomObject.getFloat(0x181100, Float.NaN);
        this.distanceSourceToDetector = dicomObject.getFloat(0x181110, Float.NaN);
        this.distanceSourceToPatient = dicomObject.getFloat(0x181111, Float.NaN);
        this.exposureTime = dicomObject.getInt(1577296, 0);
        this.exposure = dicomObject.getInt(1577298, 0);
        this.xrayTubeCurrent = dicomObject.getInt(0x181151, 0);
        this.generatorPower = dicomObject.getInt(1577328, 0);
        this.focalSpots = dicomObject.getFloats(1577360, (float[])null);
        this.gantryDetectorTilt = dicomObject.getFloat(1577248, Float.NaN);
        this.tableHeight = dicomObject.getFloat(1577264, Float.NaN);
        this.convolutionKernel = dicomObject.getString(1577488, (String)null);
        this.contrastBolusInfo = new ContrastBolusInfo(dicomObject);
    }

    public CTSeriesInfo(SeriesInfo seriesInfo) {
        this.info = seriesInfo;
    }

    @Override
    public void a(DicomObject dicomObject) {
        this.a(dicomObject, false);
    }

    public void a(DicomObject dicomObject, boolean bl2) {
        if (Float.isNaN(this.kvp)) {
            dicomObject.putNull(1572960, null);
        } else {
            dicomObject.putFloat(1572960, null, this.kvp);
        }
        dicomObject.putString(1572898, null, this.scanOptions);
        this.a(dicomObject, 1573008, this.dataCollectionDiameter);
        this.a(dicomObject, 0x181100, this.reconstructionDiameter);
        this.a(dicomObject, 0x181110, this.distanceSourceToDetector);
        this.a(dicomObject, 0x181111, this.distanceSourceToPatient);
        this.a(dicomObject, 1577296, this.exposureTime);
        this.a(dicomObject, 1577298, this.exposure);
        this.a(dicomObject, 0x181151, this.xrayTubeCurrent);
        this.a(dicomObject, 1577328, this.generatorPower);
        this.a(dicomObject, 1577360, this.focalSpots);
        if (!bl2) {
            this.a(dicomObject, 1577248, this.gantryDetectorTilt);
        }
        this.a(dicomObject, 1577264, this.tableHeight);
        this.a(dicomObject, 1577488, this.convolutionKernel);
        if (this.contrastBolusInfo != null) {
            this.contrastBolusInfo.a(dicomObject);
        }
        this.a(dicomObject, 2625620, this.info.u().z());
    }

    @Override
    public void a(Document document, Element element) {
        Element element2 = document.createElement("dict");
        if (!Float.isNaN(this.kvp)) {
            a.a(document, element, BundleSeries.PlistKey.aE, Float.toString(this.kvp));
        } else {
            a.a(document, element, BundleSeries.PlistKey.aE, "");
        }
        a.a(document, element, BundleSeries.PlistKey.aF, Integer.toString(this.exposure));
        a.a(document, element, BundleSeries.PlistKey.aG, Integer.toString(this.xrayTubeCurrent));
        a.a(document, element, BundleSeries.PlistKey.aH, this.scanOptions);
        a.a(document, element2, BundleSeries.PlistKey.aE, "kVp (kV)");
        a.a(document, element2, BundleSeries.PlistKey.aF, "Exposure (mAs)");
        a.a(document, element2, BundleSeries.PlistKey.aG, "Current (mA)");
        a.a(document, element2, BundleSeries.PlistKey.aH, "Scan Options");
        a.a(document, element2, BundleSeries.PlistKey.V, "Filter");
        a.a(document, element2, BundleSeries.PlistKey.X, "Voxel Size (mm)");
        a.a(document, BundleSeries.PlistKey.az, element);
        element.appendChild(element2);
    }

    @Override
    public float a() {
        return this.reconstructionDiameter;
    }
}

