/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.viewer;

import com.mimvista.dicom.read.AtomicLoadUnit;
import com.mimvista.viewer.MinimalDynamicSignature;
import com.mimvista.viewer.SeriesInfo;
import java.io.Serializable;

public class DynamicSignature
extends MinimalDynamicSignature
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String studyDate;
    private String studyUID;
    private int binID;

    public DynamicSignature(SeriesInfo seriesInfo) {
        super(seriesInfo);
        this.studyDate = seriesInfo.N();
        this.studyUID = seriesInfo.studyUID;
        this.binID = seriesInfo.binnedID;
    }

    public DynamicSignature(AtomicLoadUnit atomicLoadUnit) {
        super(atomicLoadUnit);
        this.studyDate = atomicLoadUnit.getStringTagValue(524320, true, null);
        this.studyUID = atomicLoadUnit.getStudyUid() != null ? atomicLoadUnit.getStudyUid().toString() : null;
        this.binID = Integer.parseInt(atomicLoadUnit.getStringTagValue(930308096, true, "-1"));
    }

    @Override
    public int hashCode() {
        int n2 = 31;
        int n3 = super.hashCode();
        n3 = 31 * n3 + (this.studyDate == null ? 0 : this.studyDate.hashCode());
        n3 = 31 * n3 + (this.studyUID == null ? 0 : this.studyUID.hashCode());
        n3 = 31 * n3 + this.binID;
        return n3;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        DynamicSignature dynamicSignature = (DynamicSignature)object;
        if (this.studyDate == null ? dynamicSignature.studyDate != null : !this.studyDate.equals(dynamicSignature.studyDate)) {
            return false;
        }
        if (this.studyUID == null) {
            if (dynamicSignature.studyUID != null) {
                return false;
            }
        } else {
            if (!this.studyUID.equals(dynamicSignature.studyUID)) {
                return false;
            }
            if (this.binID != dynamicSignature.binID) {
                return false;
            }
        }
        return true;
    }
}

