/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.viewer;

import com.mimvista.dicom.ImageOrientation;
import com.mimvista.dicom.read.AtomicLoadUnit;
import com.mimvista.viewer.SeriesInfo;
import java.io.Serializable;

public class MinimalDynamicSignature
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected String frameOfRefUID;
    protected String modality;
    protected ImageOrientation imageOrientation;

    public MinimalDynamicSignature(SeriesInfo seriesInfo) {
        this.frameOfRefUID = seriesInfo.missingFrameOfReference ? null : seriesInfo.frameOfRefUID;
        this.modality = seriesInfo.modality;
        this.imageOrientation = new ImageOrientation(seriesInfo.imageOrientation);
    }

    public MinimalDynamicSignature(AtomicLoadUnit atomicLoadUnit) {
        this.frameOfRefUID = atomicLoadUnit.getStringTagValue(0x200052, true, null);
        this.modality = atomicLoadUnit.getModality();
        String[] stringArray = atomicLoadUnit.getStringTagValues(2097207, true, null);
        this.imageOrientation = this.a(stringArray);
    }

    protected ImageOrientation a(String[] stringArray) {
        if (stringArray != null && stringArray.length == 6) {
            float[] fArray = new float[stringArray.length];
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                try {
                    fArray[i2] = Float.valueOf(stringArray[i2]).floatValue();
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    return null;
                }
            }
            return new ImageOrientation(fArray);
        }
        return null;
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + (this.frameOfRefUID == null ? 0 : this.frameOfRefUID.hashCode());
        n3 = 31 * n3 + (this.imageOrientation == null ? 0 : this.imageOrientation.hashCode());
        n3 = 31 * n3 + (this.modality == null ? 0 : this.modality.hashCode());
        return n3;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        MinimalDynamicSignature minimalDynamicSignature = (MinimalDynamicSignature)object;
        if (this.frameOfRefUID == null ? minimalDynamicSignature.frameOfRefUID != null : !this.frameOfRefUID.equals(minimalDynamicSignature.frameOfRefUID)) {
            return false;
        }
        if (this.imageOrientation == null ? minimalDynamicSignature.imageOrientation != null : !this.imageOrientation.equals(minimalDynamicSignature.imageOrientation)) {
            return false;
        }
        return !(this.modality == null ? minimalDynamicSignature.modality != null : !this.modality.equals(minimalDynamicSignature.modality));
    }
}

