/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.viewer;

import com.google.common.base.Optional;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.primitives.Ints;
import com.jayway.jsonpath.JsonPath;
import com.mimvista.d;
import com.mimvista.dicom.DicomSeries;
import com.mimvista.dicom.JsonDicomSeries;
import com.mimvista.dicom.read.RadionuclideCodeValueMapping;
import com.mimvista.dicom.util.RawDicomUtils;
import com.mimvista.dicom.util.TagPath;
import com.mimvista.internals.an;
import com.mimvista.iphone.BundleSeries;
import com.mimvista.state.ReadHelper;
import com.mimvista.util.Pair;
import com.mimvista.util.as;
import com.mimvista.util.au;
import com.mimvista.util.ay;
import com.mimvista.util.x;
import com.mimvista.viewer.BeatHistogramData;
import com.mimvista.viewer.ModalitySeriesInfo;
import com.mimvista.viewer.SeriesInfo;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.VR;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class NMSeriesInfo
extends ModalitySeriesInfo {
    private static final long serialVersionUID = 1L;
    public String collimatorGridName;
    public String collimatorGridName2;
    public String collimatorType;
    public String fieldOfViewShape;
    public int[] fieldOfViewDimensions;
    public String[] radNucCodeSequence;
    public String radPharmRoute;
    public String[] adminRouteCodeSequence;
    public float radPharmVolume = Float.NaN;
    public String radPharmStartTime;
    public String radPharmStopTime;
    public float radNucTotalDose = Float.NaN;
    public String radiopharmaceutical;
    public String[] radPharmCodeSequence;
    public String[] viewCodeSequence;
    public String[] viewModifierCodeSequence;
    public int numberOfFrames;
    public String imageID;
    public String[] detectorInfoViewCodeSequenceValues;
    public int numberOfDetectors;
    public int[] detectorVector;
    public int[] rotationVector;
    public double[] frameAngles;
    public double[] centerOfRotationOffset;
    public int[] phaseVector;
    public int[] timeSliceVector;
    public int[] energyWindowVector;
    public int numberOfEnergyWindows = 1;
    public EnergyWindowInfo[] energyWindows;
    public boolean actuallyHadPhaseInfo;
    public PhaseInfo[] phases;
    public GatedInfoItem[] gatedInfoSeq;
    public RotationInfoItem[] rotationInfoSeq;
    public int[] rrVector;
    public int actualFrameDuration;
    public boolean actuallyHadActualFrameDurationTag;
    private static final Map<String, String> a = new ImmutableMap.Builder().put((Object)"R-10242", (Object)"CC").put((Object)"R-10226", (Object)"MLO").put((Object)"R-1024A", (Object)"XCCL").put((Object)"R-1024B", (Object)"XCCM").put((Object)"R-10224", (Object)"ML").build();
    private static final Map<String, String> b = new ImmutableMap.Builder().put((Object)"R-102D3", (Object)"RL").put((Object)"R-102D4", (Object)"RM").put((Object)"R-102D5", (Object)"ID").put((Object)"R-102C2", (Object)"TAN").put((Object)"R-102D1", (Object)"AT").put((Object)"R-102D2", (Object)"CV").build();
    private static JsonPath c = new TagPath(new int[]{5505058, 5505568, 524544}, null).toJsonPath();
    private static JsonPath d = new TagPath(new int[]{5505046, 5505792, 524544}, null).toJsonPath();
    private static JsonPath e = new TagPath(new int[]{5505046, 5505792, 524548}, null).toJsonPath();
    private static JsonPath f = new TagPath(new int[]{5505042, 5505048}, null).toJsonPath();

    public NMSeriesInfo(DicomObject dicomObject) {
        int n2 = 5505058;
        this.collimatorGridName = dicomObject.getString(new int[]{n2, 0, 0x181180}, (String)null);
        this.collimatorGridName2 = dicomObject.getString(new int[]{n2, 1, 0x181180}, (String)null);
        this.collimatorType = dicomObject.getString(new int[]{n2, 0, 0x181181}, (String)null);
        this.fieldOfViewShape = dicomObject.getString(new int[]{n2, 0, 1577287}, (String)null);
        this.fieldOfViewDimensions = dicomObject.getInts(new int[]{n2, 0, 1577289}, (int[])null);
        int n3 = 5505046;
        this.radNucCodeSequence = RawDicomUtils.readCodeSequence(dicomObject, new int[]{n3, 0, 5505792});
        this.radPharmRoute = dicomObject.getString(new int[]{n3, 0, 1577072}, (String)null);
        this.adminRouteCodeSequence = RawDicomUtils.readCodeSequence(dicomObject, new int[]{n3, 0, 5505794});
        this.radPharmVolume = dicomObject.getFloat(new int[]{n3, 0, 1577073}, Float.NaN);
        this.radPharmStartTime = dicomObject.getString(new int[]{n3, 0, 1577074}, (String)null);
        this.radPharmStopTime = dicomObject.getString(new int[]{n3, 0, 1577075}, (String)null);
        this.radNucTotalDose = dicomObject.getFloat(new int[]{n3, 0, 1577076}, Float.NaN);
        this.radiopharmaceutical = dicomObject.getString(new int[]{n3, 0, 1572913}, (String)null);
        this.radPharmCodeSequence = RawDicomUtils.readCodeSequence(dicomObject, new int[]{n3, 0, 5505796});
        this.imageID = dicomObject.getString(0x540400, (String)null);
        this.numberOfFrames = dicomObject.getInt(0x280008, 1);
        this.b(dicomObject);
        this.d(dicomObject);
        this.e(dicomObject);
        this.c(dicomObject);
        this.g(dicomObject);
        this.viewCodeSequence = RawDicomUtils.readCodeSequence(dicomObject, new int[]{5505568});
        this.viewModifierCodeSequence = RawDicomUtils.readCodeSequence(dicomObject, new int[]{5505568, 0, 5505570});
        int n4 = -1;
        if (this.phases != null && this.phases.length > 0) {
            n4 = Math.round(this.phases[0].actualFrameDurationInMs);
        }
        if (dicomObject.contains(1577538)) {
            this.actuallyHadActualFrameDurationTag = true;
        }
        this.actualFrameDuration = dicomObject.getInt(new int[]{1577538}, n4);
    }

    public NMSeriesInfo() {
    }

    @Override
    public boolean c() {
        return true;
    }

    @Override
    public NMSeriesInfo d() {
        return this;
    }

    public NMSeriesInfo b() {
        NMSeriesInfo nMSeriesInfo = (NMSeriesInfo)super.clone();
        nMSeriesInfo.adminRouteCodeSequence = as.a(this.adminRouteCodeSequence);
        nMSeriesInfo.detectorInfoViewCodeSequenceValues = as.a(this.detectorInfoViewCodeSequenceValues);
        nMSeriesInfo.detectorVector = as.a(this.detectorVector);
        nMSeriesInfo.fieldOfViewDimensions = as.a(this.fieldOfViewDimensions);
        nMSeriesInfo.phases = (PhaseInfo[])as.a((au[])this.phases);
        nMSeriesInfo.phaseVector = as.a(this.phaseVector);
        nMSeriesInfo.radNucCodeSequence = as.a(this.radNucCodeSequence);
        nMSeriesInfo.radPharmCodeSequence = as.a(this.radPharmCodeSequence);
        nMSeriesInfo.timeSliceVector = as.a(this.timeSliceVector);
        nMSeriesInfo.viewCodeSequence = as.a(this.viewCodeSequence);
        nMSeriesInfo.viewModifierCodeSequence = as.a(this.viewModifierCodeSequence);
        return nMSeriesInfo;
    }

    public void a(int n2, int n3) {
        Pair pair;
        ArrayList<Object> arrayList;
        if (n2 < 0 || n3 <= n2) {
            throw new IllegalArgumentException("Cannot slice the NMSeriesInfo: startIdx=" + n2 + ", endIdx=" + n3);
        }
        this.centerOfRotationOffset = NMSeriesInfo.a(this.centerOfRotationOffset, n2, n3);
        this.frameAngles = NMSeriesInfo.a(this.frameAngles, n2, n3);
        this.rotationVector = NMSeriesInfo.b(this.rotationVector, n2, n3);
        this.numberOfFrames = n3 - n2;
        if (this.energyWindows != null && this.energyWindowVector != null) {
            arrayList = new ArrayList<Object>();
            arrayList.addAll(Arrays.asList(this.energyWindows));
            pair = NMSeriesInfo.a(this.energyWindowVector, arrayList, n2, n3);
            this.energyWindowVector = (int[])pair.x;
            this.energyWindows = ((List)pair.y).toArray(new EnergyWindowInfo[0]);
            this.numberOfEnergyWindows = this.energyWindows.length;
        }
        if (this.detectorInfoViewCodeSequenceValues != null && this.detectorVector != null) {
            arrayList = new ArrayList();
            arrayList.addAll(Arrays.asList(this.detectorInfoViewCodeSequenceValues));
            pair = NMSeriesInfo.a(this.detectorVector, arrayList, n2, n3);
            this.detectorVector = (int[])pair.x;
            this.detectorInfoViewCodeSequenceValues = ((List)pair.y).toArray(new String[0]);
            this.numberOfDetectors = this.detectorInfoViewCodeSequenceValues.length;
        }
        if (this.phases != null && this.phaseVector != null) {
            arrayList = new ArrayList();
            arrayList.addAll(Arrays.asList(this.phases));
            pair = NMSeriesInfo.a(this.phaseVector, arrayList, n2, n3);
            this.phaseVector = (int[])pair.x;
            this.phases = ((List)pair.y).toArray(new PhaseInfo[0]);
            this.actualFrameDuration = (int)this.phases[this.phaseVector[0] - 1].actualFrameDurationInMs;
            for (int i2 = 0; i2 < this.phases.length; ++i2) {
                PhaseInfo phaseInfo = this.phases[i2];
                phaseInfo.phaseIdx = i2;
                phaseInfo.numberOfFramesInPhase = 0;
            }
            for (int n4 : this.phaseVector) {
                ++this.phases[n4 - 1].numberOfFramesInPhase;
            }
        }
        if (this.rrVector != null && this.gatedInfoSeq != null) {
            arrayList = new ArrayList();
            arrayList.addAll(Arrays.asList(this.gatedInfoSeq));
            pair = NMSeriesInfo.a(this.rrVector, arrayList, n2, n3);
            this.rrVector = (int[])pair.x;
            this.gatedInfoSeq = ((List)pair.y).toArray(new GatedInfoItem[0]);
        }
        this.timeSliceVector = NMSeriesInfo.b(this.timeSliceVector, n2, n3);
        if (this.timeSliceVector != null && this.phaseVector != null && this.phases != null) {
            if (this.phases.length == 1) {
                NMSeriesInfo.a(this.timeSliceVector, 0, this.timeSliceVector.length);
            } else {
                int n5;
                int n6 = this.phaseVector.length;
                for (n5 = 1; n5 < this.phaseVector.length; ++n5) {
                    if (this.phaseVector[n5] == this.phaseVector[n5 - 1]) continue;
                    n6 = n5;
                    break;
                }
                n5 = 0;
                for (int i3 = this.phaseVector.length - 2; i3 >= 0; --i3) {
                    if (this.phaseVector[i3] == this.phaseVector[i3 + 1]) continue;
                    n5 = i3;
                    break;
                }
                NMSeriesInfo.a(this.timeSliceVector, 0, n6);
                NMSeriesInfo.a(this.timeSliceVector, n5, this.timeSliceVector.length);
            }
        }
    }

    private static void a(int[] nArray, int n2, int n3) {
        int n4;
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        for (int i2 = n2; i2 < n3; ++i2) {
            treeSet.add(nArray[i2]);
        }
        ArrayList arrayList = Lists.newArrayList();
        arrayList.addAll(treeSet);
        Collections.sort(arrayList);
        HashMap hashMap = new HashMap();
        for (n4 = 0; n4 < arrayList.size(); ++n4) {
            hashMap.put(arrayList.get(n4), n4 + 1);
        }
        for (n4 = n2; n4 < n3; ++n4) {
            nArray[n4] = (Integer)hashMap.get(nArray[n4]);
        }
    }

    private static int[] b(int[] nArray, int n2, int n3) {
        if (nArray == null) {
            return null;
        }
        if (n3 > nArray.length) {
            return Arrays.copyOf(nArray, nArray.length);
        }
        return Arrays.copyOfRange(nArray, n2, n3);
    }

    private static double[] a(double[] dArray, int n2, int n3) {
        if (dArray == null) {
            return null;
        }
        if (n3 > dArray.length) {
            return Arrays.copyOf(dArray, dArray.length);
        }
        return Arrays.copyOfRange(dArray, n2, n3);
    }

    private static <X> Pair<int[], List<X>> a(int[] nArray, List<X> list, int n2, int n3) {
        int[] nArray2 = Arrays.copyOfRange(nArray, n2, n3);
        ArrayList arrayList = Lists.newArrayList();
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        for (int n4 : nArray2) {
            if (hashMap.containsKey(n4)) continue;
            arrayList.add(list.get(n4 - 1));
            hashMap.put(n4, arrayList.size());
        }
        for (int i2 = 0; i2 < nArray2.length; ++i2) {
            nArray2[i2] = (Integer)hashMap.get(nArray2[i2]);
        }
        return Pair.get(nArray2, arrayList);
    }

    @Override
    public void a(DicomObject dicomObject) {
        int n2;
        au<EnergyWindowInfo> au2;
        int n3;
        if (this.collimatorGridName == null && this.collimatorType == null && this.fieldOfViewShape == null && this.fieldOfViewDimensions == null) {
            dicomObject.putNull(5505058, VR.SQ);
        } else {
            this.a(dicomObject, new int[]{5505058, 0, 0x181180}, this.collimatorGridName);
            this.a(dicomObject, new int[]{5505058, 0, 0x181181}, this.collimatorType);
            this.a(dicomObject, new int[]{5505058, 0, 1577287}, this.fieldOfViewShape);
            this.a(dicomObject, new int[]{5505058, 0, 1577289}, this.fieldOfViewDimensions);
        }
        int n4 = 5505046;
        dicomObject.putSequence(n4);
        RawDicomUtils.writeCodeSequence(dicomObject, new int[]{n4, 0, 5505792}, this.radNucCodeSequence);
        this.a(dicomObject, new int[]{n4, 0, 1577072}, this.radPharmRoute);
        RawDicomUtils.writeCodeSequence(dicomObject, new int[]{n4, 0, 5505794}, this.adminRouteCodeSequence);
        this.a(dicomObject, new int[]{n4, 0, 1577073}, this.radPharmVolume);
        this.a(dicomObject, new int[]{n4, 0, 1577074}, this.radPharmStartTime);
        this.a(dicomObject, new int[]{n4, 0, 1577075}, this.radPharmStopTime);
        this.a(dicomObject, new int[]{n4, 0, 1577076}, this.radNucTotalDose);
        this.a(dicomObject, new int[]{n4, 0, 1572913}, this.radiopharmaceutical);
        if (this.actuallyHadActualFrameDurationTag) {
            this.a(dicomObject, new int[]{1577538}, this.actualFrameDuration);
        }
        RawDicomUtils.writeCodeSequence(dicomObject, new int[]{n4, 0, 5505796}, this.radPharmCodeSequence);
        try {
            if (this.phaseVector != null && this.timeSliceVector != null && this.phases != null && this.actuallyHadPhaseInfo) {
                this.a(dicomObject, 5505073, this.phases.length);
                this.a(dicomObject, 5505072, this.phaseVector);
                this.a(dicomObject, 5505280, this.timeSliceVector);
                n3 = 0;
                while (n3 < this.phases.length) {
                    au2 = this.phases[n3];
                    this.a(dicomObject, new int[]{5505074, n3, 5505078}, Math.round(((PhaseInfo)au2).phaseDelayInMs));
                    this.a(dicomObject, new int[]{5505074, n3, 1577538}, Math.round(((PhaseInfo)au2).actualFrameDurationInMs));
                    this.a(dicomObject, new int[]{5505074, n3, 5505080}, Math.round(((PhaseInfo)au2).pauseBetweenFramesInMs));
                    this.a(dicomObject, new int[]{5505074, n3, 5505075}, ((PhaseInfo)au2).numberOfFramesInPhase);
                    this.a(dicomObject, new int[]{5505074, n3, 5505553}, ((PhaseInfo)au2).numberOfTriggersInPhase);
                    this.a(dicomObject, new int[]{5505074, n3, 5505552}, ((PhaseInfo)au2).triggerVector);
                    this.a(dicomObject, new int[]{5505074, n3++, 5505081}, ((PhaseInfo)au2).phaseDescription);
                }
            }
        }
        catch (Throwable throwable) {
            ay.d((Object)"Error saving phase information.", throwable, this);
        }
        try {
            if (this.energyWindowVector != null && this.energyWindows != null) {
                this.a(dicomObject, 5505041, this.numberOfEnergyWindows);
                this.a(dicomObject, 5505040, this.energyWindowVector);
                for (n3 = 0; n3 < this.energyWindows.length; ++n3) {
                    au2 = this.energyWindows[n3];
                    this.a(dicomObject, new int[]{5505042, n3, 5505048}, au2.windowName);
                    if (au2.rangeLimits == null) continue;
                    n2 = 0;
                    while (n3 < au2.rangeLimits.size()) {
                        EnergyWindowRangeLimit energyWindowRangeLimit = au2.rangeLimits.get(n3);
                        this.a(dicomObject, new int[]{5505042, n3, 5505043, n2, 5505044}, energyWindowRangeLimit.lower);
                        this.a(dicomObject, new int[]{5505042, n3++, 5505043, n2, 5505045}, energyWindowRangeLimit.upper);
                    }
                }
            }
        }
        catch (Throwable throwable) {
            ay.d((Object)"Error saving energy window information.", throwable, this);
        }
        try {
            if (this.detectorVector != null && this.detectorInfoViewCodeSequenceValues != null) {
                this.a(dicomObject, 5505057, this.numberOfDetectors);
                this.a(dicomObject, 5505056, this.detectorVector);
            }
        }
        catch (Throwable throwable) {
            ay.d((Object)"Error saving detector information.", throwable, this);
        }
        try {
            if (this.frameAngles != null && this.centerOfRotationOffset != null && this.rotationVector != null && this.detectorVector != null) {
                this.a(dicomObject, 0x540050, this.rotationVector);
                int n5 = -1;
                int n6 = -1;
                for (n2 = 0; n2 < this.numberOfFrames; ++n2) {
                    int n7 = this.rotationVector[n2] - 1;
                    int n8 = this.detectorVector[n2] - 1;
                    if (n7 != n5) {
                        this.a(dicomObject, new int[]{5505106, n7, 5505536}, this.frameAngles[n2]);
                        double d2 = 0.0;
                        if (n2 + 1 < this.numberOfFrames && this.rotationVector[n2 + 1] == this.rotationVector[n2]) {
                            d2 = this.frameAngles[n2 + 1] - this.frameAngles[n2];
                            if (d2 < 0.0) {
                                this.a(dicomObject, new int[]{5505106, n7, 1577280}, "CW");
                                d2 = -d2;
                            } else {
                                this.a(dicomObject, new int[]{5505106, n7, 1577280}, "CC");
                            }
                            this.a(dicomObject, new int[]{5505106, n7, 0x181144}, d2);
                        }
                    }
                    if (n8 != n6) {
                        this.a(dicomObject, new int[]{5505058, n8, 5505536}, this.frameAngles[n2]);
                        this.a(dicomObject, new int[]{5505058, n8, 1577285}, this.centerOfRotationOffset[n2]);
                    }
                    n5 = n7;
                    n6 = n8;
                }
            }
        }
        catch (Throwable throwable) {
            ay.d((Object)"Error saving rotation information.", throwable, this);
        }
        if (this.imageID != null && !this.imageID.isEmpty()) {
            this.a(dicomObject, 0x540400, this.imageID);
        }
    }

    protected void a(DicomObject dicomObject, int[] nArray, int n2) {
        if (n2 >= 0) {
            dicomObject.putInt(nArray, null, n2);
        }
    }

    @Override
    protected void a(DicomObject dicomObject, int[] nArray, float f2) {
        if (!Float.isNaN(f2)) {
            dicomObject.putFloat(nArray, null, f2);
        }
    }

    @Override
    protected void a(DicomObject dicomObject, int[] nArray, String string) {
        if (string != null) {
            dicomObject.putString(nArray, null, string);
        } else {
            dicomObject.putString(nArray, null, "");
        }
    }

    private void a(DicomObject dicomObject, int[] nArray, int[] nArray2) {
        if (nArray2 != null) {
            dicomObject.putInts(nArray, null, nArray2);
        }
    }

    protected void a(DicomObject dicomObject, int n2, int[] nArray) {
        if (nArray != null) {
            dicomObject.putInts(n2, null, nArray);
        }
    }

    protected void a(DicomObject dicomObject, int[] nArray, String[] stringArray) {
        if (stringArray != null) {
            dicomObject.putStrings(nArray, null, stringArray);
        }
    }

    protected void a(DicomObject dicomObject, int[] nArray, double d2) {
        if (!Double.isNaN(d2)) {
            dicomObject.putDouble(nArray, null, d2);
        }
    }

    @Override
    public void a(Document document, Element element) {
        Element element2 = document.createElement("dict");
        com.mimvista.iphone.a.a.a(document, element2, BundleSeries.PlistKey.X, "Voxel Size (mm)");
        com.mimvista.iphone.a.a.a(document, "diagnosticallyRelevant", element);
        element.appendChild(element2);
    }

    public void a(DicomObject dicomObject, int n2) {
        if (this.phases != null && this.phases.length > 0) {
            for (int i2 = 0; i2 < this.phases.length; ++i2) {
                this.b(dicomObject, new int[]{5505122, i2, 5505123}, this.phases[i2].actualFrameDurationInMs);
            }
        } else {
            this.b(dicomObject, new int[]{5505122, 0, 5505123}, this.actualFrameDuration);
        }
        if (!this.actuallyHadPhaseInfo && this.timeSliceVector != null && this.timeSliceVector.length == n2) {
            dicomObject.putInts(5505136, null, this.timeSliceVector);
        }
    }

    private void b(DicomObject dicomObject, int[] nArray, float f2) {
        int[] nArray2 = new int[nArray.length + 2];
        int n2 = nArray2.length;
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        nArray2[n2 - 2] = 0;
        nArray2[n2 - 1] = 1577059;
        dicomObject.putFloat(nArray2, null, f2);
    }

    public Integer a(int n2) {
        if (this.detectorVector == null) {
            return null;
        }
        return this.detectorVector[n2];
    }

    public String b(int n2) {
        EnergyWindowInfo energyWindowInfo = this.c(n2);
        if (energyWindowInfo == null) {
            return null;
        }
        return energyWindowInfo.a();
    }

    public boolean e() {
        return this.numberOfFrames > 1;
    }

    public EnergyWindowInfo c(int n2) {
        if (this.energyWindowVector == null) {
            return null;
        }
        if (n2 >= this.energyWindowVector.length || n2 < 0) {
            return null;
        }
        return this.energyWindows[this.energyWindowVector[n2] - 1];
    }

    private void b(DicomObject dicomObject) {
        a a2 = NMSeriesInfo.a(new JsonDicomSeries(dicomObject));
        if (a2 == null) {
            return;
        }
        this.numberOfDetectors = a2.a;
        this.detectorVector = a2.b;
        this.detectorInfoViewCodeSequenceValues = a2.c;
    }

    private void c(DicomObject dicomObject) {
        try {
            Object object;
            int n2;
            int n3;
            this.frameAngles = new double[this.numberOfFrames];
            this.centerOfRotationOffset = new double[this.numberOfFrames];
            this.rotationVector = dicomObject.getInts(0x540050);
            if (this.rotationVector == null || this.rotationVector.length == 0) {
                return;
            }
            int n4 = -1;
            int n5 = -1;
            double d2 = Double.NaN;
            double d3 = Double.NaN;
            for (n3 = 0; n3 < this.numberOfFrames; ++n3) {
                double d4;
                int n6 = this.rotationVector[n3] - 1;
                n2 = this.detectorVector[n3] - 1;
                if (n6 != n4) {
                    d2 = dicomObject.getDouble(new int[]{5505106, n6, 5505536});
                    d3 = dicomObject.getDouble(new int[]{5505106, n6, 0x181144});
                    object = dicomObject.getString(new int[]{5505106, n6, 1577280});
                    if ("CW".equalsIgnoreCase((String)object)) {
                        d3 = -d3;
                    }
                }
                if (n2 != n5 && !Double.isNaN(d4 = dicomObject.getDouble(new int[]{5505058, n2, 5505536}, Double.NaN))) {
                    d2 = d4;
                }
                this.centerOfRotationOffset[n3] = dicomObject.getDouble(new int[]{5505058, n2, 1577285}, 0.0);
                this.frameAngles[n3] = d2;
                d2 += d3;
                n4 = n6;
                n5 = n2;
            }
            n3 = dicomObject.vm(5505058);
            ArrayList arrayList = Lists.newArrayList();
            n2 = 0;
            while (n2 < n3) {
                object = new RotationInfoItem();
                arrayList.add(object);
                ((RotationInfoItem)object).angularStep = dicomObject.getDouble(new int[]{5505106, n2, 0x181144}, 0.0);
                ((RotationInfoItem)object).numberOfFramesInRotation = dicomObject.getInt(new int[]{5505106, n2, 5505107}, 0);
                ((RotationInfoItem)object).radialPosition = dicomObject.getDouble(new int[]{5505106, n2, 1577282}, 0.0);
                ((RotationInfoItem)object).rotationDirection = dicomObject.getString(new int[]{5505106, n2, 1577280}, "");
                ((RotationInfoItem)object).scanArc = dicomObject.getDouble(new int[]{5505106, n2, 1577283}, 0.0);
                ((RotationInfoItem)object).startAngle = dicomObject.getDouble(new int[]{5505106, n2, 5505536}, 0.0);
                ((RotationInfoItem)object).tableHeight = dicomObject.getDouble(new int[]{5505106, n2, 1577264}, 0.0);
                ((RotationInfoItem)object).tableTraverse = dicomObject.getDouble(new int[]{5505106, n2++, 0x181131}, 0.0);
            }
            this.rotationInfoSeq = arrayList.toArray(new RotationInfoItem[0]);
        }
        catch (Throwable throwable) {
            ay.d((Object)"Error reading detector angles", throwable, this);
        }
    }

    private void d(DicomObject dicomObject) {
        if (!(dicomObject.contains(5505074) && dicomObject.contains(5505072) && dicomObject.contains(5505280))) {
            this.f(dicomObject);
            return;
        }
        this.actuallyHadPhaseInfo = true;
        int n2 = dicomObject.getInt(5505073);
        this.phaseVector = dicomObject.getInts(5505072);
        this.timeSliceVector = dicomObject.getInts(5505280);
        this.phases = new PhaseInfo[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            PhaseInfo phaseInfo = new PhaseInfo();
            phaseInfo.phaseIdx = i2;
            phaseInfo.phaseDelayInMs = dicomObject.getInt(new int[]{5505074, i2, 5505078});
            phaseInfo.actualFrameDurationInMs = dicomObject.getInt(new int[]{5505074, i2, 1577538});
            phaseInfo.pauseBetweenFramesInMs = dicomObject.getInt(new int[]{5505074, i2, 5505080});
            phaseInfo.numberOfFramesInPhase = dicomObject.getInt(new int[]{5505074, i2, 5505075});
            phaseInfo.numberOfTriggersInPhase = dicomObject.getInt(new int[]{5505074, i2, 5505553});
            phaseInfo.triggerVector = dicomObject.getInts(new int[]{5505074, i2, 5505552});
            phaseInfo.phaseDescription = dicomObject.getString(new int[]{5505074, i2, 5505081});
            this.phases[i2] = phaseInfo;
        }
    }

    private void e(DicomObject dicomObject) {
        b b2 = NMSeriesInfo.b(new JsonDicomSeries(dicomObject));
        if (b2 == null) {
            return;
        }
        this.numberOfEnergyWindows = b2.a;
        this.energyWindowVector = b2.b;
        this.energyWindows = b2.c;
    }

    private void f(DicomObject dicomObject) {
        if (!dicomObject.contains(5505122) || !dicomObject.contains(5505136)) {
            return;
        }
        try {
            int n2;
            int[] nArray = dicomObject.getInts(5505136);
            int n3 = dicomObject.getInt(0x280008, nArray.length);
            PhaseInfo phaseInfo = new PhaseInfo();
            phaseInfo.phaseIdx = 0;
            phaseInfo.phaseDelayInMs = dicomObject.getInt(5505078, 0);
            JsonPath jsonPath = new TagPath(new int[]{5505122, 5505123, 1577059}, null).toJsonPath();
            JsonDicomSeries jsonDicomSeries = new JsonDicomSeries(dicomObject);
            float f2 = 0.0f;
            if (jsonDicomSeries.exists(jsonPath)) {
                Object t2 = jsonDicomSeries.getTagValue(jsonPath);
                if (t2 instanceof Number) {
                    f2 = ((Number)t2).floatValue();
                } else if (t2 != null) {
                    try {
                        f2 = Float.valueOf(t2.toString()).floatValue();
                    }
                    catch (NumberFormatException numberFormatException) {
                        f2 = 0.0f;
                    }
                }
            }
            if (f2 > 0.0f) {
                phaseInfo.actualFrameDurationInMs = f2;
            } else if (dicomObject.contains(1577538) && (n2 = dicomObject.getInt(1577538, 0)) > 0) {
                phaseInfo.actualFrameDurationInMs = n2;
            }
            phaseInfo.pauseBetweenFramesInMs = dicomObject.getInt(5505080, 0);
            phaseInfo.numberOfFramesInPhase = n3;
            if (phaseInfo.actualFrameDurationInMs == 0.0f) {
                return;
            }
            this.phases = new PhaseInfo[]{phaseInfo};
            this.timeSliceVector = nArray;
            this.phaseVector = new int[n3];
            Arrays.fill(this.phaseVector, 1);
        }
        catch (Exception exception) {
            ay.d((Object)"Can't create phase info.", (Throwable)exception, this.getClass());
        }
    }

    private void g(DicomObject dicomObject) {
        if (!dicomObject.contains(5505122)) {
            return;
        }
        this.rrVector = dicomObject.getInts(new int[]{5505120});
        this.gatedInfoSeq = new GatedInfoItem[dicomObject.getInt(new int[]{5505121})];
        for (int i2 = 0; i2 < dicomObject.getInt(new int[]{5505121}); ++i2) {
            Object object;
            GatedInfoItem gatedInfoItem = new GatedInfoItem();
            DicomObject dicomObject2 = dicomObject.get(5505122).getDicomObject(i2);
            gatedInfoItem.a((Float)x.b(dicomObject2, 1577056).orNull());
            gatedInfoItem.a((Integer)x.a(dicomObject, 0x181088).orNull());
            int n2 = dicomObject2.get(5505123).countItems();
            for (int i3 = 0; i3 < n2; ++i3) {
                DicomObject dicomObject3 = dicomObject2.get(5505123).getDicomObject(i3);
                object = new DataSequenceItem();
                ((DataSequenceItem)object).a((Integer)x.a(dicomObject3, 1577058).orNull());
                ((DataSequenceItem)object).a((Float)x.b(dicomObject3, 1577059).orNull());
                ((DataSequenceItem)object).c((Integer)x.a(dicomObject3, 0x181081).orNull());
                ((DataSequenceItem)object).b((Integer)x.a(dicomObject3, 1577090).orNull());
                ((DataSequenceItem)object).d((Integer)x.a(dicomObject3, 1577091).orNull());
                ((DataSequenceItem)object).e((Integer)x.a(dicomObject3, 1577092).orNull());
                gatedInfoItem.dataSeq.add((DataSequenceItem)object);
            }
            this.gatedInfoSeq[i2] = gatedInfoItem;
            if (dicomObject.getString(524400).toLowerCase().contains("siemens")) {
                int n3;
                if (!(dicomObject.contains(0x50000005) && dicomObject.getShorts(0x50000005)[0] == 2 && dicomObject.contains(0x50000022) && dicomObject.getString(0x50000022).equalsIgnoreCase("beat histogram") || dicomObject.contains(0x50000040) && (dicomObject.getStrings(0x50000040)[0].equalsIgnoreCase("ms/beat") || dicomObject.getStrings(0x50000040)[0].equalsIgnoreCase("msec / beat")) && dicomObject.getStrings(0x50000040)[1].equalsIgnoreCase("beats"))) {
                    return;
                }
                short[] sArray = dicomObject.getShorts(0x50003000);
                if (sArray.length == (n3 = dicomObject.getShorts(0x50000010)[0])) {
                    double d2 = dicomObject.getShorts(1342177554)[0];
                    double d3 = dicomObject.getShorts(1342177556)[0];
                    this.gatedInfoSeq[i2].beatHist = new BeatHistogramData(d2, d3, sArray);
                } else if (sArray.length == n3 * 2) {
                    object = new short[n3];
                    double d4 = sArray[0];
                    double d5 = sArray[2] - sArray[0];
                    for (int i4 = 0; i4 < n3; ++i4) {
                        object[i4] = sArray[2 * i4 + 1];
                    }
                    this.gatedInfoSeq[i2].beatHist = new BeatHistogramData(d4, d5, (short[])object);
                }
                if (this.gatedInfoSeq[i2].dataSeq.size() > 0 && this.gatedInfoSeq[i2].beatHist != null) {
                    int n4 = Integer.MIN_VALUE;
                    int n5 = Integer.MAX_VALUE;
                    for (DataSequenceItem dataSequenceItem : this.gatedInfoSeq[i2].dataSeq) {
                        n4 = Math.max((Integer)dataSequenceItem.d().or((Object)Integer.MIN_VALUE), n4);
                        n5 = Math.min((Integer)dataSequenceItem.e().or((Object)Integer.MAX_VALUE), n5);
                    }
                    if (n4 != Integer.MIN_VALUE && n5 != Integer.MAX_VALUE) {
                        this.gatedInfoSeq[i2].beatHist.a(new int[]{n5, n4});
                    }
                }
            }
            if (!dicomObject.contains(5505168)) continue;
            this.gatedInfoSeq[i2].angularViewVector = dicomObject.getShorts(5505168);
        }
    }

    public int d(int n2) {
        if (this.phases == null || this.phaseVector.length <= n2) {
            throw new IllegalArgumentException("Frame number " + n2 + " out of range as not enough phases available.");
        }
        return this.phaseVector[n2] - 1;
    }

    public PhaseInfo e(int n2) {
        return this.phases[this.d(n2)];
    }

    public int a(int n2, an an2) {
        for (int i2 = 0; i2 < an2.n(); ++i2) {
            PhaseInfo phaseInfo = this.e(an2.d(i2).c());
            if (phaseInfo.a() != n2) continue;
            return i2;
        }
        return -1;
    }

    public int b(int n2, an an2) {
        boolean bl2 = false;
        for (int i2 = 0; i2 < an2.n(); ++i2) {
            PhaseInfo phaseInfo = this.e(an2.d(i2).c());
            int n3 = phaseInfo.a();
            if (!bl2 && n3 == n2) {
                bl2 = true;
                continue;
            }
            if (!bl2 || n3 == n2) continue;
            return i2 - 1;
        }
        return an2.n() - 1;
    }

    public int f() {
        if (this.phases == null) {
            return 1;
        }
        return this.phases.length;
    }

    public boolean g() {
        return this.actualFrameDuration > 0 || this.phases != null && this.phases.length > 0;
    }

    public Pair<Integer, Integer> f(int n2) throws IllegalArgumentException {
        int n3;
        if (n2 == 0 && this.phases == null && this.actualFrameDuration > 0) {
            return Pair.get(0, this.actualFrameDuration);
        }
        PhaseInfo phaseInfo = this.e(n2);
        float f2 = 0.0f;
        for (n3 = 0; n3 < phaseInfo.phaseIdx; ++n3) {
            PhaseInfo phaseInfo2 = this.phases[n3];
            f2 += phaseInfo2.phaseDelayInMs;
            f2 += (float)(phaseInfo2.numberOfFramesInPhase - 1) * phaseInfo2.pauseBetweenFramesInMs;
            f2 += (float)phaseInfo2.numberOfFramesInPhase * phaseInfo2.actualFrameDurationInMs;
        }
        f2 += phaseInfo.phaseDelayInMs;
        n3 = this.timeSliceVector[n2] - 1;
        if (n3 > 0) {
            f2 += phaseInfo.pauseBetweenFramesInMs * (float)(n3 - 1);
        }
        return Pair.get(Math.round(f2 += phaseInfo.actualFrameDurationInMs * (float)n3), Math.round(phaseInfo.actualFrameDurationInMs));
    }

    public boolean b(SeriesInfo seriesInfo) {
        return NMSeriesInfo.a(seriesInfo.manufacturer, seriesInfo.modelName);
    }

    public GatedInfoItem g(int n2) {
        return this.gatedInfoSeq[this.rrVector[n2]];
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        ReadHelper readHelper = new ReadHelper();
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        readHelper.a("actuallyHadActualFrameDurationTag", (Object)true);
        readHelper.a("actuallyHadPhaseInfo", (Object)true);
        readHelper.a(getField, (Object)this);
    }

    public static boolean a(String string, String string2) {
        string = string == null ? "" : string.toUpperCase();
        string2 = string2 == null ? "" : string2.toUpperCase();
        return string.contains("GAMMA MEDICA") && string2.contains("LUMAGEM");
    }

    public static boolean b(String string, String string2) {
        string = string == null ? "" : string.toUpperCase();
        string2 = string2 == null ? "" : string2.toUpperCase();
        boolean bl2 = string.contains("PHILIPS") || string.contains("ADAC");
        boolean bl3 = string2.contains("SKYLIGHT");
        boolean bl4 = string2.contains("BRIGHTVIEW");
        return bl2 && (bl3 || bl4);
    }

    private static boolean a(SeriesInfo seriesInfo, String string) {
        if (!seriesInfo.W()) {
            return false;
        }
        String string2 = (String)seriesInfo.y().getTagValue(0x540400);
        if (string2 == null) {
            string2 = "";
        }
        string2 = string2.toLowerCase();
        return string2.contains(string.toLowerCase());
    }

    public static boolean c(SeriesInfo seriesInfo) {
        return NMSeriesInfo.a(seriesInfo, "ant");
    }

    public static boolean d(SeriesInfo seriesInfo) {
        return NMSeriesInfo.a(seriesInfo, "post");
    }

    public String e(SeriesInfo seriesInfo) {
        String string;
        if (seriesInfo.protocolName.contains("INJECTION SITE")) {
            return "INJ. Site";
        }
        String string2 = "";
        if (!seriesInfo.imageLaterality.isEmpty()) {
            string2 = seriesInfo.imageLaterality;
        }
        String string3 = "";
        if (this.viewCodeSequence != null && a.containsKey(string = this.viewCodeSequence[1])) {
            string3 = a.get(string);
        }
        string = "";
        if (this.viewModifierCodeSequence != null) {
            String string4 = this.viewModifierCodeSequence[1];
            if (b.containsKey(string4)) {
                string = b.get(string4);
            }
            if ("AT".equals(string)) {
                string3 = "";
            }
            if ("CV".equals(string)) {
                string3 = "";
                string2 = "";
            }
        }
        return string2 + string3 + string;
    }

    public static a a(DicomSeries dicomSeries) {
        ImmutableList immutableList;
        int[] nArray;
        Object[] objectArray;
        Integer n2;
        JsonDicomSeries jsonDicomSeries = JsonDicomSeries.castOrConvert(dicomSeries);
        if (!jsonDicomSeries.exists(5505057) || !jsonDicomSeries.exists(5505056)) {
            return null;
        }
        try {
            n2 = (Integer)jsonDicomSeries.getTagValue(5505057);
        }
        catch (Throwable throwable) {
            ay.d((Object)"Error parsing NumberOfDetectors", throwable, NMSeriesInfo.class);
            return null;
        }
        if (n2 == null || n2 < 1) {
            n2 = 1;
        }
        try {
            objectArray = jsonDicomSeries.getTagValues(5505056);
            nArray = Ints.toArray(objectArray);
        }
        catch (Throwable throwable) {
            ay.d((Object)"Error parsing DetectorVector", throwable, NMSeriesInfo.class);
            return null;
        }
        objectArray = new String[n2.intValue()];
        Arrays.fill(objectArray, "");
        if (jsonDicomSeries.exists(c)) {
            try {
                immutableList = jsonDicomSeries.getTagValues(c);
                if (immutableList != null) {
                    for (int i2 = 0; i2 < objectArray.length && i2 < immutableList.size(); ++i2) {
                        String string = (String)immutableList.get(i2);
                        if (string == null) continue;
                        objectArray[i2] = string;
                    }
                }
            }
            catch (Throwable throwable) {
                ay.d((Object)"Error parsing DetectorInformationSequence.ViewCodeSequence.CodeValue", throwable, NMSeriesInfo.class);
            }
        }
        immutableList = new ImmutableList();
        immutableList.a = n2;
        immutableList.b = nArray;
        immutableList.c = objectArray;
        return immutableList;
    }

    public static b b(DicomSeries dicomSeries) {
        ImmutableList<DicomSeries> immutableList;
        Object object;
        int[] nArray;
        EnergyWindowInfo[] energyWindowInfoArray;
        Integer n2;
        JsonDicomSeries jsonDicomSeries = JsonDicomSeries.castOrConvert(dicomSeries);
        if (!jsonDicomSeries.exists(5505041) || !jsonDicomSeries.exists(5505040)) {
            return null;
        }
        try {
            n2 = (Integer)jsonDicomSeries.getTagValue(5505041);
        }
        catch (Throwable throwable) {
            ay.d((Object)"Error getting NumberOfEnergyWindows", throwable, NMSeriesInfo.class);
            return null;
        }
        if (n2 == null || n2 < 1) {
            n2 = 1;
        }
        try {
            energyWindowInfoArray = jsonDicomSeries.getTagValues(5505040);
            nArray = Ints.toArray(energyWindowInfoArray);
        }
        catch (Throwable throwable) {
            ay.d((Object)"Error parseing EnergyWindowVector", throwable, NMSeriesInfo.class);
            return null;
        }
        energyWindowInfoArray = new EnergyWindowInfo[n2.intValue()];
        for (int i2 = 0; i2 < energyWindowInfoArray.length; ++i2) {
            energyWindowInfoArray[i2] = new EnergyWindowInfo();
        }
        for (JsonPath jsonPath : new JsonPath[]{d, e, f}) {
            if (!jsonDicomSeries.exists(jsonPath)) continue;
            try {
                ImmutableList immutableList2 = jsonDicomSeries.getTagValues(jsonPath);
                if (immutableList2 == null) continue;
                for (int i3 = 0; i3 < energyWindowInfoArray.length && i3 < immutableList2.size(); ++i3) {
                    object = (String)immutableList2.get(i3);
                    if (object == null) continue;
                    if (jsonPath == d) {
                        energyWindowInfoArray[i3].radInfoCodeValue = object;
                        continue;
                    }
                    if (jsonPath == e) {
                        energyWindowInfoArray[i3].radInfoCodeMeaning = object;
                        continue;
                    }
                    if (jsonPath != f) continue;
                    energyWindowInfoArray[i3].windowName = object;
                }
            }
            catch (Throwable throwable) {
                ay.d((Object)("Error parsing " + jsonPath.getPath()), throwable, NMSeriesInfo.class);
            }
        }
        if (jsonDicomSeries.exists(5505042)) {
            try {
                immutableList = jsonDicomSeries.getTagSequence(5505042);
                if (immutableList != null) {
                    for (int i4 = 0; i4 < energyWindowInfoArray.length && i4 < immutableList.size(); ++i4) {
                        ImmutableList<? extends DicomSeries> immutableList3;
                        DicomSeries dicomSeries2 = (DicomSeries)immutableList.get(i4);
                        if (!dicomSeries2.exists(5505043) || (immutableList3 = dicomSeries2.getTagSequence(5505043)) == null) continue;
                        for (DicomSeries dicomSeries3 : immutableList3) {
                            object = new EnergyWindowRangeLimit();
                            if (dicomSeries3.exists(5505044)) {
                                ((EnergyWindowRangeLimit)object).lower = (Double)dicomSeries3.getTagValue(5505044);
                            }
                            if (dicomSeries3.exists(5505045)) {
                                ((EnergyWindowRangeLimit)object).upper = (Double)dicomSeries3.getTagValue(5505045);
                            }
                            energyWindowInfoArray[i4].rangeLimits.add((EnergyWindowRangeLimit)object);
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                ay.d((Object)"Error parsing EnergyWindowInformationSequence", throwable, NMSeriesInfo.class);
            }
        }
        immutableList = new b();
        immutableList.a = n2;
        immutableList.b = nArray;
        immutableList.c = energyWindowInfoArray;
        return immutableList;
    }

    @Override
    public /* synthetic */ Object clone() {
        return this.b();
    }

    public static class EnergyWindowRangeLimit
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public Double lower;
        public Double upper;
    }

    public static class EnergyWindowInfo
    implements au<EnergyWindowInfo>,
    Serializable {
        private static final long serialVersionUID = 1L;
        public String windowName;
        public String radInfoCodeValue;
        public String radInfoCodeMeaning;
        public List<EnergyWindowRangeLimit> rangeLimits = new ArrayList<EnergyWindowRangeLimit>();

        public String a() {
            if (this.radInfoCodeValue != null) {
                return RadionuclideCodeValueMapping.getMeaningForValue(this.radInfoCodeValue);
            }
            return this.radInfoCodeMeaning;
        }

        public EnergyWindowInfo b() {
            try {
                EnergyWindowInfo energyWindowInfo = (EnergyWindowInfo)super.clone();
                return energyWindowInfo;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return null;
            }
        }

        @Override
        public /* synthetic */ Object clone() throws CloneNotSupportedException {
            return this.b();
        }
    }

    public static class b {
        public int a;
        public int[] b;
        public EnergyWindowInfo[] c;

        public String toString() {
            return "NumEnergyWindows: " + this.a + " " + Arrays.toString(this.b);
        }
    }

    public static class a {
        public int a;
        public int[] b;
        public String[] c;

        public String toString() {
            return "NumDetectors: " + this.a + " " + Arrays.toString(this.b);
        }
    }

    public class DataSequenceItem
    implements au<DataSequenceItem>,
    Serializable {
        private static final long serialVersionUID = 1L;
        @d
        private Integer nominalInterval;
        @d
        private Float frameTime;
        @d
        private Integer lowRRValue;
        @d
        private Integer highRRValue;
        @d
        private Integer intervalsAcquired;
        @d
        private Integer intervalsRejected;

        public DataSequenceItem a() {
            try {
                DataSequenceItem dataSequenceItem = (DataSequenceItem)super.clone();
                dataSequenceItem.a((Float)this.c().orNull());
                dataSequenceItem.b((Integer)this.d().orNull());
                dataSequenceItem.d((Integer)this.f().orNull());
                dataSequenceItem.e((Integer)this.g().orNull());
                dataSequenceItem.c((Integer)this.e().orNull());
                dataSequenceItem.a((Integer)this.b().orNull());
                return dataSequenceItem;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                ay.d((Object)cloneNotSupportedException, this);
                return null;
            }
        }

        public Optional<Integer> b() {
            return Optional.fromNullable((Object)this.nominalInterval);
        }

        public void a(Integer n2) {
            this.nominalInterval = n2;
        }

        public Optional<Float> c() {
            return Optional.fromNullable((Object)this.frameTime);
        }

        public void a(Float f2) {
            this.frameTime = f2;
        }

        public Optional<Integer> d() {
            return Optional.fromNullable((Object)this.highRRValue);
        }

        public void b(Integer n2) {
            this.highRRValue = n2;
        }

        public Optional<Integer> e() {
            return Optional.fromNullable((Object)this.lowRRValue);
        }

        public void c(Integer n2) {
            this.lowRRValue = n2;
        }

        public Optional<Integer> f() {
            return Optional.fromNullable((Object)this.intervalsAcquired);
        }

        public void d(Integer n2) {
            this.intervalsAcquired = n2;
        }

        public Optional<Integer> g() {
            return Optional.fromNullable((Object)this.intervalsRejected);
        }

        public void e(Integer n2) {
            this.intervalsRejected = n2;
        }

        @Override
        public /* synthetic */ Object clone() throws CloneNotSupportedException {
            return this.a();
        }
    }

    public class GatedInfoItem
    implements au<GatedInfoItem>,
    Serializable {
        private static final long serialVersionUID = 1L;
        @d
        private Float triggerTime;
        @d
        private Integer heartRate;
        public BeatHistogramData beatHist;
        public short[] angularViewVector;
        public List<DataSequenceItem> dataSeq = Lists.newArrayList();

        public GatedInfoItem a() {
            try {
                GatedInfoItem gatedInfoItem = (GatedInfoItem)super.clone();
                gatedInfoItem.a((Float)this.b().orNull());
                gatedInfoItem.dataSeq = Lists.newArrayList();
                for (DataSequenceItem dataSequenceItem : this.dataSeq) {
                    gatedInfoItem.dataSeq.add(dataSequenceItem.a());
                }
                return gatedInfoItem;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                ay.d((Object)cloneNotSupportedException, this);
                return null;
            }
        }

        public Optional<Float> b() {
            return Optional.fromNullable((Object)this.triggerTime);
        }

        public void a(Float f2) {
            this.triggerTime = f2;
        }

        public Optional<Integer> c() {
            return Optional.fromNullable((Object)this.heartRate);
        }

        public void a(Integer n2) {
            this.heartRate = n2;
        }

        @Override
        public /* synthetic */ Object clone() throws CloneNotSupportedException {
            return this.a();
        }
    }

    public class RotationInfoItem
    implements au<RotationInfoItem>,
    Serializable {
        private static final long serialVersionUID = 1L;
        public double tableHeight;
        public double tableTraverse;
        public String rotationDirection;
        @d
        public double radialPosition;
        public double scanArc;
        public double angularStep;
        public int numberOfFramesInRotation;
        public double startAngle;

        public RotationInfoItem a() {
            try {
                return (RotationInfoItem)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw Throwables.propagate((Throwable)cloneNotSupportedException);
            }
        }

        @Override
        public /* synthetic */ Object clone() throws CloneNotSupportedException {
            return this.a();
        }
    }

    public class PhaseInfo
    implements au<PhaseInfo>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private int phaseIdx;
        public float phaseDelayInMs;
        public float actualFrameDurationInMs;
        public float pauseBetweenFramesInMs;
        public int numberOfFramesInPhase;
        public int numberOfTriggersInPhase;
        public int[] triggerVector;
        public String phaseDescription;

        public int a() {
            return this.phaseIdx;
        }

        public void a(int n2) {
            this.phaseIdx = n2;
        }

        public PhaseInfo b() {
            try {
                PhaseInfo phaseInfo = (PhaseInfo)super.clone();
                phaseInfo.triggerVector = as.a(this.triggerVector);
                return phaseInfo;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return null;
            }
        }

        @Override
        public /* synthetic */ Object clone() throws CloneNotSupportedException {
            return this.b();
        }
    }
}

