/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.viewer;

import com.mimvista.dicom.util.RawDicomUtils;
import com.mimvista.iphone.BundleSeries;
import com.mimvista.iphone.a.a;
import com.mimvista.viewer.ModalitySeriesInfo;
import com.mimvista.viewer.SeriesInfo;
import com.mimvista.viewer.algo.SuvCalculator;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.dcm4che2.data.DicomObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PTSeriesInfo
extends ModalitySeriesInfo {
    private static final long serialVersionUID = 1L;
    protected SeriesInfo seriesInfo = null;
    public String countsSource = "EMISSION";
    public String reprojectionMethod = "";
    public String randomsCorrectionMethod = "";
    public String attenuationCorrectionMethod = "";
    public String scatterCorrectionMethod = "";
    public String decayCorrection = "NONE";
    public String convolutionKernel = "";
    public String reconstructionMethod = "";
    public float reconstructionDiameter = Float.NaN;
    public String fieldOfViewShape = "";
    public String typeOfDetectorMotion = "";
    public String secondaryCountsType = "";
    public String origUnits = "NONE";
    public String actualFrameDuration = null;
    public String[] radNucCodeSequence;
    public String radPharmRoute;
    public String[] adminRouteCodeSequence;
    public float radPharmVolume = Float.NaN;
    public String radPharmStartTime;
    public String radPharmStopTime;
    public float radNucTotalDose = Float.NaN;
    public float radNucHalfLife = Float.NaN;
    public float radNucPositronFraction = Float.NaN;
    public float radPharmSpecificActivity = Float.NaN;
    public String radiopharmaceutical;
    public String[] radPharmCodeSequence;

    public PTSeriesInfo(DicomObject dicomObject, SeriesInfo seriesInfo) {
        this.seriesInfo = seriesInfo;
        this.countsSource = dicomObject.getString(5509122, "EMISSION");
        this.reprojectionMethod = dicomObject.getString(5509124, "");
        this.randomsCorrectionMethod = dicomObject.getString(5509376, "");
        this.attenuationCorrectionMethod = dicomObject.getString(5509377, "");
        this.scatterCorrectionMethod = dicomObject.getString(5509381, "");
        this.decayCorrection = dicomObject.getString(5509378, "NONE");
        this.convolutionKernel = dicomObject.getString(1577488, "");
        this.reconstructionMethod = dicomObject.getString(5509379, "");
        this.reconstructionDiameter = dicomObject.getFloat(0x181100, Float.NaN);
        this.fieldOfViewShape = dicomObject.getString(1577287, "");
        this.typeOfDetectorMotion = dicomObject.getString(5505538, "");
        this.secondaryCountsType = dicomObject.getString(5509664, "");
        this.origUnits = dicomObject.getString(5509121, "NONE");
        this.actualFrameDuration = dicomObject.getString(1577538);
        int n2 = 5505046;
        this.radNucCodeSequence = RawDicomUtils.readCodeSequence(dicomObject, new int[]{n2, 0, 5505792});
        if (this.radNucCodeSequence == null) {
            this.radNucCodeSequence = RawDicomUtils.readCodeSequence(dicomObject, new int[]{5505792});
        }
        this.radPharmRoute = dicomObject.getString(new int[]{n2, 0, 1577072}, (String)null);
        this.adminRouteCodeSequence = RawDicomUtils.readCodeSequence(dicomObject, new int[]{n2, 0, 5505794});
        this.radPharmVolume = dicomObject.getFloat(new int[]{n2, 0, 1577073}, Float.NaN);
        this.radPharmStartTime = dicomObject.getString(new int[]{n2, 0, 1577074}, (String)null);
        this.radPharmStopTime = dicomObject.getString(new int[]{n2, 0, 1577075}, (String)null);
        this.radNucTotalDose = dicomObject.getFloat(new int[]{n2, 0, 1577076}, Float.NaN);
        this.radNucHalfLife = dicomObject.getFloat(new int[]{n2, 0, 1577077}, Float.NaN);
        this.radNucPositronFraction = dicomObject.getFloat(new int[]{n2, 0, 1577078}, Float.NaN);
        this.radPharmSpecificActivity = dicomObject.getFloat(new int[]{n2, 0, 1577079}, Float.NaN);
        this.radiopharmaceutical = dicomObject.getString(new int[]{n2, 0, 1572913}, (String)null);
        this.radPharmCodeSequence = RawDicomUtils.readCodeSequence(dicomObject, new int[]{n2, 0, 5505796});
    }

    public PTSeriesInfo() {
        this.seriesInfo = new SeriesInfo();
    }

    @Override
    public void a(DicomObject dicomObject) {
        dicomObject.putString(5509122, null, this.countsSource);
        if (this.reprojectionMethod.length() > 0) {
            dicomObject.putString(5509124, null, this.reprojectionMethod);
        }
        dicomObject.putString(5509376, null, this.randomsCorrectionMethod);
        dicomObject.putString(5509377, null, this.attenuationCorrectionMethod);
        dicomObject.putString(5509381, null, this.scatterCorrectionMethod);
        dicomObject.putString(5509378, null, this.decayCorrection);
        dicomObject.putString(1577488, null, this.convolutionKernel);
        dicomObject.putString(5509379, null, this.reconstructionMethod);
        dicomObject.putString(1577287, null, this.fieldOfViewShape);
        dicomObject.putString(5505538, null, this.typeOfDetectorMotion);
        dicomObject.putString(5509664, null, this.secondaryCountsType);
        if (this.actualFrameDuration != null) {
            dicomObject.putString(1577538, null, this.actualFrameDuration);
        }
        int n2 = 5505046;
        dicomObject.putSequence(n2);
        RawDicomUtils.writeCodeSequence(dicomObject, new int[]{n2, 0, 5505792}, this.radNucCodeSequence);
        this.a(dicomObject, new int[]{n2, 0, 1577072}, this.radPharmRoute);
        RawDicomUtils.writeCodeSequence(dicomObject, new int[]{n2, 0, 5505794}, this.adminRouteCodeSequence);
        this.a(dicomObject, new int[]{n2, 0, 1577073}, this.radPharmVolume);
        this.a(dicomObject, new int[]{n2, 0, 1577074}, this.seriesInfo.startTime);
        this.a(dicomObject, new int[]{n2, 0, 1577080}, SuvCalculator.getRadiopharmStartDateIncludingDateAndTime(this.seriesInfo));
        this.a(dicomObject, new int[]{n2, 0, 1577075}, this.radPharmStopTime);
        this.a(dicomObject, new int[]{n2, 0, 1577076}, this.seriesInfo.dose);
        this.a(dicomObject, new int[]{n2, 0, 1577077}, this.seriesInfo.halflife);
        this.a(dicomObject, new int[]{n2, 0, 1577078}, this.radNucPositronFraction);
        this.a(dicomObject, new int[]{n2, 0, 1577079}, this.radPharmSpecificActivity);
        this.a(dicomObject, new int[]{n2, 0, 1572913}, this.radiopharmaceutical);
        RawDicomUtils.writeCodeSequence(dicomObject, new int[]{n2, 0, 5505796}, this.radPharmCodeSequence);
        dicomObject.putFloat(5509888, null, this.seriesInfo.frameReferenceTime);
        if (this.seriesInfo != null && this.seriesInfo.correctedImage != null) {
            this.a(dicomObject, 2621521, this.seriesInfo.correctedImage.replace(',', '\\'));
        }
    }

    @Override
    public void a(Document document, Element element) {
        Element element2 = document.createElement("dict");
        a.a(document, element, BundleSeries.PlistKey.aV, this.seriesInfo.radpharm);
        a.a(document, element, BundleSeries.PlistKey.aW, Float.toString(this.seriesInfo.dose));
        a.a(document, element, BundleSeries.PlistKey.aX, this.seriesInfo.exposureTime);
        a.a(document, element, BundleSeries.PlistKey.aY, this.a(this.seriesInfo.acqTime));
        a.a(document, element, BundleSeries.PlistKey.aZ, this.reconstructionMethod);
        a.a(document, element, BundleSeries.PlistKey.ba, this.seriesInfo.seriesType);
        a.a(document, element, BundleSeries.PlistKey.bb, this.countsSource);
        a.a(document, element, BundleSeries.PlistKey.bc, Float.toString(this.seriesInfo.frameTime));
        a.a(document, element2, BundleSeries.PlistKey.aV, "Radiopharmacuetical");
        a.a(document, element2, BundleSeries.PlistKey.aW, "Dose");
        a.a(document, element2, BundleSeries.PlistKey.aX, "Exposure Time");
        a.a(document, element2, BundleSeries.PlistKey.aY, "Acquisition Time");
        a.a(document, element2, BundleSeries.PlistKey.aZ, "Reconstruction Method");
        a.a(document, element2, BundleSeries.PlistKey.ba, "Series Type");
        a.a(document, element2, BundleSeries.PlistKey.M, "Units");
        a.a(document, element2, BundleSeries.PlistKey.bb, "Counts Source");
        a.a(document, element2, BundleSeries.PlistKey.bc, "Frame Duration");
        a.a(document, element2, BundleSeries.PlistKey.X, "Voxel Size (mm)");
        a.a(document, "diagnosticallyRelevant", element);
        element.appendChild(element2);
    }

    String a(Date date) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HHmmss");
        return simpleDateFormat.format(date);
    }

    @Override
    public float a() {
        return this.reconstructionDiameter;
    }
}

