/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.viewer;

import com.google.common.collect.Lists;
import com.mimvista.d;
import com.mimvista.dicom.reffinder.params.RefSeriesFinderStrategyRTDOSE;
import com.mimvista.dicom.reffinder.params.ReferencedSeriesFinderStrategy;
import com.mimvista.dicom.rtdose.DoseValue;
import com.mimvista.e;
import com.mimvista.internals.ad;
import com.mimvista.numerics.Point3f;
import com.mimvista.state.ReadHelper;
import com.mimvista.util.Messages;
import com.mimvista.util.ay;
import com.mimvista.util.cn;
import com.mimvista.viewer.RTSeriesInfo;
import com.mimvista.viewer.SeriesInfo;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.vecmath.Tuple3f;
import org.dcm4che2.data.BasicDicomObject;
import org.dcm4che2.data.DicomElement;
import org.dcm4che2.data.DicomObject;

public class RTDoseSeriesInfo
extends RTSeriesInfo
implements ad {
    private static final long serialVersionUID = 1L;
    public transient WeakReference<Object> a;
    @d
    public transient WeakReference<Object> b;
    public DicomElement dvhSequence;
    public float doseGridScaling;
    public boolean rxDoseShouldBeLockedInGUI = false;
    public List<String> tissueHeterogeneityCorrection;
    public String referencedImageUID;
    public List<String> referencedRtPlanUIDs;
    public String referencedRtPlanUID = null;
    public List<DoseAccumParent> accumParents;
    public RxDose origDose;
    public RxDose curDose;
    private List<RxDose> availableRxDoses;

    public RTDoseSeriesInfo(String string, float f2, DoseValue doseValue, String string2, String string3, String string4) {
        super(string2, string3, string4);
        this.f();
        this.referencedImageUID = string;
        this.doseGridScaling = f2;
        this.curDose = new RxDose(doseValue, RxType.AUTO);
    }

    public RTDoseSeriesInfo(DicomObject dicomObject) {
        super(dicomObject);
        DicomElement dicomElement;
        this.f();
        this.referencedImageUID = dicomObject.getString(new int[]{528704, 0, 528725}, (String)null);
        this.b(dicomObject);
        this.doseGridScaling = dicomObject.getFloat(805568526, 1.0f);
        DicomElement dicomElement2 = dicomObject.getStrings(805568532);
        if (dicomElement2 != null && ((String[])dicomElement2).length > 0) {
            for (DicomElement dicomElement3 : dicomElement2) {
                this.tissueHeterogeneityCorrection.add((String)dicomElement3);
            }
        }
        try {
            dicomElement = dicomObject.get(806092802);
            for (int i2 = 0; i2 < dicomElement.countItems(); ++i2) {
                DicomObject dicomObject2 = dicomElement.getDicomObject(i2);
                this.referencedRtPlanUIDs.add(dicomObject2.getString(528725));
                this.referencedRtPlanUID = dicomObject2.getString(528725);
            }
        }
        catch (Throwable throwable) {
            ay.d((Object)"Couldn't parse referenced rtplans", RTDoseSeriesInfo.class);
        }
        dicomElement = dicomObject.get(930295840);
        this.a(dicomElement, this.accumParents);
    }

    private void f() {
        this.availableRxDoses = Lists.newArrayList();
        this.accumParents = Lists.newArrayList();
        this.referencedRtPlanUIDs = Lists.newArrayList();
        this.tissueHeterogeneityCorrection = Lists.newArrayList();
    }

    private void a(DicomElement dicomElement, List<DoseAccumParent> list) {
        if (dicomElement == null) {
            return;
        }
        for (int i2 = 0; i2 < dicomElement.countItems(); ++i2) {
            DicomObject dicomObject = dicomElement.getDicomObject(i2);
            String string = dicomObject.getString(930295841);
            Date date = dicomObject.getDate(930295842);
            String string2 = dicomObject.getString(930295843);
            Float f2 = Float.valueOf(dicomObject.getFloat(930295844));
            Float f3 = Float.valueOf(dicomObject.getFloat(930295845));
            ArrayList<DoseAccumParent> arrayList = new ArrayList<DoseAccumParent>();
            DicomElement dicomElement2 = dicomObject.get(930295840);
            this.a(dicomElement2, arrayList);
            list.add(new DoseAccumParent(string, date, f2.floatValue(), f3.floatValue(), string2, arrayList));
        }
    }

    public List<RxDose> b() {
        return Lists.newArrayList(this.availableRxDoses);
    }

    public void e() {
        this.availableRxDoses.clear();
    }

    public void a(RxDose rxDose) {
        RxType rxType = rxDose.b();
        if (rxType == RxType.PRESCRIPTION || rxType == RxType.USER) {
            this.availableRxDoses.add(rxDose);
        } else if (rxType == RxType.MAX || rxType == RxType.AUTO) {
            ArrayList arrayList = Lists.newArrayList();
            for (RxDose rxDose2 : this.availableRxDoses) {
                if (rxDose2.b() != rxType) continue;
                arrayList.add(rxDose2);
            }
            this.availableRxDoses.removeAll(arrayList);
            this.availableRxDoses.add(rxDose);
        }
    }

    private void b(DicomObject dicomObject) {
        DicomElement dicomElement = dicomObject.get(805568592);
        if (dicomElement != null && dicomElement.countItems() > 0) {
            BasicDicomObject basicDicomObject = new BasicDicomObject();
            DicomElement dicomElement2 = basicDicomObject.putSequence(805568592);
            for (int i2 = 0; i2 < dicomElement.countItems(); ++i2) {
                DicomObject dicomObject2 = dicomElement.getDicomObject(i2);
                BasicDicomObject basicDicomObject2 = new BasicDicomObject();
                dicomObject2.copyTo((DicomObject)basicDicomObject2, false);
                dicomElement2.addDicomObject((DicomObject)basicDicomObject2);
            }
            this.dvhSequence = dicomElement2;
        }
    }

    @Override
    public ReferencedSeriesFinderStrategy a(SeriesInfo seriesInfo) {
        return new RefSeriesFinderStrategyRTDOSE(seriesInfo);
    }

    @Override
    public DoseValue getRxDose() {
        return this.curDose.c();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Object object;
        this.f();
        ReadHelper readHelper = new ReadHelper();
        ObjectInputStream.GetField getField = readHelper.a(objectInputStream, (Object)this);
        RxType rxType = RxType.AUTO;
        DoseValue doseValue = null;
        DoseValue doseValue2 = null;
        if (ReadHelper.b(getField, "rxDose")) {
            object = getField.get("rxDose", null);
            if (object instanceof DoseValue) {
                doseValue = (DoseValue)object;
            }
        } else if (ReadHelper.b(getField, "oldRxDose")) {
            doseValue = new DoseValue();
            doseValue.setValueInGy(getField.get("oldRxDose", 0.0f));
        }
        if (ReadHelper.b(getField, "origRxDose")) {
            object = getField.get("origRxDose", null);
            if (object instanceof DoseValue) {
                doseValue2 = (DoseValue)object;
            }
        } else if (ReadHelper.b(getField, "oldOrigRxDose")) {
            doseValue2 = new DoseValue();
            doseValue2.setValueInGy(getField.get("oldOrigRxDose", 0.0f));
        }
        if (ReadHelper.b(getField, "rxType") && (object = getField.get("rxType", null)) instanceof RxType) {
            rxType = (RxType)((Object)object);
        }
        if (this.curDose == null && doseValue != null) {
            this.curDose = new RxDose(doseValue, rxType);
        }
        if (this.origDose == null && doseValue2 != null) {
            this.origDose = new RxDose(doseValue2, rxType);
        }
    }

    public static class RxDose
    implements Serializable,
    Cloneable {
        private static final long serialVersionUID = 1L;
        private int refROINum = -1;
        private Point3f coords = null;
        private RxType type = RxType.AUTO;
        private DoseValue value = null;
        private List<String> refRTstSOP = Lists.newArrayList();

        public RxDose(RTDoseSeriesInfo rTDoseSeriesInfo) {
            this(rTDoseSeriesInfo.curDose.c(), rTDoseSeriesInfo.curDose.b());
        }

        public RxDose(DoseValue doseValue, RxType rxType) {
            this.value = doseValue;
            this.type = rxType;
        }

        public RxDose(DoseValue doseValue, RxType rxType, int n2) {
            this.value = doseValue;
            this.type = rxType;
            this.refROINum = n2;
        }

        public RxDose(DoseValue doseValue, RxType rxType, Point3f point3f) {
            this.value = doseValue;
            this.type = rxType;
            this.coords = point3f.e();
        }

        public int a() {
            return this.refROINum;
        }

        public RxType b() {
            return this.type;
        }

        public DoseValue c() {
            return this.value;
        }

        public Point3f d() {
            return this.coords;
        }

        public String e() {
            NumberFormat numberFormat = NumberFormat.getInstance();
            numberFormat.setMinimumFractionDigits(2);
            numberFormat.setMaximumFractionDigits(2);
            String string = numberFormat.format(this.coords.x);
            String string2 = numberFormat.format(this.coords.y);
            String string3 = numberFormat.format(this.coords.z);
            return "(" + string + ", " + string2 + ", " + string3 + ")";
        }

        public List<String> f() {
            return Lists.newArrayList(this.refRTstSOP);
        }

        public void a(String string) {
            if (!this.refRTstSOP.contains(string)) {
                this.refRTstSOP.add(string);
            }
        }

        public boolean g() {
            return this.type == RxType.PRESCRIPTION;
        }

        public boolean h() {
            return this.g() && this.refROINum < 0 && this.coords == null;
        }

        public boolean i() {
            return this.g() && this.refROINum >= 0;
        }

        public boolean j() {
            return this.g() && this.coords != null;
        }

        public int hashCode() {
            int n2 = 31;
            int n3 = 1;
            n3 = 31 * n3 + (this.coords == null ? 0 : this.coords.hashCode());
            n3 = 31 * n3 + this.refROINum;
            n3 = 31 * n3 + (this.refRTstSOP == null ? 0 : ((Object)this.refRTstSOP).hashCode());
            n3 = 31 * n3 + (this.type == null ? 0 : this.type.hashCode());
            n3 = 31 * n3 + (this.value == null ? 0 : this.value.hashCode());
            return n3;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            RxDose rxDose = (RxDose)object;
            if (this.coords == null ? rxDose.coords != null : !this.coords.equals((Tuple3f)rxDose.coords)) {
                return false;
            }
            if (this.refROINum != rxDose.refROINum) {
                return false;
            }
            if (this.refRTstSOP == null ? rxDose.refRTstSOP != null : !((Object)this.refRTstSOP).equals(rxDose.refRTstSOP)) {
                return false;
            }
            if (this.type != rxDose.type) {
                return false;
            }
            return !(this.value == null ? rxDose.value != null : !this.value.equals(rxDose.value));
        }

        public RxDose k() {
            try {
                RxDose rxDose = (RxDose)super.clone();
                rxDose.refRTstSOP = new ArrayList<String>(this.refRTstSOP);
                return rxDose;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                ay.d((Object)cloneNotSupportedException, RxDose.class);
                return null;
            }
        }

        public String toString() {
            return cn.a(this.value, "(null value)") + ": [" + (this.type == null ? "null" : this.type.name()) + "]";
        }

        public /* synthetic */ Object clone() throws CloneNotSupportedException {
            return this.k();
        }
    }

    @e
    public static enum RxType {
        PRESCRIPTION("DOSE_TYPE_RX"),
        MAX("DOSE_TYPE_MAX"),
        USER("DOSE_TYPE_USER"),
        AUTO("DOSE_TYPE_AUTO");

        private String extKey;

        private RxType(String string2) {
            this.extKey = string2;
        }

        public String getDisplayString() {
            return Messages.a("Dose", this.extKey);
        }
    }

    public static class DoseAccumParent
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public String name;
        public Date date;
        public float numerator;
        public float denominator;
        public String seriesUID;
        public List<DoseAccumParent> parents;

        public DoseAccumParent(String string, Date date, float f2, float f3, String string2, List<DoseAccumParent> list) {
            this.name = string;
            this.date = date;
            this.numerator = f2;
            this.denominator = f3;
            this.seriesUID = string2;
            this.parents = list;
        }
    }
}

