/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.viewer;

import com.mimvista.state.ReadHelper;
import com.mimvista.viewer.ModalitySeriesInfo;
import com.mimvista.viewer.SeriesInfo;
import java.io.IOException;
import java.io.ObjectInputStream;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.VR;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RTImageSeriesInfo
extends ModalitySeriesInfo {
    private static final long serialVersionUID = 1L;
    public float gantryAngle = Float.NaN;
    public float sourceAxisDistance = Float.NaN;
    public Integer referencedBeamNumber = null;
    public String referencedRTPlanSopInstanceUID = "";
    public float[] isocenter = new float[]{0.0f, 0.0f, 0.0f};
    public float[] imagePlanePixelSpacing = new float[0];
    public float[] xrayImageReceptorTranslation = null;
    public Float sourceImageDistance = null;
    public boolean hasIsocenter = false;
    public String rtImageLabel = "";
    public String rtImageName = "";
    public String rtImageDescription = "";
    public Float xrayImageReceptorAngle = null;
    public float[] rtImagePosition = null;
    public String rtImagePlane = "";
    public String radiationMachineName = "";
    public String primaryDosimeterUnit = "";
    public String conversionType = "";
    public String pixelIntensityRelationship = "LIN";
    public int pixelIntensitySign = 1;
    public int instanceNumber = 1;
    private SeriesInfo info;

    public RTImageSeriesInfo(DicomObject dicomObject, SeriesInfo seriesInfo) {
        this(seriesInfo);
        this.gantryAngle = dicomObject.getFloat(805962014, Float.NaN);
        int[] nArray = dicomObject.getInts(806092806, (int[])null);
        if (nArray != null && nArray.length != 0) {
            this.referencedBeamNumber = nArray[0];
        }
        this.referencedRTPlanSopInstanceUID = dicomObject.getString(new int[]{806092802, 0, 528725}, "");
        this.isocenter = dicomObject.getFloats(805962028, new float[]{0.0f, 0.0f, 0.0f});
        this.hasIsocenter = dicomObject.contains(805962028);
        this.imagePlanePixelSpacing = dicomObject.getFloats(805437457, new float[]{0.0f, 0.0f, 0.0f});
        this.xrayImageReceptorTranslation = dicomObject.getFloats(805437453, new float[]{0.0f, 0.0f, 0.0f});
        this.sourceAxisDistance = dicomObject.getFloat(0x30020022, Float.NaN);
        this.sourceImageDistance = Float.valueOf(dicomObject.getFloat(805437478, Float.NaN));
        this.rtImageLabel = dicomObject.getString(0x30020002);
        this.rtImageName = dicomObject.getString(0x30020003);
        this.rtImageDescription = dicomObject.getString(805437444);
        this.xrayImageReceptorAngle = Float.valueOf(dicomObject.getFloat(805437454, Float.NaN));
        this.rtImagePosition = dicomObject.getFloats(805437458);
        this.radiationMachineName = dicomObject.getString(0x30020020);
        this.primaryDosimeterUnit = dicomObject.getString(805961907);
        this.conversionType = dicomObject.getString(524388);
        this.rtImagePlane = dicomObject.getString(805437452);
        this.pixelIntensityRelationship = dicomObject.getString(2625600, VR.CS, "LIN");
        this.pixelIntensitySign = dicomObject.getInt(2625601, 1);
        this.instanceNumber = dicomObject.getInt(2097171, 1);
    }

    public RTImageSeriesInfo(SeriesInfo seriesInfo) {
        this.info = seriesInfo;
    }

    @Override
    public void a(DicomObject dicomObject) {
        this.a(dicomObject, 805962014, this.gantryAngle);
        this.a(dicomObject, 806092806, this.referencedBeamNumber);
        this.a(dicomObject, 805962028, this.isocenter);
        this.a(dicomObject, 805437457, this.imagePlanePixelSpacing);
        this.a(dicomObject, 805437453, this.xrayImageReceptorTranslation);
        this.a(dicomObject, 0x30020022, this.sourceAxisDistance);
        this.a(dicomObject, 805437478, this.sourceImageDistance.floatValue());
        this.a(dicomObject, 0x30020002, this.rtImageLabel);
        this.a(dicomObject, 0x30020003, this.rtImageName);
        this.a(dicomObject, 805437444, this.rtImageDescription);
        this.a(dicomObject, 805437454, this.xrayImageReceptorAngle);
        this.a(dicomObject, 805437458, this.rtImagePosition);
        this.a(dicomObject, 0x30020020, this.radiationMachineName);
        this.a(dicomObject, 805961907, this.primaryDosimeterUnit);
        this.a(dicomObject, 524388, this.conversionType);
        this.a(dicomObject, 805437452, this.rtImagePlane);
        this.a(dicomObject, 2097171, 1);
        this.a(dicomObject, 2625600, this.pixelIntensityRelationship);
        this.a(dicomObject, 2625601, this.pixelIntensitySign);
        this.a(dicomObject, 2097171, this.instanceNumber);
    }

    public void a(DicomObject dicomObject, int n2, Float f2) {
        if (f2 != null) {
            this.a(dicomObject, n2, f2.floatValue());
        }
    }

    @Override
    public void a(Document document, Element element) {
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        ReadHelper readHelper = new ReadHelper();
        readHelper.a(getField, (Object)this);
        if (ReadHelper.b(getField, "oldReferencedBeamNumber")) {
            int n2 = getField.get("oldReferencedBeamNumber", Integer.MIN_VALUE);
            this.referencedBeamNumber = n2 == Integer.MIN_VALUE ? null : Integer.valueOf(n2);
        }
    }
}

