/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.viewer;

import com.google.common.collect.Lists;
import com.mimvista.dicom.Modality;
import com.mimvista.dicom.read.DicomReader;
import com.mimvista.dicom.reffinder.params.RefSeriesFinderStrategyRTPLAN;
import com.mimvista.dicom.reffinder.params.RefSeriesFinderStrategyRTST;
import com.mimvista.dicom.reffinder.params.ReferencedSeriesFinderStrategy;
import com.mimvista.viewer.ModalitySeriesInfo;
import com.mimvista.viewer.SeriesInfo;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import org.dcm4che2.data.DicomObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RTSeriesInfo
extends ModalitySeriesInfo {
    private static final long serialVersionUID = 1L;
    public List<String> referencedUIDs = Lists.newArrayList();
    public String structureSetDate = "";
    public String referencedFrameOfReferenceUID = "";
    public String referencedSeriesUID = "";
    public String rtPlanDate = "";
    public String referencedRtStructUID = "";
    public String rtPlanBrachyReferencedRtStructUID = "";
    public String rtPlanBrachyResliceVector = null;
    public String rtPlanBrachyBaselineDoseUID = "";

    public RTSeriesInfo(String string, String string2, String string3) {
        this.referencedRtStructUID = string;
        this.structureSetDate = string2;
        this.rtPlanDate = string3;
    }

    public RTSeriesInfo(DicomObject dicomObject) {
        this.referencedRtStructUID = dicomObject.getString(new int[]{806092896, 0, 528725}, (String)null);
        this.structureSetDate = dicomObject.getString(805699592, new SimpleDateFormat("yyyyMMdd").format(Calendar.getInstance().getTime()));
        if (dicomObject.getString(524310).equals("1.2.840.10008.5.1.4.1.1.481.3")) {
            this.referencedSeriesUID = dicomObject.getString(new int[]{805699600, 0, 805699602, 0, 805699604, 0, 0x20000E});
            this.referencedUIDs.add(this.referencedSeriesUID);
            this.referencedFrameOfReferenceUID = dicomObject.getString(new int[]{805699600, 0, 0x200052});
        } else if (Modality.getModalityForSopClass(dicomObject.getString(524310)) == Modality.RTPLAN || DicomReader.isBXPlan(dicomObject)) {
            this.rtPlanDate = dicomObject.getString(805961734, new SimpleDateFormat("yyyyMMdd").format(Calendar.getInstance().getTime()));
            this.rtPlanBrachyReferencedRtStructUID = dicomObject.getString(new int[]{930283796, 0, 806092896, 0, 528725});
            this.rtPlanBrachyResliceVector = dicomObject.getString(new int[]{930283796, 0, 928055316}, (String)null);
            this.rtPlanBrachyBaselineDoseUID = dicomObject.getString(new int[]{930283796, 0, 930291968, 0, 0x20000E}, (String)null);
        }
    }

    @Override
    public void a(Document document, Element element) {
    }

    @Override
    public void a(DicomObject dicomObject) {
    }

    @Override
    public ReferencedSeriesFinderStrategy a(SeriesInfo seriesInfo) {
        switch (Modality.get(seriesInfo.modality)) {
            case RTST: {
                return new RefSeriesFinderStrategyRTST(seriesInfo);
            }
            case RTPLAN: {
                return new RefSeriesFinderStrategyRTPLAN(seriesInfo);
            }
        }
        if (seriesInfo.y().getTagValue(930291986) != null) {
            return new RefSeriesFinderStrategyRTPLAN(seriesInfo);
        }
        return null;
    }
}

