/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.viewer;

import com.google.common.collect.Lists;
import com.mimvista.d;
import com.mimvista.dicom.DataUnitUtils;
import com.mimvista.state.ReadHelper;
import com.mimvista.util.MIMFormat;
import com.mimvista.util.Messages;
import com.mimvista.util.ay;
import com.mimvista.util.cn;
import com.mimvista.viewer.SeriesInfo;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class UnitHelper
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String a = "PROPCNTS";
    public static final String b = "PROPCPS";
    public static final String c = "Gy";
    public static final String d = "z-score";
    public static final String e = "BED";
    public static final String f = "PCNT";
    public static final String g = "SUV";
    public static final String h = "PUV";
    public static final String i = "HU";
    public static final String j = "GML";
    private final SeriesInfo info;
    private AppliedImageUnit originalUnit;
    private AppliedImageUnit currentUnit;
    private List<AppliedImageUnit> derivedUnits = Lists.newCopyOnWriteArrayList();
    private boolean enableDecayCorrection = false;
    private String decayCorrectionPrettyDesc;
    private String decayCorrectionKey;
    private long decayCorrectionAbsoluteTZero;
    private float decayCorrectionScale = 1.0f;

    public UnitHelper(SeriesInfo seriesInfo, UnitHelper unitHelper) {
        this.info = seriesInfo;
        this.originalUnit = unitHelper.originalUnit;
        this.currentUnit = unitHelper.currentUnit;
        this.derivedUnits = Lists.newArrayList(unitHelper.derivedUnits);
        this.enableDecayCorrection = unitHelper.enableDecayCorrection;
        this.decayCorrectionPrettyDesc = unitHelper.decayCorrectionPrettyDesc;
        this.decayCorrectionKey = unitHelper.decayCorrectionKey;
        this.decayCorrectionAbsoluteTZero = unitHelper.decayCorrectionAbsoluteTZero;
        this.decayCorrectionScale = unitHelper.decayCorrectionScale;
    }

    public UnitHelper(SeriesInfo seriesInfo) {
        this.info = seriesInfo;
        this.a("");
    }

    public AppliedImageUnit a() {
        return this.originalUnit;
    }

    public void a(String string) {
        this.a(string, null);
    }

    public void a(String string, @d String string2) {
        String string3 = DataUnitUtils.getCanonicalUnit(string, this.info.modality);
        String string4 = UnitHelper.b(string3, string2, this.info, true);
        String string5 = MIMFormat.a(Messages.a("Internals", "IMAGEUNIT_ORIGINAL_UNIT_DESC"), string4);
        this.a(new AppliedImageUnit(string, string2, 1.0f, string5, this.info));
    }

    public void a(AppliedImageUnit appliedImageUnit) {
        AppliedImageUnit appliedImageUnit2;
        this.originalUnit = appliedImageUnit2 = appliedImageUnit.a(1.0f);
        this.b(appliedImageUnit2);
        this.b();
    }

    public void b() {
        this.derivedUnits.clear();
    }

    public String c() {
        return this.originalUnit.unit.canonBaseUnit;
    }

    public void a(String string, float f2) {
        this.a(string, null, f2);
    }

    public void a(String string, float f2, boolean bl2) {
        this.a(string, null, f2, null, bl2);
    }

    public void a(String string, String string2, float f2) {
        this.a(string, string2, f2, null, true);
    }

    public void a(String string, float f2, String string2, boolean bl2) {
        this.a(string, null, f2, string2, bl2);
    }

    public void a(String string, String string2, float f2, String string3, boolean bl2) {
        this.a(new AppliedImageUnit(string, string2, f2, string3, this.info), bl2);
    }

    public void a(AppliedImageUnit appliedImageUnit, boolean bl2) {
        if (this.derivedUnits.contains(appliedImageUnit)) {
            ay.c((Object)("Unit was double added: " + appliedImageUnit), this);
        } else {
            this.derivedUnits.add(appliedImageUnit);
        }
        if (bl2) {
            this.b(appliedImageUnit);
        }
    }

    public void b(AppliedImageUnit appliedImageUnit) {
        if (!this.derivedUnits.contains(appliedImageUnit) && !this.originalUnit.equals(appliedImageUnit)) {
            ay.c((Object)("Setting images unit to a previously unknown unit: " + appliedImageUnit), this);
            this.derivedUnits.add(appliedImageUnit);
        }
        this.currentUnit = appliedImageUnit;
        this.d();
    }

    public void d() {
        if (this.info.rescale != null) {
            this.info.rescale.unitScale = this.k();
        }
    }

    public void a(boolean bl2) {
        if (bl2 && this.decayCorrectionPrettyDesc == null) {
            ay.c((Object)"Can't enable decay correction; no info.", this);
            return;
        }
        this.enableDecayCorrection = bl2;
        this.d();
    }

    public boolean e() {
        return this.enableDecayCorrection;
    }

    public void f() {
        this.decayCorrectionScale = 1.0f;
        this.decayCorrectionKey = null;
        this.decayCorrectionPrettyDesc = null;
        this.d();
    }

    public String g() {
        return this.decayCorrectionPrettyDesc;
    }

    public float h() {
        return this.decayCorrectionScale;
    }

    public void a(float f2, long l2, String string, String string2) {
        this.decayCorrectionScale = f2;
        this.decayCorrectionAbsoluteTZero = l2;
        this.decayCorrectionPrettyDesc = string;
        this.decayCorrectionKey = string2;
        this.a(true);
    }

    public String i() {
        return this.decayCorrectionKey;
    }

    public long j() {
        return this.decayCorrectionAbsoluteTZero;
    }

    public float k() {
        float f2 = this.currentUnit.unitScale;
        if (this.enableDecayCorrection) {
            f2 *= this.decayCorrectionScale;
        }
        return f2;
    }

    public List<AppliedImageUnit> l() {
        ArrayList arrayList = Lists.newArrayList();
        arrayList.add(this.originalUnit);
        arrayList.addAll(this.derivedUnits);
        return arrayList;
    }

    public AppliedImageUnit m() {
        return this.currentUnit;
    }

    public void a(SeriesInfo seriesInfo) {
        this.a(seriesInfo.u().m(), true);
    }

    public boolean n() {
        return this.c(j);
    }

    public boolean o() {
        return this.c(i);
    }

    public boolean p() {
        return DataUnitUtils.BQML_CANON_.matchesUnit(this.y());
    }

    public boolean q() {
        return !cn.g(this.currentUnit.unit.canonBaseUnit);
    }

    public boolean r() {
        return this.c(f);
    }

    public boolean s() {
        return this.c(e);
    }

    public boolean t() {
        boolean bl2 = this.c(d) || this.e(d);
        return bl2;
    }

    public boolean u() {
        return this.y().toLowerCase().contains(c);
    }

    @Deprecated
    public boolean v() {
        return this.y().equalsIgnoreCase(c);
    }

    public boolean b(SeriesInfo seriesInfo) {
        return this.c(seriesInfo.u().m().unit.canonBaseUnit);
    }

    public boolean b(String string) {
        String string2 = cn.i(string).toLowerCase();
        return this.y().toLowerCase().startsWith(string2);
    }

    public boolean c(String string) {
        return this.y().equalsIgnoreCase(string);
    }

    private boolean e(String string) {
        try {
            String string2 = this.a().unit.canonBaseUnit;
            return string2.equalsIgnoreCase(string);
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    public boolean d(String string) {
        List<AppliedImageUnit> list = this.l();
        for (AppliedImageUnit appliedImageUnit : list) {
            if (!appliedImageUnit.unit.canonBaseUnit.equals(string)) continue;
            return true;
        }
        return false;
    }

    public boolean a(DataUnitUtils.CanonDataUnit canonDataUnit) {
        return DataUnitUtils.getCanonicalUnitOrUnknown(this.y(), this.info.modality) == canonDataUnit;
    }

    public boolean w() {
        return this.c(g);
    }

    public boolean x() {
        return this.b(g);
    }

    public String y() {
        return cn.i(this.z());
    }

    public String z() {
        return this.m().unit.canonBaseUnit;
    }

    public String A() {
        return cn.i(this.B());
    }

    public String B() {
        return this.m().unit.unitDesc;
    }

    public String C() {
        String string = this.B();
        String string2 = this.y();
        return UnitHelper.b(string2, string, this.info, false);
    }

    private static String b(String string, String string2, SeriesInfo seriesInfo, boolean bl2) {
        if (bl2 && DataUnitUtils.NONE_CANON_.canonicalUnit.equals(string)) {
            string = Messages.a("Internals", "IMAGEUNIT_UNIT_NONE");
        }
        StringBuilder stringBuilder = new StringBuilder(string);
        if (g.equals(string)) {
            if (seriesInfo.S()) {
                return h;
            }
            if (string2 != null) {
                stringBuilder.append(string2.toLowerCase(Locale.ENGLISH));
            }
        } else if (string2 != null) {
            stringBuilder.append(" (");
            stringBuilder.append(string2);
            stringBuilder.append(")");
        }
        return stringBuilder.toString();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        ReadHelper readHelper = new ReadHelper();
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        readHelper.a(getField, (Object)this);
        if (!ReadHelper.b(getField, "decayCorrectionScale")) {
            this.decayCorrectionScale = 1.0f;
        }
    }

    public static class AppliedImageUnit
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final ImageUnit unit;
        public final String rawBaseUnit;
        public final float unitScale;
        private final String prettyDescription;

        private AppliedImageUnit() {
            this.unit = new ImageUnit("", "");
            this.rawBaseUnit = "";
            this.unitScale = 1.0f;
            this.prettyDescription = "";
        }

        public AppliedImageUnit(String string, String string2, float f2, String string3, SeriesInfo seriesInfo) {
            String string4 = DataUnitUtils.getCanonicalUnit(string, seriesInfo.modality);
            this.unit = new ImageUnit(string4, string2);
            this.rawBaseUnit = string;
            this.unitScale = f2;
            if (string3 == null) {
                string3 = UnitHelper.b(string4, string2, seriesInfo, true);
            }
            this.prettyDescription = string3;
        }

        protected AppliedImageUnit(String string, String string2, String string3, float f2, String string4) {
            this.unit = new ImageUnit(string2, string3);
            this.rawBaseUnit = string;
            this.unitScale = f2;
            this.prettyDescription = string4;
        }

        public AppliedImageUnit a(float f2) {
            return new AppliedImageUnit(this.rawBaseUnit, this.unit.canonBaseUnit, this.unit.unitDesc, f2, this.prettyDescription);
        }

        public String a() {
            return this.prettyDescription;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(this.unit.toString());
            stringBuilder.append(" (");
            stringBuilder.append(this.rawBaseUnit);
            stringBuilder.append(")");
            stringBuilder.append(" (");
            stringBuilder.append(this.prettyDescription);
            stringBuilder.append(")");
            stringBuilder.append(" (");
            stringBuilder.append(this.unitScale);
            stringBuilder.append(")");
            return stringBuilder.toString();
        }

        public int hashCode() {
            int n2 = 31;
            int n3 = 1;
            n3 = 31 * n3 + (this.prettyDescription == null ? 0 : this.prettyDescription.hashCode());
            n3 = 31 * n3 + (this.rawBaseUnit == null ? 0 : this.rawBaseUnit.hashCode());
            n3 = 31 * n3 + (this.unit == null ? 0 : this.unit.hashCode());
            n3 = 31 * n3 + Float.floatToIntBits(this.unitScale);
            return n3;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            AppliedImageUnit appliedImageUnit = (AppliedImageUnit)object;
            if (this.prettyDescription == null ? appliedImageUnit.prettyDescription != null : !this.prettyDescription.equals(appliedImageUnit.prettyDescription)) {
                return false;
            }
            if (this.rawBaseUnit == null ? appliedImageUnit.rawBaseUnit != null : !this.rawBaseUnit.equals(appliedImageUnit.rawBaseUnit)) {
                return false;
            }
            if (this.unit == null ? appliedImageUnit.unit != null : !this.unit.equals(appliedImageUnit.unit)) {
                return false;
            }
            return Float.floatToIntBits(this.unitScale) == Float.floatToIntBits(appliedImageUnit.unitScale);
        }

        public static AppliedImageUnit b() {
            return new AppliedImageUnit();
        }
    }

    public static class ImageUnit
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final String canonBaseUnit;
        public final String unitDesc;

        public ImageUnit(String string, String string2) {
            this.canonBaseUnit = string;
            this.unitDesc = string2;
        }

        public ImageUnit(String string) {
            this(string, null);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(this.canonBaseUnit);
            if (this.unitDesc != null) {
                stringBuilder.append(this.unitDesc);
            }
            return stringBuilder.toString();
        }

        public int hashCode() {
            int n2 = 31;
            int n3 = 1;
            n3 = 31 * n3 + (this.canonBaseUnit == null ? 0 : this.canonBaseUnit.hashCode());
            n3 = 31 * n3 + (this.unitDesc == null ? 0 : this.unitDesc.hashCode());
            return n3;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            ImageUnit imageUnit = (ImageUnit)object;
            if (this.canonBaseUnit == null ? imageUnit.canonBaseUnit != null : !this.canonBaseUnit.equals(imageUnit.canonBaseUnit)) {
                return false;
            }
            return !(this.unitDesc == null ? imageUnit.unitDesc != null : !this.unitDesc.equals(imageUnit.unitDesc));
        }
    }
}

