/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.viewer.algo;

import com.mimvista.dicom.Modality;
import com.mimvista.dicom.SeriesIdentifier;
import com.mimvista.dicom.util.RescaleConverter;
import com.mimvista.internals.volumes.SimpleImageVolume;
import com.mimvista.numerics.ImageCube;
import com.mimvista.preferencesNew.DicomPrefs;
import com.mimvista.state.ReadHelper;
import com.mimvista.swing.widgets.MOptionPane;
import com.mimvista.util.Messages;
import com.mimvista.util.ay;
import com.mimvista.viewer.SeriesInfo;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;

public class BestContrastor
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    public static Messages a = Messages.a("Internals");
    protected float width;
    protected float center;
    protected int top;
    protected int bottom;
    protected int max = Short.MIN_VALUE;
    protected int min = Short.MAX_VALUE;
    protected int offset;
    protected int[] bins;
    protected boolean subtraction = false;
    protected boolean seriesInfoIndicatesSubtraction = false;
    protected boolean dontBackOffFromMaxValue = false;
    protected SubtractionStrategy subStrat;
    protected String modality = null;

    public BestContrastor(SubtractionStrategy subtractionStrategy) {
        this.subStrat = subtractionStrategy;
    }

    public void a(String string) {
        this.modality = string;
    }

    public void a(SimpleImageVolume<ImageCube.ImageCubeShort> simpleImageVolume, RescaleConverter rescaleConverter) {
        this.a(simpleImageVolume, (short)simpleImageVolume.ah(), (short)simpleImageVolume.ai(), rescaleConverter);
    }

    public void a(SimpleImageVolume<ImageCube.ImageCubeShort> simpleImageVolume, short s2, short s3, RescaleConverter rescaleConverter) {
        if (simpleImageVolume.az() != null) {
            this.a(simpleImageVolume.az(), Short.MIN_VALUE, rescaleConverter);
            return;
        }
        this.min = s2;
        this.max = s3;
        if (this.max < this.min) {
            ay.b((Object)"Trying to calculate best contrast when we have no data?", this);
            this.min = 0;
            this.max = 0;
        }
        this.offset = this.min;
        this.bins = new int[this.max - this.min + 1];
        List list = simpleImageVolume.ad().b();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            short[] sArray = (short[])list.get(i2);
            for (int i3 = 0; i3 < sArray.length; ++i3) {
                int n2;
                short s4 = sArray[i3];
                int n3 = n2 = s4 - this.offset;
                this.bins[n3] = this.bins[n3] + 1;
            }
        }
        this.a(simpleImageVolume.H(), rescaleConverter);
    }

    public void a(Iterable<Short> iterable, RescaleConverter rescaleConverter) {
        long l2 = 0L;
        for (Short object : iterable) {
            if (object == null) continue;
            if (object < this.min) {
                this.min = object.shortValue();
            }
            if (object > this.max) {
                this.max = object.shortValue();
            }
            ++l2;
        }
        this.offset = this.min;
        int n2 = this.max - this.min + 1;
        this.bins = new int[n2];
        for (Short s2 : iterable) {
            if (s2 == null) continue;
            int n3 = s2 - this.offset;
            this.bins[n3] = this.bins[n3] + 1;
        }
        this.a(l2, rescaleConverter);
    }

    public void a(int[] nArray, int n2, RescaleConverter rescaleConverter) {
        int n3;
        this.offset = n2;
        this.bins = nArray;
        long l2 = 0L;
        for (n3 = 0; n3 < this.bins.length; ++n3) {
            l2 += (long)this.bins[n3];
        }
        for (n3 = 0; n3 < this.bins.length; ++n3) {
            if (this.bins[n3] == 0) continue;
            this.min = n3 + n2;
            break;
        }
        for (n3 = this.bins.length - 1; n3 >= 0; --n3) {
            if (this.bins[n3] == 0) continue;
            this.max = n3 + n2;
            break;
        }
        this.a(l2, rescaleConverter);
    }

    private void a(long l2, RescaleConverter rescaleConverter) {
        int n2;
        rescaleConverter = this.a(rescaleConverter);
        int n3 = 0;
        boolean bl2 = DicomPrefs.ctIgnoreVerySmallIncorrectPixelsWhenContrasting.getValue();
        for (int i2 = 0; i2 < this.bins.length; ++i2) {
            if (this.bins[i2] <= 0) continue;
            if (!SeriesIdentifier.isFunctionalModality(this.modality)) {
                n3 = i2 + 1;
            }
            l2 -= (long)this.bins[i2];
            if (!bl2 || !Modality.CT.isSameModality(this.modality) || !(rescaleConverter.apply(n3 + this.offset) < -1025.0f)) break;
        }
        long l3 = (long)((double)l2 * 0.002);
        long l4 = (long)((double)l2 * 0.3);
        int n4 = this.a(n3, l3, l4);
        long l5 = (long)((double)l2 * 0.002);
        if (this.dontBackOffFromMaxValue) {
            this.a(n3, 0L);
        } else {
            n2 = 1;
            if ("MR".equalsIgnoreCase(this.modality)) {
                n2 = 4;
            }
            this.a(n3, l5 * (long)n2);
        }
        ++this.top;
        if (this.top == this.bottom) {
            ++this.top;
            --this.bottom;
        }
        this.top = (int)((float)this.top + (float)(this.top - this.bottom) * 0.1f);
        if (this.top > this.max) {
            this.top = this.max;
        }
        if (this.b(rescaleConverter)) {
            this.a(n4, rescaleConverter);
        }
        if (!this.subtraction && SeriesIdentifier.isFunctionalModality(this.modality) && (n2 = rescaleConverter.removeWithBounds(0.0f)) >= this.min && n2 < this.top && 0.3f > (float)Math.abs(n2 - this.bottom) / (float)(this.top - this.bottom)) {
            this.bottom = n2;
        }
        this.width = this.top - this.bottom;
        this.center = (float)(this.top + this.bottom) / 2.0f;
    }

    private void a(int n2, RescaleConverter rescaleConverter) {
        RescaleConverter rescaleConverter2 = new RescaleConverter(rescaleConverter.slope / 2.0f, rescaleConverter.intercept, rescaleConverter.unitScale);
        if (this.subStrat == SubtractionStrategy.c || rescaleConverter2.apply(n2) < 0.0f) {
            int n3 = 0;
            if (!(this.seriesInfoIndicatesSubtraction || this.subStrat != SubtractionStrategy.a && this.subStrat != SubtractionStrategy.b)) {
                n3 = MOptionPane.c(SeriesInfo.g, a.getProperty("BESTCONTRAST_OPEN"), a.getProperty("BESTCONTRAST_MAYBE"), 0);
            }
            if (n3 == 0) {
                this.subtraction = true;
                float f2 = rescaleConverter.apply(this.min);
                float f3 = rescaleConverter.apply(this.max);
                float f4 = Math.max(Math.abs(f2), f3);
                int n4 = (int)Math.ceil(rescaleConverter.removeRaw(f4));
                int n5 = (int)Math.floor(rescaleConverter.removeRaw(-f4));
                int[] nArray = new int[n4 - n5 + 1];
                int n6 = n5 - this.offset;
                int n7 = n4 - this.offset;
                int n8 = 0;
                this.offset += n6;
                if (n6 < 0) {
                    n8 = -n6;
                    n6 = 0;
                }
                if (n7 > this.bins.length - 1) {
                    n7 = this.bins.length - 1;
                }
                int n9 = n7 - n6 + 1;
                System.arraycopy(this.bins, n6, nArray, n8, n9);
                this.bins = nArray;
                this.max = n4;
                this.min = n5;
                if (this.width > 0.0f) {
                    this.bottom = (int)(this.center - this.width / 2.0f);
                    this.top = (int)(this.center + this.width / 2.0f);
                    rescaleConverter.intercept = 0.0f;
                }
                float f5 = rescaleConverter.apply(this.bottom);
                float f6 = rescaleConverter.apply(this.top);
                f5 = -Math.max(Math.abs(f5), f6);
                f6 = -f5;
                this.bottom = (int)rescaleConverter.removeRaw(f5);
                this.top = (int)rescaleConverter.removeRaw(f6);
                ay.a((Object)("Using subtraction type contrast: " + f5 + " " + f6), this);
            }
        }
    }

    private void a(int n2, long l2) {
        this.top = 0;
        long l3 = 0L;
        for (int i2 = this.bins.length - 1; i2 >= n2; --i2) {
            if ((l3 += (long)this.bins[i2]) < l2) continue;
            this.top = i2 + this.offset;
            break;
        }
    }

    private int a(int n2, long l2, long l3) {
        this.bottom = 0;
        long l4 = 0L;
        boolean bl2 = false;
        int n3 = 0;
        for (int i2 = n2; i2 < this.bins.length; ++i2) {
            if (!bl2 && (l4 += (long)this.bins[i2]) >= l2) {
                bl2 = true;
                this.bottom = i2 + this.offset;
            }
            if (l4 < l3) continue;
            n3 = i2 + this.offset;
            break;
        }
        return n3;
    }

    private boolean b(RescaleConverter rescaleConverter) {
        float f2 = rescaleConverter.apply(this.min);
        float f3 = rescaleConverter.apply(this.max);
        boolean bl2 = this.subStrat == SubtractionStrategy.c;
        bl2 |= this.subStrat == SubtractionStrategy.a && f2 < 0.0f && f3 > 0.0f && Math.abs(f2) / f3 > 0.35f;
        return bl2 |= this.subStrat == SubtractionStrategy.b && f2 < 0.0f && f3 > 0.0f;
    }

    public boolean a() {
        return this.subtraction;
    }

    public float b() {
        return this.width;
    }

    public float c() {
        return this.center;
    }

    public void a(int n2) {
        this.width = n2;
    }

    public void b(int n2) {
        this.center = n2;
    }

    public int d() {
        return this.top;
    }

    public int e() {
        return this.bottom;
    }

    public int[] f() {
        return this.bins;
    }

    public int g() {
        return this.offset;
    }

    public int h() {
        return this.max;
    }

    public int i() {
        return this.min;
    }

    public void a(int n2, int n3) {
        this.min = n2;
        this.max = n3;
    }

    public void a(boolean bl2) {
        this.dontBackOffFromMaxValue = bl2;
    }

    protected RescaleConverter a(RescaleConverter rescaleConverter) {
        return rescaleConverter;
    }

    public BestContrastor j() {
        try {
            return (BestContrastor)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
            return null;
        }
    }

    public void b(boolean bl2) {
        this.seriesInfoIndicatesSubtraction = bl2;
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + Arrays.hashCode(this.bins);
        n3 = 31 * n3 + this.bottom;
        n3 = 31 * n3 + Float.floatToIntBits(this.center);
        n3 = 31 * n3 + (this.dontBackOffFromMaxValue ? 1231 : 1237);
        n3 = 31 * n3 + this.max;
        n3 = 31 * n3 + this.min;
        n3 = 31 * n3 + (this.modality == null ? 0 : this.modality.hashCode());
        n3 = 31 * n3 + this.offset;
        n3 = 31 * n3 + (this.seriesInfoIndicatesSubtraction ? 1231 : 1237);
        n3 = 31 * n3 + (this.subStrat == null ? 0 : this.subStrat.hashCode());
        n3 = 31 * n3 + (this.subtraction ? 1231 : 1237);
        n3 = 31 * n3 + this.top;
        n3 = 31 * n3 + Float.floatToIntBits(this.width);
        return n3;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        BestContrastor bestContrastor = (BestContrastor)object;
        if (!Arrays.equals(this.bins, bestContrastor.bins)) {
            return false;
        }
        if (this.bottom != bestContrastor.bottom) {
            return false;
        }
        if (this.center != bestContrastor.center) {
            return false;
        }
        if (this.dontBackOffFromMaxValue != bestContrastor.dontBackOffFromMaxValue) {
            return false;
        }
        if (this.max != bestContrastor.max) {
            return false;
        }
        if (this.min != bestContrastor.min) {
            return false;
        }
        if (this.modality == null ? bestContrastor.modality != null : !this.modality.equals(bestContrastor.modality)) {
            return false;
        }
        if (this.offset != bestContrastor.offset) {
            return false;
        }
        if (this.seriesInfoIndicatesSubtraction != bestContrastor.seriesInfoIndicatesSubtraction) {
            return false;
        }
        if (this.subStrat != bestContrastor.subStrat) {
            return false;
        }
        if (this.subtraction != bestContrastor.subtraction) {
            return false;
        }
        if (this.top != bestContrastor.top) {
            return false;
        }
        return this.width == bestContrastor.width;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        ReadHelper readHelper = new ReadHelper();
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        readHelper.a(getField, (Object)this);
        if (ReadHelper.b(getField, "oldWidth")) {
            this.width = getField.get("oldWidth", 0);
        }
        if (ReadHelper.b(getField, "oldCenter")) {
            this.center = getField.get("oldCenter", 0);
        }
    }

    public /* synthetic */ Object clone() throws CloneNotSupportedException {
        return this.j();
    }

    public static enum SubtractionStrategy {
        a,
        b,
        c,
        d;

    }
}

