/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.viewer.algo;

import com.google.common.collect.MapMaker;
import com.mimvista.ExternallyVisible;
import com.mimvista.dicom.DataUnitUtils;
import com.mimvista.numerics.helpers.FuncUtils;
import com.mimvista.preferencesNew.ConfigPrefs;
import com.mimvista.util.DateUtils;
import com.mimvista.util.MIMFormat;
import com.mimvista.util.Messages;
import com.mimvista.util.ay;
import com.mimvista.util.az;
import com.mimvista.util.cn;
import com.mimvista.viewer.PTSeriesInfo;
import com.mimvista.viewer.SeriesInfo;
import com.mimvista.viewer.UnitHelper;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;

@ExternallyVisible
public class SuvCalculator {
    public static Messages props = Messages.a("Util");
    private static String a = props.getProperty("SUVCALC_BODY_WEIGHT_ABBREV");
    private static String b = props.getProperty("SUVCALC_LEAN_BODY_MASS_ABBREV");
    private static String c = props.getProperty("SUVCALC_BODY_SURFACE_AREA_ABBREV");
    private static String d = MIMFormat.a(props.getProperty("SUVCORR_BQML"), SuvCalculator.e());
    private static ConcurrentMap<SeriesInfo, Boolean> e = new MapMaker().weakKeys().makeMap();

    public static boolean tryCalcSuv(SeriesInfo seriesInfo, CalculationType calculationType) {
        if (calculationType == null || seriesInfo.decayCorrection == null) {
            return false;
        }
        String string = seriesInfo.decayCorrection.toLowerCase();
        if (string.equals("none")) {
            return false;
        }
        String string2 = seriesInfo.u().z();
        String string3 = seriesInfo.u().B();
        UnitHelper unitHelper = seriesInfo.u();
        if (calculationType == CalculationType.d) {
            SuvCalculator.doBQML(seriesInfo);
            return true;
        }
        try {
            boolean bl2 = SuvCalculator.a(seriesInfo);
            if (!bl2) {
                return false;
            }
            if (!unitHelper.p() && !unitHelper.w()) {
                return false;
            }
            double d2 = 3.7E7;
            if ((double)seriesInfo.dose / d2 < 0.001) {
                return false;
            }
            Calendar calendar = Calendar.getInstance();
            az<Date> az2 = SuvCalculator.getScanDateTimeQIBAMethod(seriesInfo);
            if (!az2.a()) {
                return false;
            }
            calendar.setTime(az2.b());
            Calendar calendar2 = Calendar.getInstance();
            calendar2.setTime(SuvCalculator.getRadiopharmStartDateIncludingDateAndTime(seriesInfo));
            double d3 = (double)(calendar.getTimeInMillis() - calendar2.getTimeInMillis()) / 1000.0;
            if (d3 < 0.0) {
                return false;
            }
            ay.b((Object)("Weight: " + seriesInfo.weight + " dose: " + seriesInfo.dose + " halflife: " + seriesInfo.halflife + "\nstarttime: " + seriesInfo.startTime + " scan time: " + az2.b() + " diff: " + d3 / 60.0), SuvCalculator.class);
            double d4 = Math.log(0.5) / (double)seriesInfo.halflife;
            double d5 = 0.0;
            if (string.equals("admin")) {
                d5 = 1.0;
            } else if (string.equals("start")) {
                d5 = Math.exp(d4 * d3);
            }
            double d6 = seriesInfo.weight;
            String string4 = a;
            if (calculationType == CalculationType.b) {
                d6 = seriesInfo.sex.equals("F") ? (double)(1.07f * seriesInfo.weight) - 148.0 * Math.pow((double)seriesInfo.weight / ((double)seriesInfo.patientSize * 100.0), 2.0) : (double)(1.1f * seriesInfo.weight) - 120.0 * Math.pow((double)seriesInfo.weight / ((double)seriesInfo.patientSize * 100.0), 2.0);
                string4 = b;
            } else if (calculationType == CalculationType.c) {
                d6 = 0.007184 * Math.pow(seriesInfo.weight, 0.425) * Math.pow((double)seriesInfo.patientSize * 100.0, 0.725);
                string4 = c;
            }
            if (Math.abs(d6 - 0.0) < (double)1.0E-5f) {
                return false;
            }
            float f2 = (float)(1000.0 * d6 / ((double)seriesInfo.dose * d5));
            if (Float.isInfinite(f2) || Float.isNaN(f2)) {
                return false;
            }
            unitHelper.a("SUV", string4, f2);
            return true;
        }
        catch (Exception exception) {
            ay.d((Object)("Unable to calculate " + (Object)((Object)calculationType) + " SUV"), (Throwable)exception, SuvCalculator.class);
            unitHelper.b(unitHelper.a());
            return false;
        }
    }

    public static void doBQML(SeriesInfo seriesInfo) {
        seriesInfo.acqTime = seriesInfo.originalAcqTime;
        seriesInfo.acqDate = seriesInfo.originalAcqDate;
        seriesInfo.weight = seriesInfo.originalWeight;
        seriesInfo.dose = seriesInfo.originalDose;
        seriesInfo.halflife = seriesInfo.originalHalfLife;
        seriesInfo.startTime = seriesInfo.originalStartTime;
        seriesInfo.patientSize = seriesInfo.originalPatientSize;
        seriesInfo.sex = seriesInfo.originalSex;
        seriesInfo.u().b(seriesInfo.u().a());
        seriesInfo.rescale.unitScale = 1.0f;
    }

    public static double arr2double(byte[] byArray, int n2) {
        int n3 = 0;
        int n4 = 8;
        int n5 = 0;
        byte[] byArray2 = new byte[n4];
        for (n3 = n2; n3 < n2 + n4; ++n3) {
            byArray2[n5] = byArray[n3];
            ++n5;
        }
        long l2 = 0L;
        n3 = 0;
        for (int i2 = 0; i2 < 64; i2 += 8) {
            l2 |= (long)(byArray2[n3] & 0xFF) << i2;
            ++n3;
        }
        return Double.longBitsToDouble(l2);
    }

    private static boolean a(SeriesInfo seriesInfo) {
        String string;
        if (seriesInfo.modInfo == null || !(seriesInfo.modInfo instanceof PTSeriesInfo)) {
            return false;
        }
        PTSeriesInfo pTSeriesInfo = (PTSeriesInfo)seriesInfo.modInfo;
        String[] stringArray = pTSeriesInfo.radNucCodeSequence;
        boolean bl2 = false;
        if (seriesInfo.radpharm != null && seriesInfo.radpharm.indexOf("FDG") > -1) {
            bl2 = true;
        } else if (stringArray != null && ("C-111A1".equals(string = stringArray[1]) || "C-105A1".equals(string))) {
            bl2 = true;
        }
        if (!bl2 && seriesInfo.halflife > 70.0f && (double)seriesInfo.halflife < 5.0E7) {
            bl2 = true;
        }
        return bl2;
    }

    public static Date getRadiopharmStartDateIncludingDateAndTime(SeriesInfo seriesInfo) {
        String string = "HH";
        String string2 = "mm";
        String string3 = "ss";
        if (seriesInfo == null || seriesInfo.startTime == null) {
            return null;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
        int n2 = Integer.valueOf(simpleDateFormat.format(seriesInfo.startTime));
        simpleDateFormat = new SimpleDateFormat(string2);
        int n3 = Integer.valueOf(simpleDateFormat.format(seriesInfo.startTime));
        simpleDateFormat = new SimpleDateFormat(string3);
        int n4 = Integer.valueOf(simpleDateFormat.format(seriesInfo.startTime));
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(seriesInfo.startDate);
        calendar.set(11, n2);
        calendar.set(12, n3);
        calendar.set(13, n4);
        return calendar.getTime();
    }

    public static az<Date> getScanDateTimeQIBAMethod(SeriesInfo seriesInfo) {
        boolean bl2;
        Object object;
        Date date;
        final boolean bl3 = !e.containsKey(seriesInfo);
        e.put(seriesInfo, true);
        FuncUtils.m<String> m2 = new FuncUtils.m<String>(){

            public void a(String string) {
                if (bl3) {
                    ay.b((Object)string, "SUV");
                }
            }

            @Override
            public /* synthetic */ void doIt(Object object) {
                this.a((String)object);
            }
        };
        Date date2 = seriesInfo.e();
        Date date3 = seriesInfo.f();
        Date date4 = null;
        Date date5 = null;
        if (date2 != null && date3 != null) {
            long l2;
            date = DateUtils.b(date2, date3);
            object = new Date(0L);
            long l3 = date.getTime() - ((Date)object).getTime();
            if (l3 > (l2 = TimeUnit.MILLISECONDS.convert(48L, TimeUnit.HOURS))) {
                date4 = date;
            }
        }
        date = SuvCalculator.b(seriesInfo);
        object = seriesInfo.correctedImage;
        String string = seriesInfo.decayCorrection;
        boolean bl4 = false;
        boolean bl5 = bl2 = cn.h((String)object) || cn.h(string);
        if (!bl2) {
            boolean bl6 = bl4 = ((String)object).contains("ATTN") && (((String)object).contains("DECAY") || ((String)object).contains("DECY")) && string.contains("START");
        }
        if (!bl4 && bl3) {
            m2.doIt("Missing or unexpected corrections, assuming ATTN, DECAY and relative to START: " + seriesInfo.seriesDesc);
        }
        if (date4 == null) {
            if (date != null) {
                m2.doIt("Missing or bogus series date, using acquisition date to calculate SUV: " + seriesInfo.seriesDesc);
                date5 = date;
            } else {
                m2.doIt("No series date or acqusition date, we can't compute SUV on this!: " + seriesInfo.seriesDesc);
                date5 = null;
            }
        } else if (date != null) {
            date5 = date4.before(date) || date4.equals(date) ? date4 : date;
        } else {
            m2.doIt("Series date but no acquisition date, assuming series date is sane for SUV calculation: " + seriesInfo.seriesDesc);
            date5 = date4;
        }
        if (date5 != null) {
            return az.b(date5);
        }
        return az.c();
    }

    private static Date b(SeriesInfo seriesInfo) {
        String string = "HH";
        String string2 = "mm";
        String string3 = "ss";
        if (seriesInfo.acqTime == null) {
            return null;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
        int n2 = Integer.valueOf(simpleDateFormat.format(seriesInfo.acqTime));
        simpleDateFormat = new SimpleDateFormat(string2);
        int n3 = Integer.valueOf(simpleDateFormat.format(seriesInfo.acqTime));
        simpleDateFormat = new SimpleDateFormat(string3);
        int n4 = Integer.valueOf(simpleDateFormat.format(seriesInfo.acqTime));
        Date date = seriesInfo.acqDate;
        if (date == null) {
            ay.b((Object)("No acq date, trying series date: " + seriesInfo.seriesDesc), "SUV");
            date = seriesInfo.e();
        }
        if (date == null) {
            ay.b((Object)("No seriesDate date, trying study date: " + seriesInfo.seriesDesc), "SUV");
            date = seriesInfo.g();
        }
        if (date == null) {
            ay.b((Object)("No study date, trying any date: " + seriesInfo.seriesDesc), "SUV");
            date = seriesInfo.j();
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, n2);
        calendar.set(12, n3);
        calendar.set(13, n4);
        return calendar.getTime();
    }

    private static final String e() {
        String string = Messages.a("DVH").getProperty("DVH_UNIT_ML");
        if (ConfigPrefs.showCcInsteadOfMl.getValue().booleanValue()) {
            string = Messages.a("DVH").getProperty("DVH_UNIT_CC");
        }
        return string;
    }

    static /* synthetic */ String a() {
        return a;
    }

    static /* synthetic */ String b() {
        return b;
    }

    static /* synthetic */ String c() {
        return c;
    }

    static /* synthetic */ String d() {
        return d;
    }

    public static enum CalculationType {
        a("BW", SuvCalculator.a(), props.getProperty("SUVCORR_BODY_WEIGHT")),
        b("LBM", SuvCalculator.b(), props.getProperty("SUVCORR_LEAN_BODY_MASS")),
        c("BSA", SuvCalculator.c(), props.getProperty("SUVCORR_BODY_SURFACE_AREA")),
        d("BQML", SuvCalculator.d(), MIMFormat.a(props.getProperty("SUVCORR_BQML"), ConfigPrefs.showCcInsteadOfMl.getValue() != false ? "cc" : "ml"));

        String key = "";
        String abbreviation = "";
        String description = "";

        private CalculationType(String string2, String string3, String string4) {
            this.key = string2;
            this.abbreviation = string3;
            this.description = string4;
        }

        public static CalculationType a(UnitHelper.ImageUnit imageUnit) {
            if (imageUnit.canonBaseUnit == null) {
                return null;
            }
            if (DataUnitUtils.BQML_CANON_.matchesUnit(imageUnit.canonBaseUnit)) {
                return d;
            }
            if (imageUnit.unitDesc == null) {
                return null;
            }
            String string = imageUnit.unitDesc.toLowerCase(Locale.ENGLISH);
            if (string.equals("lbm")) {
                return b;
            }
            if (string.equals("bw")) {
                return a;
            }
            if (string.equals("bsa")) {
                return c;
            }
            return null;
        }

        public static CalculationType a(String string) {
            CalculationType[] calculationTypeArray;
            for (CalculationType calculationType : calculationTypeArray = CalculationType.values()) {
                if (!calculationType.key.equals(string)) continue;
                return calculationType;
            }
            return a;
        }

        public String a() {
            return this.key;
        }

        public String b() {
            return this.abbreviation;
        }

        public String c() {
            return this.description;
        }
    }
}

