/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.viewer.algo;

import com.mimvista.archive.Parser;
import com.mimvista.archive.gui.SendToDestination;
import com.mimvista.archive.gui.SeriesFilesTransfer;
import com.mimvista.archive.search.SearchSource;
import com.mimvista.dicom.Modality;
import com.mimvista.dicom.UIDContainer;
import com.mimvista.dicom.util.UIDGenerator;
import com.mimvista.dicom.write.rtst.DicomRtStructCreator;
import com.mimvista.file.Path;
import com.mimvista.internals.ViewController;
import com.mimvista.update.VersionNumber;
import com.mimvista.util.MIMContext;
import com.mimvista.util.Messages;
import com.mimvista.util.ay;
import com.mimvista.util.progress.Progress;
import com.mimvista.util.progress.u;
import com.mimvista.viewer.SeriesInfo;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.dcm4che2.data.BasicDicomObject;
import org.dcm4che2.data.DicomElement;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.VR;
import org.dcm4che2.io.DicomOutputStream;

public abstract class b {
    public static final String ORIGINAL_MODALITY_SENTINEL = "ORIGINAL";
    protected ViewController viewState;
    protected SeriesInfo info;
    protected String seriesDescription = "";
    protected String studyDescription = null;
    protected String sopInstanceUID = null;
    protected String stationName = "";
    private BasicDicomObject meta = null;
    private BasicDicomObject dicom = null;

    public abstract String getProgressTitle();

    public abstract Modality getModality();

    public abstract UIDContainer getSopClassUID();

    public abstract String getSeriesDate();

    public abstract String getSeriesTime();

    protected abstract void fillIodSpecificTags(DicomObject var1);

    public String getSeriesDescription() {
        return this.seriesDescription;
    }

    public String getStudyDescription() {
        return this.studyDescription;
    }

    public String getOperatorName() {
        return null;
    }

    public void setSeriesDescription(String string) {
        this.seriesDescription = string;
    }

    public void setStudyDescription(String string) {
        this.studyDescription = string;
    }

    public String getSopInstanceUID() {
        return this.sopInstanceUID;
    }

    public String getSeriesInstanceUID() {
        return this.sopInstanceUID;
    }

    public final DicomObject getDicomObject() {
        this.buildDICOM();
        return this.dicom;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeTo(SendToDestination sendToDestination, Progress progress) {
        u u2 = new u(progress, 0.5f);
        u u3 = new u(progress, 0.5f);
        u3.o();
        File file = this.writeToTempFile(u2);
        if (file != null) {
            try {
                this.setupProgress(u3, Messages.a("Dicom", "DCM_SERIES_SAVE_SENDING"));
                if (sendToDestination != null) {
                    SearchSource searchSource = this.viewState != null ? this.viewState.bJ() : null;
                    new SeriesFilesTransfer(searchSource, file.getParent()).a(sendToDestination, status -> {
                        switch (status) {
                            case c: {
                                u3.b();
                                break;
                            }
                            case d: {
                                u3.k();
                                break;
                            }
                            case e: {
                                u3.j();
                                break;
                            }
                            case g: {
                                u3.m();
                                break;
                            }
                            case f: {
                                u3.l();
                            }
                        }
                    });
                }
            }
            catch (Throwable throwable) {
                ay.d((Object)"Error writing DICOM series", throwable, this);
                boolean bl2 = false;
                return bl2;
            }
            finally {
                u3.b();
            }
            return true;
        }
        return false;
    }

    public String getTempFileName() {
        this.initializeSopInstanceUIDIfNeeded();
        String string = (this.getModality().get() + ".").toLowerCase();
        return string + this.sopInstanceUID + ".dcm";
    }

    public File writeToTempFile(Progress progress) {
        String string = this.getModality() == Modality.REG ? "reg" : "rtstSave";
        File file = new File(Path.getTempPath(string, true, true), this.getTempFileName());
        if (this.writeTo(file, progress)) {
            return file;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean writeTo(File file, Progress progress) {
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
            boolean bl2 = this.writeTo(fileOutputStream, progress);
            return bl2;
        }
        catch (Exception exception) {
            ay.d((Object)("Error writing " + this.getModality()), (Throwable)exception, this);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeTo(OutputStream outputStream, Progress progress) throws IOException {
        this.setupProgress(progress, Messages.a("Dicom", "DCM_SERIES_SAVE_BUILDING"));
        boolean bl2 = true;
        try (DicomOutputStream dicomOutputStream = new DicomOutputStream(outputStream);){
            this.buildDICOM();
            dicomOutputStream.writeFileMetaInformation((DicomObject)this.meta);
            dicomOutputStream.writeDataset((DicomObject)this.dicom, "1.2.840.10008.1.2");
            dicomOutputStream.flush();
        }
        catch (DicomRtStructCreator.SavingAtlasContoursException savingAtlasContoursException) {
            ay.d((Object)"Cannot save atlas contours", (Throwable)savingAtlasContoursException, this);
            progress.b_(Messages.a("Dicom", "DCM_SERIES_SAVE_ATLAS"));
            progress.k();
            bl2 = false;
        }
        catch (DicomRtStructCreator.SavingEmptyContourException savingEmptyContourException) {
            ay.d((Object)"Cannot save empty contours with current preferences", (Throwable)savingEmptyContourException, this);
            progress.b_(Messages.a("Dicom", "DCM_RT_STRUCT_CREATOR_EMPTY_WARNING"));
            progress.k();
            bl2 = false;
        }
        catch (Throwable throwable) {
            ay.d((Object)("Error saving " + this.getModality()), throwable, this);
            progress.k();
            bl2 = false;
        }
        finally {
            progress.b();
        }
        return bl2;
    }

    protected void initializeDicom() {
        this.meta = new BasicDicomObject();
        this.initializeSopInstanceUIDIfNeeded();
        this.includeMetaInformation();
        this.dicom = new BasicDicomObject();
        String string = this.viewState != null ? (String)this.viewState.getDicomSeries().getTagValue(524293) : this.dicom.getString(524293);
        Parser.setDefaultSpecificCharacterSet((DicomObject)this.dicom, string);
        this.includePatientInfoModule();
        this.includeStudyModule();
        this.includePatientStudyModule();
        this.includeSeriesModule();
        this.includeGeneralEquipmentModule();
        this.includeSopCommonModule();
    }

    private void includeMetaInformation() {
        this.meta.putString(131074, VR.UI, this.getSopClassUID().uid);
        this.meta.putString(131075, VR.UI, this.sopInstanceUID);
        this.meta.putString(131088, VR.UI, "1.2.840.10008.1.2");
        this.meta.putBytes(131073, VR.OB, new byte[]{0, 1});
        this.meta.putString(131090, VR.UI, "2.16.840.1.114362.1");
        String string = this.getSoftwareName();
        String string2 = this.getVersionNumber();
        String string3 = string + " " + string2;
        this.meta.putString(131091, VR.SH, string3);
        this.meta.putString(131094, VR.AE, string);
    }

    protected void initializeSopInstanceUIDIfNeeded() {
        if (this.sopInstanceUID == null) {
            this.sopInstanceUID = UIDGenerator.generateUID();
        }
    }

    protected String getSoftwareName() {
        String string = "MIM";
        if (MIMContext.j()) {
            string = "MIMviewer";
        }
        return string;
    }

    private String getVersionNumber() {
        String[] stringArray = VersionNumber.loadVersion();
        if (MIMContext.j()) {
            stringArray[0] = String.valueOf(Integer.parseInt(stringArray[0]) - 3);
        }
        return stringArray[0] + "." + stringArray[1] + "." + stringArray[2];
    }

    protected void includePatientInfoModule() {
        this.dicom.putString(0x100010, VR.PN, this.info.patientNameRaw);
        this.dicom.putString(0x100020, VR.LO, this.info.patientId);
        this.dicom.putString(0x100030, VR.DA, this.info.birthDate);
        this.dicom.putString(0x100040, VR.CS, this.info.sex);
        this.dicom.putString(0x101010, VR.AS, this.info.A());
    }

    protected void includePatientStudyModule() {
        this.dicom.putString(0x101010, VR.AS, this.info.A());
        if (!Float.isNaN(this.info.patientSize) && this.info.patientSize > 0.0f) {
            this.dicom.putFloat(0x101020, VR.DS, this.info.patientSize);
        }
        if (!Float.isNaN(this.info.weight) && this.info.weight > 0.0f) {
            this.dicom.putFloat(0x101030, VR.DS, this.info.weight);
        }
    }

    protected void includeStudyModule() {
        this.dicom.putString(0x20000D, VR.UI, this.info.studyUID);
        this.dicom.putString(0x200010, null, this.info.studyID);
        String string = this.info.N();
        if (this.info.hasStudyDate) {
            this.dicom.putString(524320, VR.DA, string);
        } else {
            this.dicom.putString(524320, VR.DA, "");
        }
        this.dicom.putString(524336, VR.TM, this.info.studyTimeRaw);
        this.dicom.putString(524432, VR.PN, this.info.referringPhysRaw);
        this.dicom.putString(524368, VR.SH, this.info.accession);
        this.dicom.putString(528432, null, this.getStudyDescription() == null ? this.info.studyDesc : this.getStudyDescription());
    }

    protected void includeSeriesModule() {
        this.dicom.putString(524384, VR.CS, this.getModality().get());
        this.dicom.putString(0x20000E, VR.UI, this.getSeriesInstanceUID());
        this.dicom.putInt(0x200011, VR.IS, 1);
        this.dicom.putString(524321, VR.DA, this.getSeriesDate());
        this.dicom.putString(524337, VR.TM, this.getSeriesTime());
        this.dicom.putString(524306, VR.DA, this.getSeriesDate());
        this.dicom.putString(524307, VR.TM, this.getSeriesTime());
        this.dicom.putString(528446, VR.LO, this.getSeriesDescription());
        String string = this.getOperatorName();
        if (string != null) {
            this.dicom.putString(528496, VR.PN, string);
        }
    }

    protected void includeSopCommonModule() {
        this.dicom.putString(524312, VR.UI, this.sopInstanceUID);
        this.dicom.putString(524310, VR.UI, this.getSopClassUID().uid);
    }

    protected void includeGeneralEquipmentModule() {
        this.dicom.putString(524400, VR.LO, "MIM Software Inc.");
        this.dicom.putString(524416, VR.LO, this.info.institutionName);
        if (this.stationName != null) {
            this.dicom.putString(528400, VR.SH, this.stationName);
        }
        this.dicom.putString(528528, VR.LO, this.getSoftwareName());
        this.dicom.putString(1576992, VR.LO, this.getVersionNumber());
    }

    protected void addCodeSequence(DicomElement dicomElement, String string, String string2, String string3) {
        BasicDicomObject basicDicomObject = new BasicDicomObject();
        dicomElement.addDicomObject((DicomObject)basicDicomObject);
        basicDicomObject.putString(524544, VR.SH, string);
        basicDicomObject.putString(524546, VR.SH, string2);
        basicDicomObject.putString(524548, VR.LO, string3);
    }

    private final void buildDICOM() {
        if (this.dicom == null || this.meta == null || this.dicom.isEmpty() || this.meta.isEmpty()) {
            this.initializeDicom();
            this.fillIodSpecificTags((DicomObject)this.dicom);
        }
    }

    private void setupProgress(Progress progress, String string) {
        progress.a(this.getProgressTitle());
        progress.b_(string);
        progress.a(true);
        progress.c(false);
        progress.a();
    }
}

