/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.workflow.backend;

import com.google.common.collect.Sets;
import com.mimvista.dicom.util.DicomSeriesEvaluator;
import com.mimvista.dicom.util.DicomTagParseException;
import com.mimvista.dicom.util.Operator;
import com.mimvista.dicom.util.TagPath;
import com.mimvista.state.ReadHelper;
import com.mimvista.util.ay;
import com.mimvista.util.cn;
import com.mimvista.workflow.backend.g;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Tag
implements Serializable {
    private static final long serialVersionUID = 4982286100818574126L;
    private String id;
    private String tag;
    private String value;
    private Operator operator;

    public Tag(String string, String string2, String string3) {
        this(string, string2, string3, Operator.CONTAINS);
    }

    public Tag(String string, String string2, String string3, Operator operator) {
        this.id = string != null ? string : "";
        this.tag = Tag.a(string2);
        this.value = string3 != null ? string3 : "";
        this.operator = operator != null ? operator : Operator.CONTAINS;
    }

    public Tag(String string, TagPath tagPath, String string2) {
        this(string, tagPath, string2, Operator.CONTAINS);
    }

    public Tag(String string, TagPath tagPath, String string2, Operator operator) {
        this.id = string != null ? string : "";
        this.tag = tagPath.toHexPath();
        this.value = string2 != null ? string2 : "";
        this.operator = operator != null ? operator : Operator.CONTAINS;
    }

    public Tag(Tag tag) {
        this.id = tag.id;
        this.tag = tag.tag;
        this.value = tag.value;
        this.operator = tag.operator;
    }

    public Tag(Element element) {
        this.id = element.getAttribute("id");
        this.id = this.id == null ? "" : this.id;
        this.tag = Tag.a(element.getAttribute("tag"));
        this.value = element.getAttribute("value");
        this.value = this.value == null ? "" : this.value;
        String string = element.getAttribute("regex");
        this.operator = Boolean.parseBoolean(string) || "1".equals(string) ? Operator.REGEX : Operator.safeParse(element.getAttribute("operator"));
    }

    public String a() {
        return this.id;
    }

    public String b() {
        return this.tag;
    }

    public String c() {
        return this.value;
    }

    public Operator d() {
        return this.operator;
    }

    private List<String> f() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : this.value.split(",")) {
            arrayList.add(string.trim());
        }
        return arrayList;
    }

    private Set<String> g() {
        return Sets.newHashSet((Object[])this.value.toLowerCase().split(","));
    }

    public TagPath e() {
        try {
            return TagPath.parse(this.tag);
        }
        catch (DicomTagParseException dicomTagParseException) {
            ay.d((Object)("Could not parse this tag into a TagPath: " + this.tag), (Throwable)dicomTagParseException, this);
            return new TagPath();
        }
    }

    public Node a(Document document) {
        Element element = document.createElementNS(null, "tag");
        element.setAttributeNS(null, "id", this.id);
        element.setAttributeNS(null, "tag", this.tag);
        element.setAttributeNS(null, "value", this.value);
        element.setAttributeNS(null, "operator", this.operator.name());
        return element;
    }

    public boolean a(g g2) {
        if (g2.getDicomSeries() == null) {
            return false;
        }
        DicomSeriesEvaluator dicomSeriesEvaluator = new DicomSeriesEvaluator(g2.getDicomSeries());
        if (this.operator == Operator.CONTAINS || this.operator == Operator.IS) {
            return dicomSeriesEvaluator.evaluate(this.e(), this.operator, this.f());
        }
        if (this.operator == Operator.DOESNT_CONTAIN) {
            return !dicomSeriesEvaluator.evaluate(this.e(), Operator.CONTAINS, this.f());
        }
        if (this.operator == Operator.IS_NOT) {
            return !dicomSeriesEvaluator.evaluate(this.e(), Operator.IS, this.f());
        }
        return dicomSeriesEvaluator.evaluate(this.e(), this.operator, this.value);
    }

    private boolean a(Tag tag) {
        if (tag == null) {
            return false;
        }
        if (this.operator == Operator.REGEX) {
            return this.value.equals(tag.value);
        }
        return Sets.difference(this.g(), tag.g()).isEmpty();
    }

    public String toString() {
        return this.id + " " + this.tag + " " + this.operator.name() + " " + this.value;
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + (this.operator == null ? 0 : this.operator.hashCode());
        n3 = 31 * n3 + (this.tag == null ? 0 : this.tag.hashCode());
        return n3;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Tag tag = (Tag)object;
        if (this.operator != tag.operator) {
            return false;
        }
        if (this.tag == null ? tag.tag != null : !this.tag.equals(tag.tag)) {
            return false;
        }
        return this.a(tag);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        boolean bl2;
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        this.id = (String)getField.get("id", null);
        this.tag = Tag.a((String)getField.get("tag", ""));
        this.value = (String)getField.get("value", "");
        this.operator = ReadHelper.b(getField, "regex") ? ((bl2 = getField.get("regex", false)) ? Operator.REGEX : Operator.CONTAINS) : (Operator)((Object)getField.get("operator", (Object)Operator.CONTAINS));
    }

    private static String a(String string) {
        if (cn.h(string)) {
            return "";
        }
        try {
            return TagPath.parse(string).toHexPath();
        }
        catch (Exception exception) {
            return string;
        }
    }
}

