/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.workflow.backend;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mimvista.dicom.SeriesIdentifier;
import com.mimvista.state.ReadHelper;
import com.mimvista.util.Pair;
import com.mimvista.util.ay;
import com.mimvista.util.bm;
import com.mimvista.util.cn;
import com.mimvista.workflow.backend.Tag;
import com.mimvista.workflow.backend.TargetGrouping;
import com.mimvista.workflow.backend.i;
import com.mimvista.workflow.backend.y;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Target
implements bm,
i,
Serializable,
Comparable<Target> {
    private static final long serialVersionUID = -2534870123174350017L;
    private String name = "";
    private String modality = "";
    private String chronology = "";
    private Collection<Tag> tags = new ArrayList<Tag>();
    private String expression = "";
    private List<String> derivedFromNames = new ArrayList<String>();
    private boolean is2D;
    private TargetGrouping grouping = TargetGrouping.a;
    private long chronologyGroupingThresholdInMs = TimeUnit.HOURS.toMillis(6L);
    private transient boolean b = false;
    public static final Comparator<Target> a = (target, target2) -> {
        if (target.a().isOptional && target2.a().isOptional) {
            return 0;
        }
        if (target.a().isOptional) {
            return 1;
        }
        if (target2.a().isOptional) {
            return -1;
        }
        return 0;
    };

    public Target(String string) {
        this(string, "");
    }

    public Target(String string, String string2) {
        this(string, string2, null, null, null);
    }

    public Target(String string, String string2, String string3, String string4, Collection<Tag> collection) {
        this(string, string2, string3, string4, collection, new ArrayList<String>(), SeriesIdentifier.is2dModality(string2));
    }

    public Target(String string, String string2, String string3, String string4, Collection<Tag> collection, Collection<String> collection2, boolean bl2) {
        this(string, string2, string3, string4, collection, collection2, bl2, TargetGrouping.a);
    }

    public Target(String string, String string2, String string3, String string4, Collection<Tag> collection, Collection<String> collection2, boolean bl2, TargetGrouping targetGrouping) {
        this.name = string != null ? string : "";
        this.modality = string2 != null ? string2 : "";
        this.chronology = string3 != null ? string3 : "";
        String string5 = this.expression = string4 != null ? string4 : "";
        if (collection != null) {
            this.tags.addAll(collection);
        }
        if (collection2 != null) {
            this.derivedFromNames.addAll(collection2);
        }
        this.is2D = bl2;
        this.grouping = targetGrouping;
    }

    public Target(Target target) {
        this.name = target.name;
        this.modality = target.modality;
        this.chronology = target.chronology;
        this.expression = target.expression;
        this.tags = target.g();
        this.derivedFromNames = Lists.newArrayList(target.derivedFromNames);
        this.chronologyGroupingThresholdInMs = target.chronologyGroupingThresholdInMs;
        this.is2D = target.is2D;
        this.grouping = target.grouping;
    }

    public TargetGrouping a() {
        return this.grouping;
    }

    @Override
    public boolean is2D() {
        return this.is2D;
    }

    @Override
    public String getWorkflowDisplayName() {
        return this.name;
    }

    public boolean b() {
        return !this.getModality().equals("") && !this.getModality().equals(".*");
    }

    @Override
    public String getModality() {
        return this.modality;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public boolean c() {
        return this.d() != null && !"".equals(this.d());
    }

    public String d() {
        return this.chronology;
    }

    public String e() {
        int n2 = this.f();
        return n2 == -1 ? "" : Integer.toString(n2 + 1);
    }

    public int f() {
        if (this.chronology.length() == 0) {
            return -1;
        }
        try {
            return Integer.valueOf(this.chronology);
        }
        catch (NumberFormatException numberFormatException) {
            ay.d((Object)("Bad chronology: " + this.chronology), (Throwable)numberFormatException, this);
            return -1;
        }
    }

    public Collection<Tag> g() {
        return ImmutableList.copyOf(this.tags);
    }

    public String h() {
        return this.expression;
    }

    public boolean i() {
        return this.derivedFromNames.size() != 0;
    }

    public List<String> j() {
        return ImmutableList.copyOf(this.derivedFromNames);
    }

    public Pair<TimeUnit, Long> k() {
        ArrayList arrayList = Lists.newArrayList((Object[])new TimeUnit[]{TimeUnit.MILLISECONDS, TimeUnit.SECONDS, TimeUnit.MINUTES, TimeUnit.HOURS, TimeUnit.DAYS});
        for (int i2 = 0; i2 < arrayList.size() - 1; ++i2) {
            long l2 = ((TimeUnit)((Object)arrayList.get(i2 + 1))).toMillis(1L);
            if (this.chronologyGroupingThresholdInMs >= l2 && this.chronologyGroupingThresholdInMs % l2 == 0L) continue;
            TimeUnit timeUnit = (TimeUnit)((Object)arrayList.get(i2));
            return Pair.get(timeUnit, timeUnit.convert(this.chronologyGroupingThresholdInMs, TimeUnit.MILLISECONDS));
        }
        return Pair.get(TimeUnit.DAYS, TimeUnit.DAYS.convert(this.chronologyGroupingThresholdInMs, TimeUnit.MILLISECONDS));
    }

    public long l() {
        return this.chronologyGroupingThresholdInMs;
    }

    public void a(Document document, Element element) {
        y.a(document, element, this);
    }

    private void a(String string) {
        this.name = string;
    }

    public int a(Target target) {
        return this.getWorkflowDisplayName().compareTo(target.getWorkflowDisplayName());
    }

    public String toString() {
        return this.getWorkflowDisplayName() + "," + this.getModality() + "," + this.d() + "," + this.derivedFromNames;
    }

    public boolean m() {
        return this.b;
    }

    public void a(boolean bl2) {
        this.b = bl2;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        boolean bl2;
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        ReadHelper readHelper = new ReadHelper();
        readHelper.a(getField, (Object)this);
        if (ReadHelper.b(getField, "isMultiSeries") && (bl2 = getField.get("isMultiSeries", false))) {
            this.grouping = TargetGrouping.c;
        }
        if (ReadHelper.b(getField, "useTimeWithDateForChronologyMapping")) {
            this.chronologyGroupingThresholdInMs = getField.get("useTimeWithDateForChronologyMapping", false) ? TimeUnit.SECONDS.toMillis(1L) : TimeUnit.HOURS.toMillis(6L);
        }
    }

    @Override
    public /* synthetic */ int compareTo(Object object) {
        return this.a((Target)object);
    }

    public static class b
    extends a {
        @Override
        public int a(Target target, Target target2) {
            return super.a(target, target2) * -1;
        }

        @Override
        public /* synthetic */ int compare(Object object, Object object2) {
            return this.a((Target)object, (Target)object2);
        }
    }

    public static class a
    implements Comparator<Target> {
        public int a(Target target, Target target2) {
            boolean bl2;
            boolean bl3 = target.a() == TargetGrouping.e;
            boolean bl4 = bl2 = target2.a() == TargetGrouping.e;
            if (bl3 != bl2) {
                if (bl3) {
                    return -1;
                }
                return 1;
            }
            return 0;
        }

        @Override
        public /* synthetic */ int compare(Object object, Object object2) {
            return this.a((Target)object, (Target)object2);
        }
    }

    public static class MutableTarget
    implements Serializable {
        private static final long serialVersionUID = -6443112191228526176L;
        private Target back;

        public MutableTarget(Target target) {
            this.back = new Target(target);
        }

        public MutableTarget() {
            this.back = new Target("");
        }

        public MutableTarget a(String string) {
            this.back.a(cn.i(string));
            return this;
        }

        public MutableTarget b(String string) {
            this.back.modality = cn.i(string);
            return this;
        }

        public MutableTarget c(String string) {
            this.back.chronology = cn.i(string);
            return this;
        }

        public MutableTarget d(String string) {
            this.back.expression = cn.i(string);
            return this;
        }

        public MutableTarget a(Collection<Tag> collection) {
            this.back.tags = new ArrayList();
            if (collection != null) {
                this.back.tags.addAll(collection);
            }
            return this;
        }

        public MutableTarget a(boolean bl2) {
            this.back.is2D = bl2;
            return this;
        }

        public MutableTarget a(long l2) {
            this.back.chronologyGroupingThresholdInMs = l2;
            return this;
        }

        public MutableTarget e(String string) {
            if (string == null) {
                return this;
            }
            this.back.derivedFromNames.add(string);
            return this;
        }

        public MutableTarget a(List<String> list) {
            if (list == null) {
                return this;
            }
            this.back.derivedFromNames.addAll(list);
            return this;
        }

        public MutableTarget a() {
            this.back.derivedFromNames.clear();
            return this;
        }

        public MutableTarget f(String string) {
            this.back.derivedFromNames.remove(string);
            return this;
        }

        public void a(Target target) {
            this.back = target;
        }

        public Target b() {
            return this.back;
        }

        public Target c() {
            return new Target(this.back);
        }

        public MutableTarget a(TargetGrouping targetGrouping) {
            this.back.grouping = targetGrouping;
            return this;
        }
    }
}

