/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.workflow.backend;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.primitives.Ints;
import com.mimvista.ExternallyVisible;
import com.mimvista.commands.f;
import com.mimvista.commands.workflow.WorkflowCommand;
import com.mimvista.commands.workflow.dose.IsodoseSettingCommand;
import com.mimvista.commands.workflow.h;
import com.mimvista.commands.workflow.launch.d;
import com.mimvista.commands.workflow.launch.h;
import com.mimvista.dose.constraints.DoseConstraintSetCSVUtils;
import com.mimvista.file.MIMFile;
import com.mimvista.file.PathUtils;
import com.mimvista.gui.util.ImageManipulator;
import com.mimvista.imports.ImportContainer;
import com.mimvista.internals.ViewController;
import com.mimvista.internals.dose.IsodoseSettingData;
import com.mimvista.license.LicenseTransformer;
import com.mimvista.preferencesNew.WorkflowPrefs;
import com.mimvista.report.gui.TemplateSavePage;
import com.mimvista.util.Messages;
import com.mimvista.util.Pair;
import com.mimvista.util.ay;
import com.mimvista.util.cg;
import com.mimvista.util.cn;
import com.mimvista.workflow.backend.Target;
import com.mimvista.workflow.backend.TargetGrouping;
import com.mimvista.workflow.backend.Variable;
import com.mimvista.workflow.backend.VariableReference;
import com.mimvista.workflow.backend.VariableType;
import com.mimvista.workflow.backend.r;
import com.mimvista.workflow.backend.x;
import gnu.trove.TIntCollection;
import gnu.trove.list.TIntList;
import gnu.trove.list.array.TIntArrayList;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

@ExternallyVisible
public class Workflow
implements d.c<Integer>,
h.a<WorkflowCommand>,
ImportContainer.a,
cg.a {
    public static Messages props = Messages.a("Workflow");
    public static final boolean COPY_TARGETS = true;
    public static final boolean KEEP_SAME_TARGETS = false;
    public static final int WORKFLOW_ICON_SIZE = 96;
    protected transient boolean a = false;
    protected String b;
    protected String c = "";
    protected String d;
    protected String e;
    protected List<WorkflowCommand> f;
    protected final Map<WorkflowCommand, a> g;
    protected Map<Integer, Variable> h;
    protected List<Target> i;
    protected List<Integer> j;
    protected List<String> k;
    private CopyOnWriteArrayList<r<WorkflowCommand>> q;
    private BufferedImage r;
    protected int l = 0;
    protected int m = 0;
    protected Map<Integer, Integer> n;
    protected long o;
    protected transient Map<WorkflowCommand, WorkflowCommand> p = new HashMap<WorkflowCommand, WorkflowCommand>();

    public Workflow() {
        this.b = Messages.a("Workflow", "WORKFLOW_DEFAULT_NAME");
        this.d = "";
        this.e = "";
        this.f = new ArrayList<WorkflowCommand>();
        this.g = Maps.newHashMap();
        this.h = new HashMap<Integer, Variable>();
        this.n = new HashMap<Integer, Integer>();
        this.j = new ArrayList<Integer>();
        this.i = new ArrayList<Target>();
        this.k = new ArrayList<String>();
        this.q = new CopyOnWriteArrayList();
    }

    public Workflow(Workflow workflow) {
        this(workflow, true);
    }

    public Workflow(Workflow workflow, boolean bl2) {
        Object object;
        Object object2;
        this.a = workflow.a;
        this.b = workflow.getName();
        this.c = workflow.getPath();
        this.d = workflow.getDescription();
        this.f = new ArrayList<WorkflowCommand>();
        this.g = Maps.newHashMap();
        for (WorkflowCommand object3 : workflow.getCommands()) {
            object2 = workflow.getCmdState(object3);
            object = (WorkflowCommand)com.mimvista.commands.workflow.h.l(object3.getClass());
            ((WorkflowCommand)object).setWorkflow(this);
            a a2 = new a((WorkflowCommand)object, (a)object2);
            this.f.add((WorkflowCommand)object);
            this.g.put((WorkflowCommand)object, a2);
        }
        this.j = Lists.newArrayList(workflow.j);
        this.i = bl2 ? workflow.getTargetsWithAntis() : workflow.getTargetsWithAntisNoCopy();
        this.o = workflow.o;
        this.l = workflow.l;
        if (workflow.r != null) {
            this.r = new BufferedImage(workflow.r.getWidth(), workflow.r.getHeight(), workflow.r.getType());
            Iterator<Integer> iterator = this.r.createGraphics();
            ((Graphics)((Object)iterator)).drawImage(workflow.r, 0, 0, null);
            ((Graphics)((Object)iterator)).dispose();
        }
        this.h = new HashMap<Integer, Variable>();
        this.n = new HashMap<Integer, Integer>();
        this.n.putAll(workflow.n);
        for (Integer n2 : workflow.h.keySet()) {
            object2 = workflow.h.get(n2);
            object = new Variable((Variable)object2);
            if (((Variable)object2).d() instanceof Target) {
                ((Variable)object).a(this.i.get(this.j.indexOf(((Variable)object2).varID)));
            }
            this.h.put(n2, (Variable)object);
        }
        this.k = new ArrayList<String>(workflow.k);
        this.q = new CopyOnWriteArrayList();
    }

    public int getRawCommandCondition(WorkflowCommand workflowCommand) {
        return this.getCmdState(workflowCommand).c();
    }

    public VariableReference getCommandCondition(WorkflowCommand workflowCommand) {
        return this.getVariableReference(this.getRawCommandCondition(workflowCommand));
    }

    public boolean isOptional(WorkflowCommand workflowCommand) {
        return this.getCmdState(workflowCommand).b();
    }

    public boolean getInvertCondition(WorkflowCommand workflowCommand) {
        return this.getCmdState(workflowCommand).d();
    }

    public boolean canRunHeadless() {
        boolean bl2 = true;
        if (this.f != null) {
            for (WorkflowCommand workflowCommand : this.f) {
                bl2 &= workflowCommand.canRunHeadless();
            }
        }
        return bl2;
    }

    public Set<com.mimvista.imports.a> getDependencies() {
        HashSet<com.mimvista.imports.a> hashSet = new HashSet<com.mimvista.imports.a>();
        for (int i2 = 0; i2 < this.f.size(); ++i2) {
            WorkflowCommand workflowCommand = this.f.get(i2);
            try {
                hashSet.addAll(workflowCommand.getDependencies(this));
                continue;
            }
            catch (Throwable throwable) {
                ay.d((Object)("Cannot determine dependencies of WF command. Step " + (i2 + 1) + " of " + this.getName() + ". " + String.valueOf(workflowCommand)), this);
            }
        }
        return hashSet;
    }

    public List<com.mimvista.imports.a> getReportTemplateDependencies() {
        return this.getReportTemplateDependencies(this.getDependencies());
    }

    public List<com.mimvista.imports.a> getReportTemplateDependencies(Collection<com.mimvista.imports.a> collection) {
        return collection.stream().filter(a2 -> a2.b() == ImportContainer.ImportType.d).collect(Collectors.toList());
    }

    public List<com.mimvista.imports.a> getDoseConstraintDependencies() {
        return this.getDoseConstraintDependencies(this.getReportTemplateDependencies());
    }

    public List<com.mimvista.imports.a> getDoseConstraintDependencies(Collection<com.mimvista.imports.a> collection) {
        return collection.stream().flatMap(a2 -> this.a(a2.a()).stream()).collect(Collectors.toList());
    }

    private List<com.mimvista.imports.a> a(String string) {
        return TemplateSavePage.d().stream().filter(a2 -> PathUtils.getFilenameFromOSIndependentPath(a2.getPath()).equals(string)).flatMap(a2 -> a2.e().stream()).map(doseConstraintSet -> {
            try {
                MIMFile mIMFile = new MIMFile(PathUtils.getTempPathUnique("constraints").getAbsolutePath(), x.c(doseConstraintSet.getName()) + ImportContainer.ImportType.l.ext);
                PrintWriter printWriter = new PrintWriter(mIMFile);
                DoseConstraintSetCSVUtils.a(printWriter, doseConstraintSet.constraints, true, Character.valueOf(','));
                return mIMFile;
            }
            catch (Exception exception) {
                ay.d((Object)exception, this);
                return null;
            }
        }).filter(mIMFile -> mIMFile != null).map(mIMFile -> new com.mimvista.imports.a((File)mIMFile)).collect(Collectors.toList());
    }

    public List<com.mimvista.imports.a> getIsodoseSettingsDependencies() {
        com.mimvista.internals.dose.a a2 = IsodoseSettingCommand.getIsodoseSettings();
        ArrayList<IsodoseSettingData> arrayList = new ArrayList<IsodoseSettingData>();
        for (WorkflowCommand object : this.f) {
            String string;
            IsodoseSettingData isodoseSettingData;
            if (!(object instanceof IsodoseSettingCommand) || (isodoseSettingData = a2.a(string = (String)this.getInputVarReference(object, 0).b().d())) == null) continue;
            arrayList.add(isodoseSettingData);
        }
        ArrayList arrayList2 = new ArrayList();
        if (!arrayList.isEmpty()) {
            MIMFile mIMFile = new MIMFile(PathUtils.getTempPathUnique("isodosesettings").getAbsolutePath(), "wfsettings" + ImportContainer.ImportType.m.ext);
            IsodoseSettingData.a(mIMFile, arrayList);
            arrayList2.add(new com.mimvista.imports.a(mIMFile));
        }
        return arrayList2;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public String getName() {
        return this.b;
    }

    @Override
    public String getDescription() {
        return new String(this.d);
    }

    public void setVersion(String string) {
        this.e = string;
    }

    public String getVersion() {
        return this.e;
    }

    @Override
    public long getFileLastModifiedTime() {
        return this.o;
    }

    @Override
    public String getPath() {
        return new String(this.c);
    }

    @Override
    public ImportContainer.ImportType getImportType() {
        return ImportContainer.ImportType.b;
    }

    @Override
    public String getFilename() {
        File file = new File(this.getPath());
        if (file.getName() != null) {
            return x.c(file.getName());
        }
        return null;
    }

    @Override
    public String getIdentifier() {
        return String.valueOf(this.o);
    }

    public WorkflowCommand getCommand(int n2) {
        return this.f.get(n2);
    }

    public int getCommandIndex(WorkflowCommand workflowCommand) {
        return this.f.indexOf(workflowCommand);
    }

    public a getCmdState(WorkflowCommand workflowCommand) {
        a a2 = this.g.get(workflowCommand);
        if (a2 == null) {
            ay.d((Object)("Someone is asking for the state of an unknown command: " + workflowCommand + ". Returning dummy state."), this);
            a2 = new a(workflowCommand);
        }
        return a2;
    }

    public List<WorkflowCommand> getCommands() {
        return Lists.newArrayList(this.f);
    }

    public List<Class<? extends WorkflowCommand>> getCommandClasses() {
        ArrayList<Class<? extends WorkflowCommand>> arrayList = new ArrayList<Class<? extends WorkflowCommand>>();
        for (WorkflowCommand workflowCommand : this.f) {
            arrayList.add(workflowCommand.getClass());
        }
        return arrayList;
    }

    public List<Target> getTargets() {
        ArrayList<Target> arrayList = new ArrayList<Target>();
        for (Target target : this.i) {
            if (target.a() == TargetGrouping.e) continue;
            arrayList.add(new Target(target));
        }
        return arrayList;
    }

    public List<Target> getTargetsWithAntis() {
        ArrayList<Target> arrayList = new ArrayList<Target>();
        for (Target target : this.i) {
            arrayList.add(new Target(target));
        }
        return arrayList;
    }

    public List<Target> getTargetsNoCopy() {
        ArrayList<Target> arrayList = new ArrayList<Target>();
        for (Target target : this.i) {
            if (target.a() == TargetGrouping.e) continue;
            arrayList.add(target);
        }
        return arrayList;
    }

    public List<Target> getTargetsWithAntisNoCopy() {
        ArrayList<Target> arrayList = new ArrayList<Target>();
        for (Target target : this.i) {
            arrayList.add(target);
        }
        return arrayList;
    }

    public Iterable<Target> getTargetsIterable() {
        return Iterables.filter(this.i, (Predicate)new Predicate<Target>(){

            public boolean a(Target target) {
                return target.a() != TargetGrouping.e;
            }

            public /* synthetic */ boolean apply(Object object) {
                return this.a((Target)object);
            }
        });
    }

    public Iterable<Target> getTargetsWithAntisIterable() {
        return this.i;
    }

    public void registerRunningCommand(int n2, WorkflowCommand workflowCommand) {
        WorkflowCommand workflowCommand2 = this.getCommand(n2);
        if (workflowCommand2 != null) {
            this.p.put(workflowCommand, workflowCommand2);
        }
    }

    public WorkflowCommand getInternalCommand(WorkflowCommand workflowCommand) {
        return this.p.get(workflowCommand);
    }

    public List<Integer> getAssignableVariableIDs(WorkflowCommand workflowCommand) {
        LinkedHashSet<Integer> linkedHashSet = new LinkedHashSet<Integer>();
        linkedHashSet.addAll(this.getTargetReferenceIDs());
        for (int i2 = 0; i2 < this.getCommandIndex(workflowCommand); ++i2) {
            WorkflowCommand workflowCommand2 = this.getCommand(i2);
            a a2 = this.getCmdState(workflowCommand2);
            a2.i().filter(n2 -> n2 != -1).boxed().forEach(n2 -> linkedHashSet.add((Integer)n2));
        }
        return Lists.newArrayList(linkedHashSet);
    }

    public List<Integer> getAssignableVariableIDs(WorkflowCommand workflowCommand, VariableType variableType, boolean bl2) {
        LinkedHashSet<Integer> linkedHashSet = new LinkedHashSet<Integer>();
        if (variableType == VariableType.a || variableType == VariableType.w) {
            linkedHashSet.addAll(this.getTargetReferenceIDs());
        }
        for (int i2 = 0; i2 < this.getCommandIndex(workflowCommand); ++i2) {
            WorkflowCommand workflowCommand2 = this.getCommand(i2);
            a a2 = this.getCmdState(workflowCommand2);
            a2.i().filter(n2 -> {
                if (n2 == -1 || linkedHashSet.contains(n2)) {
                    return false;
                }
                Variable variable = this.h.get(n2);
                return !(!variableType.a(variable.b()) && variableType != VariableType.w || variable.c() && !bl2);
            }).boxed().forEach(n2 -> linkedHashSet.add((Integer)n2));
        }
        return Lists.newArrayList(linkedHashSet);
    }

    public List<Integer> getTargetReferenceIDs() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (Integer n2 : this.j) {
            Target target;
            Variable variable = this.h.get(n2);
            if (variable == null || !(variable.d() instanceof Target) || (target = (Target)variable.d()).a() == TargetGrouping.e) continue;
            arrayList.add(n2);
        }
        return arrayList;
    }

    public List<Integer> getTargetsWithAntisReferenceIDs() {
        return Lists.newArrayList(this.j);
    }

    public List<VariableReference> getTargetReferences() {
        ArrayList<VariableReference> arrayList = new ArrayList<VariableReference>();
        for (Integer n2 : this.getTargetReferenceIDs()) {
            arrayList.add(new VariableReference(this, this.h.get(n2)));
        }
        return arrayList;
    }

    public List<VariableReference> getTargetReferencesWithAntis() {
        ArrayList<VariableReference> arrayList = new ArrayList<VariableReference>();
        for (Integer n2 : this.getTargetsWithAntisReferenceIDs()) {
            arrayList.add(new VariableReference(this, this.h.get(n2)));
        }
        return arrayList;
    }

    public VariableReference getTargetReference(Target target) {
        if (target == null) {
            return null;
        }
        int n2 = this.i.indexOf(target);
        if (n2 >= 0) {
            int n3 = this.j.get(n2);
            return new VariableReference(this, this.h.get(n3));
        }
        return null;
    }

    public Target getTargetByVariableReferenceNoCopy(VariableReference variableReference) {
        for (Integer n2 : this.j) {
            if (n2.intValue() != variableReference.g()) continue;
            return this.i.get(this.j.indexOf(n2));
        }
        for (Integer n2 : this.j) {
            if (this.h.get(n2).d() != variableReference.a()) continue;
            return this.i.get(this.j.indexOf(n2));
        }
        return null;
    }

    public Target getTargetByVariableReference(VariableReference variableReference) {
        Target target = this.c(variableReference);
        if (target == null) {
            target = this.getTargetByViewController((ViewController)variableReference.a());
        }
        return target;
    }

    public Target getTargetByViewController(ViewController viewController) {
        Target target = this.a(viewController);
        if (target == null && viewController != null) {
            target = new Target(viewController.getWorkflowDisplayName(), viewController.getModality());
        }
        return target;
    }

    private Target c(VariableReference variableReference) {
        for (Integer n2 : this.j) {
            if (n2.intValue() != variableReference.g()) continue;
            return new Target(this.i.get(this.j.indexOf(n2)));
        }
        return null;
    }

    private Target a(ViewController viewController) {
        if (viewController == null) {
            return null;
        }
        for (Integer n2 : this.j) {
            if (this.h.get(n2).d() != viewController) continue;
            return new Target(this.i.get(this.j.indexOf(n2)));
        }
        return null;
    }

    public int getInputReferenceID(WorkflowCommand workflowCommand, int n2) {
        return this.getCmdState(workflowCommand).b(n2);
    }

    @Override
    public int getInputReference(WorkflowCommand workflowCommand, int n2) {
        return this.getInputReferenceID(workflowCommand, n2);
    }

    public VariableReference getInputVarReference(WorkflowCommand workflowCommand, int n2) {
        Variable variable = this.h.get(this.getCmdState(workflowCommand).c(n2));
        if (variable != null) {
            return new VariableReference(this, variable);
        }
        return null;
    }

    public List<VariableReference> getInputReferences(WorkflowCommand workflowCommand) {
        return this.getVariableReferences(this.getCmdState(workflowCommand).j());
    }

    public IntStream getAllInputReferences() {
        return this.f.stream().map(workflowCommand -> this.getCmdState((WorkflowCommand)workflowCommand)).flatMapToInt(a2 -> a2.j());
    }

    public IntStream getAllOutputReferences() {
        return this.f.stream().map(workflowCommand -> this.getCmdState((WorkflowCommand)workflowCommand)).flatMapToInt(a2 -> a2.i());
    }

    public int getTargetIndex(String string) {
        for (int i2 = 0; i2 < this.i.size(); ++i2) {
            if (!this.i.get(i2).getWorkflowDisplayName().equals(string)) continue;
            return i2;
        }
        return -1;
    }

    public VariableReference getTargetReference(String string) {
        for (int i2 = 0; i2 < this.i.size(); ++i2) {
            if (!this.i.get(i2).getWorkflowDisplayName().equals(string)) continue;
            return new VariableReference(this, this.h.get(this.j.get(i2)));
        }
        return null;
    }

    @Override
    public d.d getOutput(Integer n2) {
        Variable variable = this.h.get(n2);
        if (variable != null) {
            return new d.d(variable.b(), variable.c());
        }
        return null;
    }

    @Override
    public VariableReference getVariableReference(int n2) {
        Variable variable = this.h.get(n2);
        if (variable != null) {
            return new VariableReference(this, variable);
        }
        return null;
    }

    public VariableReference getVariableReference(String string) {
        for (Variable variable : this.h.values()) {
            if (!variable.a().equals(string)) continue;
            return new VariableReference(this, variable);
        }
        return null;
    }

    public List<TIntList> getInputReferences() {
        return this.f.stream().map(workflowCommand -> this.getCmdState((WorkflowCommand)workflowCommand)).map(a2 -> a2.e()).collect(Collectors.toList());
    }

    public List<Integer> getVariableIDs() {
        return Lists.newArrayList(this.h.keySet());
    }

    public List<VariableReference> getVariableReferences() {
        ArrayList<VariableReference> arrayList = new ArrayList<VariableReference>();
        for (Integer n2 : this.h.keySet()) {
            Variable variable = this.h.get(n2);
            if (variable.d() instanceof Target) {
                Target target = (Target)variable.d();
                if (target.a() == TargetGrouping.e) continue;
                arrayList.add(new VariableReference(this, this.h.get(n2)));
                continue;
            }
            arrayList.add(new VariableReference(this, this.h.get(n2)));
        }
        return arrayList;
    }

    public List<VariableReference> getVariableReferencesWithAntis() {
        ArrayList<VariableReference> arrayList = new ArrayList<VariableReference>();
        for (Integer n2 : this.h.keySet()) {
            arrayList.add(new VariableReference(this, this.h.get(n2)));
        }
        return arrayList;
    }

    public String getUniqueName(String string, Integer n2) {
        if (this.checkName(string, n2)) {
            return string;
        }
        Pair<String, Integer> pair = cn.s(string);
        string = (String)pair.x;
        int n3 = (Integer)pair.y + 1;
        String string2 = cn.c(string, n3);
        while (!this.checkName(string2, n2)) {
            string2 = cn.c(string, ++n3);
        }
        return string2;
    }

    public boolean checkName(String string, Integer n2) {
        for (Variable variable : this.h.values()) {
            if (variable.varID == n2 || !variable.a().equals(string)) continue;
            return false;
        }
        return true;
    }

    public boolean isReassignedOutput(WorkflowCommand workflowCommand, int n2) {
        int n3 = this.getCommandIndex(workflowCommand);
        int n4 = this.getCmdState(workflowCommand).f(n2);
        for (int i2 = 0; i2 < n3; ++i2) {
            WorkflowCommand workflowCommand2 = this.getCommand(i2);
            for (VariableReference variableReference : this.getOutputReferences(workflowCommand2)) {
                if (variableReference.g() != n4) continue;
                return true;
            }
        }
        return false;
    }

    public List<VariableReference> getOutputReferences(WorkflowCommand workflowCommand) {
        return this.getVariableReferences(this.getCmdState(workflowCommand).i());
    }

    public TIntList getOutputVarIds(WorkflowCommand workflowCommand) {
        return this.getCmdState(workflowCommand).g();
    }

    public TIntList getInputVarIds(WorkflowCommand workflowCommand) {
        return this.getCmdState(workflowCommand).e();
    }

    public List<VariableReference> getVariableReferences(IntStream intStream) {
        return intStream.mapToObj(n2 -> this.getVariableReference(n2)).collect(Collectors.toList());
    }

    public List<TIntList> getOutputReferences() {
        return this.f.stream().map(workflowCommand -> this.getCmdState((WorkflowCommand)workflowCommand)).map(a2 -> a2.g()).collect(Collectors.toList());
    }

    void a(r<WorkflowCommand> r2) {
        this.q.add(r2);
    }

    void b(r<WorkflowCommand> r2) {
        this.q.remove(r2);
    }

    public int getCommandCount() {
        return this.f.size();
    }

    public boolean isLicensed() {
        for (WorkflowCommand workflowCommand : this.f) {
            try {
                if (LicenseTransformer.isLicensedForMIMFeature(workflowCommand.getClass())) continue;
                ay.b((Object)(workflowCommand.getName(this) + " requires one of the following license to run but this workstation is not licensed for it: " + Arrays.toString(com.mimvista.commands.f.b(workflowCommand.getClass()).m())), this);
                return false;
            }
            catch (Throwable throwable) {
                ay.d((Object)"Error determining if the workflow is licensed", throwable, this);
                return false;
            }
        }
        return true;
    }

    public BufferedImage getWorkflowImage() {
        return this.r;
    }

    public ImageIcon getWorkflowIcon(boolean bl2, boolean bl3, int n2, boolean bl4) {
        BufferedImage bufferedImage = new BufferedImage(n2, n2, 2);
        BufferedImage bufferedImage2 = this.getWorkflowImage();
        if (bl2 && bufferedImage2 == null) {
            Icon icon = ImageManipulator.c("star", 24);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            int n3 = (n2 - icon.getIconWidth()) / 2;
            int n4 = (n2 - icon.getIconHeight()) / 2;
            icon.paintIcon(new JLabel(), graphics2D, n3, n4);
            graphics2D.dispose();
        } else {
            if (bufferedImage2 == null && bl4) {
                bufferedImage2 = ImageManipulator.d("workflow_undefined", n2);
            }
            if (bufferedImage2 != null) {
                BufferedImage bufferedImage3 = null;
                if (bl2) {
                    bufferedImage3 = ImageManipulator.b("star_badge", n2 / 2, n2 / 2, null, false);
                }
                Graphics2D graphics2D = bufferedImage.createGraphics();
                BufferedImage bufferedImage4 = this.a(this, n2);
                if (!bl3) {
                    bufferedImage4 = ImageManipulator.a(bufferedImage4, 0.5f);
                }
                graphics2D.drawImage((Image)bufferedImage4, bufferedImage.getWidth() - bufferedImage4.getWidth(), bufferedImage.getHeight() - bufferedImage4.getHeight(), null);
                if (bufferedImage3 != null) {
                    graphics2D.drawImage((Image)bufferedImage3, bufferedImage.getWidth() - bufferedImage3.getWidth(), bufferedImage.getHeight() - bufferedImage3.getHeight(), null);
                }
                graphics2D.dispose();
            }
        }
        return new ImageIcon(bufferedImage);
    }

    private BufferedImage a(Workflow workflow, int n2) {
        BufferedImage bufferedImage = x.a(workflow);
        bufferedImage = ImageManipulator.c(bufferedImage, n2);
        return bufferedImage;
    }

    public List<String> getUserLabels() {
        return new ArrayList<String>(this.k);
    }

    public void setWorkflowImage(BufferedImage bufferedImage) {
        this.r = bufferedImage;
    }

    protected void a(WorkflowCommand workflowCommand, VariableReference variableReference) {
        this.q.forEach((Consumer<r<WorkflowCommand>>)((Consumer<r>)r2 -> {
            try {
                r2.a(workflowCommand, variableReference);
            }
            catch (Throwable throwable) {
                ay.d((Object)throwable, this);
            }
        }));
    }

    protected void a(WorkflowCommand workflowCommand) {
        a a2 = this.getCmdState(workflowCommand);
        boolean bl2 = a2.b();
        this.q.forEach((Consumer<r<WorkflowCommand>>)((Consumer<r>)r2 -> {
            try {
                r2.a(workflowCommand, bl2);
            }
            catch (Throwable throwable) {
                ay.d((Object)throwable, this);
            }
        }));
    }

    protected void a(Variable variable) {
        this.q.forEach((Consumer<r<WorkflowCommand>>)((Consumer<r>)r2 -> {
            try {
                r2.a(new VariableReference(this, variable));
            }
            catch (Throwable throwable) {
                ay.d((Object)throwable, this);
            }
        }));
    }

    protected void b(Variable variable) {
        this.q.forEach((Consumer<r<WorkflowCommand>>)((Consumer<r>)r2 -> {
            try {
                r2.b(new VariableReference(this, variable));
            }
            catch (Throwable throwable) {
                ay.d((Object)throwable, this);
            }
        }));
    }

    protected void a(VariableReference variableReference) {
        this.q.forEach((Consumer<r<WorkflowCommand>>)((Consumer<r>)r2 -> {
            try {
                r2.c(variableReference);
            }
            catch (Throwable throwable) {
                ay.d((Object)throwable, this);
            }
        }));
    }

    protected void b(VariableReference variableReference) {
        this.q.forEach((Consumer<r<WorkflowCommand>>)((Consumer<r>)r2 -> {
            try {
                r2.d(variableReference);
            }
            catch (Throwable throwable) {
                ay.d((Object)throwable, this);
            }
        }));
    }

    protected void a(WorkflowCommand workflowCommand, int n2) {
        this.q.forEach((Consumer<r<WorkflowCommand>>)((Consumer<r>)r2 -> {
            try {
                r2.a(workflowCommand, n2);
            }
            catch (Throwable throwable) {
                ay.d((Object)throwable, this);
            }
        }));
    }

    protected void a() {
        this.q.forEach((Consumer<r<WorkflowCommand>>)((Consumer<r>)r2 -> {
            try {
                r2.a();
            }
            catch (Throwable throwable) {
                ay.d((Object)throwable, this);
            }
        }));
    }

    protected void b() {
        this.q.forEach((Consumer<r<WorkflowCommand>>)((Consumer<r>)r2 -> {
            try {
                r2.b();
            }
            catch (Throwable throwable) {
                ay.d((Object)throwable, this);
            }
        }));
    }

    protected void b(WorkflowCommand workflowCommand) {
        this.q.forEach((Consumer<r<WorkflowCommand>>)((Consumer<r>)r2 -> {
            try {
                r2.a(workflowCommand);
            }
            catch (Throwable throwable) {
                ay.d((Object)throwable, this);
            }
        }));
    }

    protected void c(WorkflowCommand workflowCommand) {
        this.q.forEach((Consumer<r<WorkflowCommand>>)((Consumer<r>)r2 -> {
            try {
                r2.c(workflowCommand);
            }
            catch (Throwable throwable) {
                ay.d((Object)throwable, this);
            }
        }));
    }

    protected void d(WorkflowCommand workflowCommand) {
        this.q.forEach((Consumer<r<WorkflowCommand>>)((Consumer<r>)r2 -> {
            try {
                r2.b(workflowCommand);
            }
            catch (Throwable throwable) {
                ay.d((Object)throwable, this);
            }
        }));
    }

    protected void b(WorkflowCommand workflowCommand, VariableReference variableReference) {
        this.q.forEach((Consumer<r<WorkflowCommand>>)((Consumer<r>)r2 -> {
            try {
                r2.b(workflowCommand, variableReference);
            }
            catch (Throwable throwable) {
                ay.d((Object)throwable, this);
            }
        }));
    }

    public void fireNeedsRevalidation() {
        this.q.forEach((Consumer<r<WorkflowCommand>>)((Consumer<r>)r2 -> {
            try {
                r2.c();
            }
            catch (Throwable throwable) {
                ay.d((Object)throwable, this);
            }
        }));
    }

    protected void c(WorkflowCommand workflowCommand, VariableReference variableReference) {
        this.q.forEach((Consumer<r<WorkflowCommand>>)((Consumer<r>)r2 -> {
            try {
                r2.c(workflowCommand, variableReference);
            }
            catch (Throwable throwable) {
                ay.d((Object)throwable, this);
            }
        }));
    }

    protected synchronized int c() {
        int n2 = this.l;
        while (this.h.get(this.l) != null) {
            ++this.l;
        }
        ++this.l;
        return n2;
    }

    protected synchronized void d() {
        Iterator iterator = Lists.newArrayList(this.n.keySet()).iterator();
        while (iterator.hasNext()) {
            int n2 = (Integer)iterator.next();
            if (this.getVariableIDs().contains(n2)) continue;
            this.n.remove(n2);
        }
    }

    protected int a(int n2) {
        List<Integer> list = Collections.emptyList();
        this.m = this.a(list);
        this.n.put(n2, this.m);
        return this.m;
    }

    protected int a(List<Integer> list) {
        this.m = 0;
        while (this.n.values().contains(this.m) || list.contains(this.m)) {
            ++this.m;
        }
        return this.m;
    }

    @Override
    public List<String> getRepresentativeTextForRelevanceSearch() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (WorkflowPrefs.useName.getValue().booleanValue()) {
            arrayList.add(this.getName());
        }
        if (WorkflowPrefs.useUserLabels.getValue().booleanValue()) {
            arrayList.addAll(this.getUserLabels());
        }
        if (WorkflowPrefs.useDescription.getValue().booleanValue()) {
            arrayList.add(this.getDescription());
        }
        return arrayList;
    }

    @Override
    public List<String> getEnglishRepresentativeTextForRelevanceSearch() {
        return this.getRepresentativeTextForRelevanceSearch();
    }

    public boolean isSerialized() {
        return this.a;
    }

    public static class a {
        private WorkflowCommand a;
        private int b = -1;
        private boolean c = false;
        private TIntList d = new TIntArrayList();
        private TIntList e = new TIntArrayList();
        private boolean f;

        public a(WorkflowCommand workflowCommand) {
            this.a = workflowCommand;
        }

        public a(WorkflowCommand workflowCommand, a a2) {
            this.a = workflowCommand;
            this.b = a2.b;
            this.c = a2.c;
            this.d = new TIntArrayList((TIntCollection)a2.d);
            this.e = new TIntArrayList((TIntCollection)a2.e);
            this.f = a2.f;
        }

        public WorkflowCommand a() {
            return this.a;
        }

        public boolean b() {
            return this.f;
        }

        public void a(boolean bl2) {
            this.f = bl2;
        }

        public int c() {
            return this.b;
        }

        public void a(int n2) {
            this.b = n2;
        }

        public boolean d() {
            return this.c;
        }

        public void b(boolean bl2) {
            this.c = bl2;
        }

        public TIntList e() {
            return new TIntArrayList((TIntCollection)this.d);
        }

        public int b(int n2) {
            if (n2 < 0 || n2 >= this.d.size()) {
                ay.c((Object)("Input ref idx OOB: " + n2 + "~" + this.a), this);
                return -1;
            }
            return this.c(n2);
        }

        public int c(int n2) {
            return this.d.get(n2);
        }

        public void a(int n2, int n3) {
            this.d.set(n2, n3);
        }

        public void a(TIntList tIntList) {
            this.d = new TIntArrayList((TIntCollection)tIntList);
        }

        public int f() {
            return this.d.size();
        }

        public void d(int n2) {
            if (n2 == this.d.size()) {
                return;
            }
            if (n2 > this.d.size()) {
                while (n2 > this.d.size()) {
                    this.d.add(-1);
                }
            } else {
                this.d = this.d.subList(0, n2);
            }
        }

        public void e(int n2) {
            this.d = new TIntArrayList();
            for (int i2 = 0; i2 < n2; ++i2) {
                this.d.add(-1);
            }
        }

        public TIntList g() {
            return new TIntArrayList((TIntCollection)this.e);
        }

        public int f(int n2) {
            return this.e.get(n2);
        }

        public int h() {
            return this.e.size();
        }

        public void b(TIntList tIntList) {
            this.e = new TIntArrayList((TIntCollection)tIntList);
        }

        public void a(List<Integer> list) {
            this.e = new TIntArrayList(Ints.toArray(list));
        }

        public boolean g(int n2) {
            return this.e.remove(n2);
        }

        public void h(int n2) {
            if (this.e.size() != 1) {
                this.e.clear();
                this.e.add(n2);
            } else {
                this.e.set(0, n2);
            }
        }

        public void i(int n2) {
            this.e.add(n2);
        }

        public IntStream i() {
            return IntStream.range(0, this.e.size()).map(n2 -> this.e.get(n2));
        }

        public IntStream j() {
            return IntStream.range(0, this.d.size()).map(n2 -> this.d.get(n2));
        }
    }
}

